/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementPlan;
import org.apache.solr.cluster.placement.PlacementPlanFactory;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.ReplicaPlacement;

public class RandomPlacementFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    @Override
    public PlacementPlugin createPluginInstance() {
        return new RandomPlacementPlugin();
    }

    public static class RandomPlacementPlugin
    implements PlacementPlugin {
        private final Random replicaPlacementRandom = new Random();

        private RandomPlacementPlugin() {
            String seed = System.getProperty("tests.seed");
            if (seed != null) {
                this.replicaPlacementRandom.setSeed(seed.hashCode());
            }
        }

        @Override
        public List<PlacementPlan> computePlacements(Collection<PlacementRequest> requests, PlacementContext placementContext) throws PlacementException {
            ArrayList<PlacementPlan> placementPlans = new ArrayList<PlacementPlan>(requests.size());
            for (PlacementRequest request : requests) {
                int totalReplicasPerShard = 0;
                for (Replica.ReplicaType rt : Replica.ReplicaType.values()) {
                    totalReplicasPerShard += request.getCountReplicasToCreate(rt);
                }
                if (request.getTargetNodes().size() < totalReplicasPerShard) {
                    throw new PlacementException("Cluster size too small for number of replicas per shard");
                }
                HashSet<ReplicaPlacement> replicaPlacements = new HashSet<ReplicaPlacement>(totalReplicasPerShard * request.getShardNames().size());
                for (String shardName : request.getShardNames()) {
                    ArrayList<Node> nodesToAssign = new ArrayList<Node>(request.getTargetNodes());
                    Collections.shuffle(nodesToAssign, this.replicaPlacementRandom);
                    for (Replica.ReplicaType rt : Replica.ReplicaType.values()) {
                        this.placeForReplicaType(request.getCollection(), nodesToAssign, placementContext.getPlacementPlanFactory(), replicaPlacements, shardName, request, rt);
                    }
                }
                placementPlans.add(placementContext.getPlacementPlanFactory().createPlacementPlan(request, replicaPlacements));
            }
            return placementPlans;
        }

        private void placeForReplicaType(SolrCollection solrCollection, ArrayList<Node> nodesToAssign, PlacementPlanFactory placementPlanFactory, Set<ReplicaPlacement> replicaPlacements, String shardName, PlacementRequest request, Replica.ReplicaType replicaType) {
            for (int replica = 0; replica < request.getCountReplicasToCreate(replicaType); ++replica) {
                Node node = nodesToAssign.remove(0);
                replicaPlacements.add(placementPlanFactory.createReplicaPlacement(solrCollection, shardName, node, replicaType));
            }
        }
    }
}

