/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.saml;

import com.coveo.saml.SamlException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.LogoutRequest;

public class LogoutRequestSchemaValidator {
    public void validate(LogoutRequest request) throws SamlException {
        this.validateID(request);
        this.validateVersion(request);
        this.validateIssueInstant(request);
        this.validateIdentifiers(request);
    }

    private void validateID(LogoutRequest request) throws SamlException {
        if (StringUtils.isEmpty((CharSequence)request.getID())) {
            throw new SamlException("ID attribute must not be empty");
        }
    }

    private void validateVersion(LogoutRequest request) throws SamlException {
        if (request.getVersion() == null) {
            throw new SamlException("Version attribute must not be null");
        }
        if (!Objects.equals(request.getVersion().toString(), SAMLVersion.VERSION_20.toString())) {
            throw new SamlException("Wrong SAML Version");
        }
    }

    private void validateIssueInstant(LogoutRequest request) throws SamlException {
        if (request.getIssueInstant() == null) {
            throw new SamlException("IssueInstant attribute must not be null");
        }
    }

    protected void validateIdentifiers(LogoutRequest request) throws SamlException {
        int idCount = 0;
        if (request.getBaseID() != null) {
            ++idCount;
        }
        if (request.getNameID() != null) {
            ++idCount;
        }
        if (request.getEncryptedID() != null) {
            ++idCount;
        }
        if (idCount != 1) {
            throw new SamlException("LogoutRequest must contain exactly one of: BaseID, NameID, EncryptedID");
        }
    }
}

