/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.transforms;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.entrystore.Entry;
import org.entrystore.impl.RDFResource;
import org.entrystore.impl.converters.Graph2Entries;
import org.entrystore.repository.util.NS;
import org.entrystore.transforms.Transform;
import org.entrystore.transforms.TransformException;
import org.entrystore.transforms.TransformParameters;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final Logger log = LoggerFactory.getLogger(Pipeline.class);
    public static final IRI transform;
    public static final IRI transformPriority;
    public static final IRI transformType;
    public static final IRI transformArgument;
    public static final IRI transformArgumentKey;
    public static final IRI transformArgumentValue;
    public static final IRI transformDestination;
    public static final IRI transformDetectDestination;
    private Entry entry;
    private String destination = "";
    private boolean detectDestination = false;
    private List<Transform> tsteps = new ArrayList<Transform>();
    private static Map<String, Class<?>> type2Class;
    private static Map<String, Class<?>> format2Class;

    public Pipeline(Entry entry) {
        this.entry = entry;
        this.detectTransforms();
    }

    public Entry getEntry() {
        return this.entry;
    }

    private void detectTransforms() {
        Iterator detectStmts;
        Iterator toEntryStmts;
        Model graph = ((RDFResource)this.entry.getResource()).getGraph();
        if (graph.isEmpty()) {
            graph = this.entry.getMetadataGraph();
        }
        if ((toEntryStmts = graph.filter(null, transformDestination, null, new Resource[0]).iterator()).hasNext()) {
            this.destination = ((Statement)toEntryStmts.next()).getObject().stringValue();
            if (this.destination.startsWith("http")) {
                Entry toEntryEntry = this.entry.getContext().getByEntryURI(URI.create(this.destination));
                this.destination = toEntryEntry.getId();
            }
        }
        if ((detectStmts = graph.filter(null, transformDetectDestination, null, new Resource[0]).iterator()).hasNext()) {
            this.detectDestination = ((Statement)detectStmts.next()).getObject().stringValue().contains("true");
        }
        for (Statement statement : graph.filter(null, transform, null, new Resource[0])) {
            Transform transform;
            Resource transformResource;
            Iterator types;
            if (!(statement.getObject() instanceof Resource) || !(types = graph.filter(transformResource = (Resource)statement.getObject(), transformType, null, new Resource[0]).iterator()).hasNext() || (transform = this.createTransform(((Statement)types.next()).getObject().stringValue())) == null) continue;
            transform.extractArguments(graph, transformResource);
            this.tsteps.add(transform);
        }
        Collections.sort(this.tsteps);
    }

    private Transform createTransform(String typeOrFormat) {
        if (typeOrFormat != null) {
            Pipeline.loadTransforms();
            Class<?> transformClass = null;
            transformClass = type2Class.get(typeOrFormat);
            if (transformClass == null) {
                transformClass = format2Class.get(typeOrFormat);
            }
            if (transformClass != null) {
                try {
                    return (Transform)transformClass.newInstance();
                }
                catch (InstantiationException ie) {
                    log.error(ie.getMessage());
                }
                catch (IllegalAccessException iae) {
                    log.error(iae.getMessage());
                }
            }
        }
        return null;
    }

    public Set<Entry> run(Entry sourceEntry, URI listIRI) throws TransformException {
        if (this.tsteps.size() == 0) {
            throw new IllegalStateException("Pipeline has no recognizable transforms.");
        }
        Transform first = this.tsteps.get(0);
        Object result = first.transform(this, sourceEntry);
        for (int idx = 1; idx < this.tsteps.size(); ++idx) {
            if (result instanceof Model) {
                result = this.tsteps.get(idx).transform(this, (Model)result);
                continue;
            }
            if (result instanceof Entry) {
                result = this.tsteps.get(idx).transform(this, (Entry)result);
                continue;
            }
            throw new IllegalStateException("Transform result must be either Graph or Entry.");
        }
        if (result instanceof Model) {
            Model graph = (Model)result;
            Graph2Entries g2e = new Graph2Entries(this.entry.getContext());
            if (this.detectDestination) {
                return g2e.merge(graph, null, null);
            }
            return g2e.merge(graph, this.destination, listIRI);
        }
        if (result instanceof Entry) {
            return new HashSet<Entry>(Arrays.asList((Entry)result));
        }
        throw new IllegalStateException("Transform result must be either Graph or Entry.");
    }

    private static synchronized void loadTransforms() {
        if (type2Class == null || format2Class == null) {
            type2Class = new HashMap();
            format2Class = new HashMap();
            Reflections reflections = new Reflections(Pipeline.class.getPackage().getName(), new Scanner[0]);
            Set classes = reflections.getTypesAnnotatedWith(TransformParameters.class);
            for (Class c : classes) {
                if (!c.isAnnotationPresent(TransformParameters.class)) continue;
                TransformParameters annot = c.getAnnotation(TransformParameters.class);
                type2Class.put(annot.type(), c);
                for (String format : annot.extensions()) {
                    format2Class.put(format, c);
                }
            }
        }
    }

    static {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        transform = vf.createIRI(NS.entrystore, "transform");
        transformPriority = vf.createIRI(NS.entrystore, "transformPriority");
        transformType = vf.createIRI(NS.entrystore, "transformType");
        transformArgument = vf.createIRI(NS.entrystore, "transformArgument");
        transformArgumentKey = vf.createIRI(NS.entrystore, "transformArgumentKey");
        transformArgumentValue = vf.createIRI(NS.entrystore, "transformArgumentValue");
        transformDestination = vf.createIRI(NS.entrystore, "transformDestination");
        transformDetectDestination = vf.createIRI(NS.entrystore, "transformDetectDestination");
        type2Class = null;
        format2Class = null;
    }
}

