/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Couple;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.RdfRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

@Deprecated
public class RdfClientResource
extends ClientResource {
    private Graph links;

    public RdfClientResource(Context context, Method method, Reference reference) {
        super(context, method, reference);
    }

    public RdfClientResource(Context context, Method method, String uri) {
        super(context, method, uri);
    }

    public RdfClientResource(Context context, Method method, URI uri) {
        super(context, method, uri);
    }

    public RdfClientResource(Context context, Reference reference) {
        super(context, reference);
    }

    public RdfClientResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public RdfClientResource(Context context, String uri) {
        super(context, uri);
    }

    public RdfClientResource(Context context, URI uri) {
        super(context, uri);
    }

    public RdfClientResource(Method method, Reference reference) {
        super(method, reference);
    }

    public RdfClientResource(Method method, String uri) {
        super(method, uri);
    }

    public RdfClientResource(Method method, URI uri) {
        super(method, uri);
    }

    public RdfClientResource(Reference reference) {
        super(reference);
    }

    public RdfClientResource(Request request, Response response) {
        super(request, response);
    }

    public RdfClientResource(String uri) {
        super(uri);
    }

    public RdfClientResource(URI uri) {
        super(uri);
    }

    public Set<RdfClientResource> getLinked() {
        return this.getLinked((Collection<Reference>)null);
    }

    public Set<RdfClientResource> getLinked(Collection<Reference> typeRefs) {
        HashSet<RdfClientResource> result = null;
        Graph links = this.getLinks();
        if (links != null) {
            result = new HashSet<RdfClientResource>();
            for (Link link : links) {
                if (!link.hasReferenceTarget() || typeRefs != null && !typeRefs.contains(link.getTypeRef())) continue;
                result.add(new RdfClientResource(this.getContext(), link.getTargetAsReference()));
            }
        }
        return result;
    }

    public Set<RdfClientResource> getLinked(Reference typeRef) {
        return this.getLinked(Collections.singleton(typeRef));
    }

    public Graph getLinks() {
        Graph result = this.links;
        if (result == null) {
            ClientInfo currentInfo = this.getClientInfo();
            ClientInfo newInfo = new ClientInfo();
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.APPLICATION_RDF_XML));
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_RDF_N3));
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_RDF_NTRIPLES));
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_TURTLE));
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_XML, 0.5f));
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN, 0.4f));
            newInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.APPLICATION_ALL_XML, 0.3f));
            try {
                Representation rep = this.get();
                if (rep != null) {
                    RdfRepresentation rdfRep = new RdfRepresentation(rep);
                    result = this.links = rdfRep.getGraph();
                } else {
                    this.getLogger().log(Level.WARNING, "Unable to retrieve an RDF representation of this resource: " + this.getReference());
                }
            }
            catch (Throwable e) {
                this.getLogger().log(Level.WARNING, "Unable to retrieve an RDF representation of this resource: " + this.getReference(), e);
            }
            this.setClientInfo(currentInfo);
        }
        return result;
    }

    public Set<Couple<Reference, Literal>> getLiterals() {
        HashSet<Couple<Reference, Literal>> result = null;
        Graph links = this.getLinks();
        if (links != null) {
            for (Link link : links) {
                if (!link.hasLiteralTarget()) continue;
                if (result == null) {
                    result = new HashSet<Couple<Reference, Literal>>();
                }
                result.add(new Couple<Reference, Literal>(link.getTypeRef(), link.getTargetAsLiteral()));
            }
        }
        return result;
    }

    public Set<Literal> getLiterals(Reference typeRef) {
        HashSet<Literal> result = null;
        Graph links = this.getLinks();
        if (links != null) {
            result = new HashSet<Literal>();
            for (Link link : links) {
                if (!link.hasLiteralTarget() || typeRef != null && !typeRef.equals((Object)link.getTypeRef())) continue;
                result.add(link.getTargetAsLiteral());
            }
        }
        return result;
    }

    public void refresh() {
        this.links = null;
        this.getLinks();
    }
}

