/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.n3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfConstants;
import org.restlet.ext.rdf.internal.n3.FormulaToken;
import org.restlet.ext.rdf.internal.turtle.BlankNodeToken;
import org.restlet.ext.rdf.internal.turtle.LexicalUnit;
import org.restlet.ext.rdf.internal.turtle.ListToken;
import org.restlet.ext.rdf.internal.turtle.RdfTurtleReader;
import org.restlet.ext.rdf.internal.turtle.StringToken;
import org.restlet.ext.rdf.internal.turtle.Token;
import org.restlet.ext.rdf.internal.turtle.UriToken;
import org.restlet.representation.Representation;

@Deprecated
public class RdfN3Reader
extends RdfTurtleReader {
    public RdfN3Reader(Representation rdfN3Representation, GraphHandler graphHandler) throws IOException {
        super(rdfN3Representation, graphHandler);
    }

    @Override
    protected void generateLinks(List<LexicalUnit> lexicalUnits) {
        Object currentSubject = null;
        Reference currentPredicate = null;
        Object currentObject = null;
        int nbTokens = 0;
        boolean swapSubjectObject = false;
        ArrayList<Object> subjects = new ArrayList<Object>();
        block5: for (int i = 0; i < lexicalUnits.size(); ++i) {
            LexicalUnit lexicalUnit = lexicalUnits.get(i);
            switch (++nbTokens) {
                case 1: {
                    if (",".equals(lexicalUnit.getValue())) {
                        ++nbTokens;
                        continue block5;
                    }
                    if (";".equals(lexicalUnit.getValue())) {
                        if (subjects.isEmpty()) continue block5;
                        currentSubject = subjects.get(subjects.size() - 1);
                        continue block5;
                    }
                    if ("!".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentObject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        currentPredicate = this.getPredicate(lexicalUnits.get(++i));
                        this.link(currentSubject, currentPredicate, currentObject);
                        currentSubject = currentObject;
                        nbTokens = 1;
                        continue block5;
                    }
                    if ("^".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentObject = currentSubject;
                        currentPredicate = this.getPredicate(lexicalUnits.get(++i));
                        currentSubject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                        nbTokens = 1;
                        continue block5;
                    }
                    currentSubject = lexicalUnit.resolve();
                    subjects.add(currentSubject);
                    continue block5;
                }
                case 2: {
                    if ("is".equalsIgnoreCase(lexicalUnit.getValue())) {
                        --nbTokens;
                        swapSubjectObject = true;
                        continue block5;
                    }
                    if ("has".equalsIgnoreCase(lexicalUnit.getValue())) {
                        --nbTokens;
                        continue block5;
                    }
                    if ("=".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentPredicate = RdfConstants.PREDICATE_SAME;
                        continue block5;
                    }
                    if ("=>".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentPredicate = RdfConstants.PREDICATE_IMPLIES;
                        continue block5;
                    }
                    if ("<=".equalsIgnoreCase(lexicalUnit.getValue())) {
                        swapSubjectObject = true;
                        currentPredicate = RdfConstants.PREDICATE_IMPLIES;
                        continue block5;
                    }
                    if ("a".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentPredicate = RdfConstants.PREDICATE_TYPE;
                        continue block5;
                    }
                    if ("!".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentObject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        currentPredicate = this.getPredicate(lexicalUnits.get(++i));
                        this.link(currentSubject, currentPredicate, currentObject);
                        currentSubject = currentObject;
                        nbTokens = 1;
                        continue block5;
                    }
                    if ("^".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentObject = currentSubject;
                        currentPredicate = this.getPredicate(lexicalUnits.get(++i));
                        currentSubject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                        nbTokens = 1;
                        continue block5;
                    }
                    currentPredicate = this.getPredicate(lexicalUnit);
                    continue block5;
                }
                case 3: {
                    if ("of".equalsIgnoreCase(lexicalUnit.getValue())) {
                        --nbTokens;
                        continue block5;
                    }
                    int j = i + 1;
                    if (j < lexicalUnits.size() && this.isPath(lexicalUnits.get(j))) {
                        if ("!".equalsIgnoreCase(lexicalUnits.get(j).getValue())) {
                            currentObject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                            this.link(currentSubject, currentPredicate, currentObject);
                            currentPredicate = this.getPredicate(lexicalUnits.get(j + 1));
                            this.link(lexicalUnit.resolve(), currentPredicate, currentObject);
                            currentSubject = currentObject;
                            nbTokens = 0;
                            i += 2;
                            continue block5;
                        }
                        if (!"^".equalsIgnoreCase(lexicalUnits.get(j).getValue())) continue block5;
                        currentObject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                        currentSubject = currentObject;
                        currentPredicate = this.getPredicate(lexicalUnits.get(j + 1));
                        currentObject = lexicalUnit.resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                        nbTokens = 0;
                        i += 2;
                        continue block5;
                    }
                    if (swapSubjectObject) {
                        currentObject = currentSubject;
                        currentSubject = lexicalUnit.resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                        currentSubject = currentObject;
                    } else {
                        currentObject = lexicalUnit.resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                    }
                    nbTokens = 0;
                    swapSubjectObject = false;
                    continue block5;
                }
            }
        }
    }

    private Reference getPredicate(LexicalUnit lexicalUnit) {
        Reference result = null;
        Object p = lexicalUnit.resolve();
        if (p instanceof Reference) {
            result = (Reference)p;
        } else if (p instanceof String) {
            result = new Reference((String)p);
        }
        return result;
    }

    @Override
    protected boolean isDelimiter(int c) {
        return this.isWhiteSpace(c) || c == 94 || c == 33 || c == 61 || c == 60 || c == 34 || c == 123 || c == 125 || c == 91 || c == 93 || c == 40 || c == 41 || c == 46 || c == 59 || c == 44 || c == 64;
    }

    protected boolean isPath(LexicalUnit lexicalUnit) {
        return "!".equals(lexicalUnit.getValue()) || "^".equals(lexicalUnit.getValue());
    }

    @Override
    protected void link(Object source, Reference typeRef, Object target) {
        if (source instanceof Reference) {
            if (target instanceof Reference) {
                this.getGraphHandler().link((Reference)source, typeRef, (Reference)target);
            } else if (target instanceof Literal) {
                this.getGraphHandler().link((Reference)source, typeRef, (Literal)target);
            } else {
                Context.getCurrentLogger().warning("The N3 document contains an object which is neither a Reference nor a literal: " + target);
                Context.getCurrentLogger().warning(this.getParsingMessage());
            }
        } else if (source instanceof Graph) {
            if (target instanceof Reference) {
                this.getGraphHandler().link((Graph)source, typeRef, (Reference)target);
            } else if (target instanceof Literal) {
                this.getGraphHandler().link((Graph)source, typeRef, (Literal)target);
            } else {
                Context.getCurrentLogger().warning("The N3 document contains an object which is neither a Reference nor a literal: " + target);
                Context.getCurrentLogger().warning(this.getParsingMessage());
            }
        }
    }

    @Override
    protected void parseBlankNode(BlankNodeToken blankNode) throws IOException {
        this.step();
        block16: do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '(': {
                    blankNode.getLexicalUnits().add(new ListToken(this, this.getContext()));
                    break;
                }
                case '<': {
                    if (this.step() == 61) {
                        blankNode.getLexicalUnits().add(new Token("<="));
                        this.step();
                        this.discard();
                        break;
                    }
                    this.stepBack();
                    blankNode.getLexicalUnits().add(new UriToken(this, this.getContext()));
                    break;
                }
                case '_': {
                    blankNode.getLexicalUnits().add(new BlankNodeToken(this.parseToken()));
                    break;
                }
                case '\"': {
                    blankNode.getLexicalUnits().add(new StringToken(this, this.getContext()));
                    break;
                }
                case '[': {
                    blankNode.getLexicalUnits().add(new BlankNodeToken(this, this.getContext()));
                    break;
                }
                case '!': {
                    blankNode.getLexicalUnits().add(new Token("!"));
                    this.step();
                    this.discard();
                    break;
                }
                case '^': {
                    blankNode.getLexicalUnits().add(new Token("^"));
                    this.step();
                    this.discard();
                    break;
                }
                case '=': {
                    if (this.step() == 62) {
                        blankNode.getLexicalUnits().add(new Token("=>"));
                        this.step();
                        this.discard();
                        break;
                    }
                    blankNode.getLexicalUnits().add(new Token("="));
                    this.discard();
                    break;
                }
                case '@': {
                    this.step();
                    this.discard();
                    blankNode.getLexicalUnits().add(new Token(this, this.getContext()));
                    this.discard();
                    break;
                }
                case ';': {
                    this.step();
                    this.discard();
                    blankNode.getLexicalUnits().add(new Token(";"));
                    break;
                }
                case ',': {
                    this.step();
                    this.discard();
                    blankNode.getLexicalUnits().add(new Token(","));
                    break;
                }
                case '#': {
                    this.parseComment();
                    break;
                }
                case '{': {
                    blankNode.getLexicalUnits().add(new FormulaToken(this, this.getContext()));
                    break;
                }
                case ']': {
                    break;
                }
                default: {
                    if (this.isEndOfFile(this.getChar())) continue block16;
                    blankNode.getLexicalUnits().add(new Token(this, this.getContext()));
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != ']');
        if (this.getChar() == ']') {
            this.step();
        }
    }

    protected void parseFormula(FormulaToken formulaToken) throws IOException {
        this.step();
        do {
            this.parseStatement(new org.restlet.ext.rdf.internal.turtle.Context());
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != '}');
        if (this.getChar() == '}') {
            this.step();
        }
    }

    @Override
    protected void parseList(ListToken listToken) throws IOException {
        this.step();
        block9: do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '(': {
                    listToken.getLexicalUnits().add(new ListToken(this, this.getContext()));
                    break;
                }
                case '<': {
                    if (this.step() == 61) {
                        listToken.getLexicalUnits().add(new Token("<="));
                        this.step();
                        this.discard();
                        break;
                    }
                    this.stepBack();
                    listToken.getLexicalUnits().add(new UriToken(this, this.getContext()));
                    break;
                }
                case '_': {
                    listToken.getLexicalUnits().add(new BlankNodeToken(this.parseToken()));
                    break;
                }
                case '\"': {
                    listToken.getLexicalUnits().add(new StringToken(this, this.getContext()));
                    break;
                }
                case '[': {
                    listToken.getLexicalUnits().add(new BlankNodeToken(this, this.getContext()));
                    break;
                }
                case '{': {
                    listToken.getLexicalUnits().add(new FormulaToken(this, this.getContext()));
                    break;
                }
                case ')': {
                    break;
                }
                default: {
                    if (this.isEndOfFile(this.getChar())) continue block9;
                    listToken.getLexicalUnits().add(new Token(this, this.getContext()));
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != ')');
        if (this.getChar() == ')') {
            this.step();
        }
    }

    @Override
    protected void parseStatement(org.restlet.ext.rdf.internal.turtle.Context context) throws IOException {
        ArrayList<LexicalUnit> lexicalUnits = new ArrayList<LexicalUnit>();
        block16: do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '(': {
                    lexicalUnits.add(new ListToken(this, context));
                    break;
                }
                case '<': {
                    if (this.step() == 61) {
                        lexicalUnits.add(new Token("<="));
                        this.step();
                        this.discard();
                        break;
                    }
                    this.stepBack();
                    lexicalUnits.add(new UriToken(this, context));
                    break;
                }
                case '_': {
                    lexicalUnits.add(new BlankNodeToken(this.parseToken()));
                    break;
                }
                case '\"': {
                    lexicalUnits.add(new StringToken(this, context));
                    break;
                }
                case '[': {
                    lexicalUnits.add(new BlankNodeToken(this, context));
                    break;
                }
                case '!': {
                    lexicalUnits.add(new Token("!"));
                    this.step();
                    this.discard();
                    break;
                }
                case '^': {
                    lexicalUnits.add(new Token("^"));
                    this.step();
                    this.discard();
                    break;
                }
                case '=': {
                    if (this.step() == 62) {
                        lexicalUnits.add(new Token("=>"));
                        this.step();
                        this.discard();
                        break;
                    }
                    lexicalUnits.add(new Token("="));
                    this.discard();
                    break;
                }
                case '@': {
                    this.step();
                    this.discard();
                    lexicalUnits.add(new Token(this, context));
                    this.discard();
                    break;
                }
                case ';': {
                    this.step();
                    this.discard();
                    lexicalUnits.add(new Token(";"));
                    break;
                }
                case ',': {
                    this.step();
                    this.discard();
                    lexicalUnits.add(new Token(","));
                    break;
                }
                case '{': {
                    lexicalUnits.add(new FormulaToken(this, context));
                    break;
                }
                case '#': {
                    this.parseComment();
                    break;
                }
                case '.': {
                    break;
                }
                default: {
                    if (this.isEndOfFile(this.getChar())) continue block16;
                    lexicalUnits.add(new Token(this, context));
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != '.' && this.getChar() != '}');
        this.generateLinks(lexicalUnits);
    }
}

