/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.Data;
import org.entrystore.DeletedEntryInfo;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.List;
import org.entrystore.PrincipalManager;
import org.entrystore.QuotaException;
import org.entrystore.Resource;
import org.entrystore.ResourceType;
import org.entrystore.exception.EntryMissingException;
import org.entrystore.impl.DataImpl;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.ListImpl;
import org.entrystore.impl.RDFResource;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.ResourceImpl;
import org.entrystore.impl.SoftCache;
import org.entrystore.impl.StringResource;
import org.entrystore.impl.Util;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.security.DisallowedException;
import org.entrystore.repository.test.TestSuite;
import org.entrystore.repository.util.NS;
import org.entrystore.repository.util.URISplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextImpl
extends ResourceImpl
implements Context {
    private long counter = -1L;
    protected final SoftCache softCache;
    protected String id;
    protected HashMap<URI, Object> extMdUri2entry;
    protected HashMap<URI, Object> res2entry;
    protected ArrayList<URI> systemEntries = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    public static final IRI DCModified = Values.iri((String)NS.dc, (String)"modified");
    public static final IRI DCTermsModified = Values.iri((String)NS.dcterms, (String)"modified");
    private final Object quotaMutex = new Object();
    protected long quotaFillLevel = -3L;
    protected long quota = -3L;
    private volatile boolean deleted = false;

    protected ContextImpl(EntryImpl entry, String uri, SoftCache softCache) {
        super(entry, uri);
        this.softCache = softCache;
        this.id = uri.substring(uri.lastIndexOf(47) + 1);
    }

    public ContextImpl(EntryImpl entry, IRI contextUri, SoftCache softCache) {
        super(entry, contextUri);
        this.softCache = softCache;
        this.id = this.resourceURI.toString().substring(this.resourceURI.toString().lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reIndex() {
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    ValueFactory vf = this.entry.repository.getValueFactory();
                    rc.begin();
                    rc.remove((org.eclipse.rdf4j.model.Resource)null, RepositoryProperties.mdHasEntry, null, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    rc.remove((org.eclipse.rdf4j.model.Resource)null, RepositoryProperties.resHasEntry, null, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    rc.remove((org.eclipse.rdf4j.model.Resource)null, RepositoryProperties.counter, null, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    ArrayList<Statement> stmntsToAdd = new ArrayList<Statement>();
                    int maxIndex = 0;
                    RepositoryResult resources = rc.getStatements(null, RepositoryProperties.resource, null, false, new org.eclipse.rdf4j.model.Resource[0]);
                    while (resources.hasNext()) {
                        Statement statement = (Statement)resources.next();
                        org.eclipse.rdf4j.model.Resource mmd = statement.getContext();
                        if (!(mmd instanceof IRI)) continue;
                        if (!mmd.stringValue().startsWith(this.entry.getRepositoryManager().getRepositoryURL().toString())) {
                            log.warn("This Entry URI does not belong to this repository: {}", (Object)mmd.stringValue());
                            continue;
                        }
                        StringTokenizer tokenizer = Util.extractParameters((RepositoryManager)this.entry.repositoryManager, (IRI)mmd);
                        if (tokenizer.countTokens() != 3 || !tokenizer.nextToken().equals(this.id)) continue;
                        try {
                            tokenizer.nextToken();
                            int index = Integer.parseInt(tokenizer.nextToken());
                            if (index > maxIndex) {
                                maxIndex = index;
                            }
                        }
                        catch (NumberFormatException index) {
                            // empty catch block
                        }
                        stmntsToAdd.add(vf.createStatement((org.eclipse.rdf4j.model.Resource)statement.getObject(), RepositoryProperties.resHasEntry, (Value)statement.getContext(), (org.eclipse.rdf4j.model.Resource)this.resourceURI));
                    }
                    resources.close();
                    RepositoryResult externalMD = rc.getStatements(null, RepositoryProperties.externalMetadata, null, false, new org.eclipse.rdf4j.model.Resource[0]);
                    while (externalMD.hasNext()) {
                        StringTokenizer stok;
                        Statement statement = (Statement)externalMD.next();
                        org.eclipse.rdf4j.model.Resource mmd = statement.getContext();
                        if (!(mmd instanceof IRI) || (stok = Util.extractParameters((RepositoryManager)this.entry.repositoryManager, (IRI)mmd)).countTokens() != 3 || !stok.nextToken().equals(this.id)) continue;
                        stmntsToAdd.add(vf.createStatement((org.eclipse.rdf4j.model.Resource)statement.getObject(), RepositoryProperties.mdHasEntry, (Value)statement.getContext(), (org.eclipse.rdf4j.model.Resource)this.resourceURI));
                    }
                    externalMD.close();
                    rc.add(stmntsToAdd, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.counter, (Value)vf.createLiteral(maxIndex), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    rc.commit();
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
        this.res2entry = null;
        this.extMdUri2entry = null;
        this.loadIndex();
    }

    private void push(URI from, URI to, HashMap<URI, Object> map) {
        if (from == null || to == null) {
            return;
        }
        if (map == null) {
            log.warn("Map to be pushed to is not initialized");
            return;
        }
        Object existingTo = map.get(from);
        if (existingTo == null) {
            map.put(from, to);
        } else if (existingTo instanceof Set) {
            ((Set)existingTo).add(to);
        } else {
            HashSet<URI> set = new HashSet<URI>();
            set.add((URI)existingTo);
            set.add(to);
            map.put(from, set);
        }
    }

    private void pop(URI from, URI to, HashMap<URI, Object> map) {
        if (from == null || to == null) {
            return;
        }
        if (map == null) {
            log.warn("Map to be popped from is not initialized");
            return;
        }
        Object existingTo = map.get(from);
        if (existingTo != null) {
            if (existingTo instanceof Set) {
                ((Set)existingTo).remove(to);
                if (((Set)existingTo).isEmpty()) {
                    map.remove(from);
                }
            } else if (existingTo.equals(to)) {
                map.remove(from);
            }
        }
    }

    void updateResource2EntryIndex(URI oldResourceURI, URI newResourceURI, URI entryURI) {
        if (oldResourceURI == null || newResourceURI == null || entryURI == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        log.debug("Removing resource to entry mapping: {} -> {}", (Object)oldResourceURI, (Object)entryURI);
        this.pop(oldResourceURI, entryURI, this.res2entry);
        log.debug("Adding resource to entry mapping: {} -> {}", (Object)newResourceURI, (Object)entryURI);
        this.push(newResourceURI, entryURI, this.res2entry);
    }

    void updateExternalMetadata2EntryIndex(URI oldExtMdURI, URI newExtMdURI, URI entryURI) {
        if (oldExtMdURI == null || newExtMdURI == null || entryURI == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        log.debug("Removing external metadata to entry mapping: {} -> {}", (Object)oldExtMdURI, (Object)entryURI);
        this.pop(oldExtMdURI, entryURI, this.extMdUri2entry);
        log.debug("Adding external metadata to entry mapping: {} -> {}", (Object)newExtMdURI, (Object)entryURI);
        this.push(newExtMdURI, entryURI, this.extMdUri2entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadIndex() {
        try {
            EntryImpl entryImpl = this.entry;
            synchronized (entryImpl) {
                if (this.res2entry != null) {
                    return;
                }
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    this.res2entry = new HashMap();
                    this.extMdUri2entry = new HashMap();
                    RepositoryResult statements = rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    while (statements.hasNext()) {
                        Statement statement = (Statement)statements.next();
                        try {
                            URI entryURI;
                            IRI predicate = statement.getPredicate();
                            if (predicate.equals((Object)RepositoryProperties.mdHasEntry)) {
                                URI mdURI = URI.create(statement.getSubject().toString());
                                entryURI = URI.create(statement.getObject().toString());
                                this.push(mdURI, entryURI, this.extMdUri2entry);
                                continue;
                            }
                            if (predicate.equals((Object)RepositoryProperties.resHasEntry)) {
                                URI resourceURI = URI.create(statement.getSubject().toString());
                                entryURI = URI.create(statement.getObject().toString());
                                this.push(resourceURI, entryURI, this.res2entry);
                                continue;
                            }
                            if (!predicate.equals((Object)RepositoryProperties.counter)) continue;
                            this.counter = ((Literal)statement.getObject()).intValue();
                        }
                        catch (Exception e) {
                            log.error(e.getMessage());
                        }
                    }
                    statements.close();
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository", (Exception)((Object)e));
        }
    }

    private void addToIndex(IRI entryURI, IRI resURI, IRI extMdURI, RepositoryConnection rc) throws RepositoryException {
        rc.add((org.eclipse.rdf4j.model.Resource)resURI, RepositoryProperties.resHasEntry, (Value)entryURI, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
        URI euri = URI.create(entryURI.toString());
        if (extMdURI != null) {
            rc.add((org.eclipse.rdf4j.model.Resource)extMdURI, RepositoryProperties.mdHasEntry, (Value)entryURI, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            if (this.extMdUri2entry != null) {
                URI mdURI = URI.create(extMdURI.toString());
                this.push(mdURI, euri, this.extMdUri2entry);
            }
        }
        if (this.res2entry != null) {
            URI resourceURI = URI.create(resURI.toString());
            this.push(resourceURI, euri, this.res2entry);
        }
    }

    protected void removeFromIndex(EntryImpl entry, RepositoryConnection rc) throws RepositoryException {
        IRI entryURI = entry.getSesameEntryURI();
        IRI resURI = entry.getSesameResourceURI();
        IRI mdURI = entry.getSesameExternalMetadataURI();
        rc.remove((org.eclipse.rdf4j.model.Resource)resURI, RepositoryProperties.resHasEntry, (Value)entryURI, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
        if (mdURI != null) {
            rc.remove((org.eclipse.rdf4j.model.Resource)mdURI, RepositoryProperties.mdHasEntry, (Value)entryURI, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            if (this.extMdUri2entry != null) {
                this.pop(entry.getExternalMetadataURI(), entry.getEntryURI(), this.extMdUri2entry);
            }
        }
        if (this.res2entry != null) {
            this.pop(entry.getResourceURI(), entry.getEntryURI(), this.res2entry);
        }
        if (RepositoryManagerImpl.trackDeletedEntries) {
            URI deletedBy;
            ValueFactory vf = rc.getValueFactory();
            XMLGregorianCalendar deletedDate = null;
            try {
                deletedDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            }
            catch (DatatypeConfigurationException e) {
                log.error(e.getMessage());
            }
            if (deletedDate != null) {
                Statement delDateStatement = vf.createStatement((org.eclipse.rdf4j.model.Resource)entryURI, RepositoryProperties.Deleted, (Value)vf.createLiteral(deletedDate), (org.eclipse.rdf4j.model.Resource)this.resourceURI);
                rc.add(delDateStatement, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            }
            if ((deletedBy = entry.getRepositoryManager().getPrincipalManager().getAuthenticatedUserURI()) != null) {
                Statement delByStatement = vf.createStatement((org.eclipse.rdf4j.model.Resource)entryURI, RepositoryProperties.DeletedBy, (Value)vf.createIRI(deletedBy.toString()), (org.eclipse.rdf4j.model.Resource)this.resourceURI);
                rc.add(delByStatement, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, DeletedEntryInfo> getDeletedEntries() {
        RepositoryConnection rc = null;
        java.util.List delDates = null;
        java.util.List delPrincipals = null;
        Repository repository = this.entry.repository;
        synchronized (repository) {
            try {
                rc = this.entry.getRepository().getConnection();
                delDates = rc.getStatements(null, RepositoryProperties.Deleted, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}).stream().toList();
                delPrincipals = rc.getStatements(null, RepositoryProperties.DeletedBy, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}).stream().toList();
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            finally {
                if (rc != null) {
                    try {
                        rc.close();
                    }
                    catch (RepositoryException e) {
                        log.error(e.getMessage());
                    }
                }
            }
        }
        HashMap<URI, Date> uri2date = new HashMap<URI, Date>();
        if (delDates != null) {
            for (Statement dateStatement : delDates) {
                URI deletedEntryURI = URI.create(dateStatement.getSubject().stringValue());
                Date deletionDate = ((Literal)dateStatement.getObject()).calendarValue().toGregorianCalendar().getTime();
                uri2date.put(deletedEntryURI, deletionDate);
            }
        }
        HashMap<URI, URI> uri2principal = new HashMap<URI, URI>();
        if (delPrincipals != null) {
            for (Statement principalStatement : delPrincipals) {
                URI deletedEntryURI = URI.create(principalStatement.getSubject().stringValue());
                URI deletedBy = URI.create(principalStatement.getObject().stringValue());
                uri2principal.put(deletedEntryURI, deletedBy);
            }
        }
        HashMap<URI, DeletedEntryInfo> result = new HashMap<URI, DeletedEntryInfo>();
        for (URI delEntryURI : uri2principal.keySet()) {
            DeletedEntryInfo delEntryInfo = new DeletedEntryInfo(delEntryURI, (Date)uri2date.get(delEntryURI), (URI)uri2principal.get(delEntryURI));
            result.put(delEntryURI, delEntryInfo);
        }
        return result;
    }

    public Map<URI, DeletedEntryInfo> getDeletedEntriesInRange(Date from, Date until) {
        if (from == null && until == null) {
            return this.getDeletedEntries();
        }
        HashMap<URI, DeletedEntryInfo> result = new HashMap<URI, DeletedEntryInfo>();
        Map<URI, DeletedEntryInfo> allDeletedEntries = this.getDeletedEntries();
        for (URI delEntryURI : allDeletedEntries.keySet()) {
            boolean inRange = true;
            DeletedEntryInfo delEntryInfo = allDeletedEntries.get(delEntryURI);
            Date deletionDate = delEntryInfo.getDeletionDate();
            if (deletionDate != null) {
                if (from != null && !deletionDate.after(from)) {
                    inRange = false;
                }
                if (until != null && !deletionDate.before(until)) {
                    inRange = false;
                }
            }
            if (!inRange) continue;
            result.put(delEntryURI, delEntryInfo);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected synchronized EntryImpl createNewMinimalItem(URI resourceURI, URI metadataURI, EntryType lType, GraphType bType, ResourceType rType, String entryId) {
        try (RepositoryConnection rc = this.entry.repository.getConnection();){
            IRI resURI;
            String identity;
            ValueFactory vf = this.entry.repository.getValueFactory();
            rc.begin();
            if (this.counter == -1L) {
                java.util.List counters = rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.counter, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}).stream().toList();
                this.counter = !counters.isEmpty() ? (long)((Literal)((Statement)counters.getFirst()).getObject()).intValue() : 0L;
            }
            String base = this.entry.repositoryManager.getRepositoryURL().toString();
            if (entryId != null) {
                identity = entryId;
            } else {
                IRI entryUri;
                java.util.List infoRecord;
                do {
                    ++this.counter;
                    identity = Long.toString(this.counter);
                } while (!(infoRecord = rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{entryUri = vf.createIRI(base + this.id + "/entry/" + this.counter)}).stream().toList()).isEmpty());
            }
            if (resourceURI != null) {
                String resourceURIStr = resourceURI.toString().replace("_newId", identity);
                resURI = vf.createIRI(resourceURIStr);
            } else {
                resURI = bType == GraphType.Context || bType == GraphType.SystemContext ? vf.createIRI(URISplit.createURI(base, identity).toString()) : vf.createIRI(URISplit.createURI(base, this.id, RepositoryProperties.getResourcePath(bType), identity).toString());
            }
            EntryImpl newEntry = null;
            try {
                newEntry = new EntryImpl(identity, this, this.entry.repositoryManager, this.entry.getRepository());
                if (lType == EntryType.Reference || lType == EntryType.LinkReference) {
                    newEntry.create(resURI, vf.createIRI(metadataURI.toString()), bType, lType, rType, rc);
                } else {
                    newEntry.create(resURI, null, bType, lType, rType, rc);
                }
                this.initResource(newEntry);
                this.addToIndex(newEntry.getSesameEntryURI(), newEntry.getSesameResourceURI(), newEntry.getSesameExternalMetadataURI(), rc);
                java.util.List counters = rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.counter, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}).stream().toList();
                rc.remove(counters, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.counter, (Value)vf.createLiteral(this.counter), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                rc.commit();
                this.softCache.put(newEntry);
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)newEntry, RepositoryEvent.EntryCreated));
                EntryImpl entryImpl = newEntry;
                return entryImpl;
            }
            catch (Exception e) {
                rc.rollback();
                if (newEntry != null) {
                    newEntry.refreshFromRepository(rc);
                }
                throw new org.entrystore.repository.RepositoryException("Error in connection to repository", e);
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository", (Exception)((Object)e));
        }
    }

    public void initResource(EntryImpl newEntry) throws RepositoryException {
        if (newEntry.getEntryType() != EntryType.Local) {
            return;
        }
        switch (newEntry.getGraphType()) {
            case None: 
            case PipelineResult: {
                if (newEntry.getEntryType() != EntryType.Local) break;
                newEntry.setResource(new DataImpl(newEntry));
                break;
            }
            case List: {
                newEntry.setResource(new ListImpl(newEntry, newEntry.getSesameResourceURI()));
                break;
            }
            case ResultList: {
                break;
            }
            case String: {
                newEntry.setResource(new StringResource(newEntry, newEntry.getSesameResourceURI()));
                break;
            }
            case Graph: 
            case Pipeline: {
                newEntry.setResource(new RDFResource(newEntry, newEntry.getSesameResourceURI()));
                break;
            }
        }
    }

    private ListImpl getList(URI listURI) {
        URI listEntryURI;
        Entry listItem;
        if (listURI != null && (listItem = this.getByEntryURI(listEntryURI = new URISplit(listURI, this.entry.getRepositoryManager().getRepositoryURL()).getMetaMetadataURI())).getGraphType() == GraphType.List && listItem.getEntryType() == EntryType.Local) {
            return (ListImpl)listItem.getResource();
        }
        return null;
    }

    protected boolean checkAccess(Entry secondChance, PrincipalManager.AccessProperty ap) throws AuthorizationException {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        if (pm == null) {
            return true;
        }
        try {
            pm.checkAuthenticatedUserAuthorized((Entry)this.entry, ap);
            return true;
        }
        catch (AuthorizationException ae) {
            if (secondChance != null) {
                pm.checkAuthenticatedUserAuthorized(secondChance, ap);
                return false;
            }
            throw ae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry createLinkReference(String entryId, URI resourceURI, URI metadataURI, URI listURI) throws AuthorizationException {
        ListImpl list = this.getList(listURI);
        boolean isOwner = this.checkAccess(list != null ? list.entry : null, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            EntryImpl entry = this.createNewMinimalItem(resourceURI, metadataURI, EntryType.LinkReference, GraphType.None, null, entryId);
            if (list != null) {
                list.addChild(entry.getEntryURI());
                this.copyACL(list, (Entry)entry);
                if (!isOwner) {
                    entry.setOriginalListSynchronized(listURI.toString());
                }
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry createReference(String entryId, URI resourceURI, URI metadataURI, URI listURI) {
        ListImpl list = this.getList(listURI);
        boolean isOwner = this.checkAccess(list != null ? list.entry : null, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            EntryImpl entry = this.createNewMinimalItem(resourceURI, metadataURI, EntryType.Reference, GraphType.None, null, entryId);
            if (list != null) {
                list.addChild(entry.getEntryURI());
                this.copyACL(list, (Entry)entry);
                if (!isOwner) {
                    entry.setOriginalListSynchronized(listURI.toString());
                }
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry createLink(String entryId, URI resourceURI, URI listURI) {
        ListImpl list = this.getList(listURI);
        boolean isOwner = this.checkAccess(list != null ? list.entry : null, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            EntryImpl entry = this.createNewMinimalItem(resourceURI, null, EntryType.Link, GraphType.None, null, entryId);
            if (list != null) {
                list.addChild(entry.getEntryURI());
                this.copyACL(list, (Entry)entry);
                if (!isOwner) {
                    entry.setOriginalListSynchronized(listURI.toString());
                }
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry createResource(String entryId, GraphType buiType, ResourceType repType, URI listURI) {
        ListImpl list = this.getList(listURI);
        boolean isOwner = this.checkAccess(list != null ? list.entry : null, PrincipalManager.AccessProperty.WriteResource);
        boolean allowUserGroupToReadMetadata = true;
        Repository repository = this.entry.repository;
        synchronized (repository) {
            EntryImpl entry = this.createNewMinimalItem(null, null, EntryType.Local, buiType, repType, entryId);
            if (list != null) {
                log.info("Adding entry {} to list {}", (Object)entry.getEntryURI(), (Object)list.getURI());
                list.addChild(entry.getEntryURI());
                log.info("Copying ACL from list {} to entry {}", (Object)list.getURI(), (Object)entry.getEntryURI());
                this.copyACL(list, (Entry)entry);
                if (!isOwner) {
                    entry.setOriginalListSynchronized(listURI.toString());
                }
            }
            if (GraphType.Context.equals((Object)buiType)) {
                ((Context)entry.getResource()).initializeSystemEntries();
            } else if (GraphType.User.equals((Object)buiType)) {
                entry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteResource, entry.getResourceURI());
                entry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteMetadata, entry.getResourceURI());
                entry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, ((PrincipalManager)this).getUserGroup().getURI());
            } else if (GraphType.Group.equals((Object)buiType)) {
                entry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadResource, entry.getResourceURI());
                if (allowUserGroupToReadMetadata) {
                    entry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, ((PrincipalManager)this).getUserGroup().getURI());
                } else {
                    entry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, entry.getResourceURI());
                }
            }
            return entry;
        }
    }

    public void copyACL(List fromList, Entry toEntry) {
        if (toEntry instanceof EntryImpl) {
            EntryImpl entryImpl = (EntryImpl)toEntry;
            Set adminPrincipals = fromList.getEntry().getAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer);
            if (toEntry.getGraphType() != GraphType.List || toEntry.getEntryType() != EntryType.Local) {
                PrincipalManager pm = toEntry.getRepositoryManager().getPrincipalManager();
                try {
                    pm.checkAuthenticatedUserAuthorized(fromList.getEntry(), PrincipalManager.AccessProperty.Administer);
                }
                catch (AuthorizationException ae) {
                    adminPrincipals.add(pm.getAuthenticatedUserURI());
                }
            }
            entryImpl.updateAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer, adminPrincipals, false, true);
            entryImpl.updateAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, fromList.getEntry().getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata), false, true);
            entryImpl.updateAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadResource, fromList.getEntry().getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadResource), false, true);
            entryImpl.updateAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteMetadata, fromList.getEntry().getAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteMetadata), false, true);
            entryImpl.updateAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteResource, fromList.getEntry().getAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteResource), false, true);
        } else {
            log.warn("copyACL(fromList, toEntry): Not setting an ACL: toEntry is not an instance of EntryImpl");
        }
    }

    public void copyACL(URI fromList, Entry toEntry) {
        this.copyACL(this.getList(fromList), toEntry);
    }

    public Entry get(String entryId) {
        return this.getByEntryURI(URISplit.createURI(this.entry.getRepositoryManager().getRepositoryURL().toString(), this.id, "entry", entryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getByEntryURI(URI entryURI) {
        SoftCache softCache = this.softCache;
        synchronized (softCache) {
            Entry entry = this.softCache.getByEntryURI(entryURI);
            if (entry != null) {
                return entry;
            }
            try {
                return this.getByMMdURIDirect(entryURI);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    private Entry getByMMdURIDirect(URI entryURI) throws RepositoryException {
        Entry result;
        try (RepositoryConnection rc = null;){
            rc = this.entry.getRepository().getConnection();
            result = this.getByMMdURIDirect(entryURI, rc);
        }
        return result;
    }

    private Entry getByMMdURIDirect(URI entryURI, RepositoryConnection rc) throws RepositoryException {
        if (entryURI == null) {
            return null;
        }
        EntryImpl newEntry = null;
        try {
            URISplit split = new URISplit(entryURI, this.entry.getRepositoryManager().getRepositoryURL());
            if (!this.id.equals(split.getContextId())) {
                return null;
            }
            try {
                newEntry = new EntryImpl(split.getId(), this, this.entry.repositoryManager, this.entry.getRepository());
            }
            catch (IllegalArgumentException iae) {
                log.error("Error when creating entry object: {}", (Object)iae.getMessage());
            }
            if (newEntry != null && newEntry.load(rc)) {
                if (newEntry.getEntryType() == EntryType.Local) {
                    this.initResource(newEntry);
                }
                this.softCache.put(newEntry);
                if (GraphType.Context.equals((Object)newEntry.getGraphType()) && EntryType.Local.equals((Object)newEntry.getEntryType())) {
                    Resource resource = newEntry.getResource();
                    if (resource != null) {
                        ((Context)resource).initializeSystemEntries();
                    } else {
                        log.error("Entry's resource is null: {}", (Object)newEntry.getEntryURI());
                    }
                }
            } else {
                newEntry = null;
            }
        }
        catch (AuthorizationException ae) {
            throw ae;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Error in connection to repository", e);
        }
        return newEntry;
    }

    public Set<Entry> getByExternalMdURI(URI metadataURI) {
        if (this.extMdUri2entry == null) {
            this.loadIndex();
        }
        HashSet<Entry> entries = new HashSet<Entry>();
        Object value = this.extMdUri2entry.get(metadataURI);
        if (value != null) {
            if (value instanceof URI) {
                entries.add(this.getByEntryURI((URI)value));
            } else {
                Set mmdURIs = (Set)value;
                for (URI uri : mmdURIs) {
                    entries.add(this.getByEntryURI(uri));
                }
            }
        }
        return entries;
    }

    public Set<Entry> getByResourceURI(URI resourceURI) {
        if (this.res2entry == null) {
            this.loadIndex();
        }
        HashSet<Entry> entries = new HashSet<Entry>();
        Object value = this.res2entry.get(resourceURI);
        if (value != null) {
            if (value instanceof URI) {
                entries.add(this.getByEntryURI((URI)value));
            } else {
                Set mmdURIs = (Set)value;
                for (URI uri : mmdURIs) {
                    entries.add(this.getByEntryURI(uri));
                }
            }
        }
        return entries;
    }

    public Set<URI> getEntries() {
        if (this.res2entry == null) {
            this.loadIndex();
        }
        HashSet<URI> entries = new HashSet<URI>();
        Collection<Object> val = this.res2entry.values();
        for (Object object : val) {
            if (object instanceof URI) {
                entries.add((URI)object);
                continue;
            }
            entries.addAll((Collection)object);
        }
        return entries;
    }

    public Set<URI> getResources() {
        this.checkAccess(null, PrincipalManager.AccessProperty.ReadResource);
        if (this.res2entry == null) {
            this.loadIndex();
        }
        return this.res2entry.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(URI entryURI) throws EntryMissingException {
        if (this.systemEntries.contains(entryURI)) {
            throw new DisallowedException("Cannot remove system entry with URI: " + String.valueOf(entryURI));
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            EntryImpl removeEntry = (EntryImpl)this.getByEntryURI(entryURI);
            if (removeEntry == null) {
                throw new EntryMissingException(entryURI);
            }
            this.checkAccess(removeEntry, PrincipalManager.AccessProperty.Administer);
            try {
                for (URI uri : removeEntry.getReferringListsInSameContext()) {
                    Entry listItem = this.getByResourceURI(uri).iterator().next();
                    ((ListImpl)listItem.getResource()).removeChild(entryURI, false);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("An error occurred when removing the entry from one or more lists", e);
            }
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                rc.begin();
                this.removeFromIndex(removeEntry, rc);
                removeEntry.remove(rc);
                this.entry.updateModifiedDateSynchronized(rc, this.entry.repository.getValueFactory());
                rc.commit();
                this.softCache.remove(removeEntry);
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)removeEntry, RepositoryEvent.EntryDeleted));
            }
            catch (Exception e) {
                try {
                    rc.rollback();
                }
                catch (NullPointerException | RepositoryException e1) {
                    log.error(e1.getMessage());
                    throw new org.entrystore.repository.RepositoryException("Error when rolling back transaction", e);
                }
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("Error in connection to repository", e);
            }
            finally {
                try {
                    rc.close();
                }
                catch (NullPointerException | RepositoryException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RepositoryConnection rc) throws Exception {
        Repository repository = this.entry.repository;
        synchronized (repository) {
            if (this.res2entry == null) {
                this.loadIndex();
            }
            this.deleted = true;
            for (URI entryURI : this.getEntries()) {
                EntryImpl removeEntry = (EntryImpl)this.getByEntryURI(entryURI);
                this.removeFromIndex(removeEntry, rc);
                rc.clear(new org.eclipse.rdf4j.model.Resource[]{removeEntry.getSesameEntryURI()});
                if (this.systemEntries.contains(removeEntry.getEntryURI())) continue;
                removeEntry.remove(rc);
            }
            rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDefaultQuota() {
        RepositoryConnection rc = null;
        try {
            rc = this.entry.repository.getConnection();
            boolean bl = !rc.hasStatement((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.Quota, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            return bl;
        }
        catch (RepositoryException re) {
            log.error(re.getMessage(), (Throwable)re);
        }
        finally {
            try {
                rc.close();
            }
            catch (NullPointerException | RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQuota() {
        if (this.quota == -3L) {
            long queriedQuota = this.entry.getRepositoryManager().getDefaultQuota();
            Repository repository = this.entry.repository;
            synchronized (repository) {
                RepositoryConnection rc = null;
                try {
                    rc = this.entry.repository.getConnection();
                    java.util.List quotaStatement = rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.Quota, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}).stream().toList();
                    for (Statement statement : quotaStatement) {
                        if (!(statement.getObject() instanceof Literal)) continue;
                        queriedQuota = ((Literal)statement).longValue();
                        break;
                    }
                }
                catch (RepositoryException re) {
                    log.error(re.getMessage(), (Throwable)re);
                }
                finally {
                    try {
                        rc.close();
                    }
                    catch (NullPointerException | RepositoryException e) {
                        log.error(e.getMessage());
                    }
                }
            }
            this.quota = queriedQuota;
        }
        return this.quota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuota(long quotaInBytes) {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        URI authUserURI = pm.getAuthenticatedUserURI();
        if (!pm.getAdminUser().getURI().equals(authUserURI) && !pm.getAdminGroup().isMember(pm.getUser(authUserURI))) {
            log.info("Access denied, only administrators can set the allowed quota");
            throw new AuthorizationException(pm.getUser(authUserURI), (Entry)this.entry, PrincipalManager.AccessProperty.Administer);
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                rc.begin();
                rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.Quota, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.Quota, (Value)rc.getValueFactory().createLiteral(quotaInBytes), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                rc.commit();
                this.quota = quotaInBytes;
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.EntryUpdated));
            }
            catch (RepositoryException re) {
                log.error(re.getMessage(), (Throwable)re);
                try {
                    rc.rollback();
                }
                catch (NullPointerException | RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
            finally {
                try {
                    rc.close();
                }
                catch (NullPointerException | RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuota() {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        URI authUserURI = pm.getAuthenticatedUserURI();
        if (!pm.getAdminUser().getURI().equals(authUserURI) && !pm.getAdminGroup().isMember(pm.getUser(authUserURI))) {
            log.info("Access denied, only administrators can set the allowed quota");
            throw new AuthorizationException(pm.getUser(authUserURI), (Entry)this.entry, PrincipalManager.AccessProperty.Administer);
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.Quota, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                this.quota = -3L;
            }
            catch (RepositoryException re) {
                log.error(re.getMessage(), (Throwable)re);
            }
            finally {
                try {
                    rc.close();
                }
                catch (NullPointerException | RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQuotaFillLevel() {
        long queriedQuotaFillLevel = -2L;
        if (this.quotaFillLevel == -3L) {
            Object object = this.entry.repository;
            synchronized (object) {
                RepositoryConnection rc = null;
                try {
                    rc = this.entry.repository.getConnection();
                    java.util.List quotaStatement = rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.QuotaFillLevel, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}).stream().toList();
                    for (Statement statement : quotaStatement) {
                        if (!(statement.getObject() instanceof Literal)) continue;
                        queriedQuotaFillLevel = ((Literal)statement.getObject()).longValue();
                        break;
                    }
                }
                catch (RepositoryException re) {
                    log.error(re.getMessage(), (Throwable)re);
                }
                finally {
                    try {
                        rc.close();
                    }
                    catch (NullPointerException | RepositoryException e) {
                        log.error(e.getMessage());
                    }
                }
            }
            if (queriedQuotaFillLevel == -2L) {
                object = this.quotaMutex;
                synchronized (object) {
                    this.setQuotaFillLevel(this.recalculateQuotaFillLevel());
                }
            }
        }
        return queriedQuotaFillLevel;
    }

    private long recalculateQuotaFillLevel() {
        long fillLevel = 0L;
        Date before = new Date();
        Set<URI> entries = this.getEntries();
        for (URI uri : entries) {
            File f;
            Entry e = this.getByEntryURI(uri);
            if (!EntryType.Local.equals((Object)e.getEntryType()) || !(e.getResource() instanceof Data) || (f = ((Data)e.getResource()).getDataFile()) == null) continue;
            fillLevel += f.length();
        }
        log.info("Calculation of quota fill level took {} ms", (Object)(new Date().getTime() - before.getTime()));
        return fillLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseQuotaFillLevel(long bytes) throws QuotaException {
        long quota = this.getQuota();
        Object object = this.quotaMutex;
        synchronized (object) {
            long newFillLevel = this.getQuotaFillLevel() + bytes;
            if (quota > -1L && newFillLevel > quota) {
                throw new QuotaException(1);
            }
            this.setQuotaFillLevel(newFillLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseQuotaFillLevel(long bytes) {
        Object object = this.quotaMutex;
        synchronized (object) {
            this.setQuotaFillLevel(this.getQuotaFillLevel() - bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQuotaFillLevel(long bytes) {
        Repository repository = this.entry.repository;
        synchronized (repository) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                rc.begin();
                rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.QuotaFillLevel, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI}), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, RepositoryProperties.QuotaFillLevel, (Value)rc.getValueFactory().createLiteral(bytes), new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                rc.commit();
                this.quotaFillLevel = bytes;
            }
            catch (RepositoryException re) {
                log.error(re.getMessage(), (Throwable)re);
                try {
                    rc.rollback();
                }
                catch (NullPointerException | RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
            finally {
                try {
                    rc.close();
                }
                catch (NullPointerException | RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public void initializeSystemEntries() {
    }

    protected void addSystemEntryToSystemEntries(URI uri) {
        this.systemEntries.add(uri);
    }

    public void setMetadata(Entry entry, String title, String desc) {
        try {
            Model graph = entry.getLocalMetadata().getGraph();
            IRI root = Values.iri((String)entry.getResourceURI().toString());
            graph.add((org.eclipse.rdf4j.model.Resource)root, TestSuite.dc_title, (Value)Values.literal((String)title, (String)"en"), new org.eclipse.rdf4j.model.Resource[0]);
            if (desc != null) {
                graph.add((org.eclipse.rdf4j.model.Resource)root, TestSuite.dc_description, (Value)Values.literal((String)desc, (String)"en"), new org.eclipse.rdf4j.model.Resource[0]);
            }
            entry.getLocalMetadata().setGraph(graph);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Generated
    public SoftCache getSoftCache() {
        return this.softCache;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }
}

