/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.trig.TriGParser;
import org.eclipse.rdf4j.rio.trig.TriGWriter;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.Resource;
import org.entrystore.ResourceType;
import org.entrystore.impl.ContextImpl;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.EntryNamesContext;
import org.entrystore.impl.LocalMetadataWrapper;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.SoftCache;
import org.entrystore.impl.Util;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.DisallowedException;
import org.entrystore.repository.util.FileOperations;
import org.entrystore.repository.util.NS;
import org.entrystore.repository.util.URISplit;
import org.entrystore.repository.util.URIType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagerImpl
extends EntryNamesContext
implements ContextManager {
    Logger log = LoggerFactory.getLogger(ContextManagerImpl.class);

    public ContextManagerImpl(RepositoryManagerImpl rman, Repository repo) {
        super(new EntryImpl(rman, repo), URISplit.createURI(rman.getRepositoryURL().toString(), "_contexts", "resource", "_contexts").toString(), rman.getSoftCache());
        EntryImpl e = (EntryImpl)this.getByEntryURI(URISplit.createURI(rman.getRepositoryURL().toString(), "_contexts", "entry", "_contexts"));
        if (e == null) {
            e = this.createNewMinimalItem(null, null, EntryType.Local, GraphType.SystemContext, null, rman.getSystemContextAliases().getFirst());
        }
        this.entry = e;
        this.loadIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContext(URI contextURI) throws RepositoryException {
        if (contextURI == null) {
            throw new IllegalArgumentException("Context URI must not be null");
        }
        Object contextURIStr = contextURI.toString();
        if (!((String)contextURIStr).endsWith("/")) {
            contextURIStr = (String)contextURIStr + "/";
        }
        Entry contextEntry = this.getEntry(contextURI);
        String contextId = contextEntry.getId();
        Repository repository = this.entry.repository;
        synchronized (repository) {
            try (RepositoryConnection rc = null;){
                this.log.info("Removing context {} from index", (Object)contextURI);
                this.remove(contextURI);
                rc = this.entry.getRepository().getConnection();
                rc.begin();
                ValueFactory vf = rc.getValueFactory();
                RepositoryResult availableNGs = rc.getContextIDs();
                ArrayList<org.eclipse.rdf4j.model.Resource> filteredNGs = new ArrayList<org.eclipse.rdf4j.model.Resource>();
                while (availableNGs.hasNext()) {
                    org.eclipse.rdf4j.model.Resource ng = (org.eclipse.rdf4j.model.Resource)availableNGs.next();
                    if (!ng.toString().startsWith((String)contextURIStr)) continue;
                    filteredNGs.add(ng);
                }
                availableNGs.close();
                org.eclipse.rdf4j.model.Resource[] filteredNGsArray = filteredNGs.toArray(new org.eclipse.rdf4j.model.Resource[filteredNGs.size()]);
                if (filteredNGsArray == null || filteredNGsArray.length == 0) {
                    this.log.warn("No named graphs match this context");
                    return;
                }
                IRI contextURISesame = vf.createIRI(contextURI.toString());
                IRI baseURI = vf.createIRI(this.entry.getRepositoryManager().getRepositoryURL().toString());
                String baseURIStr = baseURI.toString();
                this.log.info("Removing triples contained in context {}", (Object)contextURI);
                rc.remove(rc.getStatements(null, null, null, false, filteredNGsArray), new org.eclipse.rdf4j.model.Resource[0]);
                rc.remove(rc.getStatements(null, null, (Value)contextURISesame, false, new org.eclipse.rdf4j.model.Resource[0]), new org.eclipse.rdf4j.model.Resource[0]);
                rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)contextURISesame, null, null, false, new org.eclipse.rdf4j.model.Resource[0]), new org.eclipse.rdf4j.model.Resource[0]);
                this.log.info("Removing references to context " + String.valueOf(contextURI));
                rc.remove(rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{vf.createIRI(URISplit.createURI(baseURIStr, "_contexts", "entry", contextId).toString())}), new org.eclipse.rdf4j.model.Resource[0]);
                rc.remove(rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{vf.createIRI(URISplit.createURI(baseURIStr, "_contexts", "metadata", contextId).toString())}), new org.eclipse.rdf4j.model.Resource[0]);
                rc.remove(rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{vf.createIRI(URISplit.createURI(baseURIStr, "_contexts", "resource", contextId).toString())}), new org.eclipse.rdf4j.model.Resource[0]);
                rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)vf.createIRI(URISplit.createURI(baseURIStr, "_contexts", "entry", contextId).toString()), null, null, false, new org.eclipse.rdf4j.model.Resource[0]), new org.eclipse.rdf4j.model.Resource[0]);
                rc.commit();
                String contextPath = this.entry.getRepositoryManager().getConfiguration().getString(Settings.DATA_FOLDER);
                if (contextPath != null) {
                    File contextPathFile = new File(contextPath);
                    File contextFolder = new File(contextPathFile, contextId);
                    if (contextFolder.exists() && contextFolder.isDirectory() && contextFolder.canWrite()) {
                        this.log.info("Removing all local files referenced by context {}", (Object)contextURI);
                        FileOperations.deleteAllFilesInDir(contextFolder);
                        contextFolder.delete();
                    } else {
                        this.log.error("The data path of context {} is not a folder or not writable: {}", (Object)contextId, (Object)contextFolder);
                    }
                } else {
                    this.log.error("No data folder configured");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportContext(Entry contextEntry, File destFile, Set<URI> users, boolean metadataOnly, Class<? extends RDFWriter> writer) throws RepositoryException {
        Object contextResourceURI = contextEntry.getResourceURI().toString();
        if (!((String)contextResourceURI).endsWith("/")) {
            contextResourceURI = (String)contextResourceURI + "/";
        }
        String contextEntryURI = contextEntry.getEntryURI().toString();
        String contextMetadataURI = contextEntry.getLocalMetadataURI().toString();
        String contextRelationURI = contextEntry.getRelationURI().toString();
        Repository repository = this.entry.repository;
        synchronized (repository) {
            block26: {
                BufferedOutputStream out;
                RepositoryConnection rc;
                block25: {
                    rc = null;
                    out = null;
                    try {
                        try {
                            out = new BufferedOutputStream(Files.newOutputStream(destFile.toPath(), new OpenOption[0]));
                        }
                        catch (IOException e) {
                            this.log.error(e.getMessage());
                            throw new RepositoryException((Throwable)e);
                        }
                        rc = this.entry.getRepository().getConnection();
                        RepositoryResult availableNGs = rc.getContextIDs();
                        ArrayList<org.eclipse.rdf4j.model.Resource> filteredNGs = new ArrayList<org.eclipse.rdf4j.model.Resource>();
                        while (availableNGs.hasNext()) {
                            org.eclipse.rdf4j.model.Resource ng = (org.eclipse.rdf4j.model.Resource)availableNGs.next();
                            String ngURI = ng.stringValue();
                            if (metadataOnly) {
                                if (!ngURI.startsWith((String)contextResourceURI) || !ngURI.contains("/metadata/") && !ngURI.contains("/cached-external-metadata/")) continue;
                                filteredNGs.add(ng);
                                continue;
                            }
                            if (!ngURI.startsWith((String)contextResourceURI) && !ngURI.equals(contextEntryURI) && !ngURI.equals(contextMetadataURI) && !ngURI.equals(contextRelationURI)) continue;
                            filteredNGs.add(ng);
                        }
                        availableNGs.close();
                        RDFHandler rdfWriter = null;
                        try {
                            Constructor<? extends RDFWriter> constructor = writer.getConstructor(OutputStream.class);
                            rdfWriter = (RDFHandler)constructor.newInstance(out);
                        }
                        catch (Exception e) {
                            this.log.error(e.getMessage());
                        }
                        if (rdfWriter == null) {
                            this.log.error("Unable to create an RDF writer, format not supported");
                            break block25;
                        }
                        rdfWriter.startRDF();
                        HashMap<String, String> namespaces = NS.getMap();
                        for (String nsName : namespaces.keySet()) {
                            rdfWriter.handleNamespace(nsName, (String)namespaces.get(nsName));
                        }
                        RepositoryResult rr = rc.getStatements(null, null, null, false, filteredNGs.toArray(new org.eclipse.rdf4j.model.Resource[filteredNGs.size()]));
                        while (rr.hasNext()) {
                            Statement s = (Statement)rr.next();
                            IRI p = s.getPredicate();
                            rdfWriter.handleStatement(s);
                            if (metadataOnly || !p.equals((Object)RepositoryProperties.Creator) && !p.equals((Object)RepositoryProperties.Contributor) && !p.equals((Object)RepositoryProperties.Read) && !p.equals((Object)RepositoryProperties.Write) && !p.equals((Object)RepositoryProperties.DeletedBy)) continue;
                            users.add(URI.create(s.getObject().stringValue()));
                        }
                        rr.close();
                        rdfWriter.endRDF();
                        break block26;
                    }
                    catch (RepositoryException e) {
                        this.log.error("Error when exporting context", (Throwable)e);
                        throw e;
                    }
                    catch (RDFHandlerException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                        throw new RepositoryException((Throwable)e);
                    }
                }
                return;
                finally {
                    rc.close();
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importContext(Entry contextEntry, File srcFile) throws RepositoryException, IOException {
        File resourceDir;
        Date before = new Date();
        File unzippedDir = FileOperations.createTempDirectory("entrystore_import", null);
        FileOperations.unzipFile(srcFile, unzippedDir);
        File propFile = new File(unzippedDir, "export.properties");
        this.log.info("Loading property file from {}", (Object)propFile);
        Properties props = new Properties();
        props.load(Files.newInputStream(propFile.toPath(), new OpenOption[0]));
        String srcBaseURI = props.getProperty("baseURI");
        String srcContextEntryURI = props.getProperty("contextEntryURI");
        String srcContextResourceURI = props.getProperty("contextResourceURI");
        String srcContextMetadataURI = props.getProperty("contextMetadataURI");
        String srcContextRelationURI = props.getProperty("contextRelationURI");
        String srcContainedUsers = props.getProperty("containedUsers");
        if (srcBaseURI == null || srcContextEntryURI == null || srcContextResourceURI == null || srcContainedUsers == null) {
            String msg = "Property file of import ZIP did not contain all necessary properties, aborting import";
            this.log.error(msg);
            throw new org.entrystore.repository.RepositoryException(msg);
        }
        this.log.info("baseURI: {}", (Object)srcBaseURI);
        this.log.info("contextEntryURI: {}", (Object)srcContextEntryURI);
        this.log.info("contextResourceURI: {}", (Object)srcContextResourceURI);
        this.log.info("contextMetadataURI: {}", (Object)srcContextMetadataURI);
        this.log.info("contextRelationURI: {}", (Object)srcContextRelationURI);
        this.log.info("containedUsers: {}", (Object)srcContainedUsers);
        String[] containedUsers = srcContainedUsers.split(",");
        HashMap<String, String> id2name = new HashMap<String, String>();
        for (String u : containedUsers) {
            String[] uS = u.split(":");
            if (uS.length == 1) {
                id2name.put(uS[0], null);
                continue;
            }
            if (uS.length != 2) continue;
            id2name.put(uS[0], uS[1]);
        }
        this.log.info("Removing old entries from context...");
        Context cont = this.getContext(contextEntry.getId());
        Set entries = cont.getEntries();
        for (URI entryURI : entries) {
            File[] eId = cont.getByEntryURI(entryURI).getId();
            if (eId.startsWith("_")) continue;
            this.log.info("Removing {}", (Object)entryURI);
            try {
                cont.remove(entryURI);
            }
            catch (DisallowedException de) {
                this.log.warn(de.getMessage());
            }
        }
        File dstDir = new File(this.entry.getRepositoryManager().getConfiguration().getString(Settings.DATA_FOLDER), contextEntry.getId());
        if (!dstDir.exists()) {
            dstDir.mkdirs();
        }
        if ((resourceDir = new File(unzippedDir, "resources")) != null && resourceDir.exists() && resourceDir.isDirectory()) {
            for (File src : resourceDir.listFiles()) {
                File dst = new File(dstDir, src.getName());
                this.log.info("Copying {} to {}", (Object)src, (Object)dst);
                FileOperations.copyFile(src, dst);
            }
        }
        long amountTriples = 0L;
        long importedTriples = 0L;
        File tripleFile = new File(unzippedDir, "triples.rdf");
        this.log.info("Loading quadruples from {}", (Object)tripleFile);
        BufferedInputStream rdfInput = new BufferedInputStream(Files.newInputStream(tripleFile.toPath(), new OpenOption[0]));
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        File[] fileArray = this.entry.repository;
        synchronized (this.entry.repository) {
            this.log.info("Importing context from stream");
            try (RepositoryConnection rc = null;){
                Object newContextNS;
                Object newBaseURI;
                rc = this.entry.getRepository().getConnection();
                rc.begin();
                TriGParser parser = new TriGParser();
                parser.getParserConfig().set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
                StatementCollector collector = new StatementCollector();
                parser.setRDFHandler((RDFHandler)collector);
                parser.parse((InputStream)rdfInput, srcBaseURI);
                Object oldBaseURI = srcBaseURI;
                if (!((String)oldBaseURI).endsWith("/")) {
                    oldBaseURI = (String)oldBaseURI + "/";
                }
                if (!((String)(newBaseURI = this.entry.getRepositoryManager().getRepositoryURL().toString())).endsWith("/")) {
                    newBaseURI = (String)newBaseURI + "/";
                }
                String oldContextID = srcContextResourceURI.substring(srcContextResourceURI.lastIndexOf("/") + 1);
                String newContextID = contextEntry.getId();
                String oldContextResourceURI = srcContextResourceURI;
                String oldContextEntryURI = srcContextEntryURI;
                String oldContextMetadataURI = srcContextMetadataURI;
                String oldContextRelationURI = srcContextRelationURI;
                Object oldContextNS = oldContextResourceURI;
                if (!((String)oldContextNS).endsWith("/")) {
                    oldContextNS = (String)oldContextNS + "/";
                }
                if (!((String)(newContextNS = contextEntry.getResourceURI().toString())).endsWith("/")) {
                    newContextNS = (String)newContextNS + "/";
                }
                this.log.info("Old context ID: {}", (Object)oldContextID);
                this.log.info("New context ID: {}", (Object)newContextID);
                this.log.info("Old context resource URI: {}", (Object)oldContextResourceURI);
                this.log.info("New context resource URI: {}", (Object)contextEntry.getResourceURI().toString());
                this.log.info("Old context entry URI: {}", (Object)oldContextEntryURI);
                this.log.info("New context entry URI: {}", (Object)contextEntry.getEntryURI().toString());
                this.log.info("Old context metadata URI: {}", (Object)oldContextMetadataURI);
                this.log.info("New context metadata URI: {}", (Object)contextEntry.getLocalMetadataURI().toString());
                this.log.info("Old context relation URI: {}", (Object)oldContextRelationURI);
                this.log.info("New context relation URI: {}", (Object)contextEntry.getRelationURI().toString());
                ValueFactory vf = rc.getValueFactory();
                for (Statement s : collector.getStatements()) {
                    Statement newStmnt;
                    ++amountTriples;
                    org.eclipse.rdf4j.model.Resource context = s.getContext();
                    if (context == null) {
                        this.log.warn("No named graph information provided, ignoring triple");
                        continue;
                    }
                    org.eclipse.rdf4j.model.Resource subject = s.getSubject();
                    IRI predicate = s.getPredicate();
                    Value object = s.getObject();
                    if (predicate.equals((Object)RepositoryProperties.Creator) || predicate.equals((Object)RepositoryProperties.Contributor) || predicate.equals((Object)RepositoryProperties.Read) || predicate.equals((Object)RepositoryProperties.Write) || predicate.equals((Object)RepositoryProperties.DeletedBy)) {
                        String oldUserID = object.stringValue().substring(object.stringValue().lastIndexOf("/") + 1);
                        this.log.info("Old user URI: {}", (Object)object);
                        this.log.info("Old user ID: {}", (Object)oldUserID);
                        String oldUserName = (String)id2name.get(oldUserID);
                        URI newUserURI = null;
                        Entry pE = null;
                        pE = oldUserName == null ? pm.get(oldUserID) : pm.getPrincipalEntry(oldUserName);
                        if (pE != null) {
                            newUserURI = pE.getResourceURI();
                        }
                        if (newUserURI == null) {
                            this.log.info("Unable to detect principal for ID {}, skipping", (Object)oldUserID);
                            continue;
                        }
                        object = vf.createIRI(newUserURI.toString());
                        this.log.info("Created principal URI for user {}:{}: {}", new Object[]{oldUserID, oldUserName, object.stringValue()});
                    }
                    if (subject instanceof IRI) {
                        String sS = subject.stringValue();
                        if (sS.startsWith((String)oldContextNS)) {
                            subject = vf.createIRI(sS.replace((CharSequence)oldContextNS, (CharSequence)newContextNS));
                        } else if (sS.equals(oldContextEntryURI)) {
                            subject = vf.createIRI(contextEntry.getEntryURI().toString());
                        } else if (sS.equals(oldContextResourceURI)) {
                            subject = vf.createIRI(contextEntry.getResourceURI().toString());
                        } else if (sS.equals(oldContextMetadataURI)) {
                            subject = vf.createIRI(contextEntry.getLocalMetadataURI().toString());
                        } else if (sS.equals(oldContextRelationURI)) {
                            subject = vf.createIRI(contextEntry.getRelationURI().toString());
                        }
                    }
                    if (object instanceof IRI) {
                        String oS = object.stringValue();
                        if (oS.startsWith((String)oldContextNS)) {
                            object = vf.createIRI(oS.replace((CharSequence)oldContextNS, (CharSequence)newContextNS));
                        } else if (oS.equals(oldContextEntryURI)) {
                            object = vf.createIRI(contextEntry.getEntryURI().toString());
                        } else if (oS.equals(oldContextResourceURI)) {
                            object = vf.createIRI(contextEntry.getResourceURI().toString());
                        } else if (oS.equals(oldContextMetadataURI)) {
                            object = vf.createIRI(contextEntry.getLocalMetadataURI().toString());
                        } else if (oS.equals(oldContextRelationURI)) {
                            object = vf.createIRI(contextEntry.getRelationURI().toString());
                        }
                    }
                    if (context instanceof IRI) {
                        String cS = context.stringValue();
                        if (cS.startsWith((String)oldContextNS)) {
                            context = vf.createIRI(cS.replace((CharSequence)oldContextNS, (CharSequence)newContextNS));
                        } else if (cS.equals(oldContextEntryURI)) {
                            context = vf.createIRI(contextEntry.getEntryURI().toString());
                        } else if (cS.equals(oldContextResourceURI)) {
                            context = vf.createIRI(contextEntry.getResourceURI().toString());
                        } else if (cS.equals(oldContextMetadataURI)) {
                            context = vf.createIRI(contextEntry.getLocalMetadataURI().toString());
                        } else if (cS.equals(oldContextRelationURI)) {
                            context = vf.createIRI(contextEntry.getRelationURI().toString());
                        }
                    }
                    if (!rc.hasStatement(newStmnt = vf.createStatement(subject, predicate, object, context), false, new org.eclipse.rdf4j.model.Resource[]{context})) {
                        ++importedTriples;
                        this.log.info("Adding statement to repository: {}", (Object)newStmnt.toString());
                        rc.add(newStmnt, new org.eclipse.rdf4j.model.Resource[]{context});
                        continue;
                    }
                    this.log.warn("Statement already exists, skipping: {}", (Object)newStmnt.toString());
                }
                rc.commit();
            }
            // ** MonitorExit[var26_32] (shouldn't be in output)
            this.log.info("Removing temporary files");
            for (File f : unzippedDir.listFiles()) {
                if (f.isDirectory()) {
                    FileOperations.deleteAllFilesInDir(f);
                }
                f.delete();
            }
            unzippedDir.delete();
            this.log.info("Reindexing {}", (Object)cont.getEntry().getEntryURI());
            cont.reIndex();
            this.log.info("Import finished in {} ms", (Object)(new Date().getTime() - before.getTime()));
            this.log.info("Imported {} triples", (Object)importedTriples);
            this.log.info("Skipped {} triples", (Object)(amountTriples - importedTriples));
            return;
        }
    }

    public boolean deleteBackup(URI contexturi, String fromTime) {
        String folder = this.getContextBackupFolder(contexturi, fromTime);
        File backupFolder = new File(folder);
        if (backupFolder.exists()) {
            return FileOperations.deleteDirectory(backupFolder);
        }
        this.log.error("The folder does not exist");
        return false;
    }

    public String getBackup(URI contexturi, String fromTime) {
        String folder = this.getContextBackupFolder(contexturi, fromTime);
        try {
            File file = new File(folder, "portfolio-index.rdf");
            File file2 = new File(folder, "portfolio-entries.rdf");
            String content1 = FileUtils.readFileToString((File)file);
            String content2 = FileUtils.readFileToString((File)file2);
            return content1 + content2;
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    public String createBackup(URI contexturi) throws RepositoryException {
        HashMap<String, String> map = this.getContextBackupFolder(contexturi, new Date());
        File backupFolder = new File(map.get("dateFolder"));
        backupFolder.mkdirs();
        try (RepositoryConnection conn = null;){
            TriGWriter entryHandler;
            conn = this.entry.getRepository().getConnection();
            Entry portfolio = this.getEntry(contexturi);
            TriGWriter indexHandler = null;
            try {
                indexHandler = new TriGWriter(Files.newOutputStream(new File(backupFolder, "portfolio-index.rdf").toPath(), new OpenOption[0]));
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
            ValueFactory f = this.entry.getRepository().getValueFactory();
            try {
                conn.export((RDFHandler)indexHandler, new org.eclipse.rdf4j.model.Resource[]{f.createIRI(portfolio.getEntryURI().toString())});
                conn.export((RDFHandler)indexHandler, new org.eclipse.rdf4j.model.Resource[]{f.createIRI(portfolio.getLocalMetadataURI().toString())});
                conn.export((RDFHandler)indexHandler, new org.eclipse.rdf4j.model.Resource[]{f.createIRI(portfolio.getResourceURI().toString())});
            }
            catch (RDFHandlerException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
            Context pfContext = (Context)portfolio.getResource();
            try {
                entryHandler = new TriGWriter(Files.newOutputStream(new File(backupFolder, "portfolio-entries.rdf").toPath(), new OpenOption[0]));
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
            try {
                Set portfolioResources = pfContext.getEntries();
                for (URI uri : portfolioResources) {
                    Entry e = pfContext.getByEntryURI(uri);
                    conn.export((RDFHandler)entryHandler, new org.eclipse.rdf4j.model.Resource[]{f.createIRI(e.getEntryURI().toString())});
                    if (e.getEntryType() == EntryType.Local || e.getEntryType() == EntryType.Link || e.getEntryType() == EntryType.LinkReference) {
                        conn.export((RDFHandler)entryHandler, new org.eclipse.rdf4j.model.Resource[]{f.createIRI(e.getLocalMetadata().getURI().toString())});
                    }
                    if (e.getEntryType() == EntryType.Local && e.getGraphType() != GraphType.None) {
                        conn.export((RDFHandler)entryHandler, new org.eclipse.rdf4j.model.Resource[]{f.createIRI(e.getResourceURI().toString())});
                        continue;
                    }
                    if (e.getEntryType() == EntryType.Local && e.getGraphType() == GraphType.None && e.getResourceType() != ResourceType.InformationResource) continue;
                }
            }
            catch (RDFHandlerException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
        }
        return map.get("timestampStr");
    }

    public List<Date> listBackups(URI contexturi) {
        File dir = new File(this.getContextBackupFolder(contexturi));
        String[] children = dir.list();
        ArrayList<Date> backups = new ArrayList<Date>();
        for (int i = 0; i < children.length; ++i) {
            Date bkp = this.parseTimestamp(children[i]);
            if (bkp == null) continue;
            backups.add(bkp);
        }
        return backups;
    }

    public void restoreBackup(URI contexturi, String fromTime) {
        this.remove(this.getByResourceURI(contexturi).iterator().next().getEntryURI());
        TriGParser trigParser = new TriGParser();
        trigParser.getParserConfig().set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        StatementCollector collector = new StatementCollector();
        trigParser.setRDFHandler((RDFHandler)collector);
        String folder = this.getContextBackupFolder(contexturi, fromTime);
        try {
            InputStream fileOut = Files.newInputStream(new File(folder, "portfolio-index.rdf").toPath(), new OpenOption[0]);
            InputStream fileOut2 = Files.newInputStream(new File(folder, "portfolio-entries.rdf").toPath(), new OpenOption[0]);
            String base = this.entry.getRepositoryManager().getConfiguration().getString(Settings.BASE_URL, "https://entrystore.org");
            trigParser.parse(fileOut, base);
            fileOut.close();
            try (RepositoryConnection conn = this.entry.getRepository().getConnection();){
                for (Statement s : collector.getStatements()) {
                    conn.add(s, new org.eclipse.rdf4j.model.Resource[0]);
                }
                trigParser.parse(fileOut2, base);
                fileOut2.close();
                for (Statement s : collector.getStatements()) {
                    conn.add(s, new org.eclipse.rdf4j.model.Resource[0]);
                }
            }
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            this.log.error(e.getMessage());
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getContextBackupFolder(URI contexturi) {
        Object backupFolder = this.entry.getRepositoryManager().getConfiguration().getString(Settings.BACKUP_FOLDER);
        String helper = contexturi.toString();
        String pfId = helper.substring(helper.lastIndexOf("/") + 1);
        if (!((String)backupFolder).endsWith("/")) {
            backupFolder = (String)backupFolder + "/";
        }
        return (String)backupFolder + pfId;
    }

    public HashMap<String, String> getContextBackupFolder(URI contexturi, Date date) {
        String timestampStr = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        File backupFolder = new File(this.getContextBackupFolder(contexturi));
        File datedFolder = new File(backupFolder, timestampStr);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dateFolder", datedFolder.toString());
        map.put("timestampStr", timestampStr);
        return map;
    }

    public String getContextBackupFolder(URI contexturi, String date) {
        File backupFolder = new File(this.getContextBackupFolder(contexturi));
        File datedFolder = new File(backupFolder, date);
        return datedFolder.toString();
    }

    private Date parseTimestamp(String timestamp) {
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = formatter.parse(timestamp);
        }
        catch (ParseException pe) {
            this.log.error(pe.getMessage());
        }
        return date;
    }

    @Override
    public String getName(URI contextURI) {
        URISplit us = new URISplit(contextURI, this.entry.getRepositoryManager().getRepositoryURL());
        if (us.getUriType() == URIType.Resource) {
            return super.getName(us.getMetaMetadataURI());
        }
        throw new org.entrystore.repository.RepositoryException("Given URI is not an existing contextURI.");
    }

    public URI getContextURI(String contextAlias) {
        Entry contextEntry = this.getEntryByName(contextAlias);
        if (contextEntry == null) {
            return null;
        }
        if (contextEntry.getGraphType() == GraphType.Context || contextEntry.getGraphType() == GraphType.SystemContext) {
            return contextEntry.getResourceURI();
        }
        throw new org.entrystore.repository.RepositoryException("Found entry for the alias is not a context...\nthis is either a programming error or someone have been tampering with the RDF directly.");
    }

    public Set<String> getNames() {
        return this.getEntryNames();
    }

    public boolean setName(URI contextURI, String newAlias) {
        URISplit us = new URISplit(contextURI, this.entry.getRepositoryManager().getRepositoryURL());
        Entry contextEntry = this.getByEntryURI(us.getMetaMetadataURI());
        if (contextEntry == null) {
            throw new org.entrystore.repository.RepositoryException("Cannot find an entry for the specified URI");
        }
        if (contextEntry.getGraphType() == GraphType.Context || contextEntry.getGraphType() == GraphType.SystemContext) {
            return this.setEntryName(us.getMetaMetadataURI(), newAlias);
        }
        throw new org.entrystore.repository.RepositoryException("Given URI does not refer to a Context.");
    }

    public Context getContext(String contextId) {
        Resource context;
        Entry entry = this.get(contextId);
        if (entry == null) {
            entry = this.getEntryByName(contextId);
        }
        if (entry != null && (entry.getGraphType() == GraphType.Context || entry.getGraphType() == GraphType.SystemContext) && (context = entry.getResource()) instanceof Context) {
            return (Context)context;
        }
        return null;
    }

    public Context getContext(URI contextURI) {
        if (contextURI == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        String contextID = contextURI.toString().substring(contextURI.toString().lastIndexOf("/") + 1);
        return this.getContext(contextID);
    }

    public Entry getEntry(URI uri) {
        return this.getEntry(uri, true);
    }

    protected Entry getEntryIgnoreACL(URI uri) {
        return this.getEntry(uri, false);
    }

    private Entry getEntry(URI uri, boolean withACL) {
        URI entryURI;
        URISplit usplit = new URISplit(uri, this.entry.getRepositoryManager().getRepositoryURL());
        try {
            entryURI = usplit.getMetaMetadataURI();
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Unable to construct entry URI based on likely incorrect URI [{}], error was: {}", (Object)uri, (Object)e.getMessage());
            return null;
        }
        if (usplit.getUriType() != URIType.Unknown) {
            Entry item = this.softCache.getByEntryURI(entryURI);
            if (item != null) {
                if (withACL) {
                    ((ContextImpl)item.getContext()).checkAccess(item, PrincipalManager.AccessProperty.ReadMetadata);
                }
                return item;
            }
            Entry contextEntry = this.getByEntryURI(usplit.getContextMetaMetadataURI());
            if (contextEntry != null) {
                return ((Context)contextEntry.getResource()).getByEntryURI(usplit.getMetaMetadataURI());
            }
            this.log.warn("No context found for Entry with URI {}", (Object)uri);
        }
        return null;
    }

    public Set<Entry> getLinks(URI resourceURI) {
        return this.getLinksOrReferences(resourceURI, true);
    }

    public Set<Entry> getReferences(URI metadataURI) {
        return this.getLinksOrReferences(metadataURI, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Entry> getLinksOrReferences(URI uri, boolean findLinks) {
        HashSet<Entry> entries = new HashSet<Entry>();
        try (RepositoryConnection rc = this.entry.repository.getConnection();){
            ValueFactory vf = this.entry.repository.getValueFactory();
            IRI resource = vf.createIRI(uri.toString());
            if (findLinks) {
                RepositoryResult resources = rc.getStatements((org.eclipse.rdf4j.model.Resource)resource, RepositoryProperties.resHasEntry, null, false, new org.eclipse.rdf4j.model.Resource[0]);
                while (resources.hasNext()) {
                    Statement statement = (Statement)resources.next();
                    try {
                        Entry entry = this.getItemInRepositoryByMMdURI(URI.create(statement.getObject().stringValue()));
                        if (entry.getEntryType() != EntryType.Link) continue;
                        entries.add(entry);
                    }
                    catch (AuthorizationException entry) {}
                }
                resources.close();
            } else {
                RepositoryResult resources = rc.getStatements((org.eclipse.rdf4j.model.Resource)resource, RepositoryProperties.mdHasEntry, null, false, new org.eclipse.rdf4j.model.Resource[0]);
                while (resources.hasNext()) {
                    Statement statement = (Statement)resources.next();
                    try {
                        Entry entry = this.getItemInRepositoryByMMdURI(URI.create(statement.getObject().stringValue()));
                        if (entry.getEntryType() != EntryType.Reference) continue;
                        entries.add(entry);
                    }
                    catch (AuthorizationException authorizationException) {}
                }
                resources.close();
            }
        }
        catch (RepositoryException e) {
            this.log.error("Repository error", (Throwable)e);
            throw new org.entrystore.repository.RepositoryException("Repository error", (Exception)((Object)e));
        }
        return entries;
    }

    protected Entry getItemInRepositoryByMMdURI(URI mmdURI) {
        Entry entry = this.softCache.getByEntryURI(mmdURI);
        if (entry != null) {
            ((ContextImpl)entry.getContext()).checkAccess(entry, PrincipalManager.AccessProperty.ReadMetadata);
            return entry;
        }
        Entry contextItem = this.getByEntryURI(Util.getContextMMdURIFromURI(this.entry.getRepositoryManager(), mmdURI));
        return ((Context)contextItem.getResource()).getByEntryURI(mmdURI);
    }

    @Override
    public void initResource(EntryImpl newEntry) throws RepositoryException {
        if (newEntry.getEntryType() != EntryType.Local) {
            return;
        }
        switch (newEntry.getGraphType()) {
            case Context: {
                Class clsReg = this.entry.repositoryManager.getRegularContextClass();
                try {
                    Object[] constrParamReg = new Object[]{newEntry, newEntry.getResourceURI().toString(), this.softCache};
                    Class[] constrClsParamReg = new Class[]{EntryImpl.class, String.class, SoftCache.class};
                    Constructor constrReg = clsReg.getConstructor(constrClsParamReg);
                    Context context = (Context)constrReg.newInstance(constrParamReg);
                    newEntry.setResource((Resource)context);
                    break;
                }
                catch (Exception e) {
                    throw new RepositoryException("Could not instantiate class " + clsReg.getName() + "\nfor regular Context with URI " + String.valueOf(newEntry.getEntryURI()));
                }
            }
            case SystemContext: {
                Class cls = this.entry.repositoryManager.getSystemContextClassForAlias(newEntry.getId());
                if (cls.isAssignableFrom(this.getClass())) {
                    newEntry.setResource(this);
                    break;
                }
                try {
                    Object[] constrParam = new Object[]{newEntry, newEntry.getResourceURI().toString(), this.softCache};
                    Class[] constrClsParam = new Class[]{EntryImpl.class, String.class, SoftCache.class};
                    Constructor constr = cls.getConstructor(constrClsParam);
                    newEntry.setResource((Resource)((Context)constr.newInstance(constrParam)));
                    break;
                }
                catch (Exception e) {
                    throw new RepositoryException("Could not instantiate class " + cls.getName() + "\nfor SystemContext with URI " + String.valueOf(newEntry.getEntryURI()));
                }
            }
            default: {
                super.initResource(newEntry);
            }
        }
    }

    public List<Entry> search(String entryQueryString, String mdQueryString, List<URI> contextList) throws Exception {
        List<Entry> mdEntries = null;
        List<Entry> entries = null;
        List<Entry> intersectionEntries = null;
        mdEntries = this.searchMetadataQuery(mdQueryString);
        entries = this.searchEntryQuery(entryQueryString);
        intersectionEntries = this.intersectEntries(entries, mdEntries);
        List<Entry> foundEntries = this.intersectEntriesFromContexts(intersectionEntries, contextList);
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (Entry entry : foundEntries) {
            if (entry == null || !this.isEntryMetadataReadable(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Entry, Integer> searchLiterals(Set<IRI> predicates, String[] terms, String lang, List<URI> context, boolean andOperation) {
        HashMap<org.eclipse.rdf4j.model.Resource, Integer> matches = new HashMap<org.eclipse.rdf4j.model.Resource, Integer>();
        RepositoryConnection rc = null;
        try {
            rc = this.entry.getRepository().getConnection();
            for (IRI iRI : predicates) {
                RepositoryResult rr = rc.getStatements(null, iRI, null, false, new org.eclipse.rdf4j.model.Resource[0]);
                while (rr.hasNext()) {
                    Statement s = (Statement)rr.next();
                    Value o = s.getObject();
                    if (!(o instanceof Literal) || lang != null && !lang.equalsIgnoreCase(((Literal)o).getLanguage().orElse(null))) continue;
                    org.eclipse.rdf4j.model.Resource c = s.getContext();
                    if (context != null && !context.isEmpty()) {
                        int contextMatches = 0;
                        for (URI cURI : context) {
                            if (cURI == null || !c.stringValue().startsWith(cURI.toString())) continue;
                            ++contextMatches;
                        }
                        if (contextMatches == 0) continue;
                    }
                    int matchCount = 0;
                    for (String term : terms) {
                        if (!o.stringValue().toLowerCase().contains(term.toLowerCase())) continue;
                        ++matchCount;
                    }
                    if (andOperation && matchCount != terms.length) continue;
                    if (matches.containsKey(c)) {
                        matches.put(c, (Integer)matches.get(c) + matchCount);
                        continue;
                    }
                    matches.put(c, matchCount);
                }
                rr.close();
            }
        }
        catch (RepositoryException re) {
            this.log.error(re.getMessage(), (Throwable)re);
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException re) {}
            }
        }
        Map<Object, Integer> result = new LinkedHashMap<Entry, Integer>();
        for (org.eclipse.rdf4j.model.Resource mdURI : matches.keySet()) {
            Entry e;
            URISplit split = new URISplit(URI.create(mdURI.toString()), this.entry.repositoryManager.getRepositoryURL());
            URI entryURI = split.getMetaMetadataURI();
            if (entryURI == null) continue;
            try {
                e = this.getEntry(entryURI);
            }
            catch (AuthorizationException ae) {
                continue;
            }
            if (e == null || !this.isEntryMetadataReadable(e)) continue;
            result.put(e, (Integer)matches.get(mdURI));
        }
        if (result.size() > 1) {
            Date date = new Date();
            result = this.sortMapByValue(result, false);
            this.log.debug("Sorting results took: {} ms", (Object)(new Date().getTime() - date.getTime()));
        }
        return result;
    }

    public boolean isEntryMetadataReadable(Entry entry) {
        if (entry == null) {
            return false;
        }
        PrincipalManager pm = entry.getRepositoryManager().getPrincipalManager();
        try {
            if ((entry.getEntryType() == EntryType.Reference || entry.getEntryType() == EntryType.LinkReference) && entry.getCachedExternalMetadata() instanceof LocalMetadataWrapper) {
                Entry refEntry = entry.getRepositoryManager().getContextManager().getEntry(entry.getExternalMetadataURI());
                pm.checkAuthenticatedUserAuthorized(refEntry, PrincipalManager.AccessProperty.ReadMetadata);
            } else {
                pm.checkAuthenticatedUserAuthorized(entry, PrincipalManager.AccessProperty.ReadMetadata);
            }
        }
        catch (AuthorizationException ae) {
            return false;
        }
        return true;
    }

    public Map sortMapByValue(Map map, final boolean ascending) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
                if (result == 0) {
                    result = ((Map.Entry)o1).getKey().toString().compareToIgnoreCase(((Map.Entry)o2).getKey().toString());
                }
                if (!ascending) {
                    result *= -1;
                }
                return result;
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private List<Entry> intersectEntries(List<Entry> entries, List<Entry> mdEntries) {
        if (mdEntries != null && entries != null) {
            mdEntries.retainAll(entries);
            return mdEntries;
        }
        if (mdEntries != null) {
            return mdEntries;
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> searchMetadataQuery(String mdQueryString) throws RepositoryException {
        if (mdQueryString == null) {
            return null;
        }
        ArrayList<Entry> entryURIs = new ArrayList<Entry>();
        try (RepositoryConnection rc = null;){
            rc = this.entry.getRepository().getConnection();
            TupleQuery mdQuery = rc.prepareTupleQuery(QueryLanguage.SPARQL, mdQueryString);
            ArrayList<String> mdURIs = new ArrayList<String>();
            TupleQueryResult result = mdQuery.evaluate();
            while (result.hasNext()) {
                BindingSet set = (BindingSet)result.next();
                for (Binding obj : set) {
                    String mdURI;
                    if (!(obj.getValue() instanceof IRI) || mdURIs.contains(mdURI = obj.getValue().toString())) continue;
                    mdURIs.add(mdURI);
                }
            }
            for (String mdStr : mdURIs) {
                Entry ent;
                URISplit split = new URISplit(URI.create(mdStr), this.entry.repositoryManager.getRepositoryURL());
                URI entryURI = split.getMetaMetadataURI();
                if (entryURIs.contains(entryURI) || entryURI == null) continue;
                try {
                    ent = this.getEntry(entryURI);
                }
                catch (NullPointerException | AuthorizationException ex) {
                    continue;
                }
                if (ent == null || entryURIs.contains(ent)) continue;
                entryURIs.add(ent);
            }
        }
        return entryURIs;
    }

    private List<Entry> intersectEntriesFromContexts(List<Entry> intersectionEntries, List<URI> contextList) {
        if (contextList == null) {
            return intersectionEntries;
        }
        ArrayList<Entry> resultList = new ArrayList<Entry>();
        if (intersectionEntries != null) {
            for (URI u : contextList) {
                for (Entry e : intersectionEntries) {
                    if (!u.equals(e.getContext().getURI())) continue;
                    resultList.add(e);
                }
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> searchEntryQuery(String entryQueryString) throws RepositoryException {
        if (entryQueryString == null) {
            return null;
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try (RepositoryConnection rc = null;){
            rc = this.entry.getRepository().getConnection();
            TupleQuery entryQuery = rc.prepareTupleQuery(QueryLanguage.SPARQL, entryQueryString);
            TupleQueryResult result = entryQuery.evaluate();
            while (result.hasNext()) {
                BindingSet set = (BindingSet)result.next();
                for (Binding obj : set) {
                    Entry entry;
                    if (!(obj.getValue() instanceof IRI) || entries.contains(entry = this.getEntry(new URI(obj.getValue().toString())))) continue;
                    entries.add(entry);
                }
            }
        }
        return entries;
    }

    public List<Entry> search(String pattern, List<URI> list) {
        return null;
    }

    @Override
    public void initializeSystemEntries() {
        Entry scon;
        super.initializeSystemEntries();
        RepositoryManagerImpl repMan = this.entry.repositoryManager;
        String base = repMan.getRepositoryURL().toString();
        for (String id : repMan.getSystemContextAliases()) {
            scon = this.getByEntryURI(URISplit.createURI(base, "_contexts", "entry", id));
            if (scon == null) {
                scon = this.createNewMinimalItem(null, null, EntryType.Local, GraphType.SystemContext, null, id);
                this.setMetadata(scon, id, null);
            }
            Context sc = (Context)scon.getResource();
            if (this.getName(scon.getResourceURI()) == null) {
                this.setName(scon.getResourceURI(), id);
            }
            if (sc != this) {
                sc.initializeSystemEntries();
            }
            this.addSystemEntryToSystemEntries(scon.getEntryURI());
        }
        for (String id : repMan.getSystemContextAliases()) {
            scon = this.getByEntryURI(URISplit.createURI(base, "_contexts", "entry", id));
            if (!scon.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata).isEmpty()) continue;
            scon.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, repMan.getPrincipalManager().getGuestUser().getURI());
        }
    }
}

