/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.entrystore.Data;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.QuotaException;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.ResourceImpl;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.FileOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImpl
extends ResourceImpl
implements Data {
    private static final Logger log = LoggerFactory.getLogger(DataImpl.class);
    public static final String SHA_256_POSTFIX = ".sha256";
    private File file = null;

    public DataImpl(Entry entry) {
        super((EntryImpl)entry, Values.iri((String)entry.getResourceURI().toString()));
    }

    private File getFile() throws IOException {
        if (this.file == null) {
            String dataDirStr = this.entry.getRepositoryManager().getConfiguration().getString(Settings.DATA_FOLDER);
            if (dataDirStr != null) {
                File contextDir;
                dataDirStr = StringUtils.removeStart((String)dataDirStr, (String)"file://");
                File dataDir = new File(dataDirStr = StringUtils.removeStart((String)dataDirStr, (String)"file:"));
                if (!dataDir.exists() && !dataDir.mkdirs()) {
                    log.error("Unable to create data folder");
                }
                if (!(contextDir = new File(dataDir, this.entry.getContext().getEntry().getId())).exists()) {
                    contextDir.mkdir();
                }
                this.file = new File(contextDir, this.entry.getId());
            }
            if (this.file == null) {
                throw new IOException("Unable to get local file of resource");
            }
        }
        return this.file;
    }

    public InputStream getData() {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        try {
            if (this.getFile() != null) {
                return Files.newInputStream(this.getFile().toPath(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public void setData(InputStream is) throws QuotaException, IOException {
        MessageDigest sha;
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        try {
            sha = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Path dataPath = this.getFile().toPath();
        long bytes = FileOperations.copyFile(new DigestInputStream(is, sha), Files.newOutputStream(dataPath, new OpenOption[0]));
        this.writeDigest(sha);
        if (this.entry.getRepositoryManager().hasQuotas()) {
            try {
                this.entry.getContext().increaseQuotaFillLevel(bytes);
            }
            catch (QuotaException qe) {
                File digestFile;
                if (this.file.exists()) {
                    this.file.delete();
                }
                if ((digestFile = this.getDigestFile()) != null && digestFile.exists()) {
                    digestFile.delete();
                }
                throw qe;
            }
        }
        this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
    }

    public void useData(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        long sizeBefore = 0L;
        long sizeAfter = 0L;
        if (this.entry.getRepositoryManager().hasQuotas()) {
            if (this.getFile() != null && this.getFile().exists()) {
                sizeBefore = this.getFile().length();
            }
            if (file.exists()) {
                sizeAfter = file.length();
            }
        }
        FileOperations.copyFile(file, this.getFile());
        if (this.entry.getRepositoryManager().hasQuotas()) {
            this.entry.getContext().decreaseQuotaFillLevel(sizeBefore);
            try {
                this.entry.getContext().increaseQuotaFillLevel(sizeAfter);
            }
            catch (QuotaException qe) {
                this.getFile().delete();
            }
        }
        this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
    }

    @Override
    public void remove(RepositoryConnection rc) throws Exception {
        super.remove(rc);
        this.delete();
    }

    public boolean delete() {
        boolean success = false;
        try {
            File f = this.getFile();
            File digestFile = this.getDigestFile();
            if (f != null && f.exists()) {
                long size = f.length();
                success = f.delete();
                if (success && this.entry.getRepositoryManager().hasQuotas()) {
                    this.entry.getContext().decreaseQuotaFillLevel(size);
                }
                if (digestFile != null && digestFile.exists()) {
                    digestFile.delete();
                }
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceDeleted));
            }
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
        }
        return success;
    }

    public File getDataFile() {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        try {
            File f = this.getFile();
            if (f != null && f.exists()) {
                return f;
            }
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
        }
        return null;
    }

    private File getDigestFile() {
        String digestFileName;
        File dataFile = this.getDataFile();
        if (dataFile == null) {
            return null;
        }
        try {
            digestFileName = dataFile.getCanonicalPath() + SHA_256_POSTFIX;
        }
        catch (IOException e) {
            log.error("Could not get canonical path of: {}", (Object)dataFile.getAbsolutePath(), (Object)e);
            return null;
        }
        return new File(digestFileName);
    }

    private void writeDigest(MessageDigest messageDigest) throws IOException {
        byte[] digest = messageDigest.digest();
        String s = String.valueOf(Hex.encodeHex((byte[])digest));
        FileUtils.writeStringToFile((File)this.getDigestFile(), (String)s, (Charset)Charsets.UTF_8);
    }

    public String readDigest() {
        File digestFile = this.getDigestFile();
        if (digestFile == null) {
            return null;
        }
        try {
            return FileUtils.readFileToString((File)digestFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }
}

