/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.Metadata;
import org.entrystore.PrincipalManager;
import org.entrystore.Provenance;
import org.entrystore.Resource;
import org.entrystore.ResourceType;
import org.entrystore.User;
import org.entrystore.impl.ContextImpl;
import org.entrystore.impl.LocalMetadataWrapper;
import org.entrystore.impl.MetadataImpl;
import org.entrystore.impl.ProvenanceImpl;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.ResourceImpl;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.util.URISplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryImpl
implements Entry {
    protected volatile String id;
    protected volatile Resource resource;
    protected volatile MetadataImpl localMetadata;
    protected volatile Metadata cachedExternalMetadata;
    protected volatile IRI localMdURI;
    protected volatile IRI relationURI;
    protected volatile IRI externalMdURI;
    protected volatile IRI cachedExternalMdURI;
    protected ContextImpl context;
    protected final Repository repository;
    protected RepositoryManagerImpl repositoryManager;
    protected volatile IRI entryURI;
    protected volatile IRI resURI;
    protected volatile EntryType locType = EntryType.Local;
    protected volatile ResourceType repType = ResourceType.InformationResource;
    protected volatile GraphType graphType = GraphType.None;
    protected volatile XMLGregorianCalendar created;
    protected volatile XMLGregorianCalendar modified;
    protected volatile XMLGregorianCalendar cachedAt;
    protected volatile IRI creator;
    protected volatile Set<IRI> contributors = new HashSet<IRI>();
    protected volatile URI status;
    Logger log = LoggerFactory.getLogger(EntryImpl.class);
    private volatile Set<URI> administerPrincipals;
    private volatile Set<URI> readMetadataPrincipals;
    private volatile Set<URI> writeMetadataPrincipals;
    private volatile Set<URI> writeResourcePrincipals;
    private volatile Set<URI> readResourcePrincipals;
    protected boolean invRelations = false;
    private volatile String format;
    private volatile long fileSize = -1L;
    private volatile String filename;
    private Boolean readOrWrite;
    private String originalList;
    private ProvenanceImpl provenance;
    private volatile boolean deleted = false;

    EntryImpl(RepositoryManagerImpl repositoryManager, Repository repository) {
        this.repositoryManager = repositoryManager;
        this.repository = repository;
        if (repositoryManager.getProvenanceRepository() != null) {
            this.provenance = new ProvenanceImpl(this);
        }
    }

    public EntryImpl(String id, ContextImpl context, RepositoryManagerImpl repositoryManager, Repository repository) {
        this.id = id;
        String base = repositoryManager.getRepositoryURL().toString();
        ValueFactory vf = repository.getValueFactory();
        this.entryURI = vf.createIRI(URISplit.createURI(base, context.id, "entry", this.id).toString());
        this.relationURI = vf.createIRI(URISplit.createURI(base, context.id, "relations", this.id).toString());
        this.localMdURI = vf.createIRI(URISplit.createURI(base, context.id, "metadata", this.id).toString());
        this.context = context;
        this.repositoryManager = repositoryManager;
        this.repository = repository;
        if (repositoryManager.getProvenanceRepository() != null) {
            this.provenance = new ProvenanceImpl(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean load() {
        try {
            try (RepositoryConnection rc = this.repository.getConnection();){
                if (this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})))) {
                    this.initMetadataObjects();
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
                throw new org.entrystore.repository.RepositoryException("Error in repository connection.", e);
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    protected boolean load(RepositoryConnection rc) throws RepositoryException {
        if (this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})))) {
            this.initMetadataObjects();
            return true;
        }
        return false;
    }

    protected void initMetadataObjects() {
        if (this.locType == EntryType.LinkReference || this.locType == EntryType.Reference) {
            this.cachedExternalMetadata = this.externalMdURI != null && this.externalMdURI.stringValue().startsWith(this.repositoryManager.getRepositoryURL().toString()) ? new LocalMetadataWrapper(this) : new MetadataImpl(this, this.cachedExternalMdURI, this.resURI, true);
        }
        if (this.locType == EntryType.Local || this.locType == EntryType.Link || this.locType == EntryType.LinkReference) {
            this.localMetadata = new MetadataImpl(this, this.localMdURI, this.resURI, false);
        }
    }

    protected void create(IRI resURI, IRI externalMetadataURI, GraphType bType, EntryType lType, ResourceType rType, RepositoryConnection rc) throws RepositoryException, DatatypeConfigurationException {
        String base = this.repositoryManager.getRepositoryURL().toString();
        ValueFactory vf = this.repository.getValueFactory();
        this.resURI = resURI;
        if (lType == EntryType.LinkReference) {
            this.cachedExternalMdURI = vf.createIRI(URISplit.createURI(base, this.context.id, "cached-external-metadata", this.id).toString());
            this.externalMdURI = externalMetadataURI;
        }
        if (lType == EntryType.Reference) {
            this.cachedExternalMdURI = vf.createIRI(URISplit.createURI(base, this.context.id, "cached-external-metadata", this.id).toString());
            this.externalMdURI = externalMetadataURI;
        }
        this.initialize(bType, lType, rType, rc);
        this.initMetadataObjects();
    }

    private void initialize(GraphType bt, EntryType locT, ResourceType repT, RepositoryConnection rc) throws RepositoryException, DatatypeConfigurationException {
        URI userURI;
        PrincipalManager pm;
        ValueFactory vf = rc.getRepository().getValueFactory();
        if (bt != null) {
            this.setGraphType(bt, rc);
        }
        if (repT != null && this.graphType == GraphType.None) {
            this.setResourceType(repT, rc);
        }
        this.setLocationType(locT, rc);
        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.resource, (Value)this.resURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        this.created = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Created, (Value)vf.createLiteral(this.created), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        this.registerEntryModified(rc, vf);
        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.relation, (Value)this.relationURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        if (locT != EntryType.Reference) {
            rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.metadata, (Value)this.localMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        }
        if (locT == EntryType.Reference || locT == EntryType.LinkReference) {
            rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.externalMetadata, (Value)this.externalMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.cachedExternalMetadata, (Value)this.cachedExternalMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        }
        if ((pm = this.repositoryManager.getPrincipalManager()) != null && (userURI = pm.getAuthenticatedUserURI()) != null) {
            this.creator = vf.createIRI(userURI.toString());
            rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Creator, (Value)this.creator, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        }
    }

    protected void refreshFromRepository(RepositoryConnection rc) throws RepositoryException {
        this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})));
    }

    private boolean loadFromStatements(List<Statement> existingStatements) throws RepositoryException {
        if (existingStatements.isEmpty()) {
            return false;
        }
        Object administerPrincipals = null;
        Object readMetadataPrincipals = null;
        Object writeMetadataPrincipals = null;
        Object readResourcePrincipals = null;
        Object writeResourcePrincipals = null;
        HashSet<IRI> contributors = new HashSet<IRI>();
        IRI entryURI = null;
        IRI resURI = null;
        IRI localMdURI = null;
        IRI cachedExternalMdURI = null;
        IRI relationURI = null;
        XMLGregorianCalendar created = null;
        IRI creator = null;
        XMLGregorianCalendar modified = null;
        IRI externalMdURI = null;
        XMLGregorianCalendar cachedAt = null;
        EntryType locType = EntryType.Local;
        ResourceType repType = ResourceType.InformationResource;
        GraphType graphType = GraphType.None;
        Object format = null;
        long fileSize = -1L;
        Object filename = null;
        boolean invRelations = false;
        try (RepositoryConnection rc = null;){
            String base = this.repositoryManager.getRepositoryURL().toString();
            rc = this.repository.getConnection();
            for (Statement statement : existingStatements) {
                IRI predicate = statement.getPredicate();
                if (predicate.equals((Object)RepositoryProperties.resource)) {
                    entryURI = (IRI)statement.getSubject();
                    resURI = (IRI)statement.getObject();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.metadata)) {
                    localMdURI = (IRI)statement.getObject();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.externalMetadata)) {
                    externalMdURI = (IRI)statement.getObject();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.cachedExternalMetadata)) {
                    cachedExternalMdURI = (IRI)statement.getObject();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.relation)) {
                    relationURI = (IRI)statement.getObject();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.cached)) {
                    cachedAt = ((Literal)statement.getObject()).calendarValue();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.Created)) {
                    created = ((Literal)statement.getObject()).calendarValue();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.Creator)) {
                    creator = (IRI)statement.getObject();
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.Contributor)) {
                    contributors.add((IRI)statement.getObject());
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.Modified)) {
                    try {
                        modified = ((Literal)statement.getObject()).calendarValue();
                    }
                    catch (NullPointerException e) {
                        this.log.error(e.getMessage());
                    }
                    continue;
                }
                if (predicate.equals((Object)RepositoryProperties.Read) || predicate.equals((Object)RepositoryProperties.Write) || predicate.equals((Object)RepositoryProperties.Pipeline) || predicate.equals((Object)RepositoryProperties.originallyCreatedIn)) continue;
                Value obj = statement.getObject();
                org.eclipse.rdf4j.model.Resource subj = statement.getSubject();
                if (!(obj instanceof IRI) || !obj.stringValue().startsWith(base) || !subj.stringValue().startsWith(base)) continue;
                invRelations = true;
            }
            for (Statement statement : existingStatements) {
                EntryType lt;
                org.eclipse.rdf4j.model.Resource subject = statement.getSubject();
                if (!statement.getPredicate().equals((Object)RDF.TYPE)) continue;
                if (resURI.equals((Object)subject)) {
                    GraphType gt = this.getGraphType(statement.getObject());
                    if (gt != null) {
                        graphType = gt;
                        continue;
                    }
                    ResourceType rt = this.getResourceType(statement.getObject());
                    if (rt == null) continue;
                    repType = rt;
                    continue;
                }
                if (!entryURI.equals((Object)subject) || (lt = this.getEntryType(statement.getObject())) == null) continue;
                locType = lt;
            }
        }
        this.administerPrincipals = administerPrincipals;
        this.readMetadataPrincipals = readMetadataPrincipals;
        this.writeMetadataPrincipals = writeMetadataPrincipals;
        this.readResourcePrincipals = readResourcePrincipals;
        this.writeResourcePrincipals = writeResourcePrincipals;
        this.contributors = contributors;
        this.entryURI = entryURI;
        this.resURI = resURI;
        this.localMdURI = localMdURI;
        this.cachedExternalMdURI = cachedExternalMdURI;
        this.relationURI = relationURI;
        this.created = created;
        this.creator = creator;
        this.modified = modified;
        this.externalMdURI = externalMdURI;
        this.cachedAt = cachedAt;
        this.locType = locType;
        this.repType = repType;
        this.graphType = graphType;
        this.format = format;
        this.fileSize = fileSize;
        this.filename = filename;
        this.invRelations = invRelations;
        return true;
    }

    private ResourceType getResourceType(Value rt) {
        if (rt.equals((Object)RepositoryProperties.NamedResource)) {
            return ResourceType.NamedResource;
        }
        if (rt.equals((Object)RepositoryProperties.ResolvableInformationResource)) {
            return ResourceType.ResolvableInformationResource;
        }
        if (rt.equals((Object)RepositoryProperties.Unknown)) {
            return ResourceType.Unknown;
        }
        if (rt.equals((Object)RepositoryProperties.InformationResource)) {
            return ResourceType.InformationResource;
        }
        return null;
    }

    private GraphType getGraphType(Value bt) {
        if (bt.equals((Object)RepositoryProperties.Context)) {
            return GraphType.Context;
        }
        if (bt.equals((Object)RepositoryProperties.SystemContext)) {
            return GraphType.SystemContext;
        }
        if (bt.equals((Object)RepositoryProperties.List)) {
            return GraphType.List;
        }
        if (bt.equals((Object)RepositoryProperties.ResultList)) {
            return GraphType.ResultList;
        }
        if (bt.equals((Object)RepositoryProperties.User)) {
            return GraphType.User;
        }
        if (bt.equals((Object)RepositoryProperties.Group)) {
            return GraphType.Group;
        }
        if (bt.equals((Object)RepositoryProperties.Pipeline)) {
            return GraphType.Pipeline;
        }
        if (bt.equals((Object)RepositoryProperties.PipelineResult)) {
            return GraphType.PipelineResult;
        }
        if (bt.equals((Object)RepositoryProperties.String)) {
            return GraphType.String;
        }
        if (bt.equals((Object)RepositoryProperties.Graph)) {
            return GraphType.Graph;
        }
        if (bt.equals((Object)RepositoryProperties.None)) {
            return GraphType.None;
        }
        return null;
    }

    private EntryType getEntryType(Value rt) {
        if (rt.equals((Object)RepositoryProperties.Reference)) {
            return EntryType.Reference;
        }
        if (rt.equals((Object)RepositoryProperties.Link)) {
            return EntryType.Link;
        }
        if (rt.equals((Object)RepositoryProperties.LinkReference)) {
            return EntryType.LinkReference;
        }
        if (rt.equals((Object)RepositoryProperties.Local)) {
            return EntryType.Local;
        }
        return null;
    }

    public URI getEntryURI() {
        return URI.create(this.entryURI.toString());
    }

    public IRI getSesameEntryURI() {
        return this.entryURI;
    }

    public IRI getSesameResourceURI() {
        return this.resURI;
    }

    public URI getResourceURI() {
        return URI.create(this.resURI.stringValue());
    }

    public URI getLocalMetadataURI() {
        if (this.localMdURI != null) {
            return URI.create(this.getSesameLocalMetadataURI().stringValue());
        }
        return null;
    }

    public IRI getSesameLocalMetadataURI() {
        return this.localMdURI;
    }

    public URI getExternalMetadataURI() {
        if (this.externalMdURI != null) {
            return URI.create(this.externalMdURI.stringValue());
        }
        return null;
    }

    public IRI getSesameExternalMetadataURI() {
        return this.externalMdURI;
    }

    public URI getCachedExternalMetadataURI() {
        if (this.cachedExternalMdURI != null) {
            return URI.create(this.cachedExternalMdURI.stringValue());
        }
        return null;
    }

    public IRI getSesameCachedExternalMetadataURI() {
        return this.cachedExternalMdURI;
    }

    public Date getExternalMetadataCacheDate() {
        if (this.cachedExternalMdURI == null) {
            return null;
        }
        return this.cachedAt != null ? this.cachedAt.toGregorianCalendar().getTime() : null;
    }

    public URI getCreator() {
        if (this.creator != null) {
            return URI.create(this.creator.stringValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreator(URI userURI) {
        if (userURI == null) {
            throw new IllegalArgumentException("User URI must not be null");
        }
        this.checkAdministerRights();
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                rc.begin();
                try (RepositoryConnection rc = this.repository.getConnection();){
                    IRI creatorURI = rc.getValueFactory().createIRI(userURI.toString());
                    rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Creator, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Creator, (Value)creatorURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    this.registerEntryModified(rc, this.repository.getValueFactory());
                    rc.commit();
                    this.creator = creatorURI;
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
    }

    public Set<URI> getContributors() {
        HashSet<URI> result = new HashSet<URI>();
        for (IRI contribURI : this.contributors) {
            result.add(URI.create(contribURI.stringValue()));
        }
        return result;
    }

    public Date getCreationDate() {
        return this.created != null ? this.created.toGregorianCalendar().getTime() : null;
    }

    public Date getModifiedDate() {
        return this.modified != null ? this.modified.toGregorianCalendar().getTime() : null;
    }

    public ResourceType getResourceType() {
        return this.repType;
    }

    public EntryType getEntryType() {
        return this.locType;
    }

    public Model getGraph() {
        Model model;
        block9: {
            RepositoryConnection rc = this.repository.getConnection();
            try {
                Model graph = (Model)Iterations.addAll((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}), (Collection)new LinkedHashModel());
                if (this.resource instanceof User && ((User)this.resource).getHomeContext() != null) {
                    Context context = ((User)this.resource).getHomeContext();
                    graph.add((org.eclipse.rdf4j.model.Resource)this.getSesameResourceURI(), RepositoryProperties.homeContext, (Value)((ContextImpl)context).getSesameURI(), new org.eclipse.rdf4j.model.Resource[0]);
                }
                model = graph;
                if (rc == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (rc != null) {
                        try {
                            rc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
                }
            }
            rc.close();
        }
        return model;
    }

    public Set<URI> getReferringListsInSameContext() {
        HashSet<URI> set = new HashSet<URI>();
        Model relations = this.getRelations();
        if (relations != null) {
            for (Statement statement : relations) {
                if (!statement.getPredicate().equals((Object)RepositoryProperties.hasListMember) && !statement.getPredicate().equals((Object)RepositoryProperties.hasGroupMember)) continue;
                set.add(URI.create(statement.getSubject().toString()));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferringList(ResourceImpl resource, RepositoryConnection rc) throws RepositoryException {
        Repository repository = this.repository;
        synchronized (repository) {
            ValueFactory vf = this.repository.getValueFactory();
            this.addRelationSynchronized(vf.createStatement((org.eclipse.rdf4j.model.Resource)resource.resourceURI, resource instanceof Group ? RepositoryProperties.hasGroupMember : RepositoryProperties.hasListMember, (Value)this.getSesameEntryURI()), rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReferringList(ResourceImpl resource, RepositoryConnection rc) throws RepositoryException {
        Repository repository = this.repository;
        synchronized (repository) {
            ValueFactory vf = this.repository.getValueFactory();
            this.removeRelationSynchronized(vf.createStatement((org.eclipse.rdf4j.model.Resource)resource.resourceURI, resource instanceof Group ? RepositoryProperties.hasGroupMember : RepositoryProperties.hasListMember, (Value)this.getSesameEntryURI()), rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntryType(EntryType entryType) {
        this.checkAdministerRights();
        EntryType oldLT = this.locType;
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                rc.begin();
                try (RepositoryConnection rc = this.repository.getConnection();){
                    if (EntryType.Reference.equals((Object)this.locType) && EntryType.LinkReference.equals((Object)entryType)) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.metadata, (Value)this.localMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    this.setLocationType(entryType, rc);
                    this.registerEntryModified(rc, this.repository.getValueFactory());
                    rc.commit();
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceURI(URI resourceURI) {
        Model resourceGraph;
        Model metadataGraph;
        Model metadataGraph2;
        if (resourceURI.toString().equals(this.resURI.toString())) {
            return;
        }
        this.checkAdministerRights();
        ValueFactory vf = this.getRepositoryManager().getValueFactory();
        IRI oldResourceURI = vf.createIRI(this.getResourceURI().toString());
        IRI newResourceURI = vf.createIRI(resourceURI.toString());
        Model entryGraph = this.getGraph();
        LinkedHashModel newEntryGraph = new LinkedHashModel();
        for (Statement stmnt : entryGraph) {
            if (RepositoryProperties.resource.equals((Object)stmnt.getPredicate())) {
                newEntryGraph.add(stmnt.getSubject(), stmnt.getPredicate(), (Value)newResourceURI, new org.eclipse.rdf4j.model.Resource[0]);
                continue;
            }
            newEntryGraph.add((Object)stmnt);
        }
        LinkedHashModel newMetadataGraph = null;
        if (this.getLocalMetadata() != null && (metadataGraph2 = this.getLocalMetadata().getGraph()) != null && !metadataGraph2.isEmpty()) {
            newMetadataGraph = new LinkedHashModel();
            for (Iterator statement : metadataGraph2) {
                if (statement.getSubject().equals((Object)oldResourceURI)) {
                    newMetadataGraph.add((org.eclipse.rdf4j.model.Resource)newResourceURI, statement.getPredicate(), statement.getObject(), new org.eclipse.rdf4j.model.Resource[0]);
                    continue;
                }
                newMetadataGraph.add((Object)statement);
            }
        }
        LinkedHashModel newCachedExternalMetadataGraph = null;
        if (this.getCachedExternalMetadata() != null && (metadataGraph = this.getCachedExternalMetadata().getGraph()) != null && !metadataGraph.isEmpty()) {
            newCachedExternalMetadataGraph = new LinkedHashModel();
            for (Object statement : metadataGraph) {
                if (statement.getSubject().equals((Object)oldResourceURI)) {
                    newCachedExternalMetadataGraph.add((org.eclipse.rdf4j.model.Resource)newResourceURI, statement.getPredicate(), statement.getObject(), new org.eclipse.rdf4j.model.Resource[0]);
                    continue;
                }
                newCachedExternalMetadataGraph.add(statement);
            }
        }
        LinkedHashModel newResourceGraph = null;
        if (!this.getGraphType().equals((Object)GraphType.None) && (resourceGraph = this.getResource().getEntry().getGraph()) != null && !resourceGraph.isEmpty()) {
            newResourceGraph = new LinkedHashModel();
            for (Statement statement : resourceGraph) {
                if (statement.getSubject().equals((Object)oldResourceURI)) {
                    newResourceGraph.add((org.eclipse.rdf4j.model.Resource)newResourceURI, statement.getPredicate(), statement.getObject(), new org.eclipse.rdf4j.model.Resource[0]);
                    continue;
                }
                newResourceGraph.add((Object)statement);
            }
        }
        this.setGraphRaw((Model)newEntryGraph);
        if (newMetadataGraph != null) {
            this.getLocalMetadata().setGraph((Model)newMetadataGraph);
        }
        if (newCachedExternalMetadataGraph != null) {
            this.getCachedExternalMetadata().setGraph((Model)newCachedExternalMetadataGraph);
        }
        if (newResourceGraph != null) {
            this.getResource().getEntry().setGraph((Model)newResourceGraph);
        }
        try {
            resourceGraph = this.repository;
            synchronized (resourceGraph) {
                try (RepositoryConnection rc = this.repository.getConnection();){
                    rc.begin();
                    IRI contextURI = vf.createIRI(this.getContext().getEntry().getResourceURI().toString());
                    IRI entryURI = vf.createIRI(this.getEntryURI().toString());
                    rc.remove(vf.createStatement((org.eclipse.rdf4j.model.Resource)oldResourceURI, RepositoryProperties.resHasEntry, (Value)entryURI, (org.eclipse.rdf4j.model.Resource)contextURI), new org.eclipse.rdf4j.model.Resource[0]);
                    rc.add(vf.createStatement((org.eclipse.rdf4j.model.Resource)newResourceURI, RepositoryProperties.resHasEntry, (Value)entryURI, (org.eclipse.rdf4j.model.Resource)contextURI), new org.eclipse.rdf4j.model.Resource[0]);
                    rc.commit();
                }
            }
        }
        catch (RepositoryException re) {
            this.log.error(re.getMessage(), (Throwable)re);
        }
        this.resURI = newResourceURI;
        this.context.updateResource2EntryIndex(URI.create(oldResourceURI.stringValue()), URI.create(this.resURI.stringValue()), URI.create(this.entryURI.stringValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalMetadataURI(URI externalMetadataURI) {
        if (this.externalMdURI != null && externalMetadataURI.toString().equals(this.externalMdURI.toString())) {
            return;
        }
        this.checkAdministerRights();
        ValueFactory vf = this.getRepositoryManager().getValueFactory();
        IRI oldExternalMetadataURI = vf.createIRI(this.getExternalMetadataURI().toString());
        IRI newExternalMetadataURI = vf.createIRI(externalMetadataURI.toString());
        Model entryGraph = this.getGraph();
        LinkedHashModel newEntryGraph = new LinkedHashModel();
        for (Statement statement : entryGraph) {
            if (statement.getSubject().equals((Object)oldExternalMetadataURI)) continue;
            if (statement.getObject().equals((Object)oldExternalMetadataURI)) {
                newEntryGraph.add(statement.getSubject(), statement.getPredicate(), (Value)newExternalMetadataURI, new org.eclipse.rdf4j.model.Resource[0]);
                continue;
            }
            newEntryGraph.add((Object)statement);
        }
        this.setGraphRaw((Model)newEntryGraph);
        try {
            Iterator iterator = this.repository;
            synchronized (iterator) {
                try (RepositoryConnection rc = this.repository.getConnection();){
                    rc.begin();
                    IRI contextURI = vf.createIRI(this.getContext().getEntry().getResourceURI().toString());
                    IRI entryURI = vf.createIRI(this.getEntryURI().toString());
                    rc.remove(vf.createStatement((org.eclipse.rdf4j.model.Resource)oldExternalMetadataURI, RepositoryProperties.mdHasEntry, (Value)entryURI, (org.eclipse.rdf4j.model.Resource)contextURI), new org.eclipse.rdf4j.model.Resource[0]);
                    rc.add(vf.createStatement((org.eclipse.rdf4j.model.Resource)newExternalMetadataURI, RepositoryProperties.mdHasEntry, (Value)entryURI, (org.eclipse.rdf4j.model.Resource)contextURI), new org.eclipse.rdf4j.model.Resource[0]);
                    rc.commit();
                }
            }
        }
        catch (RepositoryException re) {
            this.log.error(re.getMessage(), (Throwable)re);
        }
        this.externalMdURI = newExternalMetadataURI;
        this.context.updateExternalMetadata2EntryIndex(URI.create(oldExternalMetadataURI.stringValue()), URI.create(this.externalMdURI.stringValue()), URI.create(this.entryURI.stringValue()));
    }

    protected void setLocationType(EntryType entryType, RepositoryConnection rc) throws RepositoryException {
        rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.entryURI, RDF.TYPE, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        switch (entryType) {
            case Reference: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RDF.TYPE, (Value)RepositoryProperties.Reference, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case LinkReference: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RDF.TYPE, (Value)RepositoryProperties.LinkReference, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case Link: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RDF.TYPE, (Value)RepositoryProperties.Link, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            }
        }
        this.locType = entryType;
    }

    private Set<URI> getCachedAllowedPrincipalsFor(PrincipalManager.AccessProperty prop) {
        return switch (prop) {
            default -> throw new MatchException(null, null);
            case PrincipalManager.AccessProperty.Administer -> this.administerPrincipals;
            case PrincipalManager.AccessProperty.ReadMetadata -> this.readMetadataPrincipals;
            case PrincipalManager.AccessProperty.WriteMetadata -> this.writeMetadataPrincipals;
            case PrincipalManager.AccessProperty.ReadResource -> this.readResourcePrincipals;
            case PrincipalManager.AccessProperty.WriteResource -> this.writeResourcePrincipals;
        };
    }

    private void setCachedAllowedPrincipalsFor(PrincipalManager.AccessProperty prop, Set<URI> set) {
        switch (prop) {
            case Administer: {
                this.administerPrincipals = set;
                break;
            }
            case ReadMetadata: {
                this.readMetadataPrincipals = set;
                break;
            }
            case WriteMetadata: {
                this.writeMetadataPrincipals = set;
                break;
            }
            case ReadResource: {
                this.readResourcePrincipals = set;
                break;
            }
            case WriteResource: {
                this.writeResourcePrincipals = set;
            }
        }
    }

    public Set<URI> getAllowedPrincipalsFor(PrincipalManager.AccessProperty prop) {
        Set<URI> set;
        block10: {
            Set<URI> set2 = this.getCachedAllowedPrincipalsFor(prop);
            if (set2 != null) {
                return set2;
            }
            RepositoryConnection rc = this.repository.getConnection();
            try {
                IRI subject = this.getAccessSubject(prop);
                IRI predicate = this.getAccessPredicate(prop);
                List statements = Iterations.asList((CloseableIteration)rc.getStatements((org.eclipse.rdf4j.model.Resource)subject, predicate, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}));
                set2 = new HashSet<URI>();
                for (Statement statement : statements) {
                    if (!(statement.getObject() instanceof IRI)) continue;
                    set2.add(URI.create(statement.getObject().stringValue()));
                }
                this.setCachedAllowedPrincipalsFor(prop, set2);
                set = set2;
                if (rc == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (rc != null) {
                        try {
                            rc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
                }
            }
            rc.close();
        }
        return set;
    }

    public void setAllowedPrincipalsFor(PrincipalManager.AccessProperty prop, Set<URI> principals) {
        this.checkAdministerRights();
        this.updateAllowedPrincipalsFor(prop, principals, true, false);
    }

    public void addAllowedPrincipalsFor(PrincipalManager.AccessProperty prop, URI principal) {
        this.checkAdministerRights();
        HashSet<URI> principals = new HashSet<URI>();
        principals.add(principal);
        this.updateAllowedPrincipalsFor(prop, principals, false, true);
    }

    public boolean removeAllowedPrincipalsFor(PrincipalManager.AccessProperty prop, URI principal) {
        this.checkAdministerRights();
        HashSet<URI> principals = new HashSet<URI>();
        principals.add(principal);
        return this.updateAllowedPrincipalsFor(prop, principals, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAllowedPrincipalsFor(PrincipalManager.AccessProperty prop, Set<URI> principals, boolean replace, boolean append) {
        this.readOrWrite = null;
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                rc.begin();
                try (RepositoryConnection rc = this.repository.getConnection();){
                    IRI subject = this.getAccessSubject(prop);
                    IRI predicate = this.getAccessPredicate(prop);
                    if (replace) {
                        rc.remove((org.eclipse.rdf4j.model.Resource)subject, predicate, null, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    for (URI principal : principals) {
                        IRI principalURI = this.repository.getValueFactory().createIRI(principal.toString());
                        if (replace || append) {
                            rc.add((org.eclipse.rdf4j.model.Resource)subject, predicate, (Value)principalURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                            continue;
                        }
                        rc.remove((org.eclipse.rdf4j.model.Resource)subject, predicate, (Value)principalURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    rc.commit();
                    if (replace) {
                        this.setCachedAllowedPrincipalsFor(prop, principals);
                    } else {
                        this.setCachedAllowedPrincipalsFor(prop, null);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
        return false;
    }

    public boolean hasAllowedPrincipals() {
        if (this.readOrWrite == null) {
            try (RepositoryConnection rc = this.repository.getConnection();){
                this.readOrWrite = rc.hasStatement(null, RepositoryProperties.Write, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}) || rc.hasStatement(null, RepositoryProperties.Read, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (RepositoryException e) {
                this.log.error(e.getMessage());
            }
        }
        return this.readOrWrite;
    }

    private IRI getAccessSubject(PrincipalManager.AccessProperty prop) {
        return switch (prop) {
            default -> throw new MatchException(null, null);
            case PrincipalManager.AccessProperty.Administer -> this.entryURI;
            case PrincipalManager.AccessProperty.ReadMetadata, PrincipalManager.AccessProperty.WriteMetadata -> this.localMdURI;
            case PrincipalManager.AccessProperty.ReadResource, PrincipalManager.AccessProperty.WriteResource -> this.resURI;
        };
    }

    private IRI getAccessPredicate(PrincipalManager.AccessProperty prop) {
        return switch (prop) {
            default -> throw new MatchException(null, null);
            case PrincipalManager.AccessProperty.Administer, PrincipalManager.AccessProperty.WriteMetadata, PrincipalManager.AccessProperty.WriteResource -> RepositoryProperties.Write;
            case PrincipalManager.AccessProperty.ReadMetadata, PrincipalManager.AccessProperty.ReadResource -> RepositoryProperties.Read;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphType(GraphType gt) {
        this.checkAdministerRights();
        if (this.graphType != gt && this.locType == EntryType.Local) {
            throw new org.entrystore.repository.RepositoryException("Cannot change the graph type of a local resource");
        }
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                rc.begin();
                try (RepositoryConnection rc = this.repository.getConnection();){
                    this.setGraphType(gt, rc);
                    this.registerEntryModified(rc, this.repository.getValueFactory());
                    rc.commit();
                }
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    protected void setGraphType(GraphType gt, RepositoryConnection rc) throws RepositoryException {
        List statements = Iterations.asList((CloseableIteration)rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}));
        for (Statement statement : statements) {
            if (this.getGraphType(statement.getObject()) == null) continue;
            rc.remove(statement, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        }
        switch (gt) {
            case Context: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.Context, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case SystemContext: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.SystemContext, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case List: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.List, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case ResultList: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.ResultList, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case User: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.User, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case Group: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.Group, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case Pipeline: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.Pipeline, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case PipelineResult: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.PipelineResult, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case String: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.String, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case Graph: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.Graph, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            }
        }
        this.graphType = gt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceType(ResourceType resType) {
        this.checkAdministerRights();
        if (this.repType != resType && this.locType == EntryType.Local && this.graphType != GraphType.None && this.graphType != GraphType.Pipeline && this.graphType != GraphType.PipelineResult) {
            throw new org.entrystore.repository.RepositoryException("Cannot change the resource type of a local and/or built-in resource");
        }
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                rc.begin();
                try (RepositoryConnection rc = this.repository.getConnection();){
                    this.setResourceType(resType, rc);
                    this.registerEntryModified(rc, this.repository.getValueFactory());
                    rc.commit();
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository", (Exception)((Object)e));
        }
    }

    protected void setResourceType(ResourceType resType, RepositoryConnection rc) throws RepositoryException {
        List statements = Iterations.asList((CloseableIteration)rc.getStatements((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}));
        for (Statement statement : statements) {
            if (this.getResourceType(statement.getObject()) == null) continue;
            rc.remove(statement, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        }
        switch (resType) {
            case ResolvableInformationResource: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.ResolvableInformationResource, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case Unknown: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.Unknown, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                break;
            }
            case NamedResource: {
                rc.add((org.eclipse.rdf4j.model.Resource)this.resURI, RDF.TYPE, (Value)RepositoryProperties.NamedResource, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            }
        }
        this.repType = resType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedDateSynchronized(RepositoryConnection rc, ValueFactory vf) throws RepositoryException {
        Repository repository = this.repository;
        synchronized (repository) {
            this.registerEntryModified(rc, vf);
        }
    }

    protected void registerEntryModified(RepositoryConnection rc, ValueFactory vf) throws RepositoryException {
        try {
            this.modified = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            this.log.error(e.getMessage());
        }
        rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Modified, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Modified, (Value)vf.createLiteral(this.modified), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        if (this.repositoryManager != null && this.repositoryManager.getPrincipalManager() != null && this.repositoryManager.getPrincipalManager().getAuthenticatedUserURI() != null) {
            URI contrib = this.repositoryManager.getPrincipalManager().getAuthenticatedUserURI();
            String contributor = contrib.toString();
            IRI contributorURI = vf.createIRI(contributor);
            if (contrib != null && !contrib.equals(this.getCreator()) && this.contributors != null && !this.contributors.contains(contributorURI)) {
                rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Contributor, (Value)contributorURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                this.contributors.add(contributorURI);
            }
        }
    }

    public void updateModificationDate() {
        try (RepositoryConnection rc = this.repository.getConnection();){
            this.updateModifiedDateSynchronized(rc, this.getRepositoryManager().getValueFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedExternalMetadataDateSynchronized(RepositoryConnection rc, ValueFactory vf) throws RepositoryException, DatatypeConfigurationException {
        Repository repository = this.repository;
        synchronized (repository) {
            if (this.getEntryType() == EntryType.Reference || this.getEntryType() == EntryType.LinkReference) {
                this.cachedAt = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                rc.remove(rc.getStatements((org.eclipse.rdf4j.model.Resource)this.cachedExternalMdURI, RepositoryProperties.cached, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI}), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                rc.add((org.eclipse.rdf4j.model.Resource)this.cachedExternalMdURI, RepositoryProperties.cached, (Value)vf.createLiteral(this.cachedAt), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            }
            this.registerEntryModified(rc, vf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGraphRaw(Model metametadata) {
        this.checkAdministerRights();
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                RepositoryConnection rc = this.repository.getConnection();
                ValueFactory vf = this.repository.getValueFactory();
                rc.begin();
                try {
                    rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    rc.add((Iterable)metametadata, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    this.registerEntryModified(rc, vf);
                    rc.commit();
                    this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})));
                    this.initMetadataObjects();
                    this.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this, RepositoryEvent.EntryUpdated));
                }
                catch (Exception e) {
                    rc.rollback();
                    this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})));
                    throw new org.entrystore.repository.RepositoryException("Error in repository connection.", e);
                }
                finally {
                    rc.close();
                }
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraph(Model metametadata) {
        Value newResourceURI;
        Iterator externalMdURIStmnts;
        Value newResourceURI2;
        this.checkAdministerRights();
        Model oldGraph = this.getGraph();
        Iterator resourceURIStmnts = metametadata.filter((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.resource, null, new org.eclipse.rdf4j.model.Resource[0]).iterator();
        if (resourceURIStmnts.hasNext() && (newResourceURI2 = ((Statement)resourceURIStmnts.next()).getObject()) instanceof IRI) {
            this.setResourceURI(URI.create(newResourceURI2.toString()));
        }
        if ((externalMdURIStmnts = metametadata.filter((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.externalMetadata, null, new org.eclipse.rdf4j.model.Resource[0]).iterator()).hasNext() && (newResourceURI = ((Statement)externalMdURIStmnts.next()).getObject()) instanceof IRI) {
            this.setExternalMetadataURI(URI.create(newResourceURI.toString()));
        }
        String originalList = this.getOriginalList();
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                ValueFactory vf = this.repository.getValueFactory();
                RepositoryConnection rc = this.repository.getConnection();
                rc.begin();
                Model minimalProvenanceGraph = null;
                if (this.provenance != null) {
                    minimalProvenanceGraph = this.provenance.getMinimalGraph(rc);
                }
                try {
                    this.removeInverseRelations(rc);
                    rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    for (Statement statement : metametadata) {
                        IRI predicate = statement.getPredicate();
                        if (predicate.stringValue().startsWith("http://entrystore.org/terms/")) {
                            if (predicate.equals((Object)RepositoryProperties.resource) || predicate.equals((Object)RepositoryProperties.metadata) || predicate.equals((Object)RepositoryProperties.externalMetadata) || predicate.equals((Object)RepositoryProperties.cachedExternalMetadata) || predicate.equals((Object)RepositoryProperties.cached) || predicate.equals((Object)RepositoryProperties.relation)) continue;
                            rc.add(statement, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                            continue;
                        }
                        if (this.entryURI.equals((Object)statement.getSubject()) && (predicate.equals((Object)RepositoryProperties.Created) || predicate.equals((Object)RepositoryProperties.Modified) || predicate.equals((Object)RepositoryProperties.Creator) || predicate.equals((Object)RepositoryProperties.Contributor))) continue;
                        if (predicate.equals((Object)RDF.TYPE)) {
                            if (this.entryURI.equals((Object)statement.getSubject())) {
                                EntryType lt = this.getEntryType(statement.getObject());
                                if (lt != EntryType.LinkReference || !Arrays.asList(EntryType.Reference, EntryType.Link).contains(this.locType)) continue;
                                if (this.locType == EntryType.Reference) {
                                    this.localMdURI = vf.createIRI(URISplit.createURI(this.repositoryManager.getRepositoryURL().toString(), this.context.id, "metadata", this.id).toString());
                                } else if (this.locType == EntryType.Link) {
                                    this.cachedExternalMdURI = vf.createIRI(URISplit.createURI(this.repositoryManager.getRepositoryURL().toString(), this.context.id, "cached-external-metadata", this.id).toString());
                                }
                                this.locType = lt;
                                continue;
                            }
                            GraphType gt = this.getGraphType(statement.getObject());
                            if (gt != null) {
                                if (this.locType == EntryType.Local) continue;
                                this.graphType = gt;
                                continue;
                            }
                            ResourceType rt = this.getResourceType(statement.getObject());
                            if (rt != null) {
                                if (this.locType == EntryType.Local) continue;
                                this.repType = rt;
                                continue;
                            }
                            rc.add(statement, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                            continue;
                        }
                        if (this.provenance != null && this.provenance.hasProvenanceCharacter(statement)) continue;
                        rc.add(statement, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    this.setLocationType(this.locType, rc);
                    this.setGraphType(this.graphType, rc);
                    this.setResourceType(this.repType, rc);
                    rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.resource, (Value)this.getSesameResourceURI(), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.relation, (Value)this.relationURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    if (this.localMdURI != null) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.metadata, (Value)this.localMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    if (this.externalMdURI != null) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.externalMetadata, (Value)this.externalMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    if (this.cachedExternalMdURI != null) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.cachedExternalMetadata, (Value)this.cachedExternalMdURI, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                        if (this.cachedAt != null) {
                            rc.add((org.eclipse.rdf4j.model.Resource)this.cachedExternalMdURI, RepositoryProperties.cached, (Value)vf.createLiteral(this.cachedAt), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                        }
                    }
                    if (this.created != null) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Created, (Value)vf.createLiteral(this.created), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    if (this.creator != null) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Creator, (Value)this.creator, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    if (this.contributors != null && !this.contributors.isEmpty()) {
                        for (IRI contrib : this.contributors) {
                            rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Contributor, (Value)contrib, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                        }
                    }
                    if (originalList != null) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.originallyCreatedIn, (Value)vf.createIRI(originalList), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    this.modified = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                    rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.Modified, (Value)vf.createLiteral(this.modified), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    if (minimalProvenanceGraph != null) {
                        rc.add((Iterable)minimalProvenanceGraph, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    }
                    this.addInverseRelations(rc, metametadata);
                    rc.commit();
                    this.administerPrincipals = null;
                    this.readMetadataPrincipals = null;
                    this.writeMetadataPrincipals = null;
                    this.readResourcePrincipals = null;
                    this.writeResourcePrincipals = null;
                    this.readOrWrite = null;
                    this.format = null;
                    this.status = null;
                    this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})));
                    this.initMetadataObjects();
                    this.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this, RepositoryEvent.EntryUpdated));
                    if (GraphType.Context.equals((Object)this.getGraphType())) {
                        if (this.hasAclChangedForGuest(oldGraph, metametadata)) {
                            this.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this, RepositoryEvent.EntryAclGuestUpdated, metametadata));
                        }
                        if (this.hasProjectTypeChanged(oldGraph, metametadata)) {
                            this.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this, RepositoryEvent.EntryProjectTypeUpdated, metametadata));
                        }
                    }
                }
                catch (Exception e) {
                    rc.rollback();
                    this.loadFromStatements(Iterations.asList((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI})));
                    throw new org.entrystore.repository.RepositoryException("Error in repository connection.", e);
                }
                finally {
                    rc.close();
                }
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    private boolean hasAclChangedForGuest(Model oldGraph, Model newGraph) {
        if (oldGraph == null || newGraph == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        LinkedHashModel oldModel = new LinkedHashModel(oldGraph);
        LinkedHashModel newModel = new LinkedHashModel(newGraph);
        IRI guestURI = this.getRepositoryManager().getValueFactory().createIRI(this.getRepositoryManager().getPrincipalManager().getGuestUser().getURI().toString());
        LinkedHashModel oldAcl = new LinkedHashModel();
        oldAcl.addAll((Collection)oldModel.filter(null, RepositoryProperties.Read, (Value)guestURI, new org.eclipse.rdf4j.model.Resource[0]));
        oldAcl.addAll((Collection)oldModel.filter(null, RepositoryProperties.Write, (Value)guestURI, new org.eclipse.rdf4j.model.Resource[0]));
        LinkedHashModel newAcl = new LinkedHashModel();
        newAcl.addAll((Collection)newModel.filter(null, RepositoryProperties.Read, (Value)guestURI, new org.eclipse.rdf4j.model.Resource[0]));
        newAcl.addAll((Collection)newModel.filter(null, RepositoryProperties.Write, (Value)guestURI, new org.eclipse.rdf4j.model.Resource[0]));
        return !Models.isomorphic((Iterable)oldAcl, (Iterable)newAcl);
    }

    private boolean hasProjectTypeChanged(Model oldGraph, Model newGraph) {
        if (oldGraph == null || newGraph == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        IRI projectTypeProperty = Values.iri((String)"http://entryscape.com/terms/projectType");
        return !Models.isomorphic((Iterable)oldGraph.filter(null, projectTypeProperty, null, new org.eclipse.rdf4j.model.Resource[0]), (Iterable)newGraph.filter(null, projectTypeProperty, null, new org.eclipse.rdf4j.model.Resource[0]));
    }

    private boolean isStatementInvRelationCandidate(Statement statement, String base) {
        IRI predicate = statement.getPredicate();
        if (!(predicate.equals((Object)RepositoryProperties.resource) || predicate.equals((Object)RepositoryProperties.metadata) || predicate.equals((Object)RepositoryProperties.externalMetadata) || predicate.equals((Object)RepositoryProperties.cachedExternalMetadata) || predicate.equals((Object)RepositoryProperties.relation) || predicate.equals((Object)RepositoryProperties.cached) || predicate.equals((Object)RepositoryProperties.Creator) || predicate.equals((Object)RepositoryProperties.Contributor) || predicate.equals((Object)RepositoryProperties.Read) || predicate.equals((Object)RepositoryProperties.Write) || predicate.equals((Object)RepositoryProperties.originallyCreatedIn))) {
            Value obj = statement.getObject();
            org.eclipse.rdf4j.model.Resource subj = statement.getSubject();
            return obj instanceof IRI && obj.stringValue().startsWith(base) && subj.stringValue().startsWith(base);
        }
        return false;
    }

    private void removeInverseRelations(RepositoryConnection rc) throws RepositoryException {
        if (this.invRelations) {
            try (RepositoryResult rr = rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});){
                String base = this.repositoryManager.getRepositoryURL().toString();
                for (Statement statement : rr) {
                    if (!this.isStatementInvRelationCandidate(statement, base)) continue;
                    URI entryURI = URI.create(statement.getObject().stringValue());
                    EntryImpl sourceEntry = (EntryImpl)this.repositoryManager.getContextManager().getEntry(entryURI);
                    if (sourceEntry == null || sourceEntry == this) continue;
                    sourceEntry.removeRelationSynchronized(statement, rc);
                }
            }
            this.invRelations = false;
        }
    }

    private void addInverseRelations(RepositoryConnection rc, Model graph) {
        String base = this.repositoryManager.getRepositoryURL().toString();
        for (Statement statement : graph) {
            if (!this.isStatementInvRelationCandidate(statement, base)) continue;
            URI entryURI = URI.create(statement.getObject().stringValue());
            EntryImpl sourceEntry = (EntryImpl)this.repositoryManager.getContextManager().getEntry(entryURI);
            if (sourceEntry == null || sourceEntry == this) continue;
            sourceEntry.addRelationSynchronized(statement, rc);
        }
    }

    private void checkAdministerRights() {
        PrincipalManager pm = this.getRepositoryManager().getPrincipalManager();
        pm.checkAuthenticatedUserAuthorized((Entry)this, PrincipalManager.AccessProperty.Administer);
    }

    public Context getContext() {
        return this.context;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public Provenance getProvenance() {
        return this.provenance;
    }

    public Resource getResource() {
        if (this.resource == null) {
            ContextImpl contextImpl = (ContextImpl)this.getContext();
            try {
                contextImpl.initResource(this);
            }
            catch (RepositoryException e) {
                this.log.error(e.getMessage());
            }
        }
        return this.resource;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entry) {
            return this.getEntryURI().equals(((Entry)obj).getEntryURI());
        }
        return false;
    }

    public boolean isExternalMetadataCached() {
        return this.getExternalMetadataCacheDate() != null;
    }

    public Metadata getLocalMetadata() {
        if (this.localMetadata == null) {
            this.initMetadataObjects();
        }
        return this.localMetadata;
    }

    public Model getMetadataGraph() {
        if (this.getEntryType().equals((Object)EntryType.Local) || this.getEntryType().equals((Object)EntryType.Link)) {
            if (this.getLocalMetadata() != null && this.getLocalMetadata().getGraph() != null) {
                return this.getLocalMetadata().getGraph();
            }
        } else if (this.getEntryType().equals((Object)EntryType.Reference)) {
            if (this.getCachedExternalMetadata() != null && this.getCachedExternalMetadata().getGraph() != null) {
                return this.getCachedExternalMetadata().getGraph();
            }
        } else if (this.getEntryType().equals((Object)EntryType.LinkReference)) {
            LinkedHashModel mergedMd = new LinkedHashModel();
            if (this.getLocalMetadata() != null && this.getLocalMetadata().getGraph() != null) {
                mergedMd.addAll((Collection)this.getLocalMetadata().getGraph());
            }
            if (this.getCachedExternalMetadata() != null && this.getCachedExternalMetadata().getGraph() != null) {
                mergedMd.addAll((Collection)this.getCachedExternalMetadata().getGraph());
            }
            return mergedMd;
        }
        return new LinkedHashModel();
    }

    public void remove(RepositoryConnection rc) throws Exception {
        this.deleted = true;
        this.log.debug("Removing entry {}", (Object)this.entryURI);
        this.removeInverseRelations(rc);
        rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        if (this.locType == EntryType.Local || this.locType == EntryType.Link || this.locType == EntryType.LinkReference) {
            this.localMetadata.removeGraphSynchronized(rc);
        }
        if (this.locType == EntryType.LinkReference || this.locType == EntryType.Reference) {
            if (this.cachedExternalMetadata instanceof MetadataImpl) {
                ((MetadataImpl)this.cachedExternalMetadata).removeGraphSynchronized(rc);
            } else {
                rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.cachedExternalMdURI});
            }
        }
        if (this.relationURI != null) {
            rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.relationURI});
        }
        this.localMetadata = null;
        this.cachedExternalMetadata = null;
        if (this.resource != null && this.resource.isRemovable()) {
            this.resource.remove(rc);
            this.resource = null;
        }
    }

    public String getFilename() {
        Statement st;
        if (this.filename == null && (st = this.getStatement(this.resURI, RepositoryProperties.filename, null)) != null) {
            this.filename = st.getObject().stringValue();
        }
        return this.filename;
    }

    public URI getRelationURI() {
        return URI.create(this.relationURI.toString());
    }

    public void setFilename(String name) {
        PrincipalManager pm = this.getRepositoryManager().getPrincipalManager();
        pm.checkAuthenticatedUserAuthorized((Entry)this, PrincipalManager.AccessProperty.WriteResource);
        ValueFactory vf = this.repository.getValueFactory();
        if (this.replaceStatement(this.resURI, RepositoryProperties.filename, (Value)vf.createLiteral(name))) {
            this.filename = name;
        }
    }

    public long getFileSize() {
        Statement st;
        if (this.fileSize > 0L && (st = this.getStatement(this.resURI, RepositoryProperties.fileSize, null)) != null) {
            this.fileSize = ((Literal)st.getObject()).longValue();
        }
        return this.fileSize;
    }

    public void setFileSize(long size) {
        PrincipalManager pm = this.getRepositoryManager().getPrincipalManager();
        pm.checkAuthenticatedUserAuthorized((Entry)this, PrincipalManager.AccessProperty.WriteResource);
        ValueFactory vf = this.repository.getValueFactory();
        if (this.replaceStatement(this.resURI, RepositoryProperties.fileSize, (Value)vf.createLiteral(size))) {
            this.fileSize = size;
        }
    }

    public URI getStatus() {
        Statement st;
        if (this.status == null && (st = this.getStatement(this.entryURI, RepositoryProperties.status, null)) != null) {
            this.status = URI.create(st.getObject().stringValue());
        }
        return this.status;
    }

    public void setStatus(URI newStatus) {
        this.checkAdministerRights();
        ValueFactory vf = this.repository.getValueFactory();
        if (this.replaceStatement(this.entryURI, RepositoryProperties.status, (Value)vf.createIRI(newStatus.toString()))) {
            this.status = newStatus;
        }
    }

    public String getMimetype() {
        if (this.format == null) {
            String mtMd = this.getMimetypeFromMetadata();
            if (mtMd != null) {
                this.format = mtMd;
                return this.format;
            }
            Statement st = this.getStatement(this.resURI, RepositoryProperties.format, null);
            if (st != null) {
                this.format = st.getObject().stringValue();
            }
        }
        return this.format;
    }

    public void setMimetype(String mt) {
        String mtMd;
        PrincipalManager pm = this.getRepositoryManager().getPrincipalManager();
        pm.checkAuthenticatedUserAuthorized((Entry)this, PrincipalManager.AccessProperty.WriteResource);
        ValueFactory vf = this.repository.getValueFactory();
        if (this.replaceStatement(this.resURI, RepositoryProperties.format, (Value)vf.createLiteral(mt))) {
            this.format = mt;
        }
        if ((mtMd = this.getMimetypeFromMetadata()) != null) {
            this.format = mtMd;
        }
    }

    private String getMimetypeFromMetadata() {
        Value obj;
        Statement st = this.getStatementFromLocalMetadata(this.resURI, RepositoryProperties.format, null);
        if (st != null && (obj = st.getObject()).isLiteral()) {
            return obj.stringValue();
        }
        return null;
    }

    public boolean replaceStatementSynchronized(IRI subject, IRI predicate, Value object, RepositoryConnection rc, ValueFactory vf) throws RepositoryException {
        rc.remove((org.eclipse.rdf4j.model.Resource)subject, predicate, null, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        rc.add((org.eclipse.rdf4j.model.Resource)subject, predicate, object, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        this.registerEntryModified(rc, vf);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean replaceStatementSynchronized(IRI subject, IRI predicate, Value object) {
        try {
            rc.begin();
            try (RepositoryConnection rc = this.repository.getConnection();){
                boolean result = this.replaceStatementSynchronized(subject, predicate, object, rc, this.repository.getValueFactory());
                rc.commit();
                this.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this, RepositoryEvent.EntryUpdated));
                boolean bl = result;
                return bl;
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceStatement(IRI subject, IRI predicate, Value object) {
        Repository repository = this.repository;
        synchronized (repository) {
            return this.replaceStatementSynchronized(subject, predicate, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement getStatement(IRI subject, IRI predicate, Value object) {
        try (RepositoryConnection rc = this.repository.getConnection();){
            RepositoryResult matches = rc.getStatements((org.eclipse.rdf4j.model.Resource)subject, predicate, object, false, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            if (matches.hasNext()) {
                Statement result = (Statement)matches.next();
                matches.close();
                Statement statement = result;
                return statement;
            }
            if (!matches.isClosed()) {
                matches.close();
            }
            rc.close();
            Statement statement = null;
            return statement;
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement getStatementFromLocalMetadata(IRI subject, IRI predicate, Value object) {
        if (this.localMdURI == null) {
            return null;
        }
        try (RepositoryConnection rc = this.repository.getConnection();){
            RepositoryResult matches = rc.getStatements((org.eclipse.rdf4j.model.Resource)subject, predicate, object, false, new org.eclipse.rdf4j.model.Resource[]{this.localMdURI});
            if (matches.hasNext()) {
                Statement result = (Statement)matches.next();
                matches.close();
                Statement statement = result;
                return statement;
            }
            if (!matches.isClosed()) {
                matches.close();
            }
            rc.close();
            Statement statement = null;
            return statement;
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    public String getOriginalList() {
        if (this.originalList == null) {
            Statement st = this.getStatement(this.entryURI, RepositoryProperties.originallyCreatedIn, null);
            this.originalList = st != null && st.getObject() instanceof IRI ? st.getObject().stringValue() : "";
        }
        if (this.originalList.isEmpty()) {
            return null;
        }
        return this.originalList;
    }

    public void setOriginalListSynchronized(String list, RepositoryConnection rc, ValueFactory vf) throws RepositoryException {
        rc.remove((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.originallyCreatedIn, null, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
        if (list != null) {
            rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.originallyCreatedIn, (Value)vf.createIRI(list), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
            this.originalList = list;
        } else {
            this.originalList = "";
        }
    }

    public void setOriginalListSynchronized(String list) {
        try {
            rc.begin();
            try (RepositoryConnection rc = this.repository.getConnection();){
                rc.remove((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.originallyCreatedIn, null, new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                if (list != null) {
                    rc.add((org.eclipse.rdf4j.model.Resource)this.entryURI, RepositoryProperties.originallyCreatedIn, (Value)this.repository.getValueFactory().createIRI(list), new org.eclipse.rdf4j.model.Resource[]{this.entryURI});
                    this.originalList = list;
                } else {
                    this.originalList = "";
                }
                rc.commit();
            }
        }
        catch (RepositoryException e) {
            throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
        }
    }

    public Model getRelations() {
        Model model;
        block8: {
            RepositoryConnection rc = this.repository.getConnection();
            try {
                model = (Model)Iterations.addAll((CloseableIteration)rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.relationURI}), (Collection)new LinkedHashModel());
                if (rc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rc != null) {
                        try {
                            rc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    this.log.error(e.getMessage());
                    throw new org.entrystore.repository.RepositoryException("Failed to connect to Repository.", (Exception)((Object)e));
                }
            }
            rc.close();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRelationSynchronized(Statement statement, RepositoryConnection rc) {
        EntryImpl entryImpl = this;
        synchronized (entryImpl) {
            this.addRelation(statement, rc);
        }
    }

    private void addRelation(Statement statement, RepositoryConnection rc) {
        try {
            rc.add(statement, new org.eclipse.rdf4j.model.Resource[]{this.relationURI});
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRelationSynchronized(Statement statement, RepositoryConnection rc) {
        EntryImpl entryImpl = this;
        synchronized (entryImpl) {
            this.removeRelation(statement, rc);
        }
    }

    private void removeRelation(Statement statement, RepositoryConnection rc) {
        try {
            rc.remove(statement, new org.eclipse.rdf4j.model.Resource[]{this.relationURI});
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage());
            throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
        }
    }

    public String toString() {
        return this.entryURI.toString() + "," + super.toString();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Generated
    public Metadata getCachedExternalMetadata() {
        return this.cachedExternalMetadata;
    }

    @Generated
    public Repository getRepository() {
        return this.repository;
    }

    @Generated
    public GraphType getGraphType() {
        return this.graphType;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }
}

