/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.ListImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.SoftCache;
import org.entrystore.impl.UserImpl;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupImpl
extends ListImpl
implements Group {
    static Logger log = LoggerFactory.getLogger(UserImpl.class);
    private URI homeContext;

    public GroupImpl(EntryImpl entry, IRI uri, SoftCache cache) {
        super(entry, uri);
    }

    public String getName() {
        return ((PrincipalManager)this.entry.getContext()).getPrincipalName(this.getURI());
    }

    public boolean setName(String newName) {
        return ((PrincipalManager)this.entry.getContext()).setPrincipalName(this.getURI(), newName);
    }

    public Context getHomeContext() {
        Entry eContext;
        if (this.homeContext == null) {
            try (RepositoryConnection rc = this.entry.repository.getConnection();){
                List matches = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.homeContext, null, false, new Resource[]{this.entry.getSesameEntryURI()}).stream().toList();
                if (!matches.isEmpty()) {
                    this.homeContext = URI.create(((Statement)matches.getFirst()).getObject().stringValue());
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new org.entrystore.repository.RepositoryException("Failed to connect to repository", (Exception)((Object)e));
            }
        }
        if (this.homeContext != null && (eContext = this.entry.getRepositoryManager().getContextManager().getByEntryURI(this.homeContext)) != null) {
            return (Context)eContext.getResource();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setHomeContext(Context context) {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        Repository repository = this.entry.repository;
        synchronized (repository) {
            RepositoryConnection rc = null;
            try {
                rc = this.entry.repository.getConnection();
                rc.begin();
                ValueFactory vf = this.entry.repository.getValueFactory();
                RepositoryResult iter = rc.getStatements((Resource)this.resourceURI, RepositoryProperties.homeContext, null, false, new Resource[]{this.entry.getSesameEntryURI()});
                while (iter.hasNext()) {
                    Statement statement = (Statement)iter.next();
                    URI sourceEntryURI = URI.create(statement.getObject().stringValue());
                    EntryImpl sourceEntry = (EntryImpl)this.entry.getRepositoryManager().getContextManager().getEntry(sourceEntryURI);
                    if (sourceEntry != null) {
                        sourceEntry.removeRelationSynchronized(statement, rc);
                    }
                    rc.remove(statement, new Resource[]{this.entry.getSesameEntryURI()});
                }
                iter.close();
                if (context != null) {
                    Statement newStatement = vf.createStatement((Resource)this.resourceURI, RepositoryProperties.homeContext, (Value)((EntryImpl)context.getEntry()).getSesameEntryURI(), (Resource)this.entry.getSesameEntryURI());
                    rc.add(newStatement, new Resource[0]);
                    ((EntryImpl)context.getEntry()).addRelationSynchronized(newStatement, rc);
                }
                rc.commit();
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                try {
                    rc.rollback();
                }
                catch (RepositoryException e1) {
                    log.error(e.getMessage(), (Throwable)e1);
                }
            }
            finally {
                try {
                    rc.close();
                    this.entry.invRelations = true;
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                this.homeContext = context.getEntry().getEntryURI();
            }
        }
        return true;
    }

    public void addMember(User user) {
        this.addChild(user.getEntry().getEntryURI());
    }

    public boolean removeMember(User user) {
        return this.removeChild(user.getEntry().getEntryURI());
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        List<URI> children = this.getChildren();
        Entry userEntry = user.getEntry();
        URI userEntryURI = userEntry.getEntryURI();
        return children.contains(userEntryURI);
    }

    public List<URI> memberUris() {
        return this.getChildren();
    }

    public List<User> members() {
        Vector<User> userList = new Vector<User>();
        Iterator<URI> memberUriIterator = this.memberUris().iterator();
        boolean contentError = false;
        while (memberUriIterator.hasNext()) {
            URI entryURI = memberUriIterator.next();
            try {
                Entry userEntry = this.entry.getContext().getByEntryURI(entryURI);
                if (userEntry.getGraphType() == GraphType.User) {
                    userList.add((User)userEntry.getResource());
                    continue;
                }
                contentError = true;
            }
            catch (NullPointerException e) {
                log.error(e.getMessage());
            }
        }
        if (contentError) {
            log.error("Error in group {} . All members does not seem to be of the type User.", (Object)this.getURI().toString());
        }
        return userList;
    }

    public Vector<URI> setChildren(Vector<URI> children) {
        this.setChildren(children, true, true);
        return new Vector<URI>(this.getChildren());
    }
}

