/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.List;
import org.entrystore.PrincipalManager;
import org.entrystore.QuotaException;
import org.entrystore.Resource;
import org.entrystore.ResourceType;
import org.entrystore.impl.DataImpl;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.RDFResource;
import org.entrystore.repository.RepositoryEvent;
import org.entrystore.repository.RepositoryEventObject;
import org.entrystore.repository.security.DisallowedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListImpl
extends RDFResource
implements List {
    private static final Logger log = LoggerFactory.getLogger(ListImpl.class);
    private Vector<URI> children;

    public ListImpl(EntryImpl entry, String uri) {
        super(entry, uri);
    }

    public ListImpl(EntryImpl entry, IRI uri) {
        super(entry, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Model getGraph() {
        RepositoryConnection rc = null;
        LinkedHashModel result = null;
        try {
            rc = this.entry.repository.getConnection();
            RepositoryResult statements = rc.getStatements(null, null, null, false, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            result = new LinkedHashModel((Collection)Iterations.asList((CloseableIteration)statements));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                if (rc != null) {
                    rc.close();
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        return result;
    }

    @Override
    public synchronized void setGraph(Model graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph must not be null");
        }
        this.children = this.loadChildren(graph);
        this.saveChildren();
    }

    private Vector<URI> loadChildren(Model graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph must not be null");
        }
        Vector<URI> result = new Vector<URI>();
        for (Statement statement : graph) {
            IRI predicate = statement.getPredicate();
            if (!predicate.toString().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
            try {
                String value = predicate.toString().substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length());
                int index = Integer.parseInt(value.substring(value.lastIndexOf("_") + 1));
                if (index > result.size()) {
                    result.setSize(index);
                }
                result.set(index - 1, URI.create(statement.getObject().stringValue()));
            }
            catch (IndexOutOfBoundsException iobe) {
                log.error(iobe.getMessage());
            }
            catch (NumberFormatException nfe) {
                log.error("{}; affected statement: {}", (Object)nfe.getMessage(), (Object)statement);
            }
        }
        result.trimToSize();
        return result;
    }

    private synchronized void loadChildren() {
        if (this.children == null) {
            this.children = this.loadChildren(this.getGraph());
        }
    }

    private synchronized void saveChildren() {
        if (this.children == null) {
            return;
        }
        try (RepositoryConnection rc = this.entry.repository.getConnection();){
            rc.begin();
            this.saveChildren(rc);
            rc.commit();
            this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
    }

    private void saveChildren(RepositoryConnection rc) throws RepositoryException {
        ValueFactory vf = this.entry.repository.getValueFactory();
        this.children.trimToSize();
        rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
        if (!this.children.isEmpty()) {
            rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, RDF.TYPE, (Value)RDF.SEQ, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            for (int i = 0; i < this.children.size(); ++i) {
                IRI li = vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + (i + 1));
                IRI child = vf.createIRI(this.children.get(i).toString());
                rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, li, (Value)child, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            }
            this.entry.registerEntryModified(rc, rc.getValueFactory());
        }
    }

    public void addChild(URI child) {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        this.addChild(child, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(URI nEntry, boolean singleParentForListsRequirement, boolean orderedSetRequirement) {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        boolean isOwnerOfContext = false;
        if (pm != null) {
            try {
                pm.checkAuthenticatedUserAuthorized(this.entry.getContext().getEntry(), PrincipalManager.AccessProperty.WriteResource);
                isOwnerOfContext = true;
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
        EntryImpl childEntry = (EntryImpl)this.entry.getContext().getByEntryURI(nEntry);
        if (singleParentForListsRequirement && childEntry.getGraphType() == GraphType.List && !childEntry.getReferringListsInSameContext().isEmpty()) {
            throw new org.entrystore.repository.RepositoryException("The entry " + String.valueOf(nEntry) + " cannot be added since it is a list which already have another parent, try moving it instead");
        }
        if (this.children == null) {
            this.loadChildren();
        }
        if (orderedSetRequirement && this.children.contains(nEntry)) {
            throw new org.entrystore.repository.RepositoryException("The entry " + String.valueOf(nEntry) + " is already a child in this list.");
        }
        try {
            Repository repository = this.entry.repository;
            synchronized (repository) {
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    ValueFactory vf = this.entry.repository.getValueFactory();
                    rc.begin();
                    if (isOwnerOfContext) {
                        childEntry.setOriginalListSynchronized(null, rc, vf);
                    }
                    if (this.children.isEmpty()) {
                        rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, RDF.TYPE, (Value)RDF.SEQ, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    }
                    IRI li = vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + (this.children.size() + 1));
                    IRI childURI = vf.createIRI(nEntry.toString());
                    rc.add((org.eclipse.rdf4j.model.Resource)this.resourceURI, li, (Value)childURI, new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
                    childEntry.addReferringList(this, rc);
                    this.children.add(nEntry);
                    this.entry.registerEntryModified(rc, vf);
                    rc.commit();
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)childEntry, RepositoryEvent.EntryUpdated));
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Entry moveEntryHere(URI entry, URI fromList, boolean removeFromAllLists) throws QuotaException {
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        pm.checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        EntryImpl e = (EntryImpl)this.entry.getRepositoryManager().getContextManager().getEntry(entry);
        if (e == null) {
            throw new org.entrystore.repository.RepositoryException("Cannot find entry: " + String.valueOf(entry) + " and it cannot be moved.");
        }
        EntryImpl fromListEntry = (EntryImpl)this.entry.getRepositoryManager().getContextManager().getEntry(fromList);
        if (fromListEntry == null && !removeFromAllLists) {
            throw new org.entrystore.repository.RepositoryException("Cannot find list: " + String.valueOf(fromList) + " and hence cannot move an entry from it.");
        }
        if (fromListEntry != null) {
            if (fromListEntry.getContext() != e.getContext() || fromListEntry.getGraphType() != GraphType.List || !((List)fromListEntry.getResource()).getChildren().contains(entry)) {
                throw new org.entrystore.repository.RepositoryException("Entry (" + String.valueOf(entry) + ") is not a child of list (" + String.valueOf(fromList) + "), hence it cannot be moved from it.");
            }
            pm.checkAuthenticatedUserAuthorized((Entry)fromListEntry, PrincipalManager.AccessProperty.WriteResource);
        } else {
            pm.checkAuthenticatedUserAuthorized(e.getContext().getEntry(), PrincipalManager.AccessProperty.WriteResource);
        }
        if (e.getContext() == this.getEntry().getContext()) {
            if (fromListEntry != null) {
                ListImpl fromListR = (ListImpl)fromListEntry.getResource();
                fromListR.removeChild(entry, false);
            } else {
                Set<URI> lists = e.getReferringListsInSameContext();
                this.addChild(entry, false, true);
                Context c = e.getContext();
                for (URI list : lists) {
                    Entry refListE = c.getByEntryURI(list);
                    if (refListE == null) continue;
                    ((ListImpl)refListE.getResource()).removeChild(e.getEntryURI(), false);
                }
            }
            this.addChild(entry, false, true);
            return e;
        }
        int nrOfRefLists = e.getReferringListsInSameContext().size();
        GraphType bt = e.getGraphType();
        if (bt == GraphType.SystemContext || bt == GraphType.Context || bt == GraphType.User || bt == GraphType.Group) {
            throw new org.entrystore.repository.RepositoryException("Cannot move SystemContexts, Contexts, Users or Groups.");
        }
        EntryImpl newEntry = null;
        if (bt == GraphType.List) {
            try {
                newEntry = this.copyEntryHere(e);
                ((List)e.getResource()).removeTree();
            }
            catch (org.entrystore.repository.RepositoryException re) {
                if (newEntry != null) {
                    throw new org.entrystore.repository.RepositoryException("Succeeded in copying folder structure (leaving it there), but failed to remove the old structure (remove manually): " + re.getMessage());
                }
                throw new org.entrystore.repository.RepositoryException("Failed copying the folder structure, nothing is changed: " + re.getMessage());
            }
            return newEntry;
        }
        Context c = this.entry.getContext();
        switch (e.getEntryType()) {
            case Local: {
                newEntry = (EntryImpl)c.createResource(null, e.getGraphType(), e.getResourceType(), this.getURI());
                if (e.getGraphType() != GraphType.None || e.getResourceType() != ResourceType.InformationResource) break;
                try {
                    ((DataImpl)newEntry.getResource()).useData(((DataImpl)e.getResource()).getDataFile());
                }
                catch (IOException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
                break;
            }
            case Link: {
                newEntry = (EntryImpl)c.createLink(null, e.getResourceURI(), this.getURI());
                break;
            }
            case LinkReference: {
                newEntry = (EntryImpl)c.createLinkReference(null, e.getResourceURI(), e.getExternalMetadataURI(), this.getURI());
                break;
            }
            case Reference: {
                newEntry = (EntryImpl)c.createReference(null, e.getResourceURI(), e.getExternalMetadataURI(), this.getURI());
            }
        }
        this.copyGraphs(e, newEntry);
        if (removeFromAllLists || nrOfRefLists == 1 && e.getReferringListsInSameContext().isEmpty()) {
            e.getContext().remove(e.getEntryURI());
        } else {
            ListImpl fromListR = (ListImpl)fromListEntry.getResource();
            fromListR.removeChild(entry, false);
        }
        return newEntry;
    }

    protected EntryImpl copyEntryHere(EntryImpl entryToCopy) throws QuotaException {
        return this._copyEntryHere(entryToCopy, true);
    }

    private EntryImpl _copyEntryHere(EntryImpl entryToCopy, boolean first) throws QuotaException {
        EntryImpl newEntry = null;
        try {
            GraphType bt = entryToCopy.getGraphType();
            if (bt == GraphType.User || bt == GraphType.Context || bt == GraphType.Group || bt == GraphType.SystemContext) {
                return null;
            }
            Context c = this.entry.getContext();
            switch (entryToCopy.getEntryType()) {
                case Local: {
                    newEntry = (EntryImpl)c.createResource(null, entryToCopy.getGraphType(), entryToCopy.getResourceType(), this.getURI());
                    if (entryToCopy.getGraphType() != GraphType.None || entryToCopy.getResourceType() != ResourceType.InformationResource) break;
                    try {
                        ((DataImpl)newEntry.getResource()).useData(((DataImpl)entryToCopy.getResource()).getDataFile());
                    }
                    catch (IOException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    break;
                }
                case Link: {
                    newEntry = (EntryImpl)c.createLink(null, entryToCopy.getResourceURI(), this.getURI());
                    break;
                }
                case LinkReference: {
                    newEntry = (EntryImpl)c.createLinkReference(null, entryToCopy.getResourceURI(), entryToCopy.getExternalMetadataURI(), this.getURI());
                    break;
                }
                case Reference: {
                    newEntry = (EntryImpl)c.createReference(null, entryToCopy.getResourceURI(), entryToCopy.getExternalMetadataURI(), this.getURI());
                }
            }
            this.copyGraphs(entryToCopy, newEntry);
            if (bt == GraphType.List) {
                ListImpl newList = (ListImpl)newEntry.getResource();
                List oldList = (List)entryToCopy.getResource();
                java.util.List children = oldList.getChildren();
                for (URI uri : children) {
                    EntryImpl childEntryToCopy = (EntryImpl)this.entry.getRepositoryManager().getContextManager().getEntry(uri);
                    newList._copyEntryHere(childEntryToCopy, false);
                }
            }
        }
        catch (Exception e) {
            if (first && newEntry != null && newEntry.getGraphType() == GraphType.List) {
                ((List)newEntry.getResource()).removeTree();
            }
            throw new org.entrystore.repository.RepositoryException("Failed to copy entry (" + String.valueOf(entryToCopy.getEntryURI()) + "):" + e.getMessage());
        }
        return newEntry;
    }

    private void copyGraphs(EntryImpl source, EntryImpl dest) {
        Resource obj;
        Model eGraph = source.getGraph();
        HashMap<IRI, IRI> map = new HashMap<IRI, IRI>();
        map.put(source.getSesameEntryURI(), dest.getSesameEntryURI());
        map.put(source.getSesameLocalMetadataURI(), dest.getSesameLocalMetadataURI());
        map.put(source.getSesameResourceURI(), dest.getSesameResourceURI());
        if (source.getEntryType() == EntryType.LinkReference || source.getEntryType() == EntryType.Reference) {
            map.put(source.getSesameExternalMetadataURI(), dest.getSesameExternalMetadataURI());
            map.put(source.getSesameCachedExternalMetadataURI(), dest.getSesameCachedExternalMetadataURI());
        }
        eGraph = this.replaceURIs(eGraph, map);
        dest.setGraph(eGraph);
        dest.getLocalMetadata().setGraph(this.replaceURI(source.getLocalMetadata().getGraph(), source.getSesameResourceURI(), dest.getSesameResourceURI()));
        if (source.getCachedExternalMetadata() != null) {
            dest.getCachedExternalMetadata().setGraph(this.replaceURI(source.getCachedExternalMetadata().getGraph(), source.getSesameResourceURI(), dest.getSesameResourceURI()));
        }
        if ((obj = source.getResource()) instanceof RDFResource && !(obj instanceof List)) {
            ((RDFResource)dest.getResource()).setGraph(this.replaceURI(((RDFResource)obj).getGraph(), source.getSesameResourceURI(), dest.getSesameResourceURI()));
        }
    }

    private Model replaceURI(Model graph, IRI oUri, IRI nUri) {
        LinkedHashModel nGraph = new LinkedHashModel();
        for (Statement statement : graph) {
            if (statement.getSubject().equals((Object)oUri)) {
                nGraph.add((org.eclipse.rdf4j.model.Resource)nUri, statement.getPredicate(), statement.getObject(), new org.eclipse.rdf4j.model.Resource[0]);
                continue;
            }
            if (statement.getObject().equals((Object)oUri)) {
                nGraph.add(statement.getSubject(), statement.getPredicate(), (Value)nUri, new org.eclipse.rdf4j.model.Resource[0]);
                continue;
            }
            nGraph.add((Object)statement);
        }
        return nGraph;
    }

    private Model replaceURIs(Model graph, HashMap<IRI, IRI> map) {
        LinkedHashModel nGraph = new LinkedHashModel();
        for (Statement statement : graph) {
            org.eclipse.rdf4j.model.Resource subj = statement.getSubject();
            IRI pred = statement.getPredicate();
            Value obj = statement.getObject();
            if (map.containsKey(subj)) {
                subj = (org.eclipse.rdf4j.model.Resource)map.get(subj);
            }
            if (map.containsKey(pred)) {
                pred = map.get(pred);
            }
            if (obj instanceof IRI && map.containsKey(obj)) {
                obj = (Value)map.get(obj);
            }
            nGraph.add(subj, pred, obj, new org.eclipse.rdf4j.model.Resource[0]);
        }
        return nGraph;
    }

    public boolean setChildren(java.util.List<URI> newChildren) {
        return this.setChildren(newChildren, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setChildren(java.util.List<URI> newChildren, boolean singleParentForListsRequirement, boolean orderedSetRequirement) {
        Object set;
        EntryImpl childEntry;
        PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
        boolean isOwnerOfContext = false;
        if (pm != null) {
            pm.checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
            try {
                pm.checkAuthenticatedUserAuthorized(this.entry.getContext().getEntry(), PrincipalManager.AccessProperty.WriteResource);
                isOwnerOfContext = true;
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
        if (this.children == null) {
            this.loadChildren();
        }
        ArrayList<URI> toRemove = new ArrayList<URI>(this.children);
        toRemove.removeAll(newChildren);
        ArrayList<URI> toAdd = new ArrayList<URI>(newChildren);
        toAdd.removeAll(this.children);
        for (URI uri : toAdd) {
            childEntry = (EntryImpl)this.entry.getContext().getByEntryURI(uri);
            if (singleParentForListsRequirement && childEntry.getGraphType() == GraphType.List && !childEntry.getReferringListsInSameContext().isEmpty()) {
                throw new org.entrystore.repository.RepositoryException("Cannot set the list since the child " + String.valueOf(uri) + " is a list which already have a parent.");
            }
            if (childEntry != null) continue;
            throw new org.entrystore.repository.RepositoryException("Cannot set the list since the child " + String.valueOf(uri) + " does not exist.");
        }
        if (orderedSetRequirement && ((HashSet)(set = new HashSet<URI>(newChildren))).size() < newChildren.size()) {
            throw new org.entrystore.repository.RepositoryException("Cannot set the list since some of its children occur multiple times.");
        }
        for (URI uri : toRemove) {
            childEntry = (EntryImpl)this.entry.getContext().getByEntryURI(uri);
            if (childEntry == null) {
                log.warn("List contains entry which does not exist: {}", (Object)uri);
                continue;
            }
            if (this.canRemove(true, childEntry, isOwnerOfContext)) continue;
            throw new org.entrystore.repository.RepositoryException("Cannot set the list since you do not have the rights to remove the child " + String.valueOf(uri) + " from the list.");
        }
        try {
            set = this.entry.repository;
            synchronized (set) {
                Vector<URI> oldChildrenList = this.children;
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    EntryImpl childEntry2;
                    rc.begin();
                    this.children = new Vector<URI>(newChildren);
                    ArrayList<EntryImpl> updatedChildEntries = new ArrayList<EntryImpl>();
                    this.saveChildren(rc);
                    for (URI uri : toAdd) {
                        childEntry2 = (EntryImpl)this.entry.getContext().getByEntryURI(uri);
                        if (childEntry2 == null) continue;
                        childEntry2.addReferringList(this, rc);
                        if (isOwnerOfContext) {
                            childEntry2.setOriginalListSynchronized(null, rc, this.entry.repository.getValueFactory());
                        }
                        updatedChildEntries.add(childEntry2);
                    }
                    for (URI uri : toRemove) {
                        childEntry2 = (EntryImpl)this.entry.getContext().getByEntryURI(uri);
                        if (childEntry2 == null) continue;
                        childEntry2.removeReferringList(this, rc);
                        if (isOwnerOfContext) {
                            childEntry2.setOriginalListSynchronized(null, rc, this.entry.repository.getValueFactory());
                        }
                        updatedChildEntries.add(childEntry2);
                    }
                    rc.commit();
                    for (EntryImpl updatedChildEntry : updatedChildEntries) {
                        this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)updatedChildEntry, RepositoryEvent.RelationsUpdated));
                    }
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public java.util.List<URI> getChildren() {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
        if (this.children == null) {
            this.loadChildren();
        }
        return Collections.unmodifiableList(this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildAfter(URI child, URI afterChild) {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        if (this.children == null) {
            this.loadChildren();
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            this.children.remove(child);
            this.children.add(this.children.indexOf(afterChild) + 1, child);
            this.saveChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildBefore(URI child, URI beforeChild) {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        if (this.children == null) {
            this.loadChildren();
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            this.children.remove(child);
            this.children.add(this.children.indexOf(beforeChild), child);
            this.saveChildren();
        }
    }

    public boolean removeChild(URI child) {
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.WriteResource);
        return this.removeChild(child, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean removeChild(URI child, boolean checkOrphaned) {
        if (this.children == null) {
            this.loadChildren();
        }
        if (!this.children.contains(child)) {
            return false;
        }
        Repository repository = this.entry.repository;
        synchronized (repository) {
            EntryImpl childEntry;
            boolean isOwnerOfContext = true;
            PrincipalManager pm = this.entry.getRepositoryManager().getPrincipalManager();
            if (pm != null) {
                try {
                    pm.checkAuthenticatedUserAuthorized(this.entry.getContext().getEntry(), PrincipalManager.AccessProperty.WriteResource);
                }
                catch (AuthorizationException ae) {
                    isOwnerOfContext = false;
                }
            }
            if (!this.canRemove(checkOrphaned, childEntry = (EntryImpl)this.entry.getContext().getByEntryURI(child), isOwnerOfContext)) {
                return false;
            }
            this.children.remove(child);
            try {
                ValueFactory vf = this.entry.repository.getValueFactory();
                try (RepositoryConnection rc = this.entry.repository.getConnection();){
                    rc.begin();
                    if (checkOrphaned && isOwnerOfContext) {
                        childEntry.setOriginalListSynchronized(null, rc, vf);
                    }
                    this.saveChildren(rc);
                    childEntry.removeReferringList(this, rc);
                    rc.commit();
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)childEntry, RepositoryEvent.EntryUpdated));
                    this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceUpdated));
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
            return true;
        }
    }

    private boolean canRemove(boolean checkOrphaned, EntryImpl childEntry, boolean isOwnerOfContext) {
        if (childEntry == null) {
            return false;
        }
        Set<URI> refLists = childEntry.getReferringListsInSameContext();
        if (refLists != null && checkOrphaned && refLists.size() == 1) {
            if (isOwnerOfContext) {
                return true;
            }
            return childEntry.getOriginalList() == null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(RepositoryConnection rc) throws Exception {
        Repository repository = this.entry.repository;
        synchronized (repository) {
            if (this.children == null) {
                this.loadChildren();
            }
            rc.clear(new org.eclipse.rdf4j.model.Resource[]{this.resourceURI});
            for (URI uri : this.children) {
                EntryImpl childEntry = (EntryImpl)this.entry.getContext().getByEntryURI(uri);
                childEntry.removeReferringList(this, rc);
                this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)childEntry, RepositoryEvent.EntryUpdated));
            }
            this.children = null;
            this.entry.getRepositoryManager().fireRepositoryEvent(new RepositoryEventObject((Entry)this.entry, RepositoryEvent.ResourceDeleted));
        }
    }

    public void removeTree() {
        Context c = this.entry.getContext();
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized(c.getEntry(), PrincipalManager.AccessProperty.Administer);
        if (this.children == null) {
            this.loadChildren();
        }
        ArrayList<URI> tchildren = new ArrayList<URI>(this.children);
        this.setChildren(new ArrayList<URI>(), false, false);
        for (URI uri : tchildren) {
            EntryImpl childEntry = (EntryImpl)this.entry.getContext().getByEntryURI(uri);
            if (childEntry == null) continue;
            if (GraphType.List.equals((Object)childEntry.getGraphType()) && EntryType.Local.equals((Object)childEntry.getEntryType())) {
                ((List)childEntry.getResource()).removeTree();
                continue;
            }
            if (!childEntry.getReferringListsInSameContext().isEmpty()) continue;
            c.remove(uri);
        }
        try {
            c.remove(this.getEntry().getEntryURI());
        }
        catch (DisallowedException disallowedException) {
            // empty catch block
        }
    }

    public void applyACLtoChildren(boolean recursive) {
        Context c = this.entry.getContext();
        this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized(c.getEntry(), PrincipalManager.AccessProperty.Administer);
        if (this.children == null) {
            this.loadChildren();
        }
        for (URI uri : this.children) {
            Entry childEntry = this.entry.getContext().getByEntryURI(uri);
            if (childEntry == null) continue;
            for (PrincipalManager.AccessProperty ap : PrincipalManager.AccessProperty.values()) {
                childEntry.setAllowedPrincipalsFor(ap, this.entry.getAllowedPrincipalsFor(ap));
            }
            if (!GraphType.List.equals((Object)childEntry.getGraphType()) || !EntryType.Local.equals((Object)childEntry.getEntryType())) continue;
            Resource childResource = childEntry.getResource();
            if (childResource instanceof List) {
                ((List)childEntry.getResource()).applyACLtoChildren(recursive);
                continue;
            }
            log.warn("Entry has builtin type List but its resource is not instance of List, please check: {}", (Object)uri);
        }
    }
}

