/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.impl.EntryImpl;
import org.entrystore.impl.EntryNamesContext;
import org.entrystore.impl.GroupImpl;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.impl.SoftCache;
import org.entrystore.impl.SystemGroup;
import org.entrystore.impl.UserImpl;
import org.entrystore.repository.security.Password;
import org.entrystore.repository.util.URISplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalManagerImpl
extends EntryNamesContext
implements PrincipalManager {
    private static final Logger log = LoggerFactory.getLogger(PrincipalManagerImpl.class);
    private static final ThreadLocal<URI> authenticatedUserURI = new ThreadLocal();
    public User adminUser = null;
    public Group adminGroup = null;
    public User guestUser = null;
    public Group userGroup = null;
    private EntryImpl allPrincipals;
    private static final String ENV_ADMIN_PASSWORD = "ENTRYSTORE_ADMIN_PASSWORD";

    public PrincipalManagerImpl(EntryImpl entry, String uri, SoftCache softCache) {
        super(entry, uri, softCache);
    }

    public String getPrincipalName(URI principal) {
        Entry principalEntry = null;
        User u = this.getUser(principal);
        if (u != null) {
            principalEntry = u.getEntry();
        } else {
            Group g = this.getGroup(principal);
            if (g != null) {
                principalEntry = g.getEntry();
            }
        }
        if (principalEntry == null) {
            throw new org.entrystore.repository.RepositoryException("Unable to resolve URI into principal: " + String.valueOf(principal));
        }
        this.checkAuthenticatedUserAuthorized(principalEntry, PrincipalManager.AccessProperty.ReadMetadata);
        return this.getName(principalEntry.getEntryURI());
    }

    public Entry getPrincipalEntry(String name) {
        Entry principalEntry = this.getEntryByName(name.toLowerCase());
        if (principalEntry == null) {
            return null;
        }
        if (principalEntry.getGraphType() == GraphType.User || principalEntry.getGraphType() == GraphType.Group) {
            return principalEntry;
        }
        throw new org.entrystore.repository.RepositoryException("Found entry for the name is not a principal...\nthis is either a programming error or someone have been tampering with the RDF directly.");
    }

    public boolean setPrincipalName(URI principal, String newName) {
        if (principal == null || newName == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        String noZeroLengthSpaceName = newName.replaceAll("[\\p{Cf}]", "");
        String trimmedName = StringUtils.trimToNull((String)noZeroLengthSpaceName);
        if (trimmedName == null) {
            throw new IllegalArgumentException("Principal name must not be null");
        }
        String normalizedName = trimmedName.toLowerCase();
        URISplit us = new URISplit(principal, this.entry.getRepositoryManager().getRepositoryURL());
        Entry principalEntry = this.getByEntryURI(us.getMetaMetadataURI());
        if (principalEntry == null) {
            throw new org.entrystore.repository.RepositoryException("Cannot find an entry for the specified URI");
        }
        if (principalEntry.getGraphType() == GraphType.User || principalEntry.getGraphType() == GraphType.Group) {
            return this.setEntryName(us.getMetaMetadataURI(), normalizedName);
        }
        throw new org.entrystore.repository.RepositoryException("Given URI does not refer to a Principal.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserAdminOrAdminGroup(URI principal) {
        URI currentUserURI = this.getAuthenticatedUserURI();
        if (principal == null) {
            principal = currentUserURI;
        }
        URI adminUserURI = this.getAdminUser().getURI();
        try {
            this.setAuthenticatedUserURI(adminUserURI);
            User user = this.getUser(principal);
            if (adminUserURI.equals(principal) || this.getAdminGroup().isMember(user)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.setAuthenticatedUserURI(currentUserURI);
        }
        return false;
    }

    public List<URI> getUsersAsUris() {
        Iterator<URI> entryIterator = this.getEntries().iterator();
        ArrayList<URI> userUris = new ArrayList<URI>();
        while (entryIterator.hasNext()) {
            URI nextURI = entryIterator.next();
            Entry nextEntry = this.getByEntryURI(nextURI);
            if (nextEntry.getGraphType() != GraphType.User) continue;
            userUris.add(nextEntry.getResourceURI());
        }
        return userUris;
    }

    public List<User> getUsers() {
        Iterator<URI> entryIterator = this.getEntries().iterator();
        ArrayList<User> userUris = new ArrayList<User>();
        while (entryIterator.hasNext()) {
            URI nextURI = entryIterator.next();
            Entry nextEntry = this.getByEntryURI(nextURI);
            if (nextEntry.getGraphType() != GraphType.User) continue;
            userUris.add((User)nextEntry.getResource());
        }
        return userUris;
    }

    public User getUser(URI userUri) {
        for (Entry user : this.getByResourceURI(userUri)) {
            if (user.getGraphType() != GraphType.User) continue;
            return (User)user.getResource();
        }
        return null;
    }

    public Group getGroup(URI groupUri) {
        for (Entry user : this.getByResourceURI(groupUri)) {
            if (user.getGraphType() != GraphType.Group) continue;
            return (Group)user.getResource();
        }
        return null;
    }

    public Set<URI> getGroupUris() {
        Iterator<URI> entryIterator = this.getEntries().iterator();
        HashSet<URI> groupUris = new HashSet<URI>();
        while (entryIterator.hasNext()) {
            URI nextURI = entryIterator.next();
            Entry nextGroup = this.getByEntryURI(nextURI);
            if (!GraphType.Group.equals((Object)nextGroup.getGraphType())) continue;
            groupUris.add(nextGroup.getResourceURI());
        }
        return groupUris;
    }

    public Set<URI> getGroupUris(URI userUri) {
        Iterator<URI> entryIterator = this.getEntries().iterator();
        HashSet<URI> groupUris = new HashSet<URI>();
        User user = this.getUser(userUri);
        if (user != null) {
            while (entryIterator.hasNext()) {
                Group nextGroup;
                URI nextURI = entryIterator.next();
                Entry nextEntry = this.getByEntryURI(nextURI);
                if (!GraphType.Group.equals((Object)nextEntry.getGraphType()) || (nextGroup = (Group)nextEntry.getResource()) == null || !nextGroup.isMember(user)) continue;
                groupUris.add(nextGroup.getURI());
            }
        }
        return groupUris;
    }

    public List<URI> getGroupEntryUris() {
        Iterator<URI> entryIterator = this.getEntries().iterator();
        ArrayList<URI> groupUris = new ArrayList<URI>();
        while (entryIterator.hasNext()) {
            URI nextURI = entryIterator.next();
            Entry e = this.getByEntryURI(nextURI);
            if (e.getGraphType() != GraphType.Group) continue;
            groupUris.add(nextURI);
        }
        return groupUris;
    }

    public void setAuthenticatedUserURI(URI userUri) {
        authenticatedUserURI.set(userUri);
    }

    public URI getAuthenticatedUserURI() {
        return authenticatedUserURI.get();
    }

    public boolean currentUserIsGuest() {
        URI currentUserUri = authenticatedUserURI.get();
        return currentUserUri == null || this.getGuestUser().getURI().equals(currentUserUri);
    }

    public boolean currentUserIsAdminOrAdminGroup() {
        URI currentUserUri = authenticatedUserURI.get();
        return this.isUserAdminOrAdminGroup(currentUserUri);
    }

    public void checkAuthenticatedUserAuthorized(Entry entry, PrincipalManager.AccessProperty accessProperty) throws AuthorizationException {
        if (!entry.getRepositoryManager().isCheckForAuthorization()) {
            return;
        }
        URI currentUserURI = this.getAuthenticatedUserURI();
        if (currentUserURI == null) {
            currentUserURI = this.getGuestUser().getURI();
            log.warn("Authenticated user not set, assuming guest user");
        }
        if (currentUserURI.equals(this.getAdminUser().getURI())) {
            return;
        }
        if (currentUserURI.equals(entry.getResourceURI()) && (accessProperty == PrincipalManager.AccessProperty.ReadMetadata || accessProperty == PrincipalManager.AccessProperty.ReadResource)) {
            return;
        }
        try {
            this.setAuthenticatedUserURI(this.getAdminUser().getURI());
            User currentUser = this.getUser(currentUserURI);
            if (this.getAdminGroup().isMember(currentUser)) {
                return;
            }
            Entry contextEntry = entry.getContext().getEntry();
            if (this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.Administer)) {
                return;
            }
            if (entry.hasAllowedPrincipals()) {
                if (this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.Administer) || this.hasAccess(currentUser, entry, accessProperty)) {
                    return;
                }
                if (accessProperty == PrincipalManager.AccessProperty.ReadMetadata && this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.WriteMetadata)) {
                    return;
                }
                if (accessProperty == PrincipalManager.AccessProperty.ReadResource && this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.WriteResource)) {
                    return;
                }
            } else if (accessProperty == PrincipalManager.AccessProperty.ReadMetadata || accessProperty == PrincipalManager.AccessProperty.ReadResource ? this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.ReadResource) || this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.WriteResource) : this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.WriteResource)) {
                return;
            }
            throw new AuthorizationException(currentUser, entry, accessProperty);
        }
        finally {
            this.setAuthenticatedUserURI(currentUserURI);
        }
    }

    protected boolean hasAccess(User currentUser, Entry entry, PrincipalManager.AccessProperty prop) {
        Set<URI> groups;
        Set principals = entry.getAllowedPrincipalsFor(prop);
        if (!principals.isEmpty()) {
            if (principals.contains(this.getGuestUser().getURI())) {
                return true;
            }
            if (currentUser != this.getGuestUser() && principals.contains(this.getUserGroup().getURI())) {
                return true;
            }
            if (principals.contains(currentUser.getURI())) {
                return true;
            }
            groups = this.getGroupUris(currentUser.getURI());
            groups.retainAll(principals);
            if (!groups.isEmpty()) {
                return true;
            }
        }
        if (prop != PrincipalManager.AccessProperty.Administer && !(principals = entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer)).isEmpty()) {
            if (principals.contains(currentUser.getURI())) {
                return true;
            }
            groups = this.getGroupUris(currentUser.getURI());
            groups.retainAll(principals);
            return !groups.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrincipalManager.AccessProperty> getRights(Entry entry) {
        HashSet<PrincipalManager.AccessProperty> set = new HashSet<PrincipalManager.AccessProperty>();
        if (!entry.getRepositoryManager().isCheckForAuthorization()) {
            set.add(PrincipalManager.AccessProperty.Administer);
            return set;
        }
        URI currentUserURI = this.getAuthenticatedUserURI();
        if (currentUserURI == null) {
            log.error("Authenticated user not set, should at least be guest");
            throw new AuthorizationException(null, entry, null);
        }
        if (currentUserURI.equals(this.getAdminUser().getURI())) {
            set.add(PrincipalManager.AccessProperty.Administer);
            return set;
        }
        try {
            this.setAuthenticatedUserURI(this.getAdminUser().getURI());
            User currentUser = this.getUser(currentUserURI);
            if (this.getAdminGroup().isMember(currentUser)) {
                set.add(PrincipalManager.AccessProperty.Administer);
                HashSet<PrincipalManager.AccessProperty> hashSet = set;
                return hashSet;
            }
            Entry contextEntry = entry.getContext().getEntry();
            if (this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.Administer)) {
                set.add(PrincipalManager.AccessProperty.Administer);
            } else if (entry.hasAllowedPrincipals()) {
                if (this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.Administer)) {
                    set.add(PrincipalManager.AccessProperty.Administer);
                    HashSet<PrincipalManager.AccessProperty> hashSet = set;
                    return hashSet;
                }
                if (this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.WriteMetadata)) {
                    set.add(PrincipalManager.AccessProperty.WriteMetadata);
                } else if (this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.ReadMetadata)) {
                    set.add(PrincipalManager.AccessProperty.ReadMetadata);
                }
                if (this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.WriteResource)) {
                    set.add(PrincipalManager.AccessProperty.WriteResource);
                } else if (this.hasAccess(currentUser, entry, PrincipalManager.AccessProperty.ReadResource)) {
                    set.add(PrincipalManager.AccessProperty.ReadResource);
                }
            } else if (this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.WriteResource)) {
                set.add(PrincipalManager.AccessProperty.Administer);
            } else if (this.hasAccess(currentUser, contextEntry, PrincipalManager.AccessProperty.ReadResource)) {
                set.add(PrincipalManager.AccessProperty.ReadMetadata);
                set.add(PrincipalManager.AccessProperty.ReadResource);
            }
        }
        finally {
            this.setAuthenticatedUserURI(currentUserURI);
        }
        return set;
    }

    public boolean isValidSecret(String secret) {
        return Password.conformsToRules(secret);
    }

    @Override
    public void initResource(EntryImpl newEntry) throws RepositoryException {
        if (newEntry.getEntryType() != EntryType.Local) {
            return;
        }
        switch (newEntry.getGraphType()) {
            case User: {
                newEntry.setResource(new UserImpl(newEntry, newEntry.getSesameResourceURI(), this.softCache));
                break;
            }
            case Group: {
                newEntry.setResource(new GroupImpl(newEntry, newEntry.getSesameResourceURI(), this.softCache));
                break;
            }
            default: {
                super.initResource(newEntry);
            }
        }
    }

    @Override
    public void initializeSystemEntries() {
        super.initializeSystemEntries();
        Entry guestUserEntry = this.get("_guest");
        if (guestUserEntry != null) {
            this.guestUser = (User)guestUserEntry.getResource();
        } else {
            guestUserEntry = this.createNewMinimalItem(null, null, EntryType.Local, GraphType.User, null, "_guest");
            this.setMetadata(guestUserEntry, "Guest user", "All non logged in users will automatically appear as this user.");
            this.guestUser = (User)guestUserEntry.getResource();
            this.guestUser.setName("guest");
            guestUserEntry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, this.guestUser.getURI());
            log.info("Successfully added the guest user");
        }
        this.addSystemEntryToSystemEntries(guestUserEntry.getEntryURI());
        Entry adminUserEntry = this.get("_admin");
        if (adminUserEntry != null) {
            this.adminUser = (User)adminUserEntry.getResource();
        } else {
            adminUserEntry = this.createNewMinimalItem(null, null, EntryType.Local, GraphType.User, null, "_admin");
            this.setMetadata(adminUserEntry, "Admin user", "Default super user, has all rights.");
            this.adminUser = (User)adminUserEntry.getResource();
            this.adminUser.setName("admin");
            String adminSecret = System.getenv(ENV_ADMIN_PASSWORD);
            if (adminSecret != null) {
                log.info("Setting admin password based on environment variable {}", (Object)ENV_ADMIN_PASSWORD);
                if (!this.adminUser.setSecret(adminSecret)) {
                    log.warn("Password in environment variable does not conform to configured rules, initializing admin user without password");
                }
            } else {
                log.warn("Environment variable {} not found, initializing admin user without password", (Object)ENV_ADMIN_PASSWORD);
            }
            adminUserEntry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, this.guestUser.getURI());
            log.info("Successfully added the admin user");
        }
        this.addSystemEntryToSystemEntries(adminUserEntry.getEntryURI());
        Entry adminGroupEntry = this.get("_admins");
        if (adminGroupEntry != null) {
            this.adminGroup = (Group)adminGroupEntry.getResource();
        } else {
            adminGroupEntry = this.createNewMinimalItem(null, null, EntryType.Local, GraphType.Group, null, "_admins");
            this.setMetadata(adminGroupEntry, "Admin group", "All members of this group have super user rights.");
            this.adminGroup = (Group)adminGroupEntry.getResource();
            this.adminGroup.setName("admins");
            adminGroupEntry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, this.guestUser.getURI());
            log.info("Successfully added the admin group");
        }
        this.addSystemEntryToSystemEntries(adminGroupEntry.getEntryURI());
        Entry userGroupEntry = this.get("_users");
        if (userGroupEntry == null) {
            userGroupEntry = this.createNewMinimalItem(null, null, EntryType.Local, GraphType.Group, null, "_users");
            this.setMetadata(userGroupEntry, "Users group", "All regular users are part of this group.");
            this.setPrincipalName(userGroupEntry.getResourceURI(), "users");
            userGroupEntry.addAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata, this.guestUser.getURI());
            log.info("Successfully added the user group");
        }
        EntryImpl e = (EntryImpl)userGroupEntry;
        e.setResource(new SystemGroup(e, e.getSesameResourceURI()){

            @Override
            public boolean isMember(User user) {
                return user != null && PrincipalManagerImpl.this.guestUser != null && !user.getURI().equals(PrincipalManagerImpl.this.guestUser.getURI());
            }

            @Override
            public List<User> members() {
                this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
                return PrincipalManagerImpl.this.getUsers();
            }

            @Override
            public List<URI> memberUris() {
                this.entry.getRepositoryManager().getPrincipalManager().checkAuthenticatedUserAuthorized((Entry)this.entry, PrincipalManager.AccessProperty.ReadResource);
                return PrincipalManagerImpl.this.getUsersAsUris();
            }
        });
        this.userGroup = (Group)userGroupEntry.getResource();
        this.addSystemEntryToSystemEntries(userGroupEntry.getEntryURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByExternalID(String externalID) {
        RepositoryConnection rc = null;
        Resource userResourceURI = null;
        try {
            rc = this.entry.getRepository().getConnection();
            ValueFactory vf = rc.getValueFactory();
            RepositoryResult rr = rc.getStatements(null, RepositoryProperties.externalID, (Value)vf.createIRI("mailto:", externalID), false, new Resource[0]);
            if (rr.hasNext()) {
                userResourceURI = ((Statement)rr.next()).getSubject();
            }
            rr.close();
        }
        catch (RepositoryException re) {
            log.error(re.getMessage(), (Throwable)re);
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException repositoryException) {}
            }
        }
        if (userResourceURI == null) {
            return null;
        }
        return this.getUser(URI.create(userResourceURI.stringValue()));
    }

    @Generated
    public User getAdminUser() {
        return this.adminUser;
    }

    @Generated
    public Group getAdminGroup() {
        return this.adminGroup;
    }

    @Generated
    public User getGuestUser() {
        return this.guestUser;
    }

    @Generated
    public Group getUserGroup() {
        return this.userGroup;
    }
}

