/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.entrystore.Entry;

public class SoftCache {
    private final HashMap<URI, SoftReference<Entry>> cache = new HashMap();
    HashMap<URI, Object> uri2entryURIs = new HashMap();
    Thread remover;
    ReferenceQueue<Entry> clearedRefs;
    Log log = LogFactory.getLog(SoftCache.class);
    private boolean shutdown = false;

    public SoftCache() {
        this.clearedRefs = new ReferenceQueue();
        this.remover = new Remover(this.clearedRefs, this);
        this.remover.start();
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<URI, SoftReference<Entry>> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.clear();
            this.uri2entryURIs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Entry entry) {
        HashMap<URI, SoftReference<Entry>> hashMap = this.cache;
        synchronized (hashMap) {
            URI entryURI = entry.getEntryURI();
            this.cache.put(entryURI, new SoftReference<Entry>(entry, this.clearedRefs));
            this.push(entry.getLocalMetadataURI(), entryURI);
            this.push(entry.getExternalMetadataURI(), entryURI);
            this.push(entry.getResourceURI(), entryURI);
            this.push(entry.getRelationURI(), entryURI);
        }
    }

    private void push(URI from, URI to) {
        if (from == null || to == null) {
            return;
        }
        Object existingTo = this.uri2entryURIs.get(from);
        if (existingTo == null) {
            this.uri2entryURIs.put(from, to);
        } else if (existingTo instanceof Set) {
            ((Set)existingTo).add(to);
        } else {
            HashSet<URI> set = new HashSet<URI>();
            set.add((URI)existingTo);
            set.add(to);
            this.uri2entryURIs.put(from, set);
        }
    }

    private void pop(URI from, URI to) {
        if (from == null || to == null) {
            return;
        }
        Object existingTo = this.uri2entryURIs.get(from);
        if (existingTo != null) {
            if (existingTo instanceof Set) {
                ((Set)existingTo).remove(to);
                if (((Set)existingTo).isEmpty()) {
                    this.uri2entryURIs.remove(from);
                }
            } else if (existingTo.equals(to)) {
                this.uri2entryURIs.remove(from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Entry entry) {
        if (entry == null) {
            return;
        }
        HashMap<URI, SoftReference<Entry>> hashMap = this.cache;
        synchronized (hashMap) {
            URI entryURI = entry.getEntryURI();
            this.cache.remove(entryURI);
            this.pop(entry.getLocalMetadataURI(), entryURI);
            this.pop(entry.getExternalMetadataURI(), entryURI);
            this.pop(entry.getResourceURI(), entryURI);
            this.pop(entry.getRelationURI(), entryURI);
        }
    }

    public Entry getByEntryURI(URI uri) {
        SoftReference<Entry> sr = this.cache.get(uri);
        if (sr != null) {
            return sr.get();
        }
        return null;
    }

    public Set<Entry> getByURI(URI uri) {
        if (this.uri2entryURIs.containsKey(uri)) {
            HashSet<Entry> entries = new HashSet<Entry>();
            Object entryUris = this.uri2entryURIs.get(uri);
            if (entryUris instanceof Set) {
                for (URI entryURI : (Set)entryUris) {
                    entries.add(this.getByEntryURI(entryURI));
                }
            } else {
                entries.add(this.getByEntryURI((URI)entryUris));
            }
            return entries;
        }
        return null;
    }

    public void shutdown() {
        if (this.remover == null || this.shutdown && this.remover.isInterrupted()) {
            return;
        }
        this.log.info((Object)"Shutting down SoftCache");
        this.setShutdown(true);
        this.remover.interrupt();
    }

    @Generated
    public HashMap<URI, SoftReference<Entry>> getCache() {
        return this.cache;
    }

    @Generated
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Generated
    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    private class Remover
    extends Thread {
        ReferenceQueue<Entry> refQ;
        SoftCache cache;

        public Remover(ReferenceQueue<Entry> rq, SoftCache cache) {
            this.refQ = rq;
            this.cache = cache;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!SoftCache.this.shutdown) {
                    Reference<Entry> ref = this.refQ.remove();
                    this.cache.remove(ref.get());
                }
            }
            catch (InterruptedException e) {
                SoftCache.this.log.info((Object)"SoftCache remover got interrupted, shutting down");
            }
        }
    }
}

