/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl.converters;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterUtil {
    private static final Logger log = LoggerFactory.getLogger(ConverterUtil.class);

    public static URL findResource(String resource) {
        URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (resourceURL == null) {
            String[] pathElements;
            String classPath = System.getProperty("java.class.path");
            for (String element : pathElements = classPath.split(File.pathSeparator)) {
                File newFile = new File(element, resource);
                if (!newFile.exists()) continue;
                try {
                    resourceURL = newFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return resourceURL;
    }
}

