/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl.converters;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.ResourceType;
import org.entrystore.impl.ContextImpl;
import org.entrystore.impl.RDFResource;
import org.entrystore.repository.util.NS;
import org.entrystore.repository.util.URISplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph2Entries {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    private static final IRI mergeResourceId = valueFactory.createIRI(NS.entrystore, "mergeResourceId");
    private static final IRI referenceResourceId = valueFactory.createIRI(NS.entrystore, "referenceResourceId");
    private static final Logger log = LoggerFactory.getLogger(Graph2Entries.class);
    private final Context context;

    public Graph2Entries(Context context) {
        this.context = context;
    }

    public Set<Entry> merge(Model graph, String destinationEntryId, URI destinationListURI) {
        String entryId;
        if (graph == null) {
            log.info("Supplied null instead of a graph.");
            return null;
        }
        log.info("About to update/create entries in context {}.", (Object)this.context.getEntry().getId());
        HashSet<Entry> entries = new HashSet<Entry>();
        HashMap<String, IRI> newResources = new HashMap<String, IRI>();
        HashMap<String, Resource> oldResources = new HashMap<String, Resource>();
        HashMap<Value, Resource> translate = new HashMap<Value, Resource>();
        for (Statement statement : graph.filter(null, referenceResourceId, null, new Resource[0])) {
            entryId = statement.getObject().stringValue();
            Resource newResource = (Resource)newResources.get(entryId);
            if (newResource == null) {
                URI uri = URISplit.createURI(this.context.getEntry().getRepositoryManager().getRepositoryURL().toString(), this.context.getEntry().getId(), "resource", entryId);
                newResource = valueFactory.createIRI(uri.toString());
            }
            translate.put((Value)statement.getSubject(), newResource);
        }
        if (destinationEntryId != null) {
            Entry entry;
            URI uri = URISplit.createURI(this.context.getEntry().getRepositoryManager().getRepositoryURL().toString(), this.context.getEntry().getId(), "resource", destinationEntryId);
            IRI newResource = valueFactory.createIRI(uri.toString());
            for (Statement statement : graph.filter(null, mergeResourceId, null, new Resource[0])) {
                translate.put((Value)statement.getSubject(), (Resource)newResource);
            }
            boolean entryCreated = false;
            if (destinationEntryId.isEmpty()) {
                entry = this.context.createResource(null, GraphType.Graph, ResourceType.InformationResource, destinationListURI);
                entryCreated = true;
                ((ContextImpl)this.context).setMetadata(entry, "RDF Graph created at " + String.valueOf(new Date()), null);
            } else {
                entry = this.context.get(destinationEntryId);
                if (entry == null) {
                    entry = this.context.createResource(destinationEntryId, GraphType.Graph, ResourceType.InformationResource, destinationListURI);
                    entryCreated = true;
                }
            }
            Model resourceGraph = this.translate(graph, translate);
            ((RDFResource)entry.getResource()).setGraph(resourceGraph);
            Model subGraph = this.extract(resourceGraph, (Resource)newResource, new HashSet<Resource>(), new HashMap<Value, Resource>());
            if (!subGraph.isEmpty()) {
                entry.getLocalMetadata().setGraph(subGraph);
            } else if (entryCreated) {
                ((ContextImpl)this.context).setMetadata(entry, "RDF Graph created at " + String.valueOf(new Date()), null);
            }
            entries.add(entry);
            return entries;
        }
        for (Statement statement : graph.filter(null, mergeResourceId, null, new Resource[0])) {
            entryId = statement.getObject().stringValue();
            URI uri = URISplit.createURI(this.context.getEntry().getRepositoryManager().getRepositoryURL().toString(), this.context.getEntry().getId(), "resource", entryId);
            IRI newRe = valueFactory.createIRI(uri.toString());
            newResources.put(entryId, newRe);
            oldResources.put(entryId, statement.getSubject());
            translate.put((Value)statement.getSubject(), (Resource)newRe);
        }
        log.info("Found {} resources that will be updated/created.", (Object)oldResources.size());
        int newResCounter = 0;
        int updResCounter = 0;
        Collection<Resource> ignore = newResources.values();
        for (String entryId2 : newResources.keySet()) {
            Model subGraph = this.extract(graph, (Resource)oldResources.get(entryId2), ignore, translate);
            Entry entry = this.context.get(entryId2);
            if (entry == null) {
                entry = this.context.createResource(entryId2, GraphType.None, ResourceType.NamedResource, null);
                ++newResCounter;
            } else {
                ++updResCounter;
            }
            entry.getLocalMetadata().setGraph(subGraph);
            entries.add(entry);
        }
        log.info("Updated {} existing entries and created {} new entries.", (Object)updResCounter, (Object)newResCounter);
        log.info("Finished updating/creating entries in context {}.", (Object)this.context.getEntry().getId());
        return entries;
    }

    private boolean checkPredicate(IRI predicate) {
        return !mergeResourceId.equals((Object)predicate) && !referenceResourceId.equals((Object)predicate);
    }

    private void populateModel(Model model, Statement statement, Map<Value, Resource> translate) {
        Resource subject = statement.getSubject();
        IRI predicate = statement.getPredicate();
        Value object = statement.getObject();
        if (translate.get(subject) != null) {
            subject = translate.get(subject);
        }
        if (translate.get(object) != null) {
            object = (Value)translate.get(object);
        }
        model.add(subject, predicate, object, new Resource[0]);
    }

    private Model translate(Model from, Map<Value, Resource> translate) {
        LinkedHashModel to = new LinkedHashModel();
        for (Statement statement : from) {
            if (!this.checkPredicate(statement.getPredicate())) continue;
            this.populateModel((Model)to, statement, translate);
        }
        return to;
    }

    private Model extract(Model from, Resource subject, Collection<Resource> ignore, Map<Value, Resource> translate) {
        LinkedHashModel to = new LinkedHashModel();
        HashSet<Resource> collected = new HashSet<Resource>(ignore);
        this._extract(from, (Model)to, subject, collected, translate);
        return to;
    }

    private void _extract(Model from, Model to, Resource resource, Set<Resource> collected, Map<Value, Resource> translate) {
        for (Statement statement : from.filter(resource, null, null, new Resource[0])) {
            Value object = statement.getObject();
            if (object instanceof BNode && !collected.contains((Resource)object)) {
                collected.add((Resource)((BNode)object));
                this._extract(from, to, (Resource)((BNode)object), collected, translate);
            }
            if (!this.checkPredicate(statement.getPredicate())) continue;
            this.populateModel(to, statement, translate);
        }
    }
}

