/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.impl.converters;

import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.Values;
import org.entrystore.Converter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAI_DC2RDFGraphConverter
implements Converter {
    private static final Log log = LogFactory.getLog(OAI_DC2RDFGraphConverter.class);
    static Map<String, Locale> localeMap;

    public Model convertToModel(Node from, URI resourceURI) {
        if (from == null || from.getChildNodes().getLength() <= 0) {
            log.warn((Object)"Unable to convert Node to Model graph, as the Node is null or has empty childNodes");
            return null;
        }
        NodeList metadataList = from.getChildNodes();
        LinkedHashModel model = new LinkedHashModel();
        IRI root = Values.iri((String)resourceURI.toString());
        for (int i = 0; i < metadataList.getLength(); ++i) {
            Node langNode;
            Object predicate;
            Node n = metadataList.item(i);
            if (n == null || "#text".equals(n.getNodeName())) continue;
            String nodeNS = n.getNamespaceURI();
            String nodeName = n.getNodeName();
            if (nodeName.contains(":") && nodeNS != null) {
                nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
                predicate = nodeNS + nodeName;
            } else {
                predicate = nodeName;
            }
            String nodeContent = n.getTextContent();
            if (nodeContent == null) continue;
            nodeContent = nodeContent.trim();
            if ("language".equalsIgnoreCase(nodeName) && nodeContent.length() == 3 && (nodeContent = this.getISO2Language(nodeContent)) == null) continue;
            NamedNodeMap nodeAttributes = n.getAttributes();
            String lang = null;
            if (nodeAttributes != null && (langNode = nodeAttributes.getNamedItem("xml:lang")) != null && (lang = langNode.getNodeValue()) != null && (lang = lang.trim()).length() == 3) {
                lang = this.getISO2Language(lang.toLowerCase());
            }
            Literal lit = lang != null ? Values.literal((String)nodeContent, lang) : Values.literal((String)nodeContent);
            model.add((Resource)root, Values.iri((String)predicate), (Value)lit, new Resource[0]);
        }
        return model;
    }

    private String getISO2Language(String iso3Language) {
        Locale locale;
        if (localeMap == null) {
            String[] languages = Locale.getISOLanguages();
            localeMap = new HashMap<String, Locale>(languages.length);
            for (String language : languages) {
                Locale locale2 = new Locale.Builder().setLanguage(language).build();
                localeMap.put(locale2.getISO3Language(), locale2);
            }
        }
        if ((locale = localeMap.get(iso3Language)) != null) {
            return locale.getLanguage();
        }
        return null;
    }

    static {
        String[] languages = Locale.getISOLanguages();
        localeMap = new HashMap<String, Locale>(languages.length);
        for (String language : languages) {
            Locale locale = new Locale.Builder().setLanguage(language).build();
            localeMap.put(locale.getISO3Language(), locale);
        }
    }
}

