/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.backup;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.backup.BackupJob;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.MetadataUtil;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupScheduler {
    private static final Logger log = LoggerFactory.getLogger(BackupScheduler.class);
    Scheduler scheduler;
    JobDetail job;
    RepositoryManager rm;
    boolean gzip;
    String cronExpression;
    boolean maintenance;
    int upperLimit;
    int lowerLimit;
    int expiresAfterDays;
    boolean simple;
    boolean deleteAfter;
    boolean includeFiles;
    RDFFormat format;
    public static BackupScheduler instance;

    private BackupScheduler(RepositoryManager rm, String cronExp, boolean gzip, boolean deleteAfter, boolean includeFiles, boolean maintenance, int upperLimit, int lowerLimit, int expiresAfterDays, RDFFormat format) {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        this.rm = rm;
        this.gzip = gzip;
        this.deleteAfter = deleteAfter;
        this.cronExpression = cronExp;
        this.includeFiles = includeFiles;
        this.maintenance = maintenance;
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
        this.expiresAfterDays = expiresAfterDays;
        this.format = format;
        if (upperLimit < 2 && lowerLimit < 2 && expiresAfterDays < 2) {
            log.info("Switching to simple backup strategy with one folder without date and time in name");
            this.simple = true;
            this.maintenance = false;
        }
        log.info("Created backup scheduler");
    }

    public static synchronized BackupScheduler getInstance(RepositoryManager rm) {
        if (instance == null) {
            log.info("Loading backup configuration");
            Config config = rm.getConfiguration();
            String cronExp = config.getString(Settings.BACKUP_CRONEXP, config.getString(Settings.BACKUP_TIMEREGEXP_DEPRECATED));
            if (cronExp == null) {
                return null;
            }
            boolean gzip = config.getBoolean(Settings.BACKUP_GZIP, false);
            boolean maintenance = config.getBoolean(Settings.BACKUP_MAINTENANCE, false);
            boolean deleteAfter = config.getBoolean(Settings.BACKUP_DELETE_AFTER, false);
            boolean includeFiles = config.getBoolean(Settings.BACKUP_INCLUDE_FILES, true);
            int upperLimit = config.getInt(Settings.BACKUP_MAINTENANCE_UPPER_LIMIT, -1);
            int lowerLimit = config.getInt(Settings.BACKUP_MAINTENANCE_LOWER_LIMIT, -1);
            int expiresAfterDays = config.getInt(Settings.BACKUP_MAINTENANCE_EXPIRES_AFTER_DAYS, -1);
            RDFFormat format = MetadataUtil.getRDFFormat(config.getString(Settings.BACKUP_FORMAT, RDFFormat.TRIX.getName()));
            if (format == null) {
                log.warn("Invalid backup format {}, falling back to TriX", (Object)config.getString(Settings.BACKUP_FORMAT));
                format = RDFFormat.TRIX;
            }
            if (cronExp.toLowerCase().contains("rnd")) {
                cronExp = BackupScheduler.randomizeCronString(cronExp);
            }
            log.info("Cron expression: {}", (Object)cronExp);
            log.info("GZIP: {}", (Object)gzip);
            log.info("Include files: {}", (Object)includeFiles);
            log.info("Delete previous backup after new backup: {}", (Object)deleteAfter);
            log.info("Maintenance: {}", (Object)maintenance);
            log.info("Maintenance upper limit: {}", (Object)upperLimit);
            log.info("Maintenance lower limit: {}", (Object)lowerLimit);
            log.info("Maintenance expires after days: {}", (Object)expiresAfterDays);
            instance = new BackupScheduler(rm, cronExp, gzip, deleteAfter, includeFiles, maintenance, upperLimit, lowerLimit, expiresAfterDays, format);
        }
        return instance;
    }

    private static String randomizeCronString(String cronExp) {
        String[] parts = cronExp.split("\\s+");
        if (parts.length < 6) {
            log.warn("Cron expression seems to be incorrect and cannot be parsed correctly: {}", (Object)cronExp);
            return cronExp;
        }
        LinkedList<String> result = new LinkedList<String>();
        Pattern pattern = Pattern.compile("rnd\\(([\\*0-9]+)[\\-]?([0-9]*)\\)", 2);
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            Matcher matcher = pattern.matcher(p);
            if (!matcher.matches()) {
                result.add(p);
                continue;
            }
            String first = matcher.group(1);
            String second = matcher.group(2);
            if ("*".equals(first)) {
                if (i == 0 || i == 1) {
                    OptionalInt findFirst = ThreadLocalRandom.current().ints(0, 60).limit(1L).findFirst();
                    if (!findFirst.isPresent()) continue;
                    result.add(Integer.toString(findFirst.getAsInt()));
                    continue;
                }
                if (i == 2) {
                    OptionalInt findFirst = ThreadLocalRandom.current().ints(0, 24).limit(1L).findFirst();
                    if (!findFirst.isPresent()) continue;
                    result.add(Integer.toString(findFirst.getAsInt()));
                    continue;
                }
                result.add(first);
                continue;
            }
            if (BackupScheduler.isInt(first) && BackupScheduler.isInt(second)) {
                OptionalInt findFirst;
                int i1 = Integer.parseInt(first);
                int i2 = Integer.parseInt(second);
                if (i == 0 || i == 1) {
                    findFirst = ThreadLocalRandom.current().ints(i1, i2 + 1).limit(1L).findFirst();
                    if (!findFirst.isPresent()) continue;
                    result.add(Integer.toString(findFirst.getAsInt()));
                    continue;
                }
                if (i == 2) {
                    findFirst = ThreadLocalRandom.current().ints(i1, i2 + 1).limit(1L).findFirst();
                    if (!findFirst.isPresent()) continue;
                    result.add(Integer.toString(findFirst.getAsInt()));
                    continue;
                }
                result.add(first);
                continue;
            }
            result.add(p);
        }
        return String.join((CharSequence)" ", result);
    }

    private static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public void run() {
        if (!this.rm.getConfiguration().getBoolean(Settings.BACKUP_SCHEDULER, false)) {
            log.warn("Backup is disabled in configuration");
            return;
        }
        try {
            String[] names = this.scheduler.getJobNames("backupGroup");
            int index = 1;
            if (names.length > 0) {
                index = Integer.parseInt(names[names.length - 1]);
                ++index;
            }
            String jobIndex = String.valueOf(index);
            this.job = new JobDetail(jobIndex, "backupGroup", BackupJob.class);
            this.job.getJobDataMap().put((Object)"rm", (Object)this.rm);
            this.job.getJobDataMap().put("gzip", this.gzip);
            this.job.getJobDataMap().put("includeFiles", this.includeFiles);
            this.job.getJobDataMap().put("deleteAfter", this.deleteAfter);
            this.job.getJobDataMap().put("maintenance", this.maintenance);
            this.job.getJobDataMap().put("upperLimit", this.upperLimit);
            this.job.getJobDataMap().put("lowerLimit", this.lowerLimit);
            this.job.getJobDataMap().put("expiresAfterDays", this.expiresAfterDays);
            this.job.getJobDataMap().put((Object)"format", (Object)this.format);
            this.job.getJobDataMap().put("simple", this.simple);
            CronTrigger trigger = new CronTrigger("trigger" + jobIndex, "backupGroup", jobIndex, "backupGroup", this.cronExpression);
            this.scheduler.addJob(this.job, true);
            this.scheduler.scheduleJob((Trigger)trigger);
            this.scheduler.start();
        }
        catch (ParseException | SchedulerException e) {
            log.error(e.getMessage());
        }
    }

    public boolean delete() {
        try {
            if (this.job != null) {
                log.info("Deleting backup job");
                this.scheduler.deleteJob(this.job.getName(), this.job.getGroup());
                this.job = null;
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
        return true;
    }

    @Generated
    public String getCronExpression() {
        return this.cronExpression;
    }
}

