/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.transformation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.n3.N3ParserFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.entrystore.Context;
import org.entrystore.Data;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.List;
import org.entrystore.QuotaException;
import org.entrystore.ResourceType;
import org.entrystore.impl.EntryImpl;
import org.entrystore.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCAM2Import {
    static Logger log = LoggerFactory.getLogger(SCAM2Import.class);
    private Context context;
    private File backup;
    private SailRepository repository;
    private Map<IRI, Entry> uri2Entry = new HashMap<IRI, Entry>();
    private File files;
    public static final IRI manifest;
    public static final IRI organizations;
    public static final IRI firstChild;
    public static final IRI KMRcollection;
    public static final IRI KMRURL;
    public static final IRI KMRFile;
    public static final IRI KMRDisplayName;
    public static final IRI KMRrecord;
    public static final IRI IMScontent;
    public static final IRI IMSItem;
    public static final IRI LOMTlocation;
    public static final IRI DCTitle;
    public static final IRI DCDescription;
    public static final IRI DCTTitle;
    public static final IRI DCTDescription;
    public static final IRI RDF_1;
    public static final String NSbase = "http://www.imsproject.org/xsd/ims_cp_rootv1p1#";
    public static final String KMRbase = "http://kmr.nada.kth.se/scam";
    public static final String IMSbase = "http://www.imsproject.org/xsd/ims_cp_rootv1p1#";
    public static final String LOMTechnicalbase = "http://ltsc.ieee.org/2002/09/lom-technical#";
    public static final String DCbase = "http://purl.org/dc/elements/1.1/";
    public static final String DCTermsbase = "http://purl.org/dc/terms/";

    public SCAM2Import(Context importToContext, String pathToScam2BackupDir) {
        this.context = importToContext;
        this.backup = new File(pathToScam2BackupDir);
        this.files = new File(this.backup, "files");
        this.repository = new SailRepository((Sail)new MemoryStore());
    }

    public void doImport() {
        RDFParser parser = new N3ParserFactory().getParser();
        parser.getParserConfig().set((RioSetting)BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        StatementCollector collector = new StatementCollector();
        parser.setRDFHandler((RDFHandler)collector);
        try {
            InputStream fileOut = Files.newInputStream(new File(this.backup, "manifest.n3").toPath(), new OpenOption[0]);
            parser.parse(fileOut, "");
            fileOut.close();
            LinkedHashModel graph = new LinkedHashModel(collector.getStatements());
            Resource manifestRes = ((Statement)graph.filter(null, RDF.TYPE, (Value)manifest, new Resource[0]).iterator().next()).getSubject();
            Resource organizationsRes = (Resource)((Statement)graph.filter(manifestRes, organizations, null, new Resource[0]).iterator().next()).getObject();
            IRI first = this.getFirstChild((Model)graph, organizationsRes);
            this.recurse((Model)graph, null, first);
            Entry top = this.context.get("_top");
            Entry firstEntry = this.uri2Entry.get(first);
            ((List)top.getResource()).addChild(firstEntry.getEntryURI());
            this.recurseFix((Model)graph, first, (List)firstEntry.getResource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void recurseFix(Model graph, IRI folder, List list) {
        for (IRI child : this.getChildren(graph, (Resource)folder)) {
            Entry entryChild = this.uri2Entry.get(child);
            if (entryChild != null) {
                try {
                    list.addChild(entryChild.getEntryURI());
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                if (entryChild.getGraphType() != GraphType.List) continue;
                this.recurseFix(graph, child, (List)entryChild.getResource());
                continue;
            }
            IRI refChild = this.getContent(graph, child);
            Entry refEntryChild = this.uri2Entry.get(refChild);
            if (refEntryChild == null) continue;
            try {
                list.addChild(refEntryChild.getEntryURI());
            }
            catch (RepositoryException repositoryException) {}
        }
    }

    void recurse(Model graph, IRI parent, IRI folder) {
        this.handleFolder(graph, parent, folder);
        for (IRI child : this.getChildren(graph, (Resource)folder)) {
            if (this.isFolder(graph, (Resource)child)) {
                this.recurse(graph, folder, child);
                continue;
            }
            IRI refChild = this.getContent(graph, child);
            if (this.isItem(graph, (Resource)refChild) || this.uri2Entry.containsKey(refChild)) continue;
            this.handleLeaf(graph, folder, refChild);
        }
    }

    void populateFolder(Model graph, IRI parent, IRI folder) {
    }

    void handleFolder(Model graph, IRI parent, IRI folder) {
        Model closure = this.getAnonymousClosure(graph, folder);
        URI parentList = parent == null ? null : this.uri2Entry.get(parent).getResourceURI();
        Entry folderEntry = this.context.createResource(null, GraphType.List, ResourceType.InformationResource, parentList);
        this.handleItem((EntryImpl)folderEntry, closure, parent, folder);
    }

    void handleLeaf(Model graph, IRI parent, IRI leaf) {
        log.warn("Working with \"" + leaf.stringValue() + "\"");
        Model closure = this.getAnonymousClosure(graph, leaf);
        URI parentList = parent == null ? null : this.uri2Entry.get(parent).getResourceURI();
        Entry leafEntry = null;
        if (this.isURL(closure, (Resource)leaf)) {
            leafEntry = this.context.createLink(null, URI.create(leaf.stringValue()), parentList);
        } else if (this.isFile(closure, (Resource)leaf)) {
            leafEntry = this.context.createResource(null, GraphType.None, ResourceType.InformationResource, parentList);
            this.setFile((Data)leafEntry.getResource(), closure, leaf);
        } else {
            log.warn("Entry, \"" + leaf.stringValue() + "\", is neither URL or uploaded file.");
        }
        if (leafEntry != null) {
            this.handleItem((EntryImpl)leafEntry, closure, parent, leaf);
        }
    }

    void handleItem(EntryImpl entry, Model closure, IRI parent, IRI item) {
        this.uri2Entry.put(item, entry);
        LinkedHashModel metadata = new LinkedHashModel();
        for (Statement statement : closure) {
            IRI s = entry.getSesameResourceURI();
            Resource subject = statement.getSubject();
            IRI predicate = statement.getPredicate();
            String object = statement.getObject().stringValue();
            if (object.startsWith("urn:x-")) continue;
            if (predicate.equals((Object)RDF.TYPE)) {
                if (object.startsWith(KMRbase) || object.startsWith("http://www.imsproject.org/xsd/ims_cp_rootv1p1#")) continue;
                metadata.add((Resource)s, RDF.TYPE, statement.getObject(), new Resource[0]);
                continue;
            }
            if (predicate.stringValue().equals("http://purl.org/dc/elements/1.1/format")) {
                entry.setMimetype(object);
                continue;
            }
            if (predicate.stringValue().equals("http://purl.org/dc/terms/extent")) {
                entry.setFileSize(Long.parseLong(object));
                continue;
            }
            if (predicate.equals((Object)LOMTlocation)) continue;
            if (predicate.equals((Object)KMRDisplayName)) {
                entry.setFilename(statement.getObject().stringValue());
                continue;
            }
            if (subject instanceof IRI) {
                if (predicate.stringValue().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#_")) continue;
                if (predicate.equals((Object)DCTitle)) {
                    metadata.add((Resource)s, DCTTitle, statement.getObject(), new Resource[0]);
                    continue;
                }
                if (predicate.equals((Object)DCDescription)) {
                    BNode bnode = Values.bnode();
                    metadata.add((Resource)s, DCTDescription, (Value)bnode, new Resource[0]);
                    metadata.add((Resource)bnode, RDF.VALUE, statement.getObject(), new Resource[0]);
                    continue;
                }
                metadata.add((Resource)s, predicate, statement.getObject(), new Resource[0]);
                continue;
            }
            metadata.add((Object)statement);
        }
        entry.getLocalMetadata().setGraph((Model)metadata);
    }

    void setFile(Data data, Model closure, IRI uri) {
        IRI loc = this.getLocation(closure, uri);
        if (loc != null) {
            String locStr = loc.stringValue();
            locStr = locStr.substring(locStr.indexOf("&uri=") + 5);
            locStr = locStr.replace(':', '_');
            locStr = locStr.replace('/', '_');
            try {
                File file = new File(this.files, locStr);
                if (file.exists()) {
                    data.setData(Files.newInputStream(file.toPath(), new OpenOption[0]));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (QuotaException qe) {
                qe.printStackTrace();
            }
        }
    }

    Model getAnonymousClosure(Model graph, IRI subject) {
        LinkedHashModel collect = new LinkedHashModel();
        this.collectAnonymousClosure(graph, (Resource)subject, (Model)collect);
        return collect;
    }

    void collectAnonymousClosure(Model graph, Resource subject, Model collect) {
        for (Statement st : graph.filter(subject, null, null, new Resource[0])) {
            Value object = st.getObject();
            if (st.getPredicate().equals((Object)KMRrecord)) continue;
            collect.add((Object)st);
            if (!(object instanceof Resource) || object instanceof IRI) continue;
            this.collectAnonymousClosure(graph, (Resource)object, collect);
        }
    }

    boolean isFolder(Model graph, Resource subject) {
        return graph.filter(subject, RDF_1, null, new Resource[0]).iterator().hasNext();
    }

    boolean isItem(Model graph, Resource subject) {
        return graph.filter(subject, RDF.TYPE, (Value)IMSItem, new Resource[0]).iterator().hasNext();
    }

    boolean isURL(Model graph, Resource subject) {
        return graph.filter(subject, RDF.TYPE, (Value)KMRURL, new Resource[0]).iterator().hasNext();
    }

    boolean isFile(Model graph, Resource subject) {
        return graph.filter(subject, RDF.TYPE, (Value)KMRFile, new Resource[0]).iterator().hasNext();
    }

    IRI getContent(Model graph, IRI item) {
        Iterator it = graph.filter((Resource)item, IMScontent, null, new Resource[0]).iterator();
        if (it.hasNext()) {
            Value obj = ((Statement)it.next()).getObject();
            if (obj instanceof IRI) {
                return (IRI)obj;
            }
            return null;
        }
        return null;
    }

    IRI getLocation(Model graph, IRI item) {
        Iterator it = graph.filter((Resource)item, LOMTlocation, null, new Resource[0]).iterator();
        if (it.hasNext()) {
            Value obj = ((Statement)it.next()).getObject();
            if (obj instanceof IRI) {
                return (IRI)obj;
            }
            return null;
        }
        return null;
    }

    IRI getFirstChild(Model graph, Resource subject) {
        Iterator it = graph.filter(subject, firstChild, null, new Resource[0]).iterator();
        if (it.hasNext()) {
            Value obj = ((Statement)it.next()).getObject();
            if (obj instanceof IRI) {
                return (IRI)obj;
            }
            return null;
        }
        return null;
    }

    java.util.List<IRI> getChildren(Model graph, Resource subject) {
        Vector<IRI> children = new Vector<IRI>();
        for (Statement st : graph.filter(subject, null, null, new Resource[0])) {
            try {
                String value = st.getPredicate().toString().substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length());
                int index = Integer.parseInt(value.substring(value.lastIndexOf("_") + 1));
                if (index > children.size()) {
                    children.setSize(index);
                }
                if (!(st.getObject() instanceof IRI)) continue;
                children.set(index - 1, (IRI)st.getObject());
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
        }
        children.trimToSize();
        return children;
    }

    static {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        manifest = vf.createIRI("http://www.imsproject.org/xsd/ims_cp_rootv1p1#Manifest");
        organizations = vf.createIRI("http://www.imsproject.org/xsd/ims_cp_rootv1p1#organizations");
        firstChild = vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_1");
        KMRcollection = vf.createIRI("http://kmr.nada.kth.se/scam/datatypes#Collection");
        KMRURL = vf.createIRI("http://kmr.nada.kth.se/scam#Url");
        KMRFile = vf.createIRI("http://kmr.nada.kth.se/scam#File");
        KMRDisplayName = vf.createIRI("http://kmr.nada.kth.se/scam#displayName");
        KMRrecord = vf.createIRI("http://kmr.nada.kth.se/scam#record");
        IMScontent = vf.createIRI("http://www.imsproject.org/xsd/ims_cp_rootv1p1#content");
        IMSItem = vf.createIRI("http://www.imsproject.org/xsd/ims_cp_rootv1p1#Item");
        LOMTlocation = vf.createIRI("http://ltsc.ieee.org/2002/09/lom-technical#location");
        DCTitle = vf.createIRI("http://purl.org/dc/elements/1.1/title");
        DCDescription = vf.createIRI("http://purl.org/dc/elements/1.1/description");
        DCTTitle = vf.createIRI("http://purl.org/dc/terms/title");
        DCTDescription = vf.createIRI("http://purl.org/dc/terms/description");
        RDF_1 = vf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_1");
    }
}

