/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.List;
import org.entrystore.Resource;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.util.NS;
import org.entrystore.repository.util.URISplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryUtil {
    static Logger log = LoggerFactory.getLogger(EntryUtil.class);
    static ValueFactory valueFactory = SimpleValueFactory.getInstance();

    public static void sortAfterModificationDate(java.util.List<Entry> entries, boolean ascending, GraphType prioritizedResourceType) {
        entries.sort((e1, e2) -> {
            int result = 0;
            if (e1 != null && e2 != null) {
                result = e1.getModifiedDate().compareTo(e2.getModifiedDate());
                if (!ascending) {
                    result *= -1;
                }
            }
            return result;
        });
        EntryUtil.prioritizeBuiltinType(entries, prioritizedResourceType, true);
    }

    public static void sortAfterCreationDate(java.util.List<Entry> entries, boolean ascending, GraphType prioritizedResourceType) {
        entries.sort((e1, e2) -> {
            int result = 0;
            if (e1 != null && e2 != null) {
                result = e1.getCreationDate().compareTo(e2.getCreationDate());
                if (!ascending) {
                    result *= -1;
                }
            }
            return result;
        });
        EntryUtil.prioritizeBuiltinType(entries, prioritizedResourceType, true);
    }

    public static void sortAfterFileSize(java.util.List<Entry> entries, boolean ascending, GraphType prioritizedResourceType) {
        entries.sort((e1, e2) -> {
            int result = 0;
            if (e1 != null && e2 != null) {
                GraphType e1BT = e1.getGraphType();
                GraphType e2BT = e2.getGraphType();
                if (GraphType.None.equals((Object)e1BT) && GraphType.None.equals((Object)e2BT)) {
                    long size2;
                    long size1 = e1.getFileSize();
                    if (size1 < (size2 = e2.getFileSize())) {
                        result = -1;
                    } else if (size1 > size2) {
                        result = 1;
                    }
                } else if (GraphType.List.equals((Object)e1BT) && GraphType.List.equals((Object)e2BT)) {
                    int size2;
                    Resource e1Res = e1.getResource();
                    Resource e2Res = e2.getResource();
                    if (e1Res == null) {
                        log.warn("No resource found for list: {}", (Object)e1.getEntryURI());
                        return 0;
                    }
                    if (e2Res == null) {
                        log.warn("No resource found for list: {}", (Object)e2.getEntryURI());
                        return 0;
                    }
                    List e1List = (List)e1Res;
                    List e2List = (List)e2Res;
                    int size1 = e1List.getChildren().size();
                    if (size1 < (size2 = e2List.getChildren().size())) {
                        result = -1;
                    } else if (size1 > size2) {
                        result = 1;
                    }
                }
                if (!ascending) {
                    result *= -1;
                }
            }
            return result;
        });
        EntryUtil.prioritizeBuiltinType(entries, prioritizedResourceType, true);
    }

    public static void sortAfterTitle(java.util.List<Entry> entries, String language, boolean ascending, GraphType prioritizedResourceType) {
        entries.sort((e1, e2) -> {
            int result = 0;
            if (e1 != null && e2 != null) {
                String title1 = EntryUtil.getTitle(e1, language);
                String title2 = EntryUtil.getTitle(e2, language);
                if (title1 != null && title2 != null) {
                    result = title1.compareToIgnoreCase(title2);
                } else if (title1 == null && title2 != null) {
                    result = 1;
                } else if (title1 != null) {
                    result = -1;
                }
                if (!ascending) {
                    result *= -1;
                }
            }
            return result;
        });
        EntryUtil.prioritizeBuiltinType(entries, prioritizedResourceType, true);
    }

    public static void prioritizeBuiltinType(java.util.List<Entry> entries, GraphType resourceType, boolean top) {
        if (entries == null || resourceType == null) {
            return;
        }
        entries.sort((e1, e2) -> {
            int result = 0;
            if (e1 != null && e2 != null) {
                GraphType e1BT = e1.getGraphType();
                GraphType e2BT = e2.getGraphType();
                if (resourceType.equals((Object)e1BT) && !resourceType.equals((Object)e2BT)) {
                    result = -1;
                } else if (!resourceType.equals((Object)e1BT) && resourceType.equals((Object)e2BT)) {
                    result = 1;
                }
                if (!top) {
                    result *= -1;
                }
            }
            return result;
        });
    }

    public static String getLabel(Model graph, URI resourceURI, Set<IRI> predicates, String language) {
        String fallback = null;
        if (graph != null && resourceURI != null) {
            IRI resURI = valueFactory.createIRI(resourceURI.toString());
            for (IRI titlePred : predicates) {
                for (Statement statement : graph.filter((org.eclipse.rdf4j.model.Resource)resURI, titlePred, null, new org.eclipse.rdf4j.model.Resource[0])) {
                    Value indirectValue;
                    Iterator indirectLables;
                    Value value = statement.getObject();
                    Literal lit = null;
                    if (value instanceof Literal) {
                        lit = (Literal)value;
                    } else if (value instanceof org.eclipse.rdf4j.model.Resource && (indirectLables = graph.filter((org.eclipse.rdf4j.model.Resource)value, RDF.VALUE, null, new org.eclipse.rdf4j.model.Resource[0]).iterator()).hasNext() && (indirectValue = ((Statement)indirectLables.next()).getObject()) instanceof Literal) {
                        lit = (Literal)indirectValue;
                    }
                    if (lit == null) continue;
                    if (language != null) {
                        if (lit.getLanguage().isPresent() && ((String)lit.getLanguage().get()).equalsIgnoreCase(language)) {
                            return lit.stringValue();
                        }
                        fallback = lit.stringValue();
                        continue;
                    }
                    return lit.stringValue();
                }
            }
        }
        return fallback;
    }

    public static String getLabel(Model graph, URI resourceURI, IRI predicate, String language) {
        HashSet<IRI> predicates = new HashSet<IRI>();
        predicates.add(predicate);
        return EntryUtil.getLabel(graph, resourceURI, predicates, language);
    }

    public static IRI getResourceAsURI(Model graph, URI resourceURI, IRI predicate) {
        if (graph != null && resourceURI != null) {
            IRI resURI = valueFactory.createIRI(resourceURI.toString());
            for (Statement statement : graph.filter((org.eclipse.rdf4j.model.Resource)resURI, predicate, null, new org.eclipse.rdf4j.model.Resource[0])) {
                Value value = statement.getObject();
                if (!(value instanceof IRI)) continue;
                return (IRI)value;
            }
        }
        return null;
    }

    public static String getResource(Model graph, URI resourceURI, IRI predicate) {
        IRI result = EntryUtil.getResourceAsURI(graph, resourceURI, predicate);
        if (result != null) {
            return result.stringValue();
        }
        return null;
    }

    public static String getTitle(Model graph, URI resourceURI, String language) {
        if (graph != null && resourceURI != null) {
            HashSet<IRI> titlePredicates = new HashSet<IRI>();
            titlePredicates.add(valueFactory.createIRI(NS.dcterms + "title"));
            titlePredicates.add(valueFactory.createIRI(NS.dc + "title"));
            return EntryUtil.getLabel(graph, resourceURI, titlePredicates, language);
        }
        return null;
    }

    public static String getTitle(Entry entry, String language) {
        if (entry != null) {
            try {
                return EntryUtil.getTitle(entry.getMetadataGraph(), entry.getResourceURI(), language);
            }
            catch (AuthorizationException ae) {
                log.debug("AuthorizationException: " + ae.getMessage());
            }
        }
        return null;
    }

    public static String getName(Entry entry) {
        Object result = null;
        if (entry != null) {
            String name = EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), valueFactory.createIRI(NS.foaf + "name"), null);
            if (name != null) {
                return name;
            }
            String givenName = EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), valueFactory.createIRI(NS.foaf + "givenName"), null);
            String familyName = EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), valueFactory.createIRI(NS.foaf + "familyName"), null);
            if (givenName != null) {
                result = givenName;
            }
            if (familyName != null) {
                result = result != null ? (String)result + " " + familyName : familyName;
            }
        }
        return result;
    }

    public static String getStructuredName(Entry entry) {
        Object result = null;
        if (entry != null) {
            HashSet<IRI> foafFirstName = new HashSet<IRI>();
            HashSet<IRI> foafSurname = new HashSet<IRI>();
            foafFirstName.add(valueFactory.createIRI(NS.foaf + "firstName"));
            foafFirstName.add(valueFactory.createIRI(NS.foaf + "givenName"));
            foafSurname.add(valueFactory.createIRI(NS.foaf + "surname"));
            foafSurname.add(valueFactory.createIRI(NS.foaf + "lastName"));
            foafSurname.add(valueFactory.createIRI(NS.foaf + "familyName"));
            String firstName = EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), foafFirstName, null);
            String surname = EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), foafSurname, null);
            if (surname != null) {
                result = surname;
            }
            if (firstName != null) {
                result = result != null ? (String)result + ";" + firstName : firstName;
            }
        }
        return result;
    }

    public static String getFirstName(Entry entry) {
        if (entry != null) {
            HashSet<IRI> foafFN = new HashSet<IRI>();
            foafFN.add(valueFactory.createIRI(NS.foaf + "givenName"));
            foafFN.add(valueFactory.createIRI(NS.foaf + "firstName"));
            return EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), foafFN, null);
        }
        return null;
    }

    public static String getLastName(Entry entry) {
        if (entry != null) {
            HashSet<IRI> foafLN = new HashSet<IRI>();
            foafLN.add(valueFactory.createIRI(NS.foaf + "surname"));
            foafLN.add(valueFactory.createIRI(NS.foaf + "lastName"));
            foafLN.add(valueFactory.createIRI(NS.foaf + "familyName"));
            return EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), foafLN, null);
        }
        return null;
    }

    public static String getEmail(Entry entry) {
        if (entry != null) {
            return EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), valueFactory.createIRI(NS.foaf + "mbox"), null);
        }
        return null;
    }

    public static String getMemberOf(Entry entry) {
        if (entry != null) {
            return EntryUtil.getResource(entry.getMetadataGraph(), entry.getResourceURI(), valueFactory.createIRI("http://open.vocab.org/terms/isMemberOf"));
        }
        return null;
    }

    public static String getFOAFTitle(Entry entry) {
        if (entry != null) {
            return EntryUtil.getLabel(entry.getMetadataGraph(), entry.getResourceURI(), valueFactory.createIRI(NS.foaf + "title"), null);
        }
        return null;
    }

    public static Map<String, Set<String>> getTitles(Entry entry) {
        ArrayList<IRI> titlePredicates = new ArrayList<IRI>();
        titlePredicates.add(valueFactory.createIRI(NS.foaf, "name"));
        titlePredicates.add(valueFactory.createIRI(NS.vcard, "fn"));
        titlePredicates.add(valueFactory.createIRI(NS.dcterms, "title"));
        titlePredicates.add(valueFactory.createIRI(NS.dc, "title"));
        titlePredicates.add(valueFactory.createIRI(NS.skos, "prefLabel"));
        titlePredicates.add(valueFactory.createIRI(NS.skos, "altLabel"));
        titlePredicates.add(valueFactory.createIRI(NS.skos, "hiddenLabel"));
        titlePredicates.add(valueFactory.createIRI(NS.rdfs, "label"));
        titlePredicates.add(valueFactory.createIRI(NS.schema, "name"));
        return EntryUtil.getLiteralValues(entry, titlePredicates);
    }

    public static Map<String, Set<String>> getDescriptions(Entry entry) {
        ArrayList<IRI> descPreds = new ArrayList<IRI>();
        descPreds.add(valueFactory.createIRI(NS.dcterms, "description"));
        descPreds.add(valueFactory.createIRI(NS.dc, "description"));
        return EntryUtil.getLiteralValues(entry, descPreds);
    }

    public static String getDescription(Entry entry, String language) {
        Map<String, Set<String>> descriptions = EntryUtil.getDescriptions(entry);
        if (descriptions.isEmpty()) {
            return null;
        }
        String description = null;
        for (String key : descriptions.keySet()) {
            if (language != null) {
                for (String lang : descriptions.get(key)) {
                    if (!language.equals(lang)) continue;
                    description = key;
                    break;
                }
            } else {
                description = key;
            }
            if (description == null) continue;
            break;
        }
        return description;
    }

    public static Map<String, Set<String>> getTagLiterals(Entry entry) {
        ArrayList<IRI> preds = new ArrayList<IRI>();
        preds.add(valueFactory.createIRI(NS.dcterms, "subject"));
        preds.add(valueFactory.createIRI(NS.dc, "subject"));
        preds.add(valueFactory.createIRI(NS.dcat, "keyword"));
        return EntryUtil.getLiteralValues(entry, preds);
    }

    public static java.util.List<String> getTagResources(Entry entry) {
        HashSet<IRI> preds = new HashSet<IRI>();
        preds.add(valueFactory.createIRI(NS.dc, "subject"));
        preds.add(valueFactory.createIRI(NS.dcterms, "subject"));
        return EntryUtil.getResourceValues(entry, preds);
    }

    public static Map<String, Set<String>> getLiteralValues(Entry entry, java.util.List<IRI> predicates) {
        if (entry == null || predicates == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        Model graph = null;
        try {
            graph = entry.getMetadataGraph();
        }
        catch (AuthorizationException ae) {
            log.debug("AuthorizationException: " + ae.getMessage());
        }
        if (graph != null) {
            IRI resourceURI = valueFactory.createIRI(entry.getResourceURI().toString());
            LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
            for (IRI pred : predicates) {
                for (Statement statement : graph.filter((org.eclipse.rdf4j.model.Resource)resourceURI, pred, null, new org.eclipse.rdf4j.model.Resource[0])) {
                    Value value2;
                    Iterator stmnts2;
                    HashSet<String> valuesSet;
                    Value value = statement.getObject();
                    if (value instanceof Literal) {
                        Literal lit = (Literal)value;
                        valuesSet = result.get(lit.stringValue()) == null ? new HashSet<String>() : (Set)result.get(lit.stringValue());
                        valuesSet.add(lit.getLanguage().orElse(null));
                        result.put(lit.stringValue(), valuesSet);
                        continue;
                    }
                    if (!(value instanceof org.eclipse.rdf4j.model.Resource) || !(stmnts2 = graph.filter((org.eclipse.rdf4j.model.Resource)value, RDF.VALUE, null, new org.eclipse.rdf4j.model.Resource[0]).iterator()).hasNext() || !((value2 = ((Statement)stmnts2.next()).getObject()) instanceof Literal)) continue;
                    Literal lit2 = (Literal)value2;
                    valuesSet = result.get(lit2.stringValue()) == null ? new HashSet() : (Set)result.get(lit2.stringValue());
                    valuesSet.add(lit2.getLanguage().orElse(null));
                    result.put(lit2.stringValue(), valuesSet);
                }
            }
            return result;
        }
        return null;
    }

    public static java.util.List<String> getResourceValues(Entry entry, Set<IRI> predicates) {
        if (entry == null || predicates == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        Model graph = null;
        try {
            graph = entry.getMetadataGraph();
        }
        catch (AuthorizationException ae) {
            log.debug("AuthorizationException: " + ae.getMessage());
        }
        if (graph != null) {
            return EntryUtil.getResourceValues(graph, entry.getResourceURI(), predicates);
        }
        return new ArrayList<String>();
    }

    public static java.util.List<String> getResourceValues(Model graph, URI resourceURI, Set<IRI> predicates) {
        if (graph == null || predicates == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (IRI pred : predicates) {
            for (Statement statement : graph.filter((org.eclipse.rdf4j.model.Resource)valueFactory.createIRI(resourceURI.toString()), pred, null, new org.eclipse.rdf4j.model.Resource[0])) {
                Value value = statement.getObject();
                if (!(value instanceof IRI)) continue;
                IRI res = (IRI)value;
                result.add(res.stringValue());
            }
        }
        return result;
    }

    public static boolean isDeleted(Entry entry) {
        String repoURL = entry.getRepositoryManager().getRepositoryURL().toString();
        String contextID = entry.getContext().getEntry().getId();
        URI trashURI = URISplit.createURI(repoURL, contextID, "resource", "_trash");
        Set referredBy = entry.getReferringListsInSameContext();
        return referredBy.size() == 1 && referredBy.contains(trashURI);
    }

    public static TraversalResult traverseAndLoadEntryMetadata(Set<IRI> entries, Set<URI> propertiesToFollow, Map<String, String> blacklist, int level, int depth, int limit, Multimap<IRI, Integer> visited, Context context, RepositoryManager rm) {
        LinkedHashModel resultGraph = new LinkedHashModel();
        HashSet<IRI> accessDenied = new HashSet<IRI>();
        Date latestModified = null;
        for (IRI r : entries) {
            LinkedHashModel graph;
            block20: {
                if (visited.containsEntry((Object)r, (Object)level)) {
                    log.debug("Skipping <{}>, entry already fetched and traversed on level {}", (Object)r, (Object)level);
                    continue;
                }
                if (limit > 0 && visited.size() >= limit) {
                    log.info("Stopping traversal because limit of {} entries has been reached", (Object)limit);
                    break;
                }
                graph = null;
                try {
                    URI uri = URI.create(r.toString());
                    Object fetchedEntry = null;
                    ContextManager cm = rm.getContextManager();
                    if (context != null) {
                        resEntries = context.getByResourceURI(uri);
                        if (resEntries != null && !resEntries.isEmpty()) {
                            fetchedEntry = (Entry)resEntries.toArray()[0];
                            if (resEntries.size() > 1) {
                                log.warn("Resource URI {} is used by {} entries in context {}; only using first matching entry for traversal result", new Object[]{uri, resEntries.size(), context.getURI()});
                            }
                        }
                        if (fetchedEntry == null) {
                            fetchedEntry = context.getByEntryURI(uri);
                        }
                    } else {
                        fetchedEntry = cm.getEntry(uri);
                        if (fetchedEntry == null && (resEntries = cm.getLinks(uri)) != null && !resEntries.isEmpty()) {
                            fetchedEntry = (Entry)resEntries.toArray()[0];
                        }
                    }
                    if (fetchedEntry == null) break block20;
                    graph = new LinkedHashModel(fetchedEntry.getMetadataGraph());
                    Date entryDateTmp = fetchedEntry.getModifiedDate();
                    if (entryDateTmp == null) {
                        entryDateTmp = fetchedEntry.getCreationDate();
                    }
                    if (entryDateTmp != null) {
                        if (latestModified == null || latestModified.before(entryDateTmp)) {
                            latestModified = entryDateTmp;
                        }
                    } else {
                        log.warn("Entry does neither have a creation nor a modification date: " + String.valueOf(fetchedEntry.getEntryURI()));
                    }
                }
                catch (AuthorizationException ae) {
                    if (level == 0) {
                        throw ae;
                    }
                    accessDenied.add(r);
                    log.info("Unable to load entry due to ACL restrictions: {}", (Object)r);
                    continue;
                }
            }
            if (graph == null) continue;
            visited.put((Object)r, (Object)level);
            if (EntryUtil.graphContainsPredicateObjectTuple((Model)graph, blacklist)) {
                log.debug("Found blacklisted predicate/object tuple in graph, excluding {}", (Object)r);
                continue;
            }
            resultGraph.addAll((Collection)graph);
            if (propertiesToFollow == null || level >= depth) continue;
            HashSet<IRI> objects = new HashSet<IRI>();
            for (URI prop : propertiesToFollow) {
                objects.addAll(EntryUtil.valueToURI(graph.filter(null, valueFactory.createIRI(prop.toString()), null, new org.eclipse.rdf4j.model.Resource[0]).objects()));
            }
            objects.remove(r);
            if (objects.isEmpty()) continue;
            log.debug("Fetching " + objects.size() + " entr" + (objects.size() == 1 ? "y" : "ies") + " linked from <" + String.valueOf(r) + ">: " + String.valueOf(objects));
            TraversalResult nextLevel = EntryUtil.traverseAndLoadEntryMetadata(objects, propertiesToFollow, blacklist, level + 1, depth, limit, visited, context, rm);
            resultGraph.addAll((Collection)nextLevel.getGraph());
            accessDenied.addAll(nextLevel.getAccessDenied());
            if (nextLevel.getLatestModified() != null) {
                if (latestModified != null && !latestModified.before(nextLevel.getLatestModified())) continue;
                latestModified = nextLevel.getLatestModified();
                continue;
            }
            log.warn("No latest modification date on traversal level " + (level + 1));
        }
        for (IRI objectToRemove : accessDenied) {
            resultGraph.removeIf(s -> objectToRemove.equals((Object)s.getObject()));
        }
        return new TraversalResult((Model)resultGraph, latestModified, accessDenied);
    }

    private static boolean graphContainsPredicateObjectTuple(Model graph, Map<String, String> tuples) {
        if (tuples != null && !tuples.isEmpty()) {
            for (Statement s : graph) {
                String predicate = s.getPredicate().stringValue();
                String object = s.getObject().stringValue();
                for (String key : tuples.keySet()) {
                    if (!predicate.equals(key) || !object.equals(tuples.get(key))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Set<IRI> valueToURI(Set<Value> values) {
        HashSet<IRI> result = new HashSet<IRI>();
        for (Value v : values) {
            if (!(v instanceof IRI)) continue;
            result.add((IRI)v);
        }
        return result;
    }

    public static class TraversalResult {
        private final Model graph;
        private final Date latestModified;
        private final Set<IRI> accessDenied;

        private TraversalResult(Model graph, Date latestModified, Set<IRI> accessDenied) {
            this.graph = graph;
            this.latestModified = latestModified;
            this.accessDenied = accessDenied;
        }

        @Generated
        public Model getGraph() {
            return this.graph;
        }

        @Generated
        public Date getLatestModified() {
            return this.latestModified;
        }

        @Generated
        public Set<IRI> getAccessDenied() {
            return this.accessDenied;
        }
    }
}

