/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperations {
    private static final Logger log = LoggerFactory.getLogger(FileOperations.class);
    private static final int BUFFER_SIZE = 8192;

    private FileOperations() {
        throw new AssertionError();
    }

    public static void moveFile(File source, File destination) throws IOException {
        if (source == null || destination == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (source.equals(destination)) {
            throw new IllegalArgumentException("Cannot move file to itself");
        }
        log.debug("Moving file {} to {}", (Object)source, (Object)destination);
        if (!source.renameTo(destination)) {
            FileOperations.copyFile(source, destination);
            if (!source.delete()) {
                log.warn("Unable to delete source file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destinationChannel = null;
        boolean copied = false;
        try {
            sourceChannel = new FileInputStream(src).getChannel();
            destinationChannel = new FileOutputStream(dst).getChannel();
            long copiedSize = sourceChannel.transferTo(0L, sourceChannel.size(), (WritableByteChannel)((Object)destinationChannel));
            if (sourceChannel.size() == copiedSize) {
                copied = true;
            }
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destinationChannel != null) {
                destinationChannel.close();
            }
        }
        if (!copied) {
            log.warn("File copying failed using NIO, performing traditional copy using streams instead");
            FileOperations.copyFile(Files.newInputStream(src.toPath(), new OpenOption[0]), Files.newOutputStream(dst.toPath(), new OpenOption[0]));
        }
    }

    public static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static long copyFile(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        BufferedOutputStream bos = new BufferedOutputStream(os, 8192);
        long bytesCopied = 0L;
        byte[] b = new byte[8192];
        try {
            int s;
            while ((s = bis.read(b)) != -1) {
                bos.write(b, 0, s);
                bytesCopied += (long)s;
            }
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
        bis.close();
        bos.close();
        return bytesCopied;
    }

    public static boolean deleteAllFilesInDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                File file = new File(dir, child);
                if (!file.isFile()) continue;
                if (!file.delete()) {
                    log.warn("Could not delete file {}", (Object)file);
                    return false;
                }
                log.debug("Deleted file {}", (Object)file);
            }
        }
        return true;
    }

    public static boolean deleteDirectory(File path) {
        File[] files;
        if (path.exists() && (files = path.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileOperations.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    public static List<File> listFiles(File folder) {
        ArrayList<File> result = new ArrayList<File>();
        if (!folder.isDirectory()) {
            result.add(folder);
        } else {
            File[] fileArray = folder.listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    if (file.isFile()) {
                        result.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    result.addAll(FileOperations.listFiles(file));
                }
            }
        }
        return result;
    }

    public static List<File> listDirectories(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Parameter is not a folder");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = folder.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                result.add(file);
                result.addAll(FileOperations.listFiles(file));
            }
        }
        return result;
    }

    public static long unzipFile(File zipFile, File destination) throws IOException {
        ZipEntry entry;
        if (!destination.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a folder.");
        }
        InputStream fis = Files.newInputStream(zipFile.toPath(), new OpenOption[0]);
        CheckedInputStream cis = new CheckedInputStream(fis, new CRC32());
        BufferedInputStream bis = new BufferedInputStream(cis, 8192);
        ZipInputStream zis = new ZipInputStream(bis);
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            log.debug("Extracting file: {}", (Object)entry.getName());
            byte[] data = new byte[8192];
            File unzippedFile = new File(destination, entry.getName());
            File parentDir = unzippedFile.getParentFile();
            if (!parentDir.exists()) {
                log.debug("Creating directory: {}", (Object)parentDir);
                if (parentDir.mkdirs()) {
                    log.debug("Created directory: {}", (Object)parentDir);
                } else {
                    log.debug("Could not create  directory: {}", (Object)parentDir);
                }
            }
            OutputStream fos = Files.newOutputStream(unzippedFile.toPath(), new OpenOption[0]);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 8192);
            while ((count = zis.read(data, 0, 8192)) != -1) {
                bos.write(data, 0, count);
            }
            bos.flush();
            bos.close();
        }
        zis.close();
        return cis.getChecksum().getValue();
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    public static void copyPath(final Path src, final Path dst) throws IOException {
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(dst.resolve(src.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, dst.resolve(src.relativize(file)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        block11: {
            block10: {
                String[] files;
                if (!srcPath.isDirectory()) break block10;
                if (!dstPath.exists()) {
                    dstPath.mkdir();
                }
                if ((files = srcPath.list()) == null) break block11;
                for (String file : files) {
                    FileOperations.copyDirectory(new File(srcPath, file), new File(dstPath, file));
                }
                break block11;
            }
            if (!srcPath.exists()) {
                log.error("{}: file or directory does not exist.", (Object)srcPath);
            } else {
                InputStream in = null;
                OutputStream out = null;
                try {
                    int len;
                    in = Files.newInputStream(srcPath.toPath(), new OpenOption[0]);
                    out = Files.newOutputStream(dstPath.toPath(), new OpenOption[0]);
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        if (file == null) {
            throw new NullPointerException("file to write to is null");
        }
        FileWriter fw = new FileWriter(file);
        try (BufferedWriter writer = new BufferedWriter(fw);){
            writer.write(content);
        }
    }
}

