/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.rio.RDFFormat;

public class MetadataUtil {
    public static final String INTEGER_TYPE = "integer";
    public static final String DATE_TYPE = "date";
    public static final String STRING_TYPE = "string";
    public static Set<CoreDatatype> integerDataTypes = new HashSet<CoreDatatype>();
    public static Set<CoreDatatype> dateDataTypes;
    public static Set<CoreDatatype> stringDataTypes;

    public static boolean isIntegerLiteral(Literal l) {
        return MetadataUtil.isTypedLiteral(l, INTEGER_TYPE);
    }

    public static boolean isDateLiteral(Literal l) {
        return MetadataUtil.isTypedLiteral(l, DATE_TYPE);
    }

    public static boolean isStringLiteral(Literal l) {
        return MetadataUtil.isTypedLiteral(l, STRING_TYPE);
    }

    private static boolean isTypedLiteral(Literal l, String type) {
        if (l == null) {
            throw new IllegalArgumentException("Literal must not be null.");
        }
        CoreDatatype datatype = CoreDatatype.from((IRI)l.getDatatype());
        if (datatype == CoreDatatype.XSD.NONE) {
            return false;
        }
        return switch (type) {
            case INTEGER_TYPE -> integerDataTypes.contains(datatype);
            case DATE_TYPE -> dateDataTypes.contains(datatype);
            default -> stringDataTypes.contains(datatype);
        };
    }

    public static RDFFormat getRDFFormat(String formatString) {
        List<RDFFormat> allFormats = Arrays.asList(RDFFormat.RDFXML, RDFFormat.NTRIPLES, RDFFormat.TURTLE, RDFFormat.N3, RDFFormat.TRIX, RDFFormat.TRIG, RDFFormat.BINARY, RDFFormat.NQUADS, RDFFormat.JSONLD, RDFFormat.RDFJSON, RDFFormat.RDFA);
        for (RDFFormat format : allFormats) {
            if (!format.getName().equalsIgnoreCase(formatString)) continue;
            return format;
        }
        return null;
    }

    static {
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.BYTE);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.INT);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.INTEGER);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.LONG);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.NEGATIVE_INTEGER);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.NON_NEGATIVE_INTEGER);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.NON_POSITIVE_INTEGER);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.POSITIVE_INTEGER);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.SHORT);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.UNSIGNED_LONG);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.UNSIGNED_INT);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.UNSIGNED_SHORT);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.UNSIGNED_BYTE);
        integerDataTypes.add((CoreDatatype)CoreDatatype.XSD.GYEAR);
        dateDataTypes = new HashSet<CoreDatatype>();
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.DATE);
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.DATETIME);
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.GYEAR);
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.GYEARMONTH);
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.GDAY);
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.GMONTH);
        dateDataTypes.add((CoreDatatype)CoreDatatype.XSD.DATETIMESTAMP);
        stringDataTypes = new HashSet<CoreDatatype>();
        stringDataTypes.add((CoreDatatype)CoreDatatype.RDF.LANGSTRING);
        stringDataTypes.add((CoreDatatype)CoreDatatype.XSD.STRING);
    }
}

