/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.repository.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Queues;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.SearchIndex;
import org.entrystore.User;
import org.entrystore.impl.LocalMetadataWrapper;
import org.entrystore.impl.RegularContext;
import org.entrystore.impl.RepositoryProperties;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.EntryUtil;
import org.entrystore.repository.util.HashType;
import org.entrystore.repository.util.Hashing;
import org.entrystore.repository.util.MetadataUtil;
import org.entrystore.repository.util.NS;
import org.entrystore.repository.util.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSearchIndex
implements SearchIndex {
    private static final Logger log = LoggerFactory.getLogger(SolrSearchIndex.class);
    private static final int BATCH_SIZE_ADD = 100;
    private static final int BATCH_SIZE_DELETE = 100;
    private static final int SOLR_COMMIT_WITHIN = 1000;
    private static final int SOLR_COMMIT_WITHIN_MAX = 10000;
    private String defaultSortLang = null;
    private boolean extractFulltext = false;
    private boolean related = false;
    private Map<IRI, Boolean> relatedProperties = null;
    private boolean relatedContainsGlobal = false;
    private final RepositoryManager rm;
    private final SolrClient solrServer;
    private final Thread documentSubmitter;
    private final Thread delayedContextIndexer;
    private final Cache<URI, SolrInputDocument> postQueue = Caffeine.newBuilder().build();
    private final Queue<URI> deleteQueue = Queues.newConcurrentLinkedQueue();
    private final Map<URI, Future> reindexing = Collections.synchronizedMap(new HashMap());
    private final SimpleDateFormat solrDateFormatter;
    private final ExecutorService reindexExecutor = Executors.newSingleThreadExecutor();
    private final Map<URI, DelayedContextIndexerInfo> delayedReindex = Collections.synchronizedMap(new HashMap());
    private ValueFactory valueFactory;

    public SolrSearchIndex(RepositoryManager rm, SolrClient solrServer) {
        this.solrDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.solrDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.rm = rm;
        this.valueFactory = this.rm.getValueFactory();
        this.solrServer = solrServer;
        this.extractFulltext = "on".equalsIgnoreCase(rm.getConfiguration().getString(Settings.SOLR_EXTRACT_FULLTEXT, "off"));
        this.related = "on".equalsIgnoreCase(rm.getConfiguration().getString(Settings.SOLR_RELATED, "off"));
        this.defaultSortLang = rm.getConfiguration().getString(Settings.SOLR_DEFAULT_SORTING_LANG);
        if (this.related) {
            List relPropsSetting = rm.getConfiguration().getStringList(Settings.SOLR_RELATED_PROPERTIES, new ArrayList());
            if (relPropsSetting.isEmpty()) {
                this.related = false;
            } else {
                this.relatedProperties = new HashMap<IRI, Boolean>();
                for (String relProp : rm.getConfiguration().getStringList(Settings.SOLR_RELATED_PROPERTIES, new ArrayList())) {
                    if (relProp.endsWith(",global")) {
                        this.relatedProperties.put(this.valueFactory.createIRI(relProp.substring(0, relProp.indexOf(","))), true);
                        continue;
                    }
                    this.relatedProperties.put(this.valueFactory.createIRI(relProp), false);
                }
                this.relatedContainsGlobal = this.relatedProperties.containsValue(true);
            }
        }
        this.documentSubmitter = new SolrInputDocumentSubmitter();
        this.documentSubmitter.start();
        this.delayedContextIndexer = new DelayedContextIndexer();
        this.delayedContextIndexer.start();
    }

    public void shutdown() {
        if (this.documentSubmitter != null) {
            this.documentSubmitter.interrupt();
        }
        if (this.delayedContextIndexer != null) {
            this.delayedContextIndexer.interrupt();
        }
        this.reindexExecutor.shutdown();
        try {
            log.debug("Sending commit to Solr");
            this.solrServer.commit(true, false);
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage());
        }
    }

    public void clearSolrIndex(SolrClient solrServer) {
        UpdateRequest req = new UpdateRequest();
        req.deleteByQuery("*:*");
        req.setCommitWithin(1000);
        try {
            req.process(solrServer);
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void clearSolrIndex(SolrClient solrServer, Date expirationDate, Entry contextEntry) {
        if (solrServer == null || expirationDate == null && contextEntry == null) {
            throw new IllegalArgumentException("Too many parameters are null");
        }
        UpdateRequest req = new UpdateRequest();
        Object deleteQuery = "";
        if (expirationDate != null) {
            String solrExpirationDate = ClientUtils.escapeQueryChars((String)this.solrDateFormatter.format(expirationDate));
            deleteQuery = (String)deleteQuery + "indexedAt:[* TO " + solrExpirationDate + "}";
        }
        if (contextEntry != null) {
            if (!((String)deleteQuery).isEmpty()) {
                deleteQuery = (String)deleteQuery + " AND ";
            }
            deleteQuery = (String)deleteQuery + "context:" + ClientUtils.escapeQueryChars((String)contextEntry.getResourceURI().toString());
        }
        req.deleteByQuery((String)deleteQuery);
        req.setCommitWithin(1000);
        try {
            req.process(solrServer);
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void reindex(boolean purgeAllBeforeReindex) {
        this.reindex(purgeAllBeforeReindex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(URI contextURI, boolean purgeAllBeforeReindex) {
        Map<URI, Future> map = this.reindexing;
        synchronized (map) {
            if (this.reindexing.containsKey(contextURI)) {
                Future existingIndexer = this.reindexing.get(contextURI);
                if (!existingIndexer.isDone()) {
                    log.info("Cancelling existing indexer thread for {}", (Object)contextURI);
                    existingIndexer.cancel(true);
                }
                this.reindexing.remove(contextURI);
            }
            Future<?> indexer = this.reindexExecutor.submit(() -> {
                this.reindexSync(contextURI, false);
                this.reindexing.remove(contextURI);
            });
            this.reindexing.put(contextURI, indexer);
        }
    }

    public void reindexSync(boolean purgeAllBeforeReindex) {
        this.reindex(purgeAllBeforeReindex, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex(boolean purgeAllBeforeReindex, boolean sync) {
        Set contexts = new HashSet();
        PrincipalManager pm = this.rm.getPrincipalManager();
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            contexts = this.rm.getContextManager().getEntries();
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
        for (URI contextURI : contexts) {
            if (sync) {
                this.reindexSync(contextURI, purgeAllBeforeReindex);
                continue;
            }
            this.reindex(contextURI, purgeAllBeforeReindex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexSync(URI contextURI, boolean purgeAllBeforeReindex) {
        if (this.solrServer == null) {
            log.warn("Ignoring request as Solr is not used by this instance");
            return;
        }
        if (contextURI == null) {
            throw new IllegalArgumentException("Context URI must not be null");
        }
        log.info("Starting Solr reindexing of context " + String.valueOf(contextURI));
        Entry contextEntry = this.rm.getContextManager().getByEntryURI(contextURI);
        if (purgeAllBeforeReindex) {
            this.clearSolrIndex(this.solrServer, null, contextEntry);
        }
        Date reindexStart = new Date();
        PrincipalManager pm = this.rm.getPrincipalManager();
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            URI lastIndexedEntryURI = this.postContextEntriesToQueue(contextURI);
            if (lastIndexedEntryURI != null) {
                if (!purgeAllBeforeReindex) {
                    new Thread(() -> {
                        while (this.postQueue.asMap().containsKey(lastIndexedEntryURI)) {
                            try {
                                log.debug("Entries of context {} are still in submission queue, sleeping 5 seconds before attempting new purge of expired entries", (Object)contextURI);
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                log.error("Cleanup of context index was interrupted, a full Solr reindex may be necessary: {}", (Object)e.getMessage());
                            }
                            this.postQueue.cleanUp();
                        }
                        this.clearSolrIndex(this.solrServer, reindexStart, contextEntry);
                        log.info("Expired entries of context {} have been purged from the index", (Object)contextURI);
                    }).start();
                }
                log.info("Finished Solr reindexing of context {}, took {} ms; the Solr submission queue may still contain yet to be processed documents", (Object)contextURI, (Object)(new Date().getTime() - reindexStart.getTime()));
            } else {
                log.debug("Solr reindexing of context {} could not be completed, either the context could not be loaded or (most likely) another process started reindexing the same context before the ongoing process was complete", (Object)contextURI);
            }
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
    }

    public boolean isIndexing() {
        return this.isIndexing(null);
    }

    public boolean isIndexing(URI contextURI) {
        return this.reindexing.containsKey(contextURI);
    }

    public Set<URI> getIndexingContexts() {
        return this.reindexing.keySet();
    }

    public long getPostQueueSize() {
        this.postQueue.cleanUp();
        return this.postQueue.estimatedSize();
    }

    public long getDeleteQueueSize() {
        return this.deleteQueue.size();
    }

    public boolean ping() {
        try {
            SolrPingResponse pingResponse = this.solrServer.ping();
            if (pingResponse.getStatus() == 0) {
                return true;
            }
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage());
        }
        return false;
    }

    public boolean isUp() {
        return this.ping() && this.documentSubmitter.isAlive() && this.delayedContextIndexer.isAlive() && !this.reindexExecutor.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitContextForDelayedReindex(Entry contextEntry, Model entryGraph) {
        Map<URI, DelayedContextIndexerInfo> map = this.delayedReindex;
        synchronized (map) {
            boolean newGuestReadable;
            IRI guestURI = this.valueFactory.createIRI(this.rm.getPrincipalManager().getGuestUser().getURI().toString());
            URI contextURI = contextEntry.getEntryURI();
            LinkedHashModel m = new LinkedHashModel(entryGraph);
            boolean bl = newGuestReadable = m.contains((Resource)this.valueFactory.createIRI(contextEntry.getLocalMetadataURI().toString()), RepositoryProperties.Read, (Value)guestURI, new Resource[0]) || m.contains((Resource)this.valueFactory.createIRI(contextEntry.getLocalMetadataURI().toString()), RepositoryProperties.Write, (Value)guestURI, new Resource[0]);
            if (this.delayedReindex.containsKey(contextURI) && this.delayedReindex.get((Object)contextURI).guestReadable != newGuestReadable) {
                log.info("Removing context from delayed reindexing queue due to reverted ACL change within grace period");
                this.delayedReindex.remove(contextURI);
            } else {
                log.info("Enqueueing context for delayed reindexing due to ACL change");
                DelayedContextIndexerInfo info = new DelayedContextIndexerInfo();
                info.submitted = LocalDateTime.now();
                info.guestReadable = newGuestReadable;
                this.delayedReindex.put(contextURI, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI postContextEntriesToQueue(URI contextURI) {
        String id = contextURI.toString().substring(contextURI.toString().lastIndexOf("/") + 1);
        ContextManager cm = this.rm.getContextManager();
        Context context = cm.getContext(id);
        if (context != null) {
            URI lastEntryURI = null;
            for (URI entryURI : context.getEntries()) {
                Entry entry;
                if (Thread.interrupted()) {
                    log.info("Indexer thread received interrupt, stopping reindexing of " + String.valueOf(contextURI));
                    return null;
                }
                if (entryURI == null) continue;
                try {
                    entry = cm.getEntry(entryURI);
                }
                catch (Exception e) {
                    log.error("Unable to load entry with URI {} due to error: {}", (Object)entryURI, (Object)e.getMessage());
                    continue;
                }
                if (entry == null) {
                    log.warn("Unable to load entry with URI {}", (Object)entryURI);
                    continue;
                }
                Cache<URI, SolrInputDocument> cache = this.postQueue;
                synchronized (cache) {
                    if (!entry.isDeleted() && !entry.getContext().isDeleted()) {
                        log.info("Adding entry to Solr post queue: {}", (Object)entryURI);
                        try {
                            this.postQueue.put((Object)entryURI, (Object)this.constructSolrInputDocument(entry, this.extractFulltext));
                        }
                        catch (Exception e) {
                            log.error("Not indexing {} due to error: {}", (Object)entryURI, (Object)e.getMessage());
                        }
                    } else {
                        log.debug("Not adding deleted entry to post queue: {}", (Object)entryURI);
                    }
                }
                lastEntryURI = entryURI;
            }
            return lastEntryURI;
        }
        return null;
    }

    private void storeLiteralsWithLanguages(SolrInputDocument doc, Map<String, Set<String>> literals, String literalType) {
        String missingLanguageString = "nolang";
        String defaultString = "default";
        HashSet<String> alreadySetLanguages = new HashSet<String>();
        for (String literal : literals.keySet()) {
            doc.addField(literalType, (Object)literal);
            Set<String> literalLanguages = literals.get(literal);
            if (literalLanguages.isEmpty() || ObjectUtils.allNull((Object[])new Object[]{literalLanguages})) {
                if (alreadySetLanguages.contains("nolang")) continue;
                doc.addField(String.format("%s.%s", literalType, "nolang"), (Object)literal);
                alreadySetLanguages.add("nolang");
                continue;
            }
            for (String language : literalLanguages) {
                if (language != null && language.equalsIgnoreCase(this.defaultSortLang) && !alreadySetLanguages.contains("default")) {
                    doc.addField(String.format("%s.%s", literalType, "default"), (Object)literal);
                    alreadySetLanguages.add("default");
                }
                if (alreadySetLanguages.contains(language)) continue;
                doc.addField(String.format("%s.%s", literalType, language == null ? "nolang" : language), (Object)literal);
                alreadySetLanguages.add(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrInputDocument constructSolrInputDocument(Entry entry, boolean extractFulltext) {
        String email;
        String dctLang;
        Map<String, Set<String>> tagLiterals;
        Map<String, Set<String>> descriptions;
        String contextName;
        Map<String, Set<String>> titles;
        URI creator;
        Object contextEntry;
        URI resourceUriForProjectType;
        Model graphWithProjectType;
        Date modificationDate;
        Model mdGraph = entry.getMetadataGraph();
        Model entryGraph = entry.getGraph();
        URI resourceURI = entry.getResourceURI();
        SolrInputDocument doc = new SolrInputDocument();
        doc.setField("uri", (Object)entry.getEntryURI().toString());
        doc.setField("resource", (Object)resourceURI.toString());
        doc.setField("context", (Object)entry.getContext().getEntry().getResourceURI().toString());
        for (Statement value : entryGraph.filter((Resource)this.valueFactory.createIRI(resourceURI.toString()), RDF.TYPE, null, new Resource[0])) {
            doc.addField("rdfType", (Object)value.getObject().stringValue());
        }
        for (Statement statement : mdGraph.filter((Resource)this.valueFactory.createIRI(resourceURI.toString()), RDF.TYPE, null, new Resource[0])) {
            doc.addField("rdfType", (Object)statement.getObject().stringValue());
        }
        Date creationDate = entry.getCreationDate();
        if (creationDate != null) {
            doc.setField("created", (Object)creationDate);
        }
        if ((modificationDate = entry.getModifiedDate()) != null) {
            doc.setField("modified", (Object)modificationDate);
        }
        doc.setField("graphType", (Object)entry.getGraphType().name());
        doc.setField("entryType", (Object)entry.getEntryType().name());
        doc.setField("resourceType", (Object)entry.getResourceType().name());
        if (entry.getLocalMetadataURI() != null) {
            HashSet<IRI> profilePreds = new HashSet<IRI>();
            profilePreds.add(this.valueFactory.createIRI("http://entryscape.com/terms/entityType"));
            profilePreds.add(this.valueFactory.createIRI("http://entrystore.org/terms/profile"));
            Iterator<String> iterator = EntryUtil.getResourceValues(entryGraph, entry.getLocalMetadataURI(), profilePreds).iterator();
            if (iterator.hasNext()) {
                String profileURI = iterator.next();
                doc.setField("profile", (Object)profileURI);
            }
        } else {
            log.warn("Local metadata URI of entry is null: {}", (Object)entry.getEntryURI());
        }
        if (GraphType.Context.equals((Object)entry.getGraphType())) {
            graphWithProjectType = entryGraph;
            resourceUriForProjectType = resourceURI;
        } else {
            contextEntry = entry.getContext().getEntry();
            graphWithProjectType = contextEntry.getGraph();
            resourceUriForProjectType = contextEntry.getResourceURI();
        }
        contextEntry = EntryUtil.getResourceValues(graphWithProjectType, resourceUriForProjectType, Collections.singleton(this.valueFactory.createIRI("http://entryscape.com/terms/projectType"))).iterator();
        if (contextEntry.hasNext()) {
            Iterator projectTypeURI = (String)contextEntry.next();
            doc.setField("projectType", (Object)projectTypeURI);
        }
        if ((creator = entry.getCreator()) != null) {
            doc.setField("creator", (Object)creator.toString());
        }
        for (URI c : entry.getContributors()) {
            doc.addField("contributors", (Object)c.toString());
        }
        for (URI l : entry.getReferringListsInSameContext()) {
            doc.addField("lists", (Object)l.toString());
        }
        try {
            for (URI p : entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer)) {
                doc.addField("acl.admin", (Object)p.toString());
            }
            for (URI p : entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata)) {
                doc.addField("acl.metadata.r", (Object)p.toString());
            }
            for (URI p : entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteMetadata)) {
                doc.addField("acl.metadata.rw", (Object)p.toString());
            }
            for (URI p : entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadResource)) {
                doc.addField("acl.resource.r", (Object)p.toString());
            }
            for (URI p : entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteResource)) {
                doc.addField("acl.resource.rw", (Object)p.toString());
            }
        }
        catch (IllegalArgumentException iae) {
            log.warn("Unable to index ACL for entry {}: {}", (Object)entry.getEntryURI().toString(), (Object)iae.getMessage());
        }
        URI status = entry.getStatus();
        if (status != null) {
            doc.setField("status", (Object)status.toString());
        }
        if ((titles = EntryUtil.getTitles(entry)) != null && !titles.isEmpty()) {
            this.storeLiteralsWithLanguages(doc, titles, "title");
        }
        String firstName = EntryUtil.getFirstName(entry);
        String lastName = EntryUtil.getLastName(entry);
        Object name = "";
        if (firstName != null) {
            name = (String)name + firstName;
        }
        if (lastName != null) {
            name = (String)name + " " + lastName;
        }
        if (!((String)name).isEmpty()) {
            doc.addField("title", name);
        }
        if (GraphType.User.equals((Object)entry.getGraphType())) {
            User user = (User)entry.getResource();
            if (user != null) {
                String username = user.getName();
                if (username != null) {
                    doc.addField("username", (Object)username);
                }
            } else {
                log.warn("User resource of {} is null", (Object)entry.getEntryURI().toString());
            }
        }
        if ((GraphType.Context.equals((Object)entry.getGraphType()) || GraphType.SystemContext.equals((Object)entry.getGraphType())) && (contextName = this.rm.getContextManager().getName(entry.getResource().getURI())) != null) {
            doc.addField("contextname", (Object)contextName);
        }
        if ((descriptions = EntryUtil.getDescriptions(entry)) != null && !descriptions.isEmpty()) {
            this.storeLiteralsWithLanguages(doc, descriptions, "description");
        }
        if ((tagLiterals = EntryUtil.getTagLiterals(entry)) != null) {
            this.storeLiteralsWithLanguages(doc, tagLiterals, "tag.literal");
        }
        for (String s : EntryUtil.getTagResources(entry)) {
            doc.addField("tag.uri", (Object)s);
        }
        String dcLang = EntryUtil.getLabel(mdGraph, resourceURI, this.valueFactory.createIRI(NS.dc + "language"), null);
        if (dcLang != null) {
            doc.addField("lang", (Object)dcLang);
        }
        if ((dctLang = EntryUtil.getLabel(mdGraph, resourceURI, this.valueFactory.createIRI(NS.dcterms + "language"), null)) != null) {
            doc.addField("lang", (Object)dctLang);
        }
        if ((email = EntryUtil.getEmail(entry)) != null) {
            doc.addField("email", (Object)email);
        }
        boolean guestReadable = false;
        PrincipalManager pm = entry.getRepositoryManager().getPrincipalManager();
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getGuestUser().getURI());
            try {
                pm.checkAuthenticatedUserAuthorized(entry, PrincipalManager.AccessProperty.ReadMetadata);
                guestReadable = true;
            }
            catch (AuthorizationException authorizationException) {
            }
            catch (IllegalArgumentException iae) {
                log.warn(iae.getMessage());
            }
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
        doc.setField("public", (Object)guestReadable);
        this.addGenericMetadataFields(doc, mdGraph, false);
        if (this.related) {
            this.addRelatedFields(doc, entry);
        }
        return doc;
    }

    private void addGenericMetadataFields(SolrInputDocument doc, Model metadata, boolean related) {
        if (doc == null || metadata == null) {
            throw new IllegalArgumentException("Neither SolrInputDocument nor Graph must be null");
        }
        String prefix = "";
        if (related) {
            prefix = "related.";
        }
        for (Statement s : metadata) {
            Object objString;
            String predString = s.getPredicate().stringValue();
            String predMD5Trunc8 = Hashing.hash(predString, HashType.MD5).substring(0, 8);
            if (s.getObject() instanceof IRI) {
                objString = s.getObject().stringValue();
                if (!related) {
                    this.addFieldValueOnce(doc, prefix + "metadata.object.uri", objString);
                }
                this.addFieldValueOnce(doc, prefix + "metadata.predicate.uri." + predMD5Trunc8, objString);
                continue;
            }
            objString = s.getObject();
            if (!(objString instanceof Literal)) continue;
            Literal l = (Literal)objString;
            if (!related && MetadataUtil.isStringLiteral(l)) {
                this.addFieldValueOnce(doc, prefix + "metadata.object.literal", l.getLabel());
            }
            this.addFieldValueOnce(doc, prefix + "metadata.predicate.literal_s." + predMD5Trunc8, l.getLabel());
            if (MetadataUtil.isIntegerLiteral(l)) {
                try {
                    doc.setField(prefix + "metadata.predicate.integer." + predMD5Trunc8, (Object)l.longValue());
                }
                catch (NumberFormatException nfe) {
                    log.warn("Unable to index integer literal: {}. (Subject: {}, Predicate: {}, Object: {})", new Object[]{nfe.getMessage(), s.getSubject(), predString, l.getLabel()});
                }
            }
            if (!MetadataUtil.isDateLiteral(l)) continue;
            try {
                doc.setField(prefix + "metadata.predicate.date." + predMD5Trunc8, (Object)this.dateToSolrDateString(l.calendarValue()));
            }
            catch (IllegalArgumentException iae) {
                log.warn("Unable to index date literal: {}. (Subject: {}, Predicate: {}, Object: {})", new Object[]{iae.getMessage(), s.getSubject(), predString, l.getLabel()});
            }
        }
    }

    private void addRelatedFields(SolrInputDocument doc, Entry entry) {
        if (doc == null || entry == null) {
            throw new IllegalArgumentException("Neither SolrInputDocument nor Entry must be null");
        }
        HashSet<Context> contexts = new HashSet<Context>();
        if (this.relatedContainsGlobal) {
            ContextManager cm = entry.getRepositoryManager().getContextManager();
            for (URI contextURI : cm.getEntries()) {
                Context c = cm.getContext(contextURI);
                if (!(c instanceof RegularContext)) continue;
                contexts.add(c);
            }
        }
        HashSet relatedEntries = new HashSet();
        for (IRI relProp : this.relatedProperties.keySet()) {
            List<String> relatedURIs = EntryUtil.getResourceValues(entry, Collections.singleton(relProp));
            if (relatedURIs.isEmpty()) continue;
            if (this.relatedContainsGlobal && this.relatedProperties.get(relProp).booleanValue()) {
                for (Context context : contexts) {
                    for (String relEntURI : relatedURIs) {
                        relatedEntries.addAll(context.getByResourceURI(URI.create(relEntURI)));
                    }
                }
                continue;
            }
            for (String relEntURI : relatedURIs) {
                relatedEntries.addAll(entry.getContext().getByResourceURI(URI.create(relEntURI)));
            }
        }
        if (!relatedEntries.isEmpty()) {
            Set mainEntryACL = entry.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata);
            for (Entry relE : relatedEntries) {
                if (mainEntryACL.equals(relE.getAllowedPrincipalsFor(PrincipalManager.AccessProperty.ReadMetadata))) {
                    log.debug("Adding " + String.valueOf(relE.getEntryURI()) + " to related property index of " + String.valueOf(entry.getEntryURI()));
                    this.addGenericMetadataFields(doc, relE.getMetadataGraph(), true);
                    continue;
                }
                log.debug("ACLs of " + String.valueOf(entry.getEntryURI()) + " and " + String.valueOf(relE.getEntryURI()) + " do not match, not adding to related property index");
            }
        }
    }

    private void addFieldValueOnce(SolrInputDocument doc, String name, Object value) {
        Collection fieldValues = doc.getFieldValues(name);
        if (fieldValues == null || !fieldValues.contains(value)) {
            doc.addField(name, value);
        }
    }

    private String dateToSolrDateString(XMLGregorianCalendar c) {
        if (c.getTimezone() == Integer.MIN_VALUE) {
            c.setTimezone(0);
        }
        return this.solrDateFormatter.format(c.toGregorianCalendar().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEntry(Entry entry) {
        PrincipalManager pm = entry.getRepositoryManager().getPrincipalManager();
        URI currentUser = pm.getAuthenticatedUserURI();
        try {
            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
            URI entryURI = entry.getEntryURI();
            Cache<URI, SolrInputDocument> cache = this.postQueue;
            synchronized (cache) {
                if (this.postQueue.getIfPresent((Object)entryURI) != null) {
                    log.debug("Entry {} already exists in post queue, attempting replacement", (Object)entryURI);
                }
                if (!entry.isDeleted() && !entry.getContext().isDeleted()) {
                    log.info("Adding document to Solr post queue: {}", (Object)entryURI);
                    try {
                        this.postQueue.put((Object)entryURI, (Object)this.constructSolrInputDocument(entry, this.extractFulltext));
                    }
                    catch (Exception e) {
                        log.error("Not indexing {} due to error: {}", (Object)entryURI, (Object)e.getMessage());
                    }
                } else {
                    log.debug("Not adding deleted entry to post queue: {}", (Object)entryURI);
                }
            }
        }
        finally {
            pm.setAuthenticatedUserURI(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Entry entry) {
        URI entryURI = entry.getEntryURI();
        Object object = this.postQueue;
        synchronized (object) {
            this.postQueue.invalidate((Object)entryURI);
        }
        object = this.deleteQueue;
        synchronized (object) {
            log.info("Adding entry to Solr delete queue: " + String.valueOf(entryURI));
            this.deleteQueue.add(entryURI);
        }
        if (GraphType.Context.equals((Object)entry.getGraphType())) {
            this.clearSolrIndex(this.solrServer, null, entry);
        }
    }

    private long sendQueryForEntryURIs(SolrQuery query, Set<URI> result, List<FacetField> facetFields, SolrClient solrServer, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query object must not be null");
        }
        if (offset > -1) {
            query.setStart(Integer.valueOf(offset));
        }
        if (limit > -1) {
            query.setRows(Integer.valueOf(limit));
        }
        query.setFields(new String[]{"uri"});
        long hits = -1L;
        try {
            QueryResponse r = solrServer.query((SolrParams)query);
            r.getElapsedTime();
            if (r.getFacetFields() != null) {
                facetFields.addAll(r.getFacetFields());
            }
            SolrDocumentList docs = r.getResults();
            hits = docs.getNumFound();
            for (SolrDocument solrDocument : docs) {
                String uri;
                if (!solrDocument.containsKey((Object)"uri") || (uri = (String)solrDocument.getFieldValue("uri")) == null) continue;
                result.add(URI.create(uri));
            }
            log.debug("Query time: {} ms, elapsed time: {} ms", (Object)r.getQTime(), (Object)r.getElapsedTime());
        }
        catch (IOException | SolrServerException e) {
            if (e instanceof SolrServerException && ((SolrServerException)e).getRootCause() instanceof IllegalArgumentException) {
                log.info(e.getMessage());
            }
            log.error(e.getMessage());
        }
        return hits;
    }

    public QueryResult sendQuery(SolrQuery query) throws SolrException {
        LinkedHashSet<Entry> result = new LinkedHashSet<Entry>();
        long hits = -1L;
        long inaccessibleHits = 0L;
        int limit = query.getRows();
        int offset = query.getStart();
        ArrayList<FacetField> facetFields = new ArrayList<FacetField>();
        query.setIncludeScore(true);
        int resultFillIteration = 0;
        do {
            if (resultFillIteration++ > 0) {
                if (resultFillIteration == 1 && limit <= 10) {
                    query.setRows(Integer.valueOf(100));
                }
                if (resultFillIteration > 10) {
                    log.warn("Breaking after 10 result fill interations to prevent too many loops");
                    break;
                }
                log.warn("Increasing offset to " + (offset += Math.min(limit, 50)) + " in an attempt to fill the result limit");
            }
            LinkedHashSet<URI> entryURIs = new LinkedHashSet<URI>();
            hits = this.sendQueryForEntryURIs(query, entryURIs, facetFields, this.solrServer, offset, -1);
            Date before = new Date();
            for (URI uri : entryURIs) {
                try {
                    Entry entry = this.rm.getContextManager().getEntry(uri);
                    if (entry == null) continue;
                    if (entry.isDeleted()) {
                        log.warn("Deleted entry {} is still in Solr index, removing it now", (Object)uri);
                        this.removeEntry(entry);
                        throw new IllegalStateException("Cannot return deleted entry in search result: " + String.valueOf(uri));
                    }
                    PrincipalManager pm = entry.getRepositoryManager().getPrincipalManager();
                    if ((entry.getEntryType() == EntryType.Reference || entry.getEntryType() == EntryType.LinkReference) && entry.getCachedExternalMetadata() instanceof LocalMetadataWrapper) {
                        Entry refEntry = entry.getRepositoryManager().getContextManager().getEntry(entry.getExternalMetadataURI());
                        if (refEntry != null) {
                            pm.checkAuthenticatedUserAuthorized(refEntry, PrincipalManager.AccessProperty.ReadMetadata);
                        } else {
                            log.error("Entry {} contains reference to non-existing resource.", (Object)entry.getEntryURI());
                        }
                    } else {
                        pm.checkAuthenticatedUserAuthorized(entry, PrincipalManager.AccessProperty.ReadMetadata);
                    }
                    result.add(entry);
                    if (result.size() != limit) continue;
                    break;
                }
                catch (IllegalStateException | AuthorizationException e) {
                    ++inaccessibleHits;
                }
            }
            log.info("Entry fetching took " + (new Date().getTime() - before.getTime()) + " ms");
        } while (limit > result.size() && hits > (long)(offset + limit));
        long adjustedHitCount = hits - inaccessibleHits;
        if (result.isEmpty() && hits > 0L) {
            adjustedHitCount = 0L;
        }
        if (adjustedHitCount < 0L) {
            log.warn("Adjusted hit count is negative, this should not happen");
        }
        return new QueryResult(result, adjustedHitCount, facetFields);
    }

    public SolrDocument fetchDocument(String uri) {
        try {
            SolrQuery q = new SolrQuery("uri:" + ClientUtils.escapeQueryChars((String)uri));
            q.setStart(Integer.valueOf(0));
            q.setRows(Integer.valueOf(1));
            QueryResponse r = this.solrServer.query((SolrParams)q);
            SolrDocumentList docs = r.getResults();
            if (!docs.isEmpty()) {
                return (SolrDocument)docs.getFirst();
            }
        }
        catch (IOException | SolrServerException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static String extractFulltext(File f) {
        return null;
    }

    public class SolrInputDocumentSubmitter
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!SolrInputDocumentSubmitter.interrupted()) {
                SolrSearchIndex.this.postQueue.cleanUp();
                if (SolrSearchIndex.this.postQueue.estimatedSize() > 0L || !SolrSearchIndex.this.deleteQueue.isEmpty()) {
                    UpdateRequest delReq;
                    int batchCount;
                    if (!SolrSearchIndex.this.deleteQueue.isEmpty()) {
                        StringBuilder deleteQuery = new StringBuilder("uri:(");
                        Queue<URI> queue = SolrSearchIndex.this.deleteQueue;
                        synchronized (queue) {
                            URI uri;
                            for (batchCount = 0; batchCount < 100 && (uri = SolrSearchIndex.this.deleteQueue.poll()) != null; ++batchCount) {
                                if (batchCount > 0) {
                                    deleteQuery.append(" OR ");
                                }
                                deleteQuery.append(ClientUtils.escapeQueryChars((String)uri.toString()));
                            }
                        }
                        deleteQuery.append(")");
                        if (batchCount > 0) {
                            delReq = new UpdateRequest();
                            String deleteQueryStr = deleteQuery.toString();
                            delReq.deleteByQuery(deleteQueryStr);
                            delReq.setCommitWithin(1000);
                            try {
                                log.info("Sending request to delete " + batchCount + " entries from Solr, " + SolrSearchIndex.this.deleteQueue.size() + " entries remaining in delete queue");
                                delReq.process(SolrSearchIndex.this.solrServer);
                            }
                            catch (IOException | SolrServerException e) {
                                log.error(e.getMessage(), e);
                            }
                        }
                    }
                    if (SolrSearchIndex.this.postQueue.estimatedSize() <= 0L) continue;
                    UpdateRequest addReq = new UpdateRequest();
                    delReq = SolrSearchIndex.this.postQueue;
                    synchronized (delReq) {
                        ConcurrentMap postQueueMap = SolrSearchIndex.this.postQueue.asMap();
                        Iterator it = postQueueMap.keySet().iterator();
                        while (batchCount < 100 && it.hasNext()) {
                            URI key = (URI)it.next();
                            SolrInputDocument doc = (SolrInputDocument)postQueueMap.get(key);
                            postQueueMap.remove(key, doc);
                            if (doc == null) {
                                log.warn("Value for key " + String.valueOf(key) + " is null in Solr submit queue");
                            }
                            addReq.add(doc);
                            ++batchCount;
                        }
                    }
                    try {
                        SolrSearchIndex.this.postQueue.cleanUp();
                        log.info("Sending {} entries to Solr, {} entries remaining in post queue", (Object)(addReq.getDocuments() != null ? addReq.getDocuments().size() : 0), (Object)SolrSearchIndex.this.postQueue.estimatedSize());
                        if (SolrSearchIndex.this.postQueue.estimatedSize() > 500L) {
                            addReq.setCommitWithin(10000);
                        } else {
                            addReq.setCommitWithin(1000);
                        }
                        addReq.process(SolrSearchIndex.this.solrServer);
                    }
                    catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
                        log.error(e.getMessage(), e);
                    }
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    log.info("Solr document submitter got interrupted, shutting down submitter thread");
                    return;
                }
            }
        }
    }

    public class DelayedContextIndexer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!DelayedContextIndexer.interrupted()) {
                Map<URI, DelayedContextIndexerInfo> map = SolrSearchIndex.this.delayedReindex;
                synchronized (map) {
                    Iterator<URI> it = SolrSearchIndex.this.delayedReindex.keySet().iterator();
                    while (it.hasNext()) {
                        URI contextURI = it.next();
                        DelayedContextIndexerInfo info = SolrSearchIndex.this.delayedReindex.get(contextURI);
                        if (info.submitted.until(LocalDateTime.now(), ChronoUnit.SECONDS) < 10L) continue;
                        log.info("Submitting context for reindexing after 10 seconds delay");
                        SolrSearchIndex.this.reindex(contextURI, false);
                        it.remove();
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    log.info("Solr delayed context indexer got interrupted, shutting down thread");
                    return;
                }
            }
        }
    }

    public static class DelayedContextIndexerInfo {
        LocalDateTime submitted;
        boolean guestReadable;
    }

    public static class FacetSettings {
        public String fields;
        public int minCount;
        public int limit;
        public String matches;
        public boolean missing;
    }
}

