/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import lombok.Generated;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.io.FileCleaningTracker;
import org.entrystore.ContextManager;
import org.entrystore.Converter;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.config.Config;
import org.entrystore.harvester.Harvester;
import org.entrystore.harvester.factory.HarvesterFactoryException;
import org.entrystore.harvesting.oaipmh.harvester.factory.OAIHarvesterFactory;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.impl.converters.ConverterManagerImpl;
import org.entrystore.impl.converters.OAI_DC2RDFGraphConverter;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.backup.BackupScheduler;
import org.entrystore.repository.config.ConfigurationManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.Password;
import org.entrystore.repository.test.TestSuite;
import org.entrystore.rest.auth.BasicVerifier;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.auth.SimpleAuthenticator;
import org.entrystore.rest.auth.UserTempLockoutCache;
import org.entrystore.rest.filter.CORSFilter;
import org.entrystore.rest.filter.CacheControlFilter;
import org.entrystore.rest.filter.IgnoreAuthFilter;
import org.entrystore.rest.filter.JSCallbackFilter;
import org.entrystore.rest.filter.ModificationLockOutFilter;
import org.entrystore.rest.filter.PerformanceMetricsFilter;
import org.entrystore.rest.resources.CasLoginResource;
import org.entrystore.rest.resources.ContextResource;
import org.entrystore.rest.resources.CookieLoginResource;
import org.entrystore.rest.resources.DefaultResource;
import org.entrystore.rest.resources.EchoResource;
import org.entrystore.rest.resources.EntryResource;
import org.entrystore.rest.resources.ExecutionResource;
import org.entrystore.rest.resources.ExportResource;
import org.entrystore.rest.resources.ExternalMetadataResource;
import org.entrystore.rest.resources.FaviconResource;
import org.entrystore.rest.resources.GroupResource;
import org.entrystore.rest.resources.HarvesterResource;
import org.entrystore.rest.resources.ImportResource;
import org.entrystore.rest.resources.IndexResource;
import org.entrystore.rest.resources.LegacySamlLoginResource;
import org.entrystore.rest.resources.LocalMetadataResource;
import org.entrystore.rest.resources.LoggingResource;
import org.entrystore.rest.resources.LoginResource;
import org.entrystore.rest.resources.LogoutResource;
import org.entrystore.rest.resources.LookupResource;
import org.entrystore.rest.resources.MergeResource;
import org.entrystore.rest.resources.MergedMetadataResource;
import org.entrystore.rest.resources.MessageResource;
import org.entrystore.rest.resources.NameResource;
import org.entrystore.rest.resources.PasswordResetResource;
import org.entrystore.rest.resources.PerformanceMetricsResource;
import org.entrystore.rest.resources.ProxyResource;
import org.entrystore.rest.resources.QuotaResource;
import org.entrystore.rest.resources.RelationResource;
import org.entrystore.rest.resources.ResourceResource;
import org.entrystore.rest.resources.SamlLoginResource;
import org.entrystore.rest.resources.SearchResource;
import org.entrystore.rest.resources.ShutdownResource;
import org.entrystore.rest.resources.SignupResource;
import org.entrystore.rest.resources.SolrResource;
import org.entrystore.rest.resources.SparqlResource;
import org.entrystore.rest.resources.StatisticsResource;
import org.entrystore.rest.resources.StatusResource;
import org.entrystore.rest.resources.TokenResource;
import org.entrystore.rest.resources.UserResource;
import org.entrystore.rest.resources.ValidatorResource;
import org.entrystore.rest.util.CORSUtil;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Reference;
import org.restlet.routing.Filter;
import org.restlet.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryStoreApplication
extends Application {
    static Logger log = LoggerFactory.getLogger(EntryStoreApplication.class);
    public static final String KEY = EntryStoreApplication.class.getCanonicalName();
    public static final String ENV_CONFIG_URI = "ENTRYSTORE_CONFIG_URI";
    public static final String OAI_DC = "oai_dc";
    public static final String RDN_DC = "rdn_dc";
    private static Date startupDate;
    private RepositoryManagerImpl rm;
    private BackupScheduler backupScheduler;
    private ArrayList<Harvester> harvesters = new ArrayList();
    private final Component component;
    private final ContextManager cm;
    private final PrincipalManager pm;
    private LoginTokenCache loginTokenCache = null;
    private final UserTempLockoutCache userTempLockoutCache;
    private final Set<String> reservedNames = new HashSet<String>();

    public EntryStoreApplication(org.restlet.Context parentContext) {
        this(null, parentContext, null);
    }

    public EntryStoreApplication(URI configPath, org.restlet.Context parentContext, Component component) {
        this(configPath, null, parentContext, component);
    }

    public EntryStoreApplication(URI configPath, Map<String, String> configOverride, org.restlet.Context parentContext, Component component) {
        super(parentContext);
        Date startupBegin = new Date();
        this.component = component;
        URI configURI = configPath;
        this.getContext().getAttributes().put(KEY, this);
        this.getRangeService().setEnabled(false);
        log.warn("Restlet RangeService deactivated");
        if (EntryStoreApplication.getServletContext(this.getContext()) != null) {
            this.rm = (RepositoryManagerImpl)EntryStoreApplication.getServletContext(this.getContext()).getAttribute("RepositoryManager");
        }
        if (this.rm != null) {
            log.info("EntryStore initialized with a ServletContextListener");
            this.cm = this.rm.getContextManager();
            this.pm = this.rm.getPrincipalManager();
            Config config = this.rm.getConfiguration();
            this.loginTokenCache = new LoginTokenCache(config);
            this.harvesters = (ArrayList)this.getContext().getAttributes().get("Harvesters");
            this.backupScheduler = (BackupScheduler)this.getContext().getAttributes().get("BackupScheduler");
            this.userTempLockoutCache = null;
        } else {
            ConfigurationManager confManager;
            if (configURI == null) {
                String envConfigURI = System.getenv(ENV_CONFIG_URI);
                if (envConfigURI != null) {
                    configURI = URI.create(envConfigURI);
                } else {
                    try {
                        Context env = (Context)new InitialContext().lookup("java:comp/env");
                        if (env != null && env.lookup("entrystore.config") != null) {
                            configURI = new File((String)env.lookup("entrystore.config")).toURI();
                        }
                    }
                    catch (NamingException e) {
                        log.warn(e.getMessage());
                    }
                }
            }
            try {
                if (configURI != null) {
                    log.info("Manually specified config location at {}", (Object)configURI);
                    confManager = new ConfigurationManager(configURI);
                } else {
                    log.info("No config location specified, looking within classpath");
                    confManager = new ConfigurationManager(ConfigurationManager.getConfigurationURI());
                }
            }
            catch (IOException e) {
                confManager = null;
                log.error("Unable to load configuration: {}", (Object)e.getMessage());
                System.exit(1);
            }
            Config config = confManager.getConfiguration();
            if (configOverride != null) {
                config.getProperties().putAll(configOverride);
            }
            System.setProperty(Settings.RDF4J_SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES, config.getString(Settings.RDF4J_SOFT_FAIL_ON_CORRUPT_DATA_AND_REPAIR_INDEXES, "false"));
            String baseURI = config.getString(Settings.BASE_URL);
            if (baseURI == null) {
                log.error("No Base URI specified, exiting");
                System.exit(1);
            }
            OAI_DC2RDFGraphConverter oaiDcRdfConverter = new OAI_DC2RDFGraphConverter();
            ConverterManagerImpl.register((String)OAI_DC, (Converter)oaiDcRdfConverter);
            ConverterManagerImpl.register((String)RDN_DC, (Converter)oaiDcRdfConverter);
            this.rm = new RepositoryManagerImpl(baseURI, confManager.getConfiguration());
            this.cm = this.rm.getContextManager();
            this.pm = this.rm.getPrincipalManager();
            this.userTempLockoutCache = new UserTempLockoutCache((RepositoryManager)this.rm, this.pm);
            this.loginTokenCache = new LoginTokenCache(confManager.getConfiguration());
            Password.loadRules((Config)config);
            if ("on".equalsIgnoreCase(config.getString(Settings.STORE_INIT_WITH_TEST_DATA, "off"))) {
                Entry donald = this.rm.getPrincipalManager().getPrincipalEntry("Donald");
                if (donald == null) {
                    log.info("Initializing store with test data");
                    TestSuite.initDisneySuite((RepositoryManager)this.rm);
                    TestSuite.addEntriesInDisneySuite((RepositoryManager)this.rm);
                } else {
                    log.warn("Test data is already present, not loading it again");
                }
            }
            this.startHarvesters();
            boolean backup = "on".equalsIgnoreCase(this.rm.getConfiguration().getString(Settings.BACKUP_SCHEDULER, "off"));
            if (backup) {
                log.info("Starting backup scheduler");
                this.startBackupScheduler();
            } else {
                log.warn("Backup is disabled in configuration");
            }
        }
        startupDate = new Date();
        log.info("EntryStore startup completed in {} ms", (Object)(startupDate.getTime() - startupBegin.getTime()));
    }

    public synchronized Restlet createInboundRoot() {
        Config config = this.rm.getConfiguration();
        Router router = new Router(this.getContext());
        boolean passwordAuthOff = "off".equalsIgnoreCase(config.getString(Settings.AUTH_PASSWORD, "on"));
        this.reservedNames.add("favicon.ico");
        router.attach("/favicon.ico", FaviconResource.class);
        this.reservedNames.add("echo");
        router.attach("/echo", EchoResource.class);
        this.reservedNames.add("lookup");
        router.attach("/lookup", LookupResource.class);
        this.reservedNames.add("proxy");
        router.attach("/proxy", ProxyResource.class);
        this.reservedNames.add("search");
        router.attach("/search", SearchResource.class);
        this.reservedNames.add("sparql");
        router.attach("/sparql", SparqlResource.class);
        this.reservedNames.add("validator");
        router.attach("/validator", ValidatorResource.class);
        this.reservedNames.add("message");
        router.attach("/message", MessageResource.class);
        this.reservedNames.add("auth");
        if (!passwordAuthOff) {
            router.attach("/auth/cookie", CookieLoginResource.class);
            router.attach("/auth/login", LoginResource.class);
        }
        router.attach("/auth/user", UserResource.class);
        router.attach("/auth/basic", UserResource.class);
        router.attach("/auth/logout", LogoutResource.class);
        router.attach("/auth/tokens", TokenResource.class);
        if ("on".equalsIgnoreCase(config.getString(Settings.AUTH_CAS, "off"))) {
            router.attach("/auth/cas", CasLoginResource.class);
            log.info("CAS authentication enabled");
        }
        if ("on".equalsIgnoreCase(config.getString(Settings.AUTH_SAML))) {
            router.attach("/auth/saml", LegacySamlLoginResource.class);
            log.info("Legacy SAML authentication enabled");
        } else if ("new".equalsIgnoreCase(config.getString(Settings.AUTH_SAML))) {
            router.attach("/auth/saml", SamlLoginResource.class);
            log.info("SAML authentication enabled");
        }
        if ("on".equalsIgnoreCase(config.getString(Settings.SIGNUP, "off"))) {
            router.attach("/auth/signup", SignupResource.class);
        }
        if ("on".equalsIgnoreCase(config.getString(Settings.AUTH_PASSWORD_RESET, "off"))) {
            router.attach("/auth/pwreset", PasswordResetResource.class);
        }
        this.reservedNames.add("management");
        router.attach("/management/logging", LoggingResource.class);
        router.attach("/management/status", StatusResource.class);
        router.attach("/management/solr", SolrResource.class);
        router.attach("/management/metrics", PerformanceMetricsResource.class);
        router.attach("/management/shutdown", ShutdownResource.class);
        router.attach("/{context-id}", ContextResource.class);
        router.attach("/{context-id}/sparql", SparqlResource.class);
        router.attach("/{context-id}/export", ExportResource.class);
        router.attach("/{context-id}/import", ImportResource.class);
        router.attach("/{context-id}/merge", MergeResource.class);
        router.attach("/{context-id}/statistics/{stat-type}", StatisticsResource.class);
        router.attach("/{context-id}/entry/{entry-id}", EntryResource.class);
        router.attach("/{context-id}/entry/{entry-id}/index", IndexResource.class);
        router.attach("/{context-id}/entry/{entry-id}/name", NameResource.class);
        router.attach("/{context-id}/resource/{entry-id}", ResourceResource.class);
        router.attach("/{context-id}/metadata/{entry-id}", LocalMetadataResource.class);
        router.attach("/{context-id}/cached-external-metadata/{entry-id}", ExternalMetadataResource.class);
        router.attach("/{context-id}/merged-metadata/{entry-id}", MergedMetadataResource.class);
        router.attach("/{context-id}/harvester", HarvesterResource.class);
        router.attach("/{context-id}/relations/{entry-id}", RelationResource.class);
        router.attach("/{context-id}/quota", QuotaResource.class);
        router.attach("/{context-id}/lookup", LookupResource.class);
        router.attach("/{context-id}/execute", ExecutionResource.class);
        router.attach("/{context-id}/proxy", ProxyResource.class);
        router.attach("/_principals/groups", GroupResource.class);
        router.attachDefault(DefaultResource.class);
        CORSFilter corsFilter = new CORSFilter(CORSUtil.getInstance(config));
        boolean optional = !config.getBoolean(Settings.AUTH_COOKIE_INVALID_TOKEN_ERROR, true);
        CookieVerifier cookieVerifier = new CookieVerifier(this, (RepositoryManager)this.rm, corsFilter);
        SimpleAuthenticator cookieAuth = new SimpleAuthenticator(this.getContext(), optional, ChallengeScheme.HTTP_COOKIE, "EntryStore", cookieVerifier, this.pm);
        IgnoreAuthFilter ignoreAuth = new IgnoreAuthFilter();
        ModificationLockOutFilter modLockOut = new ModificationLockOutFilter();
        JSCallbackFilter jsCallback = new JSCallbackFilter(config);
        CacheControlFilter cacheControl = new CacheControlFilter();
        PerformanceMetricsFilter performanceMetrics = new PerformanceMetricsFilter();
        ignoreAuth.setNext((Restlet)cookieAuth);
        if (passwordAuthOff || !config.getBoolean(Settings.AUTH_HTTP_BASIC, false)) {
            cookieAuth.setNext((Restlet)jsCallback);
        } else {
            SimpleAuthenticator basicAuth = new SimpleAuthenticator(this.getContext(), false, ChallengeScheme.HTTP_BASIC, "EntryStore", new BasicVerifier(this.pm, config), this.pm);
            cookieAuth.setNext((Restlet)basicAuth);
            basicAuth.setNext((Restlet)jsCallback);
        }
        jsCallback.setNext((Restlet)performanceMetrics);
        performanceMetrics.setNext((Restlet)cacheControl);
        cacheControl.setNext((Restlet)modLockOut);
        if ("on".equalsIgnoreCase(config.getString(Settings.CORS, "off"))) {
            log.info("Enabling CORS");
            modLockOut.setNext((Restlet)corsFilter);
            corsFilter.setNext((Restlet)router);
        } else {
            modLockOut.setNext((Restlet)router);
        }
        if (config.getBoolean(Settings.REPOSITORY_REWRITE_BASEREFERENCE, true)) {
            log.info("Rewriting of base reference is enabled");
            Filter referenceFix = new Filter(this.getContext()){

                protected int beforeHandle(Request request, Response response) {
                    Reference origRef = request.getResourceRef();
                    String newBaseRef = EntryStoreApplication.this.rm.getRepositoryURL().toString();
                    if (newBaseRef.endsWith("/")) {
                        newBaseRef = newBaseRef.substring(0, newBaseRef.length() - 1);
                    }
                    origRef.setIdentifier(newBaseRef + origRef.getRemainingPart());
                    origRef.setBaseRef(newBaseRef);
                    return super.beforeHandle(request, response);
                }
            };
            referenceFix.setNext((Restlet)ignoreAuth);
            return referenceFix;
        }
        log.warn("Rewriting of base reference has been manually disabled");
        return ignoreAuth;
    }

    public ContextManager getCM() {
        return this.cm;
    }

    public PrincipalManager getPM() {
        return this.pm;
    }

    public RepositoryManagerImpl getRM() {
        return this.rm;
    }

    private void startBackupScheduler() {
        URI userURI = this.getPM().getAuthenticatedUserURI();
        try {
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            BackupScheduler bs = BackupScheduler.getInstance((RepositoryManager)this.rm);
            if (bs != null) {
                this.backupScheduler = bs;
                bs.run();
            }
        }
        finally {
            this.getPM().setAuthenticatedUserURI(userURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHarvesters() {
        URI realURI = this.getPM().getAuthenticatedUserURI();
        try {
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            Set entries = this.getCM().getEntries();
            for (URI entryURI : entries) {
                OAIHarvesterFactory fac;
                Entry entry = this.getCM().getByEntryURI(entryURI);
                if (entry == null) {
                    log.warn("Entry with URI {} cannot be found and is null", (Object)entryURI);
                    continue;
                }
                if (entry.getGraphType() != GraphType.Context || !(fac = new OAIHarvesterFactory()).isOAIHarvester(entry)) continue;
                try {
                    Harvester har = fac.getHarvester(this.rm, entry.getEntryURI());
                    har.run();
                    this.harvesters.add(har);
                }
                catch (HarvesterFactoryException e) {
                    log.error(e.getMessage());
                }
            }
        }
        finally {
            this.getPM().setAuthenticatedUserURI(realURI);
        }
    }

    public static String getVersion() {
        return RepositoryManagerImpl.getVersion();
    }

    public synchronized void stop() throws Exception {
        FileCleaningTracker fct;
        log.info("Shutting down");
        if (this.rm != null) {
            this.rm.shutdown();
        }
        if (EntryStoreApplication.getServletContext(this.getContext()) != null && (fct = FileCleanerCleanup.getFileCleaningTracker((ServletContext)EntryStoreApplication.getServletContext(this.getContext()))) != null) {
            log.info("Shutting down file cleaning tracker");
            fct.exitWhenFinished();
        }
        super.stop();
    }

    public static ServletContext getServletContext(org.restlet.Context context) {
        ServletContext sc = null;
        org.restlet.Context c = context.getServerDispatcher().getContext();
        if (c != null) {
            sc = (ServletContext)c.getAttributes().get("org.restlet.ext.servlet.ServletContext");
        }
        if (sc == null) {
            sc = (ServletContext)context.getAttributes().get("org.restlet.ext.servlet.ServletContext");
        }
        return sc;
    }

    public void shutdownServer() {
        if (this.component != null) {
            log.info("Shutting down server");
            try {
                this.component.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to stop server", e);
            }
        } else {
            log.info("Failed to shutdown server, component not set");
        }
    }

    @Generated
    public static Date getStartupDate() {
        return startupDate;
    }

    @Generated
    public ArrayList<Harvester> getHarvesters() {
        return this.harvesters;
    }

    @Generated
    public LoginTokenCache getLoginTokenCache() {
        return this.loginTokenCache;
    }

    @Generated
    public UserTempLockoutCache getUserTempLockoutCache() {
        return this.userTempLockoutCache;
    }

    @Generated
    public Set<String> getReservedNames() {
        return this.reservedNames;
    }
}

