/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.stream.Collectors;
import org.entrystore.config.Config;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.auth.TokenCache;
import org.entrystore.rest.auth.UserInfo;
import org.entrystore.rest.util.HttpUtil;
import org.restlet.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginTokenCache
extends TokenCache<String, UserInfo> {
    private static final Logger log = LoggerFactory.getLogger(LoginTokenCache.class);
    private static final int DEFAULT_MAX_AGE_IN_SECONDS = (int)Duration.ofDays(1L).toSeconds();
    private final boolean configTokenUpdateExpiry;
    public final int MAX_AGE_IN_SECONDS;

    public LoginTokenCache(Config config) {
        this.configTokenUpdateExpiry = config.getBoolean(Settings.AUTH_COOKIE_REFRESH_EXPIRATION_ON_ACCESS, true);
        this.MAX_AGE_IN_SECONDS = config.getInt(Settings.AUTH_TOKEN_MAX_AGE, config.getInt(Settings.AUTH_COOKIE_MAX_AGE, DEFAULT_MAX_AGE_IN_SECONDS));
    }

    public boolean isTokenUpdateExpiry() {
        return this.configTokenUpdateExpiry;
    }

    public int getMaxAgeInSeconds() {
        return this.MAX_AGE_IN_SECONDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Map map = this.tokenCache;
        synchronized (map) {
            this.tokenCache.entrySet().removeIf(userInfo -> ((UserInfo)userInfo.getValue()).getLoginExpiration().isBefore(LocalDateTime.now()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokens(String userName) {
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0, (Object)"userName must not be null");
        Map map = this.tokenCache;
        synchronized (map) {
            this.tokenCache.entrySet().removeIf(userInfo -> userName.equals(((UserInfo)userInfo.getValue()).getUserName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeToken(String token) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token must not be null");
        Map map = this.tokenCache;
        synchronized (map) {
            if (this.tokenCache.containsKey(token)) {
                this.tokenCache.remove(token);
            } else {
                log.warn("Token not found in cache");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokensButOne(String token) {
        if (token == null) {
            log.warn("Token is null, authenticated via HTTP Basic?");
            return;
        }
        Map map = this.tokenCache;
        synchronized (map) {
            if (this.tokenCache.containsKey(token)) {
                String userName = ((UserInfo)this.tokenCache.get(token)).getUserName();
                this.tokenCache.entrySet().removeIf(userInfo -> userName.equals(((UserInfo)userInfo.getValue()).getUserName()) && !token.equals(userInfo.getKey()));
            } else {
                log.warn("Token not found in cache");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameUser(String oldUserName, String newUserName) {
        if (oldUserName == null || newUserName == null) {
            throw new IllegalArgumentException("Username must not be null");
        }
        Map map = this.tokenCache;
        synchronized (map) {
            for (Map.Entry e : this.tokenCache.entrySet()) {
                UserInfo oldUi = (UserInfo)e.getValue();
                if (!oldUserName.equals(oldUi.userName)) continue;
                UserInfo newUi = new UserInfo(newUserName, oldUi.getLoginTime(), oldUi.getLoginTokenMaxAge());
                newUi.setLoginExpiration(oldUi.getLoginExpiration());
                newUi.setLastAccessTime(oldUi.getLastAccessTime());
                newUi.setLastUsedIpAddress(oldUi.getLastUsedIpAddress());
                newUi.setLastUsedUserAgent(oldUi.getLastUsedUserAgent());
                this.tokenCache.put((String)e.getKey(), newUi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, UserInfo> getTokens(String userName) {
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0, (Object)"Username must not be null");
        Map map = this.tokenCache;
        synchronized (map) {
            return this.tokenCache.entrySet().stream().filter(entry -> userName.equals(((UserInfo)entry.getValue()).getUserName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public UserInfo registerUserInteraction(String token, Request request) {
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"Token must not be null");
        UserInfo userInfo = (UserInfo)this.getTokenValue(token);
        if (userInfo == null) {
            log.debug("Call to registerUserInteraction with non-existent token [{}]", (Object)token);
            return null;
        }
        userInfo.setLastUsedUserAgent(request.getClientInfo().getAgent());
        userInfo.setLastAccessTime(LocalDateTime.now());
        userInfo.setLastUsedIpAddress(HttpUtil.getClientIpAddress(request));
        if (this.configTokenUpdateExpiry) {
            userInfo.setLoginExpiration(userInfo.getLastAccessTime().plusSeconds(userInfo.getLoginTokenMaxAge()));
        }
        return userInfo;
    }
}

