/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignupInfo {
    private static final Logger log = LoggerFactory.getLogger(SignupInfo.class);
    private String firstName;
    private String lastName;
    private String email;
    private String saltedHashedPassword;
    private Instant expirationDate;
    private String urlSuccess;
    private String urlFailure;
    private Map<String, String> customProperties;
    private RepositoryManager rm;
    private static List<String> permittedBaseUrls;

    public SignupInfo(RepositoryManager rm) {
        this.rm = rm;
        if (permittedBaseUrls == null) {
            String repoUrl = rm.getRepositoryURL().toString();
            permittedBaseUrls = new ArrayList<String>();
            if (StringUtils.countMatches((CharSequence)repoUrl, (char)'/') > 2) {
                permittedBaseUrls.add(repoUrl.substring(0, StringUtils.ordinalIndexOf((CharSequence)repoUrl, (CharSequence)"/", (int)3) + 1));
            } else {
                log.warn("Base URL is potentially misconfigured: {}", (Object)repoUrl);
            }
            permittedBaseUrls.addAll(rm.getConfiguration().getStringList(Settings.AUTH_PERMITTED_REDIRECTS, new ArrayList()));
        }
    }

    public void setUrlSuccess(String urlSuccess) {
        if (urlSuccess != null) {
            if (this.isPermittedRedirectUrl(urlSuccess)) {
                this.urlSuccess = urlSuccess;
            } else {
                log.warn("Redirect URL (success) is not permitted and will be ignored: {}", (Object)urlSuccess);
            }
        }
    }

    public void setUrlFailure(String urlFailure) {
        if (urlFailure != null) {
            if (this.isPermittedRedirectUrl(urlFailure)) {
                this.urlFailure = urlFailure;
            } else {
                log.warn("Redirect URL (failure) is not permitted and will be ignored: {}", (Object)urlFailure);
            }
        }
    }

    public void setEmail(@NonNull String email) {
        if (email == null) {
            throw new NullPointerException("email is marked non-null but is null");
        }
        this.email = email.toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPermittedRedirectUrl(@NonNull String redirectUrl) {
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl is marked non-null but is null");
        }
        for (String string : permittedBaseUrls) {
            void var3_3;
            if (!string.endsWith("/")) {
                String string2 = string + "/";
            }
            if (!redirectUrl.startsWith((String)var3_3)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getSaltedHashedPassword() {
        return this.saltedHashedPassword;
    }

    @Generated
    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    @Generated
    public String getUrlSuccess() {
        return this.urlSuccess;
    }

    @Generated
    public String getUrlFailure() {
        return this.urlFailure;
    }

    @Generated
    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    @Generated
    public RepositoryManager getRm() {
        return this.rm;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setSaltedHashedPassword(String saltedHashedPassword) {
        this.saltedHashedPassword = saltedHashedPassword;
    }

    @Generated
    public void setExpirationDate(Instant expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Generated
    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    @Generated
    public void setRm(RepositoryManager rm) {
        this.rm = rm;
    }
}

