/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.auth;

import java.time.Instant;
import java.util.Map;
import org.entrystore.rest.auth.SignupInfo;
import org.entrystore.rest.auth.TokenCache;

public class SignupTokenCache
extends TokenCache<String, SignupInfo> {
    private static SignupTokenCache instance;

    private SignupTokenCache() {
    }

    public static synchronized SignupTokenCache getInstance() {
        if (instance == null) {
            instance = new SignupTokenCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Map map = this.tokenCache;
        synchronized (map) {
            for (Map.Entry e : this.tokenCache.entrySet()) {
                if (!((SignupInfo)e.getValue()).getExpirationDate().isBefore(Instant.now())) continue;
                this.tokenCache.remove(e.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTokens(String userEmail) {
        Map map = this.tokenCache;
        synchronized (map) {
            this.tokenCache.entrySet().removeIf(userInfo -> userEmail.equals(((SignupInfo)userInfo.getValue()).getEmail()));
        }
    }
}

