/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.filter;

import org.entrystore.rest.util.CORSUtil;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.routing.Filter;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSFilter
extends Filter {
    private static final Logger log = LoggerFactory.getLogger(CORSFilter.class);
    private final CORSUtil cors;

    public CORSFilter(CORSUtil cors) {
        this.cors = cors;
    }

    protected void afterHandle(Request request, Response response) {
        if (request != null && response != null) {
            this.addCorsHeader(request, response);
        }
    }

    public void addCorsHeader(Request request, Response response) {
        Series reqHeaders;
        String origin;
        Method m = request.getMethod();
        if ((Method.GET.equals((Object)m) || Method.PUT.equals((Object)m) || Method.POST.equals((Object)m) || Method.DELETE.equals((Object)m) || Method.HEAD.equals((Object)m)) && (origin = (reqHeaders = (Series)request.getAttributes().get("org.restlet.http.headers")).getFirstValue("Origin", true)) != null) {
            if (!this.cors.isValidOrigin(origin) && !this.cors.isValidOriginWithCredentials(origin)) {
                log.debug("Received CORS request with disallowed origin");
                return;
            }
            response.setAccessControlAllowOrigin(origin);
            response.setAccessControlAllowCredentials(Boolean.valueOf(this.cors.isValidOriginWithCredentials(origin)));
            if (this.cors.getMaxAge() > -1) {
                response.setAccessControlMaxAge(this.cors.getMaxAge());
            }
            if (this.cors.getAllowedHeaders() != null) {
                response.setAccessControlAllowHeaders(this.cors.getAllowedHeaders());
                response.setAccessControlExposeHeaders(this.cors.getAllowedHeaders());
            }
        }
    }
}

