/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.filter;

import java.io.IOException;
import java.util.HashMap;
import org.entrystore.config.Config;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.util.Util;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.routing.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSCallbackFilter
extends Filter {
    private static final Logger log = LoggerFactory.getLogger(JSCallbackFilter.class);
    private final boolean enabled;

    public JSCallbackFilter(Config config) {
        this.enabled = config.getBoolean(Settings.JSONP, true);
    }

    protected void afterHandle(Request request, Response response) {
        HashMap<String, String> parameters;
        if (this.enabled && request != null && response != null && Method.GET.equals((Object)request.getMethod()) && response.getEntity() != null && this.isJSON(response.getEntity().getMediaType()) && (parameters = Util.parseRequest(request.getResourceRef().getRemainingPart())).containsKey("callback")) {
            String callback = parameters.get("callback");
            if (callback == null) {
                callback = "callback";
            }
            try {
                String wrappedResponse = callback + "(" + response.getEntity().getText() + ")";
                response.setEntity(wrappedResponse, MediaType.APPLICATION_JAVASCRIPT);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    private boolean isJSON(MediaType mediaType) {
        String mime = mediaType.toString();
        return "application/json".equals(mime) || "application/ld+json".equals(mime) || "application/rdf+json".equals(mime);
    }
}

