/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.Metadata;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.EntryUtil;
import org.entrystore.repository.util.NS;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.GraphUtil;
import org.entrystore.rest.util.JSONErrorMessages;
import org.entrystore.rest.util.Util;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(AbstractMetadataResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    private static final RDFFormat RDFJSON_WITH_APPLICATION_JSON = new RDFFormat("RDF/JSON", List.of("application/json"), StandardCharsets.UTF_8, List.of("json"), SimpleValueFactory.getInstance().createIRI("http://www.w3.org/ns/formats/RDF_JSON"), false, true, false);

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_RDF_XML);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.supportedMediaTypes.add(MediaType.TEXT_RDF_N3);
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIX.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIG.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.JSONLD.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType("application/rdf+json"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Get
    public Representation represent() {
        try {
            EmptyRepresentation result;
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
            }
            if (Method.GET.equals((Object)this.getRequest().getMethod())) {
                MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
                if (preferredMediaType == null) {
                    preferredMediaType = MediaType.APPLICATION_RDF_XML;
                }
                MediaType prefFormat = this.format != null ? this.format : preferredMediaType;
                String graphQuery = null;
                if (this.parameters.containsKey("graphQuery")) {
                    graphQuery = (String)this.parameters.get("graphQuery");
                }
                if (this.parameters.containsKey("recursive")) {
                    int depthMax;
                    String traversalParam = (String)this.parameters.get("recursive");
                    Set<URI> predicatesToFollow = this.resolvePredicates(traversalParam);
                    if (predicatesToFollow.isEmpty()) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        return null;
                    }
                    String firstDetectedProfile = this.getFirstProfile(traversalParam);
                    Map<String, String> blacklist = this.loadBlacklist(traversalParam);
                    int depth = 10;
                    int n = depthMax = firstDetectedProfile != null ? this.getRM().getConfiguration().getInt(this.traversalSetting(Settings.TRAVERSAL_PROFILE_MAX_DEPTH, firstDetectedProfile), depth) : depth;
                    if (depthMax < depth) {
                        depth = depthMax;
                    }
                    try {
                        int depthParam;
                        if (this.parameters.containsKey("depth") && (depthParam = Integer.parseInt((String)this.parameters.get("depth"))) > 0 && depthParam <= depth) {
                            depth = depthParam;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        return new StringRepresentation((CharSequence)("Error parsing depth parameter: " + e.getMessage()));
                    }
                    int limit = 1000;
                    limit = firstDetectedProfile != null ? this.getRM().getConfiguration().getInt(this.traversalSetting(Settings.TRAVERSAL_PROFILE_LIMIT, firstDetectedProfile), limit) : limit;
                    boolean repositoryScope = true;
                    boolean bl = repositoryScope = firstDetectedProfile != null ? this.getRM().getConfiguration().getBoolean(this.traversalSetting(Settings.TRAVERSAL_PROFILE_REPOSITORY_SCOPE, firstDetectedProfile), repositoryScope) : repositoryScope;
                    if (this.parameters.containsKey("scope")) {
                        repositoryScope = !"context".equalsIgnoreCase((String)this.parameters.get("scope"));
                    }
                    EntryUtil.TraversalResult travResult = this.traverse(this.entry.getEntryURI(), predicatesToFollow, blacklist, repositoryScope, depth, limit);
                    if (graphQuery != null) {
                        Model graphQueryResult = this.applyGraphQuery(graphQuery, travResult.getGraph());
                        if (graphQueryResult == null) {
                            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                            return null;
                        }
                        result = this.getRepresentation(graphQueryResult, prefFormat);
                    } else {
                        result = this.getRepresentation(travResult.getGraph(), prefFormat);
                    }
                    if (travResult.getLatestModified() != null) {
                        result.setModificationDate(travResult.getLatestModified());
                    }
                } else {
                    if (this.getMetadata() == null && this.getMetadataGraph() == null) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                        return null;
                    }
                    if (graphQuery != null) {
                        Model graphQueryResult = this.applyGraphQuery(graphQuery, this.getMetadataGraph());
                        if (graphQueryResult == null) {
                            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                            return null;
                        }
                        result = this.getRepresentation(graphQueryResult, prefFormat);
                    } else {
                        result = this.getRepresentation(this.getMetadataGraph(), prefFormat);
                    }
                }
                Object fileName = this.entry.getFilename();
                if (fileName == null) {
                    fileName = this.entry.getId();
                }
                fileName = (String)fileName + "." + AbstractMetadataResource.getFileExtensionForMediaType(prefFormat);
                Disposition disp = new Disposition();
                disp.setFilename((String)fileName);
                if (this.parameters.containsKey("download")) {
                    disp.setType("attachment");
                } else {
                    disp.setType("inline");
                }
                result.setDisposition(disp);
            } else {
                result = new EmptyRepresentation();
            }
            Date lastMod = this.getModificationDate();
            if (lastMod != null && result.getModificationDate() == null) {
                result.setModificationDate(lastMod);
                result.setTag(Util.createTag(lastMod));
            }
            return result;
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    @Put
    public void storeRepresentation(Representation r) {
        try {
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.errorEntryNotFound));
                return;
            }
            if (this.getMetadata() == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                return;
            }
            MediaType mt = this.format != null ? this.format : this.getRequestEntity().getMediaType();
            this.copyRepresentationToMetadata(r, this.getMetadata(), mt);
            this.getResponse().setEntity(this.createEmptyRepresentationWithLastModified(this.getModificationDate()));
        }
        catch (AuthorizationException e) {
            this.unauthorizedPUT();
        }
    }

    @Delete
    public void removeRepresentations() {
        try {
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.errorEntryNotFound));
                return;
            }
            if (this.getMetadata() == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                return;
            }
            this.getMetadata().setGraph((Model)new LinkedHashModel());
        }
        catch (AuthorizationException e) {
            this.unauthorizedDELETE();
        }
    }

    private Representation getRepresentation(Model graph, MediaType mediaType) throws AuthorizationException {
        String serializedGraph;
        if (graph != null && (serializedGraph = GraphUtil.serializeGraph(graph, mediaType)) != null) {
            this.getResponse().setStatus(Status.SUCCESS_OK);
            return new StringRepresentation((CharSequence)serializedGraph, mediaType);
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        return new EmptyRepresentation();
    }

    private void copyRepresentationToMetadata(Representation representation, Metadata metadata, MediaType mediaType) throws AuthorizationException {
        Model deserializedGraph;
        String graphString = null;
        try {
            graphString = representation.getText();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        if (metadata != null && graphString != null && (deserializedGraph = GraphUtil.deserializeGraph(graphString, mediaType)) != null) {
            this.getResponse().setStatus(Status.SUCCESS_OK);
            metadata.setGraph(deserializedGraph);
            return;
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
    }

    protected abstract Metadata getMetadata();

    protected Model getMetadataGraph() {
        if (this.getMetadata() != null) {
            return this.getMetadata().getGraph();
        }
        return null;
    }

    protected abstract Date getModificationDate();

    private EntryUtil.TraversalResult traverse(URI entryURI, Set<URI> predToFollow, Map<String, String> blacklist, boolean repository, int depth, int limit) {
        return EntryUtil.traverseAndLoadEntryMetadata((Set)ImmutableSet.of((Object)this.getRM().getValueFactory().createIRI(entryURI.toString())), predToFollow, blacklist, (int)0, (int)depth, (int)limit, (Multimap)HashMultimap.create(), (Context)(repository ? null : this.context), (RepositoryManager)this.getRM());
    }

    private Set<URI> resolvePredicates(String predCSV) {
        HashSet<URI> result = new HashSet<URI>();
        for (String s : predCSV.split(",")) {
            Set<URI> pSet = this.loadTraversalProfile(s);
            if (pSet.isEmpty()) {
                try {
                    URI expanded = NS.expand((String)s);
                    if (s.equals(expanded.toString())) continue;
                    result.add(URI.create(NS.expand((String)s).toString()));
                }
                catch (IllegalArgumentException iae) {
                    log.warn("Unable to expand namespace: {}", (Object)iae.getMessage());
                }
                continue;
            }
            result.addAll(pSet);
        }
        return result;
    }

    private String getFirstProfile(String predCSV) {
        for (String s : predCSV.split(",")) {
            if (this.loadTraversalProfile(s).isEmpty()) continue;
            return s;
        }
        return null;
    }

    private Map<String, String> loadBlacklist(String traversalParam) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : traversalParam.split(",")) {
            result.putAll(this.loadTraversalBlacklistForProfile(s));
        }
        return result;
    }

    private Set<URI> loadTraversalProfile(String profileName) {
        List predicates = this.getRM().getConfiguration().getStringList(this.traversalSetting(Settings.TRAVERSAL_PROFILE, profileName), new ArrayList());
        HashSet<URI> result = new HashSet<URI>();
        for (String s : predicates) {
            result.add(URI.create(s));
        }
        return result;
    }

    private Map<String, String> loadTraversalBlacklistForProfile(String profileName) {
        List blacklist = this.getRM().getConfiguration().getStringList(this.traversalSetting(Settings.TRAVERSAL_PROFILE_BLACKLIST, profileName), new ArrayList());
        HashMap<String, String> result = new HashMap<String, String>();
        for (String tuple : blacklist) {
            String[] tupleArr = tuple.split(",");
            if (tupleArr.length != 2) {
                log.warn("Invalid blacklist configuration in traversal profile " + profileName + ": " + tuple);
                continue;
            }
            result.put(NS.expand((String)tupleArr[0]).toString(), NS.expand((String)tupleArr[1]).toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model applyGraphQuery(String query, Model graph) {
        Date before = new Date();
        MemoryStore ms = new MemoryStore();
        SailRepository sr = new SailRepository((Sail)ms);
        Model result = null;
        RepositoryConnection rc = null;
        try {
            sr.init();
            rc = sr.getConnection();
            rc.add((Iterable)graph, new Resource[0]);
            GraphQuery gq = rc.prepareGraphQuery(QueryLanguage.SPARQL, query);
            gq.setMaxExecutionTime(10);
            result = (Model)Iterations.addAll((CloseableIteration)gq.evaluate(), (Collection)new LinkedHashModel());
            log.info("Graph query took " + (new Date().getTime() - before.getTime()) + " ms");
        }
        catch (QueryEvaluationException | RepositoryException e) {
            log.error(e.getMessage());
        }
        catch (MalformedQueryException mfqe) {
            log.debug(mfqe.getMessage());
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
            try {
                sr.shutDown();
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        return result;
    }

    protected static String getFileExtensionForMediaType(MediaType mt) {
        Optional rdfFormat = RDFFormat.matchMIMEType((String)mt.getName(), Arrays.asList(RDFFormat.RDFXML, RDFFormat.NTRIPLES, RDFFormat.TURTLE, RDFFormat.N3, RDFFormat.TRIX, RDFFormat.TRIG, RDFFormat.BINARY, RDFFormat.NQUADS, RDFFormat.JSONLD, RDFFormat.RDFJSON, RDFFormat.RDFA, RDFJSON_WITH_APPLICATION_JSON));
        if (rdfFormat.isPresent() && ((RDFFormat)rdfFormat.get()).getDefaultFileExtension() != null) {
            return ((RDFFormat)rdfFormat.get()).getDefaultFileExtension();
        }
        return "rdf";
    }

    private String traversalSetting(String configKey, String profile) {
        return String.format(configKey, profile);
    }
}

