/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.BasicVerifier;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.SimpleHTML;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas10TicketValidator;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Cas30ServiceTicketValidator;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasLoginResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(CasLoginResource.class);
    private static Protocol protocol;
    private static String casLoginUrl;
    private static String casServerUrlPrefix;
    private static TicketValidator ticketValidator;
    private static boolean sslVerificationInitialized;
    private static String redirSuccess;
    private static String redirFailure;

    @Override
    public void init(Context c, Request request, Response response) {
        super.init(c, request, response);
        Config config = this.getRM().getConfiguration();
        if (!sslVerificationInitialized) {
            if ("localhost".equals(URI.create(this.getBaseUrl()).getHost()) || config.getBoolean(Settings.HTTPS_DISABLE_VERIFICATION, false)) {
                CasLoginResource.disableSslVerification();
            }
            sslVerificationInitialized = true;
        }
        if (casServerUrlPrefix == null) {
            casServerUrlPrefix = config.getString(Settings.AUTH_CAS_SERVER_URL);
            if (casServerUrlPrefix == null) {
                log.warn("No CAS server URL configured");
            } else {
                log.info("CAS server URL: " + casServerUrlPrefix);
            }
        }
        if (casLoginUrl == null) {
            casLoginUrl = config.getString(Settings.AUTH_CAS_SERVER_LOGIN_URL);
            if (casLoginUrl == null && casServerUrlPrefix != null) {
                casLoginUrl = casServerUrlPrefix + (casServerUrlPrefix.endsWith("/") ? "" : "/") + "login";
            }
            log.info("CAS login URL: " + casLoginUrl);
        }
        if (protocol == null) {
            String casVersion = config.getString(Settings.AUTH_CAS_VERSION, "cas2");
            if ("cas1".equalsIgnoreCase(casVersion)) {
                protocol = Protocol.CAS1;
                ticketValidator = new Cas10TicketValidator(casServerUrlPrefix);
            } else if ("cas3".equalsIgnoreCase(casVersion)) {
                protocol = Protocol.CAS3;
                ticketValidator = new Cas30ServiceTicketValidator(casServerUrlPrefix);
            } else if ("saml11".equalsIgnoreCase(casVersion)) {
                protocol = Protocol.SAML11;
                ticketValidator = new Saml11TicketValidator(casServerUrlPrefix);
            } else {
                protocol = Protocol.CAS2;
                ticketValidator = new Cas20ServiceTicketValidator(casServerUrlPrefix);
            }
            log.info("CAS protocol: " + protocol.name());
        }
        redirSuccess = config.getString(Settings.AUTH_CAS_REDIRECT_SUCCESS_URL);
        redirFailure = config.getString(Settings.AUTH_CAS_REDIRECT_FAILURE_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get
    public Representation represent() {
        String ticket = (String)this.parameters.get(protocol.getArtifactParameterName());
        boolean html = MediaType.TEXT_HTML.equals((Object)this.getRequest().getClientInfo().getPreferredMediaType(Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ALL)));
        boolean authSuccess = false;
        EmptyRepresentation result = new EmptyRepresentation();
        if (ticket != null) {
            try {
                Assertion assertion = ticketValidator.validate(ticket, this.constructServiceUrl());
                log.info("Successfully authenticated via CAS: " + String.valueOf(assertion.getPrincipal()));
                Map attr = assertion.getPrincipal().getAttributes();
                for (String k : attr.keySet()) {
                    log.debug(k + ": " + String.valueOf(attr.get(k)));
                }
                String userName = assertion.getPrincipal().getName();
                if ("admin".equalsIgnoreCase(userName)) {
                    userName = null;
                }
                Config config = this.getRM().getConfiguration();
                boolean autoProvisioning = "on".equalsIgnoreCase(config.getString(Settings.AUTH_CAS_USER_AUTO_PROVISIONING, "off"));
                if (userName != null && !BasicVerifier.userExists(this.getPM(), userName)) {
                    if (!autoProvisioning) {
                        log.warn("User auto-provisioning is deactivated");
                    } else {
                        PrincipalManager pm = this.getPM();
                        URI authUser = pm.getAuthenticatedUserURI();
                        try {
                            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                            Entry entry = pm.createResource(null, GraphType.User, null, null);
                            if (entry != null) {
                                User u = (User)entry.getResource();
                                log.info("Created user " + String.valueOf(u.getURI()));
                                pm.setPrincipalName(entry.getResourceURI(), userName);
                            } else {
                                log.error("An error occured when creating the new user");
                            }
                        }
                        finally {
                            pm.setAuthenticatedUserURI(authUser);
                        }
                    }
                }
                if (userName != null && BasicVerifier.userExists(this.getPM(), userName) && !BasicVerifier.isUserDisabled(this.getPM(), userName)) {
                    EntryStoreApplication app = (EntryStoreApplication)this.getApplication();
                    new CookieVerifier(app, (RepositoryManager)this.getRM()).createAuthToken(userName, null, this.getRequest(), this.getResponse());
                    if (redirSuccess != null) {
                        this.getResponse().redirectTemporary(URLDecoder.decode(redirSuccess, StandardCharsets.UTF_8));
                    } else {
                        this.getResponse().setStatus(Status.SUCCESS_OK);
                        if (html) {
                            result = new SimpleHTML("Login").representation("Login successful.");
                        }
                    }
                    authSuccess = true;
                }
            }
            catch (TicketValidationException e) {
                log.error(e.getMessage());
            }
            if (!authSuccess) {
                if (redirFailure != null) {
                    this.getResponse().redirectTemporary(URLDecoder.decode(redirFailure, StandardCharsets.UTF_8));
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                    if (html) {
                        result = new SimpleHTML("Login").representation("Login failed.");
                    }
                }
            }
        } else {
            this.getResponse().redirectTemporary(CommonUtils.constructRedirectUrl((String)casLoginUrl, (String)protocol.getServiceParameterName(), (String)this.constructServiceUrl(), (boolean)false, (boolean)false));
        }
        return result;
    }

    private String constructServiceUrl() {
        return this.getBaseUrl() + "auth/cas";
    }

    private String getBaseUrl() {
        Object baseUrl = this.getRM().getConfiguration().getString(Settings.BASE_URL);
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        return baseUrl;
    }

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error(e.getMessage());
        }
    }
}

