/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.entrystore.rest.resources.BaseResource;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaviconResource
extends BaseResource {
    private static Logger log = LoggerFactory.getLogger(FaviconResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
    boolean loadingFailed = false;
    Representation faviconRep = null;

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_ALL);
    }

    @Get
    public Representation represent() throws ResourceException {
        if (this.faviconRep == null && !this.loadingFailed) {
            File favicon = this.getFavicon("favicon.ico");
            if (favicon != null) {
                this.faviconRep = new FileRepresentation(favicon, MediaType.IMAGE_ICON);
            } else {
                this.loadingFailed = true;
            }
        }
        if (this.faviconRep != null) {
            return this.faviconRep;
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return null;
    }

    private File getFavicon(String fileName) {
        URL resURL = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (resURL != null) {
            return FileUtils.toFile((URL)resURL);
        }
        log.warn("Unable to find " + fileName + " in classpath");
        return null;
    }
}

