/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.PrincipalManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.rest.resources.BaseResource;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(GroupResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    public void acceptRepresentation(Representation r) throws ResourceException {
        URI requestingUser = this.getPM().getAuthenticatedUserURI();
        try {
            if (requestingUser == null || this.getPM().getGuestUser().getURI().equals(requestingUser)) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                return;
            }
            if (!this.getRM().getConfiguration().getBoolean(Settings.NONADMIN_GROUPCONTEXT_CREATION, false)) {
                try {
                    if (!this.getPM().getAdminUser().getURI().equals(requestingUser) && !this.getPM().getAdminGroup().isMember(this.getPM().getUser(requestingUser))) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                        return;
                    }
                }
                catch (AuthorizationException ae) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                    return;
                }
            }
            String name = null;
            String contextId = null;
            boolean setName = false;
            if (this.parameters.containsKey("name")) {
                name = URLDecoder.decode((String)this.parameters.get("name"), StandardCharsets.UTF_8).trim();
                boolean bl = setName = !name.isEmpty();
            }
            if (this.parameters.containsKey("contextId") && (contextId = URLDecoder.decode((String)this.parameters.get("contextId"), StandardCharsets.UTF_8).trim()).isEmpty()) {
                contextId = null;
            }
            this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
            if (setName && this.getPM().getPrincipalEntry(name) != null || this.getCM().getContextURI(name) != null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                return;
            }
            if (contextId != null && this.getCM().getContext(contextId) != null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                return;
            }
            Entry newGroupEntry = this.getCM().getContext("_principals").createResource(null, GraphType.Group, null, null);
            newGroupEntry.setAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer, (Set)Sets.newHashSet((Object[])new URI[]{requestingUser}));
            newGroupEntry.setCreator(requestingUser);
            Group newGroup = (Group)newGroupEntry.getResource();
            newGroup.addMember(this.getPM().getUser(requestingUser));
            if (setName) {
                newGroup.setName(name);
            }
            Entry newContextEntry = this.getCM().getContext("_contexts").createResource(contextId, GraphType.Context, null, null);
            newContextEntry.setAllowedPrincipalsFor(PrincipalManager.AccessProperty.Administer, (Set)Sets.newHashSet((Object[])new URI[]{requestingUser}));
            newContextEntry.setAllowedPrincipalsFor(PrincipalManager.AccessProperty.WriteResource, (Set)Sets.newHashSet((Object[])new URI[]{newGroupEntry.getResourceURI()}));
            newContextEntry.setCreator(requestingUser);
            Context newContext = (Context)newContextEntry.getResource();
            if (setName) {
                this.getCM().setName(newContextEntry.getEntryURI(), name);
            }
            newGroup.setHomeContext(newContext);
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
            this.getResponse().setLocationRef(newGroupEntry.getEntryURI().toString());
            this.getResponse().setEntity(this.createEmptyRepresentationWithLastModified(newGroupEntry.getModifiedDate()));
        }
        finally {
            this.getPM().setAuthenticatedUserURI(requestingUser);
        }
    }
}

