/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.GraphType;
import org.entrystore.harvester.Harvester;
import org.entrystore.harvester.factory.HarvesterFactoryException;
import org.entrystore.harvesting.oaipmh.harvester.factory.OAIHarvesterFactory;
import org.entrystore.rest.resources.BaseResource;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvesterResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(HarvesterResource.class);
    Harvester harvester;

    public void doInit() {
    }

    @Get
    public Representation represent() throws ResourceException {
        if (this.context != null && this.harvester == null) {
            this.harvester = this.getHarvester();
        }
        try {
            JSONObject jsonObj = new JSONObject();
            if (this.harvester == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new JsonRepresentation("No harvester found");
            }
            try {
                this.getInformation(jsonObj);
            }
            catch (JSONException e) {
                log.error(e.getMessage());
            }
            try {
                return new JsonRepresentation(jsonObj.toString(2));
            }
            catch (JSONException e) {
                return new JsonRepresentation(jsonObj);
            }
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    private void getInformation(JSONObject jsonObj) throws JSONException {
        jsonObj.put("target", (Object)this.harvester.getTarget());
        jsonObj.put("harvesterType", (Object)this.harvester.getName());
        jsonObj.put("metadataType", (Object)this.harvester.getMetadataType());
        if (this.harvester.getFrom() != null) {
            jsonObj.put("from", (Object)this.harvester.getFrom());
        }
        if (this.harvester.getUntil() != null) {
            jsonObj.put("until", (Object)this.harvester.getUntil());
        }
        if (this.harvester.getSet() != null) {
            jsonObj.put("set", (Object)this.harvester.getSet());
        }
        if (this.harvester.getTimeRegExp() != null) {
            jsonObj.put("timeRegularExpression", (Object)this.harvester.getTimeRegExp());
        }
    }

    @Post
    public void acceptRepresentation(Representation r) throws ResourceException {
        block18: {
            if (this.context != null && this.harvester == null) {
                this.harvester = this.getHarvester();
            }
            try {
                if (this.harvester != null) {
                    this.getResponse().setEntity((Representation)new JsonRepresentation("Harvester exists already"));
                    this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                    return;
                }
                JSONObject jsonObj = this.getInputJSON();
                if (jsonObj == null) {
                    this.getResponse().setEntity((Representation)new JsonRepresentation("Invalid harvester configuration"));
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    return;
                }
                try {
                    if (!(jsonObj.isNull("timeRegularExpression") || jsonObj.isNull("target") || jsonObj.isNull("metadataType") || jsonObj.isNull("harvesterType"))) {
                        Set entries = this.getCM().getByResourceURI(this.context.getURI());
                        Iterator iter = entries.iterator();
                        Entry entry = null;
                        while (iter.hasNext() && (entry = (Entry)iter.next()).getGraphType() != GraphType.Context) {
                            entry = null;
                        }
                        if (entry == null) {
                            log.error("Unable to find the right entry");
                            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                            return;
                        }
                        try {
                            OAIHarvesterFactory factory = null;
                            Harvester harvester = null;
                            String harvesterType = jsonObj.getString("harvesterType");
                            if (harvesterType.equalsIgnoreCase("OAI-PMH")) {
                                String set = jsonObj.isNull("set") ? null : jsonObj.getString("set");
                                factory = new OAIHarvesterFactory();
                                harvester = factory.createHarvester(jsonObj.getString("target"), jsonObj.getString("metadataType"), set, jsonObj.getString("timeRegularExpression"), this.getRM(), this.context.getEntry().getEntryURI());
                            } else {
                                log.error("Harvester type unknown: " + harvesterType);
                                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Harvester type unknown: " + harvesterType);
                            }
                            if (harvester == null) {
                                log.error("Unable to create harvester type " + harvesterType);
                                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL, "Unable to create harvester type " + harvesterType);
                            }
                            if (!jsonObj.isNull("from")) {
                                harvester.setFrom(jsonObj.getString("from"));
                            }
                            if (!jsonObj.isNull("until")) {
                                harvester.setUntil((String)jsonObj.get("until"));
                            }
                            if (!jsonObj.isNull("set")) {
                                harvester.setSet((String)jsonObj.get("set"));
                            }
                            harvester.run();
                            this.getHarvesters().add(harvester);
                            log.info("Harvester created: " + String.valueOf(jsonObj.get("target")));
                            this.getResponse().setStatus(Status.SUCCESS_CREATED);
                        }
                        catch (HarvesterFactoryException e) {
                            log.error(e.getMessage());
                        }
                        break block18;
                    }
                    log.info("Parameters missing in JSON");
                    this.getResponse().setEntity((Representation)new JsonRepresentation("Parameters missing in JSON"));
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                }
            }
            catch (AuthorizationException e) {
                this.unauthorizedPOST();
            }
        }
    }

    private JSONObject getInputJSON() {
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject(this.getRequest().getEntity().getText());
        }
        catch (JSONException e) {
            log.error(e.getMessage());
            return null;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
        return jsonObj;
    }

    private Harvester getHarvester() {
        for (Harvester h : this.getHarvesters()) {
            log.info("Harvester URI: " + String.valueOf(h.getOwnerContextURI()) + "; Context URI: " + String.valueOf(this.context.getEntry().getEntryURI()));
            if (!h.getOwnerContextURI().equals(this.context.getEntry().getEntryURI())) continue;
            return h;
        }
        return null;
    }

    @Delete
    public void removeRepresentations() throws ResourceException {
        if (this.context != null && this.harvester == null) {
            this.harvester = this.getHarvester();
        }
        try {
            if (this.harvester == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return;
            }
            String target = this.harvester.getTarget();
            String type = this.harvester.getName();
            if (!type.equals("OAI-PMH")) {
                log.error("Unknown harvester: " + type);
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unknown harvester: " + type);
                return;
            }
            OAIHarvesterFactory factory = new OAIHarvesterFactory();
            factory.deleteHarvester(this.context.getEntry());
            this.harvester.delete();
            this.getHarvesters().remove(this.harvester);
            log.info("Harvester deleted: " + type + ":" + target);
        }
        catch (AuthorizationException e) {
            this.unauthorizedDELETE();
        }
    }

    @Put
    public void storeRepresentation(Representation r) throws ResourceException {
        if (this.context != null && this.harvester == null) {
            this.harvester = this.getHarvester();
        }
        try {
            if (this.harvester == null) {
                this.getResponse().setEntity((Representation)new JsonRepresentation("Harvester does not exist"));
                this.getResponse().setStatus(Status.CLIENT_ERROR_EXPECTATION_FAILED);
                return;
            }
            JSONObject jsonObj = this.getInputJSON();
            if (jsonObj == null) {
                this.getResponse().setEntity((Representation)new JsonRepresentation("Invalid configuration"));
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            } else if (!jsonObj.isNull("updateRecord")) {
                try {
                    String updateRecord = jsonObj.getString("updateRecord");
                    this.harvester.run(updateRecord);
                    log.info("Harvester updating record: " + updateRecord);
                    this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            } else if (!jsonObj.isNull("action")) {
                try {
                    String action = jsonObj.getString("action");
                    log.info("Received unknown action: " + action);
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unknown action");
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            }
        }
        catch (AuthorizationException e) {
            this.unauthorizedPUT();
        }
    }
}

