/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.entrystore.AuthorizationException;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.repository.transformation.SCAM2Import;
import org.entrystore.repository.util.FileOperations;
import org.entrystore.rest.resources.BaseResource;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(ImportResource.class);

    public void doInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    public void acceptRepresentation(Representation r) {
        block27: {
            User authenticatedUser = this.getPM().getUser(this.getPM().getAuthenticatedUserURI());
            try {
                if (authenticatedUser == null || this.getPM().getGuestUser().getURI().equals(authenticatedUser.getURI())) {
                    throw new AuthorizationException(authenticatedUser, this.context != null ? this.context.getEntry() : null, PrincipalManager.AccessProperty.Administer);
                }
                this.getPM().setAuthenticatedUserURI(this.getPM().getAdminUser().getURI());
                if (!this.getPM().getAdminUser().getURI().equals(authenticatedUser.getURI()) && !this.getPM().getAdminGroup().isMember(authenticatedUser)) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                    return;
                }
                if (this.context == null) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    return;
                }
                File tmpFile = null;
                try {
                    String version = (String)this.parameters.get("version");
                    if (version != null && version.equals("2")) {
                        String pathToScam2BackupDir = (String)this.parameters.get("backup");
                        SCAM2Import s2i = new SCAM2Import(this.context, pathToScam2BackupDir);
                        s2i.doImport();
                        break block27;
                    }
                    tmpFile = File.createTempFile("scam_import", null);
                    InputStream input = MediaType.MULTIPART_FORM_DATA.equals((Object)this.getRequest().getEntity().getMediaType(), true) ? this.getStreamFromForm(this.getRequest()) : this.getRequestEntity().getStream();
                    if (input != null) {
                        try {
                            FileOperations.copyFile((InputStream)input, (OutputStream)Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]));
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL, "Unable to copy the file");
                            if (tmpFile != null) {
                                tmpFile.delete();
                            }
                            this.getPM().setAuthenticatedUserURI(authenticatedUser.getURI());
                            return;
                        }
                        try {
                            this.getCM().importContext(this.context.getEntry(), tmpFile);
                            this.getResponse().setEntity("<textarea></textarea>", MediaType.TEXT_HTML);
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to import file, received invalid data");
                        }
                        break block27;
                    }
                    log.error("Unable to import file, received invalid data");
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to import file, received invalid data");
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
                }
                catch (RepositoryException re) {
                    log.error(re.getMessage());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL, re.getMessage());
                }
                finally {
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
            }
            catch (AuthorizationException e) {
                log.error("unauthorizedPOST");
                this.unauthorizedPOST();
            }
            finally {
                this.getPM().setAuthenticatedUserURI(authenticatedUser.getURI());
            }
        }
    }

    private InputStream getStreamFromForm(Request request) {
        try {
            RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
            List items = upload.parseRequest(request);
            Iterator iter = items.iterator();
            if (iter.hasNext()) {
                FileItem item = (FileItem)iter.next();
                return item.getInputStream();
            }
        }
        catch (FileUploadException e) {
            log.warn(e.getMessage());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (IOException ioe) {
            log.warn(ioe.getMessage());
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        }
        return null;
    }
}

