/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.repository.util.QueryResult;
import org.entrystore.repository.util.SolrSearchIndex;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.GraphUtil;
import org.entrystore.rest.util.Util;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(LookupResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_RDF_XML);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.supportedMediaTypes.add(MediaType.TEXT_RDF_N3);
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIX.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIG.getDefaultMIMEType()));
        this.entry = null;
    }

    @Get
    public Representation represent() {
        Date lastMod;
        Representation r;
        URI resourceURI = null;
        if (this.parameters.containsKey("uri")) {
            try {
                resourceURI = new URI(URLDecoder.decode((String)this.parameters.get("uri"), "UTF-8"));
            }
            catch (Exception e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return null;
            }
        }
        String scope = "all";
        if (this.parameters.containsKey("scope") && !"all".equals(scope = ((String)this.parameters.get("scope")).toLowerCase()) && !"local".equals(scope) && !"external".equals(scope)) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        if (resourceURI == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        Set entries = null;
        if (this.context != null) {
            entries = this.context.getByResourceURI(resourceURI);
        } else {
            if (this.getRM().getIndex() == null) {
                this.getResponse().setStatus(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, "Solr search deactivated");
                return null;
            }
            String solrEscapedURI = ClientUtils.escapeQueryChars((String)resourceURI.toString());
            SolrQuery q = new SolrQuery("resource:" + solrEscapedURI + " AND public:true");
            q.setStart(Integer.valueOf(0));
            q.setRows(Integer.valueOf(1));
            try {
                QueryResult qResult = ((SolrSearchIndex)this.getRM().getIndex()).sendQuery(q);
                entries = qResult.getEntries();
            }
            catch (SolrException se) {
                log.warn(se.getMessage());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return null;
            }
        }
        if (entries == null || entries.isEmpty()) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        if (entries.size() > 1) {
            log.info("Multiple matching entries for resource URI " + String.valueOf(resourceURI));
        }
        this.entry = (Entry)entries.iterator().next();
        MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
        if (preferredMediaType == null) {
            preferredMediaType = MediaType.APPLICATION_RDF_XML;
        }
        if ((r = this.getMetadata(this.entry, scope, this.format != null ? this.format : preferredMediaType)) != null && (lastMod = this.entry.getModifiedDate()) != null) {
            r.setModificationDate(lastMod);
            r.setTag(Util.createTag(lastMod));
        }
        return r;
    }

    private Representation getMetadata(Entry e, String scope, MediaType mediaType) throws AuthorizationException {
        String serializedGraph;
        EntryType locType = this.entry.getEntryType();
        LinkedHashModel graph = new LinkedHashModel();
        if (EntryType.Local.equals((Object)locType) || EntryType.Link.equals((Object)locType)) {
            if ("all".equals(scope) || "local".equals(scope)) {
                graph.addAll((Collection)this.entry.getLocalMetadata().getGraph());
            }
        } else if (EntryType.Reference.equals((Object)locType)) {
            if ("all".equals(scope) || "external".equals(scope)) {
                graph.addAll((Collection)this.entry.getCachedExternalMetadata().getGraph());
            }
        } else if (EntryType.LinkReference.equals((Object)locType)) {
            if ("all".equals(scope) || "local".equals(scope)) {
                graph.addAll((Collection)this.entry.getLocalMetadata().getGraph());
            }
            if ("all".equals(scope) || "external".equals(scope)) {
                graph.addAll((Collection)this.entry.getCachedExternalMetadata().getGraph());
            }
        }
        if (graph != null && (serializedGraph = GraphUtil.serializeGraph((Model)graph, mediaType)) != null) {
            this.getResponse().setStatus(Status.SUCCESS_OK);
            return new StringRepresentation((CharSequence)serializedGraph, mediaType);
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        return new EmptyRepresentation();
    }
}

