/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.User;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.JSONErrorMessages;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(NameResource.class);

    @Get
    public Representation represent() {
        String name = null;
        try {
            if (this.context != null && this.entry != null) {
                GraphType bt = this.entry.getGraphType();
                if (GraphType.Group.equals((Object)bt)) {
                    name = ((Group)this.entry.getResource()).getName();
                } else if (GraphType.User.equals((Object)bt)) {
                    name = ((User)this.entry.getResource()).getName();
                } else if (GraphType.Context.equals((Object)bt)) {
                    Context c = this.getCM().getContext(this.entryId);
                    name = this.getCM().getName(c.getURI());
                }
            }
        }
        catch (AuthorizationException ae) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return new EmptyRepresentation();
        }
        if (name != null) {
            JSONObject result = new JSONObject();
            try {
                result.put("name", name);
            }
            catch (JSONException e) {
                log.error(e.getMessage());
            }
            return new JsonRepresentation(result);
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
    }

    @Put
    public void storeRepresentation(Representation r) {
        String name = null;
        try {
            JSONObject nameObj = new JSONObject(this.getRequestEntity().getText());
            if (nameObj.has("name")) {
                name = nameObj.getString("name").trim();
            }
        }
        catch (IOException | JSONException jsone) {
            log.error(jsone.getMessage());
        }
        if (this.context == null || this.entry == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        if (name == null || name.isEmpty()) {
            name = null;
        }
        GraphType bt = this.entry.getGraphType();
        boolean success = false;
        if (GraphType.Group.equals((Object)bt)) {
            success = ((Group)this.entry.getResource()).setName(name);
        } else if (GraphType.User.equals((Object)bt)) {
            if (name == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
            success = ((User)this.entry.getResource()).setName(name);
        } else if (GraphType.Context.equals((Object)bt) && !this.getReservedNames().contains(StringUtils.trimToEmpty((String)name).toLowerCase())) {
            Context c = this.getCM().getContext(this.entryId);
            success = this.getCM().setName(c.getURI(), name);
        }
        if (!success) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
        } else {
            this.getResponse().setEntity(this.createEmptyRepresentationWithLastModified(this.entry.getModifiedDate()));
        }
    }
}

