/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.entrystore.AuthorizationException;
import org.entrystore.PrincipalManager;
import org.entrystore.rest.resources.BaseResource;
import org.json.JSONObject;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceMetricsResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(PerformanceMetricsResource.class);

    @Get
    public Representation represent() {
        try {
            CompositeMeterRegistry registry = Metrics.globalRegistry;
            PrincipalManager pm = this.getRM().getPrincipalManager();
            URI currentUser = pm.getAuthenticatedUserURI();
            if (!pm.getAdminUser().getURI().equals(currentUser) && !pm.getAdminGroup().isMember(pm.getUser(currentUser))) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                return new EmptyRepresentation();
            }
            JSONObject result = new JSONObject();
            for (Meter meter : registry.getMeters()) {
                if (!(meter instanceof Timer)) continue;
                Timer timer = (Timer)meter;
                String timerName = timer.getId().getName();
                HistogramSnapshot histogramSnapshot = timer.takeSnapshot();
                JSONObject timerData = new JSONObject();
                timerData.put("requests", histogramSnapshot.count());
                timerData.put("mean", Math.round(histogramSnapshot.mean(TimeUnit.MILLISECONDS)));
                timerData.put("max", Math.round(histogramSnapshot.max(TimeUnit.MILLISECONDS)));
                for (ValueAtPercentile valueAtPercentile : histogramSnapshot.percentileValues()) {
                    timerData.put("percentile-" + valueAtPercentile.percentile(), Math.round(valueAtPercentile.value(TimeUnit.MILLISECONDS)));
                }
                result.put(timerName, (Object)timerData);
            }
            return new JsonRepresentation(result.toString(2));
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            return new EmptyRepresentation();
        }
    }
}

