/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.entrystore.AuthorizationException;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.util.GraphUtil;
import org.entrystore.rest.util.JSONErrorMessages;
import org.entrystore.rest.util.Util;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(RelationResource.class);
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.APPLICATION_RDF_XML);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.supportedMediaTypes.add(MediaType.TEXT_RDF_N3);
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIX.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.TRIG.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType(RDFFormat.JSONLD.getDefaultMIMEType()));
        this.supportedMediaTypes.add(new MediaType("application/rdf+json"));
    }

    @Get
    public Representation represent() throws ResourceException {
        try {
            EmptyRepresentation result = null;
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
            }
            MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
            if (preferredMediaType == null) {
                preferredMediaType = MediaType.APPLICATION_RDF_XML;
            }
            MediaType prefFormat = this.format != null ? this.format : preferredMediaType;
            String serializedGraph = GraphUtil.serializeGraph(this.entry.getRelations(), prefFormat);
            if (serializedGraph != null) {
                this.getResponse().setStatus(Status.SUCCESS_OK);
                result = new StringRepresentation((CharSequence)serializedGraph, prefFormat);
            } else {
                result = new EmptyRepresentation();
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
            }
            Date lastMod = this.entry.getModifiedDate();
            if (lastMod != null) {
                result.setModificationDate(lastMod);
                result.setTag(Util.createTag(lastMod));
            }
            return result;
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }
}

