/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import com.google.common.html.HtmlEscapers;
import com.rometools.rome.feed.synd.SyndFeed;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.Data;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.GraphType;
import org.entrystore.Group;
import org.entrystore.List;
import org.entrystore.QuotaException;
import org.entrystore.Resource;
import org.entrystore.ResourceType;
import org.entrystore.User;
import org.entrystore.impl.DataImpl;
import org.entrystore.impl.ListImpl;
import org.entrystore.impl.RDFResource;
import org.entrystore.impl.StringResource;
import org.entrystore.repository.RepositoryException;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.security.Password;
import org.entrystore.repository.util.EntryUtil;
import org.entrystore.repository.util.FileOperations;
import org.entrystore.repository.util.SolrSearchIndex;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.BasicVerifier;
import org.entrystore.rest.auth.CookieVerifier;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.auth.UserTempLockoutCache;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.serializer.ResourceJsonSerializer;
import org.entrystore.rest.util.Email;
import org.entrystore.rest.util.GraphUtil;
import org.entrystore.rest.util.JSONErrorMessages;
import org.entrystore.rest.util.RDFJSON;
import org.entrystore.rest.util.Syndication;
import org.entrystore.rest.util.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResource
extends BaseResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceResource.class);
    private static final int DEFAULT_FEED_SIZE = 50;
    private int maxFeedSize = -1;
    private final EmptyRepresentation EMPTY_REPRESENTATION = new EmptyRepresentation();
    private final java.util.List<MediaType> supportedMediaTypes = java.util.List.of(MediaType.APPLICATION_RDF_XML, MediaType.APPLICATION_JSON, MediaType.TEXT_RDF_N3, new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()), new MediaType(RDFFormat.TRIX.getDefaultMIMEType()), new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()), new MediaType(RDFFormat.TRIG.getDefaultMIMEType()), new MediaType(RDFFormat.JSONLD.getDefaultMIMEType()), new MediaType("application/rdf+json"));
    private UserTempLockoutCache userTempLockoutCache;
    private ResourceJsonSerializer resourceSerializer;
    private static Boolean rewriteMediaTypeJavaScript;

    public void doInit() {
        this.userTempLockoutCache = this.getUserTempLockoutCache();
        this.resourceSerializer = new ResourceJsonSerializer(this.getPM(), this.getCM(), this.userTempLockoutCache);
        if (rewriteMediaTypeJavaScript == null) {
            rewriteMediaTypeJavaScript = this.getRM().getConfiguration().getBoolean(Settings.HTTP_ALLOW_MEDIA_TYPE_JAVASCRIPT, false);
        }
        if (this.maxFeedSize == -1) {
            this.maxFeedSize = this.getRM().getConfiguration().getInt(Settings.SOLR_MAX_LIMIT, 100);
        }
    }

    @Get
    public Representation represent() {
        try {
            Date lastMod;
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return new JsonRepresentation(JSONErrorMessages.errorEntryNotFound);
            }
            EmptyRepresentation result = new EmptyRepresentation();
            if (Method.GET.equals((Object)this.getRequest().getMethod()) && this.getResource() != null) {
                result = this.getResource();
            }
            if ((lastMod = this.entry.getModifiedDate()) != null) {
                result.setModificationDate(lastMod);
                result.setTag(Util.createTag(lastMod));
            }
            return result;
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    @Put
    public void storeRepresentation(Representation r) {
        if (this.entry == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return;
        }
        try {
            this.modifyResource();
            if (this.getResponse().getStatus().isSuccess()) {
                if (this.getResponse().getEntity() == null) {
                    this.getResponse().setEntity((Representation)new EmptyRepresentation());
                }
                this.entry.updateModificationDate();
                this.getResponse().getEntity().setModificationDate(this.entry.getModifiedDate());
            }
        }
        catch (AuthorizationException e) {
            this.unauthorizedPUT();
        }
    }

    @Delete
    public void removeRepresentation() {
        if (this.entry == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return;
        }
        EntryType entryType = this.entry.getEntryType();
        try {
            if ((entryType == EntryType.Link || entryType == EntryType.Reference || entryType == EntryType.LinkReference) && "true".equalsIgnoreCase((String)this.parameters.get("proxy"))) {
                Response delResponse = this.deleteRemoteResource(this.entry.getResourceURI().toString(), 0);
                if (delResponse != null) {
                    this.getResponse().setEntity(delResponse.getEntity());
                    this.getResponse().setStatus(delResponse.getStatus());
                    this.getResponse().setOnSent((request, response) -> {
                        try {
                            delResponse.release();
                        }
                        catch (Exception e) {
                            log.error(e.getMessage());
                        }
                    });
                } else {
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            } else {
                this.deleteLocalResource();
            }
        }
        catch (AuthorizationException e) {
            this.unauthorizedDELETE();
        }
    }

    @Post
    public void acceptRepresentation(Representation r) {
        block14: {
            if (this.entry == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                return;
            }
            GraphType graphType = this.entry.getGraphType();
            try {
                if (graphType == GraphType.List && this.parameters.containsKey("import") && MediaType.APPLICATION_ZIP.equals((Object)this.getRequestEntity().getMediaType())) {
                    this.getResponse().setStatus(this.importFromZIP(this.getRequestEntity()));
                    break block14;
                }
                if (graphType == GraphType.List && this.parameters.containsKey("moveEntry") && this.parameters.containsKey("fromList")) {
                    ListImpl dest = (ListImpl)this.entry.getResource();
                    String movableEntryString = (String)this.parameters.get("moveEntry");
                    String movableEntrySourceString = (String)this.parameters.get("fromList");
                    boolean removeAll = this.parameters.get("removeAll") != null;
                    Object baseURI = this.getRM().getRepositoryURL().toString();
                    if (!((String)baseURI).endsWith("/")) {
                        baseURI = (String)baseURI + "/";
                    }
                    URI movableEntry = movableEntryString.startsWith("http://") ? URI.create(movableEntryString) : URI.create((String)baseURI + movableEntryString);
                    URI movableEntrySource = null;
                    if (movableEntrySourceString != null) {
                        movableEntrySource = movableEntrySourceString.startsWith("http://") ? URI.create(movableEntrySourceString) : URI.create((String)baseURI + movableEntrySourceString);
                    }
                    Entry movedEntry = null;
                    String error = null;
                    try {
                        movedEntry = dest.moveEntryHere(movableEntry, movableEntrySource, removeAll);
                    }
                    catch (QuotaException qe) {
                        error = qe.getMessage();
                        log.warn(qe.getMessage());
                        this.getResponse().setStatus(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
                    }
                    if (error != null) {
                        JSONObject jsonError = new JSONObject();
                        try {
                            jsonError.put("error", (Object)error);
                        }
                        catch (JSONException e) {
                            log.error(e.getMessage());
                        }
                        this.getResponse().setEntity((Representation)new JsonRepresentation(jsonError));
                        return;
                    }
                    JSONObject result = new JSONObject();
                    try {
                        result.put("entryURI", (Object)movedEntry.getEntryURI());
                    }
                    catch (JSONException e) {
                        log.error(e.getMessage());
                    }
                    this.getResponse().setEntity((Representation)new JsonRepresentation(result));
                    this.getResponse().setStatus(Status.SUCCESS_OK);
                    break block14;
                }
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            }
            catch (AuthorizationException e) {
                this.unauthorizedPOST();
            }
        }
    }

    private Representation getResource() throws AuthorizationException {
        boolean isList;
        Model graph;
        if (this.parameters.containsKey("syndication")) {
            try {
                if (this.getRM().getIndex() == null) {
                    this.getResponse().setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                    return new JsonRepresentation("{\"error\":\"Feeds are not supported by this installation\"}");
                }
                StringRepresentation rep = this.getSyndicationSolr(this.entry, (String)this.parameters.get("syndication"));
                if (rep == null) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                    return new JsonRepresentation(JSONErrorMessages.errorNotAContext);
                }
                return rep;
            }
            catch (IllegalArgumentException e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return new JsonRepresentation(JSONErrorMessages.syndicationFormat);
            }
        }
        MediaType rdfFormat = MediaType.APPLICATION_JSON;
        if (RDFFormat.JSONLD.getDefaultMIMEType().equals(this.parameters.get("rdfFormat"))) {
            rdfFormat = new MediaType(RDFFormat.JSONLD.getDefaultMIMEType());
        }
        EntryType entryType = this.entry.getEntryType();
        GraphType graphType = this.entry.getGraphType();
        ResourceType resourceType = this.entry.getResourceType();
        if (graphType == null) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return new JsonRepresentation("{\"error\":\"No resource available for resource " + String.valueOf(this.entry.getResourceURI()));
        }
        MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
        if (preferredMediaType == null) {
            preferredMediaType = MediaType.APPLICATION_RDF_XML;
        }
        MediaType mediaType = preferredMediaType = this.format != null ? this.format : preferredMediaType;
        if ((graphType == GraphType.Graph || graphType == GraphType.List) && (graph = (isList = this.entry.getGraphType() == GraphType.List) ? ((List)this.entry.getResource()).getGraph() : ((RDFResource)this.entry.getResource()).getGraph()) != null) {
            String serializedGraph;
            if (MediaType.APPLICATION_JSON.equals((Object)preferredMediaType)) {
                if (isList) {
                    return this.serializeJsonRepresentationResourceList(this.entry, new ResourceJsonSerializer.ListParams(this.parameters));
                }
                serializedGraph = RDFJSON.graphToRdfJson(graph);
            } else {
                serializedGraph = GraphUtil.serializeGraph(graph, preferredMediaType);
            }
            if (serializedGraph != null) {
                this.getResponse().setStatus(Status.SUCCESS_OK);
                return new StringRepresentation((CharSequence)serializedGraph, preferredMediaType);
            }
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
            return new JsonRepresentation(JSONErrorMessages.errorUnknownFormat);
        }
        if ((entryType == EntryType.Link || entryType == EntryType.LinkReference || entryType == EntryType.Reference) && graphType == GraphType.None) {
            this.getResponse().setLocationRef(new Reference(this.entry.getResourceURI().toString()));
            this.getResponse().setStatus(Status.REDIRECTION_SEE_OTHER);
            return null;
        }
        if (entryType == EntryType.Local) {
            if (resourceType == ResourceType.NamedResource) {
                this.redirectSeeOther(this.entry.getLocalMetadataURI().toString());
                return new EmptyRepresentation();
            }
            try {
                Resource resource = this.entry.getResource();
                return switch (graphType) {
                    case GraphType.None -> this.serializeFileRepresentationResourceNone(this.entry);
                    case GraphType.User -> new JsonRepresentation(this.resourceSerializer.serializeResourceUser(resource));
                    case GraphType.Group -> new JsonRepresentation(this.resourceSerializer.serializeResourceGroup(resource, rdfFormat));
                    case GraphType.String -> new JsonRepresentation(this.resourceSerializer.serializeResourceString(resource));
                    case GraphType.Context -> new JsonRepresentation(this.resourceSerializer.serializeResourceContext(resource));
                    case GraphType.SystemContext -> new JsonRepresentation(this.resourceSerializer.serializeResourceSystemContext(resource));
                    case GraphType.Pipeline -> {
                        if (resource instanceof RDFResource) {
                            RDFResource pipeline = (RDFResource)resource;
                            if (pipeline.getGraph() == null) {
                                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                                yield new JsonRepresentation("{\"error\":\"The pipeline has not been set\"}");
                            }
                            yield new JsonRepresentation(this.resourceSerializer.serializeResourcePipeline((Resource)pipeline, rdfFormat));
                        }
                        yield this.EMPTY_REPRESENTATION;
                    }
                    case GraphType.ResultList, GraphType.PipelineResult -> this.EMPTY_REPRESENTATION;
                    default -> this.EMPTY_REPRESENTATION;
                };
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                return new JsonRepresentation("{\"error\":\"Internal Server Error\"}");
            }
        }
        return this.EMPTY_REPRESENTATION;
    }

    private FileRepresentation serializeFileRepresentationResourceNone(Entry entry) {
        if (entry.getResourceType() == ResourceType.InformationResource) {
            File file = ((Data)entry.getResource()).getDataFile();
            if (file != null) {
                String fileName;
                FileRepresentation rep;
                String medTyp = entry.getMimetype();
                if (medTyp != null) {
                    try {
                        if (rewriteMediaTypeJavaScript.booleanValue() && medTyp.toLowerCase().contains("javascript")) {
                            log.info("Rewriting media type {} to text/plain for {}", (Object)medTyp, (Object)entry.getResourceURI());
                            medTyp = MediaType.TEXT_PLAIN.toString();
                        }
                        rep = new FileRepresentation(file, MediaType.valueOf((String)medTyp));
                    }
                    catch (IllegalArgumentException iae) {
                        log.warn("Invalid media type for {}: {}", (Object)entry.getEntryURI(), (Object)iae.getMessage());
                        rep = new FileRepresentation(file, MediaType.ALL);
                    }
                } else {
                    rep = new FileRepresentation(file, MediaType.ALL);
                }
                if ((fileName = entry.getFilename()) == null) {
                    fileName = entry.getId();
                }
                Disposition disp = rep.getDisposition();
                disp.setFilename(fileName);
                if (!this.getRM().getConfiguration().getBoolean(Settings.HTTP_ALLOW_CONTENT_DISPOSITION_INLINE, true) || this.parameters.containsKey("download")) {
                    disp.setType("attachment");
                } else {
                    disp.setType("inline");
                }
                DataImpl data = new DataImpl(entry);
                String digest = data.readDigest();
                if (digest != null) {
                    this.getResponse().getHeaders().set("Digest", "sha-256=" + digest);
                } else {
                    log.debug("Digest does not exist for [{}]", (Object)entry.getResourceURI());
                }
                return rep;
            }
        } else if (entry.getResourceType() == ResourceType.NamedResource) {
            this.getResponse().setLocationRef(new Reference(entry.getLocalMetadataURI()));
            this.getResponse().setStatus(Status.REDIRECTION_SEE_OTHER);
        }
        return null;
    }

    private JsonRepresentation serializeJsonRepresentationResourceList(Entry entry, ResourceJsonSerializer.ListParams listParams) {
        JSONArray array = new JSONArray();
        List l = (List)this.entry.getResource();
        java.util.List uris = l.getChildren();
        HashSet<String> IDs = new HashSet<String>();
        for (Object u : uris) {
            String id = ((URI)u).toASCIIString().substring(((URI)u).toASCIIString().lastIndexOf(47) + 1);
            IDs.add(id);
        }
        if (this.parameters.containsKey("sort") && IDs.size() < 501) {
            String sortType;
            ArrayList<Entry> childrenEntries = new ArrayList<Entry>();
            for (String id : IDs) {
                Entry childEntry = this.context.get(id);
                if (childEntry != null) {
                    childrenEntries.add(childEntry);
                    continue;
                }
                log.warn("Child entry " + id + " in context " + String.valueOf(this.context.getURI()) + " does not exist, but is referenced by a list.");
            }
            Date before = new Date();
            boolean asc = !"desc".equalsIgnoreCase((String)this.parameters.get("order"));
            GraphType prioritizedResourceType = null;
            if (this.parameters.containsKey("prio")) {
                prioritizedResourceType = GraphType.valueOf((String)((String)this.parameters.get("prio")));
            }
            if ("title".equalsIgnoreCase(sortType = (String)this.parameters.get("sort"))) {
                String lang = (String)this.parameters.get("lang");
                EntryUtil.sortAfterTitle(childrenEntries, (String)lang, (boolean)asc, (GraphType)prioritizedResourceType);
            } else if ("modified".equalsIgnoreCase(sortType)) {
                EntryUtil.sortAfterModificationDate(childrenEntries, (boolean)asc, (GraphType)prioritizedResourceType);
            } else if ("created".equalsIgnoreCase(sortType)) {
                EntryUtil.sortAfterCreationDate(childrenEntries, (boolean)asc, (GraphType)prioritizedResourceType);
            } else if ("size".equalsIgnoreCase(sortType)) {
                EntryUtil.sortAfterFileSize(childrenEntries, (boolean)asc, (GraphType)prioritizedResourceType);
            }
            long sortDuration = new Date().getTime() - before.getTime();
            log.debug("List entry sorting took " + sortDuration + " ms");
            for (Entry childEntry : childrenEntries) {
                URI childURI = childEntry.getEntryURI();
                String id = childURI.toASCIIString().substring(childURI.toASCIIString().lastIndexOf(47) + 1);
                array.put((Object)id);
            }
        } else {
            if (IDs.size() > 500) {
                log.warn("No sorting performed because of list size bigger than 500 children");
            }
            for (String id : IDs) {
                array.put((Object)id);
            }
        }
        return new JsonRepresentation(array.toString());
    }

    public Set<Entry> getListChildrenRecursively(Entry listEntry) {
        HashSet<Entry> result = new HashSet<Entry>();
        if (GraphType.List.equals((Object)listEntry.getGraphType()) && EntryType.Local.equals((Object)listEntry.getEntryType())) {
            List l = (List)listEntry.getResource();
            java.util.List c = l.getChildren();
            for (URI uri : c) {
                Entry e = this.getRM().getContextManager().getEntry(uri);
                if (e == null) continue;
                if (GraphType.List.equals((Object)e.getGraphType())) {
                    result.addAll(this.getListChildrenRecursively(e));
                    continue;
                }
                result.add(e);
            }
        } else {
            result.add(listEntry);
        }
        return result;
    }

    private void deleteLocalResource() {
        Data data;
        if (this.entry.getGraphType() == GraphType.List) {
            ListImpl l = (ListImpl)this.entry.getResource();
            if (this.parameters.containsKey("recursive")) {
                l.removeTree();
            } else {
                l.setChildren(new Vector());
            }
        }
        if (this.entry.getGraphType() == GraphType.None && this.entry.getResourceType() == ResourceType.InformationResource && !(data = (Data)this.entry.getResource()).delete()) {
            log.error("Unable to delete resource of entry {}", (Object)this.entry.getEntryURI());
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.errorUnknownKind));
        }
    }

    private Response deleteRemoteResource(String url, int loopCount) {
        if (loopCount > 10) {
            log.warn("More than 10 redirect loops detected, aborting");
            return null;
        }
        Client client = new Client(Protocol.HTTP);
        client.setContext(new org.restlet.Context());
        client.getContext().getParameters().add("connectTimeout", "10000");
        client.getContext().getParameters().add("readTimeout", "10000");
        client.getContext().getParameters().set("socketTimeout", "10000");
        client.getContext().getParameters().set("socketConnectTimeoutMs", "10000");
        log.info("Initialized HTTP client for proxy request to delete remote resource");
        Request request = new Request(Method.DELETE, url);
        request.getClientInfo().setAcceptedMediaTypes(this.getRequest().getClientInfo().getAcceptedMediaTypes());
        Response response = client.handle(request);
        if (response.getStatus().isRedirection()) {
            Reference ref = response.getLocationRef();
            response.getEntity().release();
            if (ref != null) {
                String refURL = ref.getIdentifier();
                log.info("Request redirected to " + refURL);
                return this.deleteRemoteResource(refURL, ++loopCount);
            }
        }
        if (response.getEntity() != null && response.getEntity().getLocationRef() != null && response.getEntity().getLocationRef().getBaseRef() == null) {
            response.getEntity().getLocationRef().setBaseRef(url.substring(0, url.lastIndexOf("/") + 1));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status importFromZIP(Representation rep) {
        block14: {
            File tmpFile = null;
            try {
                tmpFile = this.writeStreamToTmpFile(rep.getStream());
                if (tmpFile != null && tmpFile.exists()) {
                    ZipFile zipFile = new ZipFile(tmpFile);
                    Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                    while (zipEntries.hasMoreElements()) {
                        String fileString;
                        ZipEntry entry = zipEntries.nextElement();
                        String nameLC = entry.getName();
                        if (entry.isDirectory() || !nameLC.endsWith(".xml") && !nameLC.endsWith(".rdf")) continue;
                        InputStream fileIS = zipFile.getInputStream(entry);
                        if (fileIS == null) {
                            log.error("Unable to get InputStream of ZipEntry: {}", (Object)nameLC);
                            continue;
                        }
                        try {
                            StringWriter writer = new StringWriter();
                            IOUtils.copy((InputStream)fileIS, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                            fileString = writer.toString();
                            if (fileString == null) {
                                log.error("[IMPORT] Problem with reading ZipEntry into String");
                                continue;
                            }
                        }
                        finally {
                            fileIS.close();
                            continue;
                        }
                        if (!nameLC.endsWith(".rdf")) continue;
                        this.importRDFResource(fileString);
                    }
                    break block14;
                }
                Status zipFile = Status.SERVER_ERROR_INTERNAL;
                return zipFile;
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage());
                Status status = Status.SERVER_ERROR_INTERNAL;
                return status;
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return Status.SUCCESS_CREATED;
    }

    public File writeStreamToTmpFile(InputStream is) throws IOException {
        File tmpFile = File.createTempFile("scam_import_", ".zip");
        log.info("[IMPORT] Created temporary file: {}", (Object)tmpFile);
        OutputStream fos = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);
        FileOperations.copyFile((InputStream)is, (OutputStream)fos);
        return tmpFile;
    }

    private void importRDFResource(String rdfString) {
    }

    public StringRepresentation getSyndicationSolr(Entry entry, String feedType) {
        if (this.getRM().getIndex() == null) {
            return null;
        }
        String language = this.getOptionalParameter("lang", "en");
        int feedSize = this.getOptionalParameterAsInteger("feedSize", 50);
        if (feedSize > this.maxFeedSize) {
            feedSize = this.maxFeedSize;
        } else if (feedSize < 0) {
            feedSize = 50;
        }
        GraphType gt = entry.getGraphType();
        if (!GraphType.Context.equals((Object)gt) && !GraphType.List.equals((Object)gt)) {
            return null;
        }
        java.util.List<Entry> recursiveEntries = this.findSyndicationEntriesInSolr(entry);
        String alias = GraphType.Context.equals((Object)gt) ? this.getCM().getName(entry.getResourceURI()) : EntryUtil.getTitle((Entry)entry, (String)language);
        SyndFeed feed = Syndication.createFeedFromEntries((RepositoryManager)this.getRM(), recursiveEntries, language, feedSize, (String)this.parameters.get("urltemplate"));
        feed.setTitle(Syndication.sanitizeFeedTitle(this.getOptionalParameter("feedtitle", "Feed of " + alias)));
        feed.setLink(entry.getResourceURI().toString());
        feed.setFeedType(feedType);
        String feedXml = Syndication.convertSyndFeedToXml(feed);
        MediaType mediaType = Syndication.convertFeedTypeToMediaType(feedType);
        if (mediaType != null) {
            return new StringRepresentation((CharSequence)feedXml, mediaType);
        }
        return new StringRepresentation((CharSequence)feedXml);
    }

    private java.util.List<Entry> findSyndicationEntriesInSolr(Entry entry) {
        Object solrQueryValue = "lists:";
        if (GraphType.Context.equals((Object)entry.getGraphType())) {
            solrQueryValue = "context:";
        }
        solrQueryValue = (String)solrQueryValue + ClientUtils.escapeQueryChars((String)entry.getResourceURI().toString());
        SolrQuery solrQuery = new SolrQuery((String)solrQueryValue);
        solrQuery.setStart(Integer.valueOf(0));
        solrQuery.setRows(Integer.valueOf(1000));
        solrQuery.setSort("modified", SolrQuery.ORDER.desc);
        Set searchEntries = ((SolrSearchIndex)this.getRM().getIndex()).sendQuery(solrQuery).getEntries();
        LinkedList<Entry> recursiveEntries = new LinkedList<Entry>();
        for (Entry e : searchEntries) {
            recursiveEntries.addAll(this.getListChildrenRecursively(e));
        }
        EntryUtil.sortAfterModificationDate(recursiveEntries, (boolean)false, null);
        return recursiveEntries;
    }

    private void modifyResource() throws AuthorizationException {
        Model graph;
        GraphType gt = this.entry.getGraphType();
        MediaType mediaType = this.getRequestEntity().getMediaType();
        if (GraphType.List.equals((Object)gt) || GraphType.Group.equals((Object)gt)) {
            String requestBody;
            try {
                requestBody = this.getRequest().getEntity().getText();
            }
            catch (IOException e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                return;
            }
            if (MediaType.APPLICATION_JSON.equals((Object)mediaType)) {
                try {
                    JSONArray childrenJSONArray = new JSONArray(requestBody);
                    ArrayList<URI> newResource = new ArrayList<URI>();
                    for (int i = 0; i < childrenJSONArray.length(); ++i) {
                        String childId = childrenJSONArray.get(i).toString();
                        Entry childEntry = this.context.get(childId);
                        if (childEntry == null) {
                            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                            log.debug("Cannot update list, since one of the children does not exist.");
                            return;
                        }
                        newResource.add(childEntry.getEntryURI());
                    }
                    if (this.entry.getGraphType() == GraphType.List) {
                        List resourceList = (List)this.entry.getResource();
                        resourceList.setChildren(newResource);
                    } else {
                        Group resourceGroup = (Group)this.entry.getResource();
                        resourceGroup.setChildren(newResource);
                    }
                    this.getResponse().setStatus(Status.SUCCESS_OK);
                }
                catch (JSONException e) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.errorJSONSyntax));
                }
                catch (RepositoryException re) {
                    log.warn(re.getMessage());
                    this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
                    this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.errorChildExistsInList));
                }
                return;
            }
            graph = GraphUtil.deserializeGraph(requestBody, mediaType);
            if (graph != null && GraphType.List.equals((Object)this.entry.getGraphType())) {
                ((List)this.entry.getResource()).setGraph(graph);
            } else {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            }
        }
        if (gt == GraphType.None) {
            String error;
            boolean textarea;
            block72: {
                textarea = this.parameters.containsKey("textarea");
                error = null;
                if (MediaType.MULTIPART_FORM_DATA.equals((Object)mediaType, true)) {
                    try {
                        java.util.List items = Util.createRestletFileUpload(this.getContext()).parseRepresentation(this.getRequest().getEntity());
                        Iterator iter = items.iterator();
                        if (!iter.hasNext()) break block72;
                        FileItem item = (FileItem)iter.next();
                        long maxFileSize = this.getRM().getMaximumFileSize();
                        if (maxFileSize != -1L && item.getSize() > maxFileSize) {
                            throw new QuotaException(3);
                        }
                        ((Data)this.entry.getResource()).setData(item.getInputStream());
                        this.entry.setFileSize(((Data)this.entry.getResource()).getDataFile().length());
                        String mimeType = item.getContentType();
                        if (this.parameters.containsKey("mimeType")) {
                            mimeType = (String)this.parameters.get("mimeType");
                        }
                        this.entry.setMimetype(mimeType);
                        String name = item.getName();
                        if (name != null && !name.isEmpty()) {
                            this.entry.setFilename(Util.sanitizeFilename(name.trim()));
                        }
                    }
                    catch (FileUploadException e) {
                        error = e.getMessage();
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    }
                    catch (IOException ioe) {
                        error = ioe.getMessage();
                        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    }
                    catch (QuotaException qe) {
                        error = qe.getMessage();
                        this.getResponse().setStatus(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
                    }
                } else {
                    Request req = this.getRequest();
                    try {
                        String name;
                        ((Data)this.entry.getResource()).setData(req.getEntity().getStream());
                        this.entry.setFileSize(((Data)this.entry.getResource()).getDataFile().length());
                        String mimeType = MediaType.APPLICATION_OCTET_STREAM.toString();
                        if (this.parameters.containsKey("mimeType")) {
                            mimeType = (String)this.parameters.get("mimeType");
                        } else if (mediaType != null) {
                            mimeType = mediaType.toString();
                        }
                        this.entry.setMimetype(mimeType);
                        Disposition disp = req.getEntity().getDisposition();
                        if (disp != null && (name = disp.getFilename()) != null && !name.isEmpty()) {
                            this.entry.setFilename(Util.sanitizeFilename(name.trim()));
                        }
                    }
                    catch (QuotaException qe) {
                        error = qe.getMessage();
                        this.getResponse().setStatus(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE);
                    }
                    catch (IOException ioe) {
                        if (ioe.getCause() instanceof NullPointerException) {
                            error = ioe.getCause().getMessage();
                            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        }
                        error = ioe.getMessage();
                        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    }
                }
            }
            if (error != null) {
                if (textarea) {
                    this.getResponse().setEntity("<textarea>{\"error\":\"" + error + "\"}</textarea>", MediaType.TEXT_HTML);
                } else {
                    JSONObject jsonError = new JSONObject();
                    try {
                        jsonError.put("error", (Object)error);
                    }
                    catch (JSONException jsone) {
                        log.error(jsone.getMessage());
                    }
                    this.getResponse().setEntity((Representation)new JsonRepresentation(error));
                }
                return;
            }
            JSONObject result = new JSONObject();
            result.put("success", (Object)"The file was uploaded");
            result.put("format", (Object)HtmlEscapers.htmlEscaper().escape(this.entry.getMimetype()));
            if (textarea) {
                this.getResponse().setEntity("<textarea>" + String.valueOf(result) + "</textarea>", MediaType.TEXT_HTML);
            } else {
                this.getResponse().setEntity((Representation)new JsonRepresentation(result));
            }
            this.getResponse().setStatus(Status.SUCCESS_CREATED);
        }
        if (gt == GraphType.String) {
            try {
                StringResource stringResource = (StringResource)this.entry.getResource();
                stringResource.setString(this.getRequest().getEntity().getText());
            }
            catch (IOException e) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Problem with input.\"}"));
            }
        }
        if (gt == GraphType.Graph || gt == GraphType.Pipeline) {
            RDFResource graphResource = (RDFResource)this.entry.getResource();
            if (graphResource != null) {
                graph = null;
                try {
                    graph = GraphUtil.deserializeGraph(this.getRequest().getEntity().getText(), mediaType);
                }
                catch (IOException ioe) {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Unable to read request entity\"}"));
                }
                if (graph != null) {
                    graphResource.setGraph(graph);
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                }
            } else {
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"No RDF resource found for this entry\"}"));
                log.error("No RDF resource found for entry with ResourceType Graph");
            }
        }
        if (GraphType.User.equals((Object)gt)) {
            try {
                LoginTokenCache loginTokenCache;
                JSONObject entityJSON = new JSONObject(this.getRequest().getEntity().getText());
                User resourceUser = (User)this.entry.getResource();
                if (entityJSON.has("name")) {
                    String oldName = resourceUser.getName();
                    String newName = entityJSON.getString("name");
                    if (resourceUser.setName(newName)) {
                        loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
                        loginTokenCache.renameUser(oldName, newName);
                    } else {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Name is already in use\"}"));
                        return;
                    }
                }
                if (entityJSON.has("password")) {
                    boolean requireCurrentPassword = this.getRM().getConfiguration().getBoolean(Settings.AUTH_PASSWORD_REQUIRE_CURRENT_PASSWORD, true);
                    String newPassword = entityJSON.getString("password");
                    if (requireCurrentPassword && (!this.getPM().currentUserIsAdminOrAdminGroup() || this.getPM().currentUserIsAdminOrAdminGroup() && this.getPM().getAuthenticatedUserURI().equals(resourceUser.getURI()))) {
                        if (!entityJSON.has("currentPassword")) {
                            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                            this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Current password is required\"}"));
                            return;
                        }
                        String currentPassword = entityJSON.getString("currentPassword");
                        String saltedHashedSecret = BasicVerifier.getSaltedHashedSecret(this.getPM(), resourceUser.getName());
                        if (saltedHashedSecret == null || !Password.check((String)currentPassword, (String)saltedHashedSecret)) {
                            this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                            this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"No password set or incorrect current password provided\"}"));
                            return;
                        }
                    }
                    if (resourceUser.setSecret(newPassword)) {
                        loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
                        loginTokenCache.removeTokensButOne(CookieVerifier.getAuthToken(this.getRequest()));
                        Email.sendPasswordChangeConfirmation(this.getRM().getConfiguration(), this.entry);
                    } else {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Password must conform to configured rules.\"}"));
                        return;
                    }
                }
                if (entityJSON.has("language")) {
                    String prefLang = entityJSON.getString("language");
                    if (prefLang.isEmpty()) {
                        resourceUser.setLanguage(null);
                    } else if (!resourceUser.setLanguage(prefLang)) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Preferred language could not be set.\"}"));
                        return;
                    }
                }
                if (entityJSON.has("homecontext")) {
                    String homeContext = entityJSON.getString("homecontext");
                    Entry entryHomeContext = this.getCM().get(homeContext);
                    if (!(entryHomeContext == null || entryHomeContext.getResource() instanceof Context && resourceUser.setHomeContext((Context)entryHomeContext.getResource()))) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Given homecontext is not a context.\"}"));
                        return;
                    }
                }
                if (entityJSON.has("disabled")) {
                    if (this.entry.getResourceURI().equals(this.getPM().getAuthenticatedUserURI())) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"Users cannot set their own disabled status\"}"));
                        return;
                    }
                    boolean disabled = entityJSON.optBoolean("disabled", false);
                    resourceUser.setDisabled(disabled);
                    if (disabled) {
                        String userName = this.getPM().getPrincipalName(this.entry.getResourceURI());
                        loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
                        loginTokenCache.removeTokens(userName);
                    }
                }
                if (entityJSON.has("customProperties")) {
                    HashMap<String, String> customPropMap = new HashMap<String, String>();
                    JSONObject customPropJson = entityJSON.getJSONObject("customProperties");
                    Iterator cPIt = customPropJson.keys();
                    while (cPIt.hasNext()) {
                        String key = (String)cPIt.next();
                        customPropMap.put(key, customPropJson.getString(key));
                    }
                    resourceUser.setCustomProperties(customPropMap);
                }
                this.getResponse().setStatus(Status.SUCCESS_OK);
            }
            catch (JSONException e) {
                log.debug("Wrong JSON syntax: {}", (Object)e.getMessage());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity((Representation)new JsonRepresentation(JSONErrorMessages.errorJSONSyntax));
            }
            catch (IOException e) {
                log.error(e.getMessage());
                this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                this.getResponse().setEntity((Representation)new JsonRepresentation("{\"error\":\"IOException\"}"));
            }
        }
    }
}

