/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.net.URI;
import org.entrystore.AuthorizationException;
import org.entrystore.Entry;
import org.entrystore.PrincipalManager;
import org.entrystore.rest.resources.BaseResource;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(SolrResource.class);

    public void doInit() {
    }

    @Post
    public void acceptRepresentation(Representation r) throws ResourceException {
        if (!MediaType.APPLICATION_JSON.equals((Object)r.getMediaType())) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        JSONObject request = null;
        try {
            request = new JsonRepresentation(r).getJsonObject();
        }
        catch (JSONException e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return;
        }
        if (this.getRM().getIndex() == null) {
            log.warn("Cannot reindex, Solr is not used");
            this.getResponse().setStatus(Status.SERVER_ERROR_SERVICE_UNAVAILABLE);
            return;
        }
        if (request.has("command") && "reindex".equalsIgnoreCase(request.getString("command"))) {
            String contextURIStr;
            PrincipalManager pm = this.getRM().getPrincipalManager();
            URI authUser = pm.getAuthenticatedUserURI();
            String string = contextURIStr = request.has("context") ? request.getString("context") : null;
            if (contextURIStr == null) {
                if (!pm.getAdminUser().getURI().equals(authUser) && !pm.getAdminGroup().isMember(pm.getUser(authUser))) {
                    this.unauthorizedPOST();
                    return;
                }
                this.getRM().getIndex().reindex(false);
                this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
                return;
            }
            URI contextURI = URI.create(contextURIStr);
            Entry contextEntry = this.getRM().getContextManager().getByEntryURI(contextURI);
            try {
                pm.checkAuthenticatedUserAuthorized(contextEntry, PrincipalManager.AccessProperty.Administer);
            }
            catch (AuthorizationException ae) {
                this.unauthorizedPOST();
                return;
            }
            this.getRM().getIndex().reindex(contextURI, false);
            this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
            return;
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
    }
}

