/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.entrystore.AuthorizationException;
import org.entrystore.PrincipalManager;
import org.entrystore.config.Config;
import org.entrystore.repository.RepositoryManager;
import org.entrystore.repository.backup.BackupScheduler;
import org.entrystore.repository.config.Settings;
import org.entrystore.repository.util.SolrSearchIndex;
import org.entrystore.repository.util.URISplit;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.resources.BaseResource;
import org.entrystore.rest.resources.EchoResource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusResource
extends BaseResource {
    static Logger log = LoggerFactory.getLogger(StatusResource.class);
    Config config;
    List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public void doInit() {
        this.supportedMediaTypes.add(MediaType.TEXT_PLAIN);
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        this.config = this.getRM().getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get
    public Representation represent() throws ResourceException {
        MediaType preferredMediaType = this.getRequest().getClientInfo().getPreferredMediaType(this.supportedMediaTypes);
        if (preferredMediaType == null) {
            preferredMediaType = MediaType.TEXT_PLAIN;
        }
        MediaType prefFormat = this.format != null ? this.format : preferredMediaType;
        try {
            if (this.parameters.containsKey("extended")) {
                JSONObject result = new JSONObject();
                try {
                    PrincipalManager pm = this.getRM().getPrincipalManager();
                    URI currentUser = pm.getAuthenticatedUserURI();
                    if (!pm.getAdminUser().getURI().equals(currentUser) && !pm.getAdminGroup().isMember(pm.getUser(currentUser))) {
                        this.getResponse().setStatus(Status.CLIENT_ERROR_FORBIDDEN);
                        return new EmptyRepresentation();
                    }
                    result.put("baseURI", (Object)this.getRM().getRepositoryURL().toString());
                    result.put("echoMaxEntitySize", EchoResource.MAX_ENTITY_SIZE);
                    result.put("oaiHarvester", this.config.getBoolean(Settings.HARVESTER_OAI, false));
                    result.put("oaiHarvesterMultiThreaded", this.config.getBoolean(Settings.HARVESTER_OAI_MULTITHREADED, false));
                    result.put("provenance", this.config.getBoolean(Settings.REPOSITORY_PROVENANCE, false));
                    result.put("quota", this.config.getBoolean(Settings.DATA_QUOTA, false));
                    result.put("quotaDefault", (Object)this.config.getString(Settings.DATA_QUOTA_DEFAULT, "unconfigured"));
                    result.put("repositoryCache", this.config.getBoolean(Settings.REPOSITORY_CACHE, false));
                    result.put("repositoryIndices", (Object)this.config.getString(Settings.STORE_INDEXES, "unconfigured"));
                    result.put("repositoryStatus", (Object)(this.getRM() != null ? "online" : "offline"));
                    result.put("repositoryType", (Object)this.config.getString(Settings.STORE_TYPE, "unconfigured"));
                    result.put("rowstoreURL", (Object)this.config.getString(Settings.ROWSTORE_URL, "unconfigured"));
                    result.put("version", (Object)EntryStoreApplication.getVersion());
                    result.put("startupTime", (Object)EntryStoreApplication.getStartupDate());
                    JSONObject auth = new JSONObject();
                    auth.put("signup", this.config.getBoolean(Settings.SIGNUP, false));
                    List domainWhitelist = this.config.getStringList(Settings.SIGNUP_WHITELIST, new ArrayList());
                    JSONArray signupWhitelist = new JSONArray();
                    for (String domain : domainWhitelist) {
                        if (domain == null) continue;
                        signupWhitelist.put((Object)domain.toLowerCase());
                    }
                    auth.put("signupWhitelist", (Object)signupWhitelist);
                    auth.put("passwordReset", this.config.getBoolean(Settings.AUTH_PASSWORD_RESET, false));
                    auth.put("passwordMaxLength", 2048);
                    LoginTokenCache loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
                    auth.put("authTokenCount", loginTokenCache.size());
                    result.put("auth", (Object)auth);
                    JSONObject cors = new JSONObject();
                    cors.put("enabled", this.config.getBoolean(Settings.CORS, false));
                    cors.put("headers", (Object)this.config.getString(Settings.CORS_HEADERS, "unconfigured"));
                    cors.put("maxAge", (Object)this.config.getString(Settings.CORS_MAX_AGE, "unconfigured"));
                    cors.put("origins", (Object)this.config.getString(Settings.CORS_ORIGINS, "unconfigured"));
                    cors.put("originsAllowCredentials", (Object)this.config.getString(Settings.CORS_ORIGINS_ALLOW_CREDENTIALS, "unconfigured"));
                    result.put("cors", (Object)cors);
                    JSONObject solr = new JSONObject();
                    SolrSearchIndex searchIndex = (SolrSearchIndex)this.getRM().getIndex();
                    solr.put("enabled", this.config.getBoolean(Settings.SOLR, false));
                    solr.put("reindexOnStartup", this.config.getBoolean(Settings.SOLR_REINDEX_ON_STARTUP, false));
                    solr.put("status", (Object)(searchIndex.isUp() ? "online" : "offline"));
                    solr.put("postQueueSize", searchIndex.getPostQueueSize());
                    solr.put("deleteQueueSize", searchIndex.getDeleteQueueSize());
                    solr.put("indexingContexts", (Collection)searchIndex.getIndexingContexts());
                    result.put("solr", (Object)solr);
                    JSONObject backup = new JSONObject();
                    backup.put("active", this.config.getBoolean(Settings.BACKUP_SCHEDULER, false));
                    backup.put("format", (Object)this.config.getString(Settings.BACKUP_FORMAT, "unconfigured"));
                    backup.put("maintenance", this.config.getBoolean(Settings.BACKUP_MAINTENANCE, false));
                    backup.put("cronExpression", (Object)this.config.getString(Settings.BACKUP_CRONEXP, this.config.getString(Settings.BACKUP_TIMEREGEXP_DEPRECATED, "unconfigured")));
                    if (BackupScheduler.getInstance((RepositoryManager)this.getRM()) != null) {
                        backup.put("cronExpressionResolved", (Object)BackupScheduler.getInstance((RepositoryManager)this.getRM()).getCronExpression());
                    }
                    backup.put("maintenanceExpiresAfterDays", (Object)this.config.getString(Settings.BACKUP_MAINTENANCE_EXPIRES_AFTER_DAYS, "unconfigured"));
                    backup.put("maintenanceLowerLimit", (Object)this.config.getString(Settings.BACKUP_MAINTENANCE_LOWER_LIMIT, "unconfigured"));
                    backup.put("maintenanceUpperLimit", (Object)this.config.getString(Settings.BACKUP_MAINTENANCE_UPPER_LIMIT, "unconfigured"));
                    result.put("backup", (Object)backup);
                    JSONObject jvm = new JSONObject();
                    jvm.put("totalMemory", Runtime.getRuntime().totalMemory());
                    jvm.put("freeMemory", Runtime.getRuntime().freeMemory());
                    jvm.put("maxMemory", Runtime.getRuntime().maxMemory());
                    jvm.put("availableProcessors", Runtime.getRuntime().availableProcessors());
                    jvm.put("totalCommittedMemory", this.getTotalCommittedMemory());
                    jvm.put("committedHeap", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted());
                    jvm.put("totalUsedMemory", this.getTotalUsedMemory());
                    jvm.put("usedHeap", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
                    jvm.put("gc", (Object)this.getGarbageCollectors());
                    result.put("jvm", (Object)jvm);
                    if (this.parameters.containsKey("includeStats")) {
                        JSONObject stats = new JSONObject();
                        try {
                            pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                            stats.put("contextCount", this.getRM().getContextManager().getEntries().size());
                            stats.put("groupCount", pm.getGroupUris().size());
                            stats.put("userCount", pm.getUsersAsUris().size());
                            stats.put("namedGraphCount", this.getRM().getNamedGraphCount());
                            stats.put("tripleCount", this.getRM().getTripleCount());
                        }
                        finally {
                            pm.setAuthenticatedUserURI(currentUser);
                        }
                        result.put("stats", (Object)stats);
                    }
                    if (this.parameters.containsKey("includeRelationStats")) {
                        result.put("relationStats", (Object)this.getRelationStats(((String)this.parameters.get("includeRelationStats")).equalsIgnoreCase("verbose")));
                    }
                    return new JsonRepresentation(result);
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    return new EmptyRepresentation();
                }
            }
            if (prefFormat.equals((Object)MediaType.APPLICATION_JSON)) {
                try {
                    JSONObject result = new JSONObject();
                    result.put("version", (Object)EntryStoreApplication.getVersion());
                    result.put("repositoryStatus", (Object)(this.getRM() != null ? "online" : "offline"));
                    return new JsonRepresentation(result);
                }
                catch (JSONException e) {
                    log.error(e.getMessage());
                    this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                    return new EmptyRepresentation();
                }
            }
            if (this.getRM() != null && this.getRM().getIndex() != null && this.getRM().getIndex().isUp()) {
                return new StringRepresentation((CharSequence)"UP", MediaType.TEXT_PLAIN);
            }
            return new StringRepresentation((CharSequence)"DOWN", MediaType.TEXT_PLAIN);
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    long getTotalCommittedMemory() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted() + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getCommitted();
    }

    long getTotalUsedMemory() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed() + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
    }

    JSONArray getGarbageCollectors() {
        JSONArray result = new JSONArray();
        for (GarbageCollectorMXBean gcMxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            result.put((Object)gcMxBean.getName());
        }
        return result;
    }

    JSONObject getRelationStats(boolean verbose) {
        Repository repository = this.getRM().getRepository();
        long checkedRelations = 0L;
        HashMap<String, Long> relationStats = new HashMap<String, Long>();
        ArrayList<String> relationContextsWithoutEntryContext = new ArrayList<String>();
        ArrayList<String> statementsWithDanglingObject = new ArrayList<String>();
        try (RepositoryConnection rc = repository.getConnection();
             RepositoryResult rr = rc.getContextIDs();){
            for (Resource context : rr) {
                String contextIRIStr;
                if (context == null || !context.isIRI() || !this.isRelationIRI(contextIRIStr = context.toString())) continue;
                if (!this.doesEntryExist(contextIRIStr)) {
                    log.warn("No corresponding entry found for relation graph <{}>", (Object)contextIRIStr);
                    relationContextsWithoutEntryContext.add(contextIRIStr);
                    continue;
                }
                RepositoryConnection rc2 = repository.getConnection();
                try {
                    RepositoryResult relations = rc2.getStatements(null, null, null, false, new Resource[]{context});
                    try {
                        for (Statement relation : relations) {
                            if (!relation.getObject().isIRI()) {
                                log.warn("Statement does not have a resource in object position: {}", (Object)relation);
                                continue;
                            }
                            RepositoryConnection rc3 = repository.getConnection();
                            try {
                                RepositoryResult targetEntry = rc3.getStatements((Resource)relation.getObject(), null, null, false, new Resource[0]);
                                try {
                                    ++checkedRelations;
                                    if (targetEntry.hasNext()) continue;
                                    log.warn("Relation target does not exist: <{}>, statement: {}", (Object)relation.getObject(), (Object)relation);
                                    statementsWithDanglingObject.add(relation.toString());
                                    String predicate = relation.getPredicate().toString();
                                    relationStats.put(predicate, relationStats.getOrDefault(predicate, 0L) + 1L);
                                }
                                finally {
                                    if (targetEntry == null) continue;
                                    targetEntry.close();
                                }
                            }
                            finally {
                                if (rc3 == null) continue;
                                rc3.close();
                            }
                        }
                    }
                    finally {
                        if (relations == null) continue;
                        relations.close();
                    }
                }
                finally {
                    if (rc2 == null) continue;
                    rc2.close();
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        for (Map.Entry entry : relationStats.entrySet()) {
            log.info("{}: {}", entry.getKey(), entry.getValue());
        }
        log.info("Checked relations: {}", (Object)checkedRelations);
        log.info("Active relations pointing to non-existing targets: {}", (Object)statementsWithDanglingObject.size());
        log.info("Relation contexts without existing entry context: {}", (Object)relationContextsWithoutEntryContext.size());
        JSONObject result = new JSONObject();
        result.put("checkedRelationCount", checkedRelations);
        result.put("activeRelationsWithNonExistingTargetPredicateStats", relationStats);
        result.put("activeRelationsWithNonExistingTargetCount", statementsWithDanglingObject.size());
        result.put("relationContextsWithoutEntryContextCount", relationContextsWithoutEntryContext.size());
        if (verbose) {
            result.put("activeRelationsWithNonExistingTarget", (Object)new JSONArray(statementsWithDanglingObject));
            result.put("relationContextsWithoutEntryContext", (Object)new JSONArray(relationContextsWithoutEntryContext));
        }
        return result;
    }

    private boolean doesEntryExist(String relationIRIStr) {
        IRI entryURI = Values.iri((String)new URISplit(URI.create(relationIRIStr), this.getRM().getRepositoryURL()).getMetaMetadataURI().toString());
        try (RepositoryConnection rc = this.getRM().getRepository().getConnection();
             RepositoryResult entryGraph = rc.getStatements(null, null, null, false, new Resource[]{entryURI});){
            if (entryGraph.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean isRelationIRI(String iriStr) {
        return iriStr.startsWith(this.getRM().getRepositoryURL().toString()) && iriStr.contains("/relations/");
    }
}

