/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.resources;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import org.entrystore.AuthorizationException;
import org.entrystore.Context;
import org.entrystore.PrincipalManager;
import org.entrystore.User;
import org.entrystore.rest.EntryStoreApplication;
import org.entrystore.rest.auth.LoginTokenCache;
import org.entrystore.rest.auth.UserInfo;
import org.entrystore.rest.resources.BaseResource;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Cookie;
import org.restlet.data.Language;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(UserResource.class);

    @Get
    public Representation represent() throws ResourceException {
        try {
            try {
                return new JsonRepresentation(this.buildUserInfo(this.getPM(), this.getPM().getUser(this.getPM().getAuthenticatedUserURI())));
            }
            catch (JSONException e) {
                log.error(e.getMessage());
                this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
                return new EmptyRepresentation();
            }
        }
        catch (AuthorizationException e) {
            return this.unauthorizedGET();
        }
    }

    private JSONObject buildUserInfo(PrincipalManager pm, User user) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("user", (Object)user.getName());
        result.put("id", (Object)user.getEntry().getId());
        result.put("uri", (Object)user.getEntry().getEntryURI());
        JSONObject clientAcceptLanguage = new JSONObject();
        DecimalFormat decFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        decFormat.applyPattern("#.##");
        decFormat.setRoundingMode(RoundingMode.FLOOR);
        for (Preference lang : this.getRequest().getClientInfo().getAcceptedLanguages()) {
            clientAcceptLanguage.put(((Language)lang.getMetadata()).toString(), (Object)Float.valueOf(decFormat.format(lang.getQuality())));
        }
        result.put("clientAcceptLanguage", (Object)clientAcceptLanguage);
        if (!user.getURI().equals(pm.getGuestUser().getURI())) {
            Cookie authTokenCookie;
            String extID;
            String userLang;
            Context homeContext = user.getHomeContext();
            if (homeContext != null) {
                result.put("homecontext", (Object)homeContext.getEntry().getId());
            }
            if ((userLang = user.getLanguage()) != null) {
                result.put("language", (Object)userLang);
            }
            if ((extID = user.getExternalID()) != null) {
                result.put("external_id", (Object)extID);
            }
            if ((authTokenCookie = (Cookie)this.getRequest().getCookies().getFirst("auth_token")) != null) {
                String authToken = authTokenCookie.getValue();
                LoginTokenCache loginTokenCache = ((EntryStoreApplication)this.getApplication()).getLoginTokenCache();
                UserInfo ui = (UserInfo)loginTokenCache.getTokenValue(authToken);
                if (ui != null && ui.getLoginExpiration() != null) {
                    result.put("authTokenExpires", (Object)ui.getLoginExpiration());
                }
            }
        }
        return result;
    }
}

