/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.entrystore.config.Config;
import org.entrystore.repository.config.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSUtil {
    private static final Logger log = LoggerFactory.getLogger(CORSUtil.class);
    private static final Map<Config, CORSUtil> instances = new HashMap<Config, CORSUtil>();
    private final List<String> allowedOriginPatterns;
    private final List<String> allowedOriginPatternsWithCredentials;
    private Set<String> allowedHeaders;
    private int maxAge = -1;

    private CORSUtil(Config config) {
        String[] patterns;
        String origins = config.getString(Settings.CORS_ORIGINS, "*");
        this.allowedOriginPatterns = new ArrayList<String>();
        for (String p : patterns = origins.split(",")) {
            log.info("CORS allowed origin: {}", (Object)p);
            this.allowedOriginPatterns.add(p.trim().toLowerCase());
        }
        String originsAllowCredentials = config.getString(Settings.CORS_ORIGINS_ALLOW_CREDENTIALS, "");
        this.allowedOriginPatternsWithCredentials = new ArrayList<String>();
        for (String p : patterns = originsAllowCredentials.split(",")) {
            log.info("CORS allowed origin (with credentials): {}", (Object)p);
            this.allowedOriginPatternsWithCredentials.add(p.trim().toLowerCase());
        }
        if (config.containsKey(Settings.CORS_HEADERS)) {
            String confAllHeaders = config.getString(Settings.CORS_HEADERS);
            this.allowedHeaders = new HashSet<String>(Arrays.asList(confAllHeaders.split(",")));
            log.info("CORS allowed/exposed headers: " + confAllHeaders);
        }
        if (config.containsKey(Settings.CORS_MAX_AGE)) {
            this.maxAge = config.getInt(Settings.CORS_MAX_AGE, -1);
            log.info("CORS max age: " + this.maxAge);
        }
    }

    public static CORSUtil getInstance(Config config) {
        if (!instances.containsKey(config)) {
            instances.put(config, new CORSUtil(config));
        }
        return instances.get(config);
    }

    public boolean isValidOrigin(String origin) {
        return this.isAllowedOrigin(origin, this.allowedOriginPatterns);
    }

    public boolean isValidOriginWithCredentials(String origin) {
        return this.isAllowedOrigin(origin, this.allowedOriginPatternsWithCredentials);
    }

    private boolean isAllowedOrigin(String origin, List<String> patterns) {
        if (origin == null || patterns == null) {
            return false;
        }
        origin = origin.toLowerCase();
        for (String pattern : patterns) {
            if ("*".equals(pattern)) {
                return true;
            }
            if (pattern.equals(origin)) {
                return true;
            }
            if (!(pattern.startsWith("*") ? origin.endsWith(pattern = pattern.substring(1)) : pattern.endsWith("*") && origin.startsWith(pattern = pattern.substring(0, pattern.length() - 1)))) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public int getMaxAge() {
        return this.maxAge;
    }
}

