/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.InetAddressValidator;

public class EmailValidator
extends org.apache.commons.validator.routines.EmailValidator {
    private static final String IP_DOMAIN_REGEX = "^\\[(.*)\\]$";
    private static final Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final EmailValidator EMAIL_VALIDATOR_WITH_LOCAL = new EmailValidator();

    protected EmailValidator() {
        super(true);
    }

    public static EmailValidator getInstance() {
        return EMAIL_VALIDATOR_WITH_LOCAL;
    }

    protected boolean isValidDomain(String domain) {
        Matcher ipDomainMatcher = IP_DOMAIN_PATTERN.matcher(domain);
        if (ipDomainMatcher.matches()) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            return inetAddressValidator.isValid(ipDomainMatcher.group(1));
        }
        return domain.contains(".") && domain.indexOf(".") != 0 && domain.lastIndexOf(".") <= domain.length() - 3;
    }
}

