/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.xml.XMLReaderFactory;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.JSONLDMode;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.rio.helpers.XMLParserSettings;
import org.eclipse.rdf4j.rio.jsonld.JSONLDParser;
import org.eclipse.rdf4j.rio.jsonld.JSONLDWriter;
import org.eclipse.rdf4j.rio.n3.N3ParserFactory;
import org.eclipse.rdf4j.rio.n3.N3Writer;
import org.eclipse.rdf4j.rio.ntriples.NTriplesParser;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLParser;
import org.eclipse.rdf4j.rio.rdfxml.util.RDFXMLPrettyWriter;
import org.eclipse.rdf4j.rio.trig.TriGParser;
import org.eclipse.rdf4j.rio.trig.TriGWriter;
import org.eclipse.rdf4j.rio.trix.TriXParser;
import org.eclipse.rdf4j.rio.trix.TriXWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.entrystore.repository.util.NS;
import org.entrystore.rest.util.RDFJSON;
import org.entrystore.rest.util.URIValidatingRDFHandler;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GraphUtil {
    private static final Logger log = LoggerFactory.getLogger(GraphUtil.class);
    private static final List<MediaType> supportedMediaTypes = new ArrayList<MediaType>();

    public static String serializeGraph(Model graph, Class<? extends RDFWriter> writer) {
        if (graph == null || writer == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        StringWriter stringWriter = new StringWriter();
        HashMap<String, String> namespaces = NS.getMap();
        RDFWriter rdfWriter = null;
        try {
            Constructor<? extends RDFWriter> constructor = writer.getConstructor(Writer.class);
            rdfWriter = constructor.newInstance(stringWriter);
            if (!System.getProperties().containsKey("org.eclipse.rdf4j.rio.rdf10_plain_literals")) {
                rdfWriter.getWriterConfig().set((RioSetting)BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, (Object)true);
            }
            if (!System.getProperties().containsKey("org.eclipse.rdf4j.rio.rdf10_language_literals")) {
                rdfWriter.getWriterConfig().set((RioSetting)BasicWriterSettings.RDF_LANGSTRING_TO_LANG_LITERAL, (Object)true);
            }
            if (!System.getProperties().containsKey("org.eclipse.rdf4j.rio.jsonld.optimize")) {
                rdfWriter.getWriterConfig().set((RioSetting)JSONLDSettings.OPTIMIZE, (Object)true);
            }
            if (!System.getProperties().containsKey("org.eclipse.rdf4j.rio.jsonld.use_native_types")) {
                rdfWriter.getWriterConfig().set((RioSetting)JSONLDSettings.USE_NATIVE_TYPES, (Object)true);
            }
            rdfWriter.getWriterConfig().set(JSONLDSettings.JSONLD_MODE, (Object)JSONLDMode.COMPACT);
            if (rdfWriter instanceof JSONLDWriter) {
                namespaces = new HashMap<String, String>();
                for (Statement s : graph) {
                    namespaces.putAll(GraphUtil.findNS((Value)s.getSubject()));
                    namespaces.putAll(GraphUtil.findNS((Value)s.getPredicate()));
                    namespaces.putAll(GraphUtil.findNS(s.getObject()));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (rdfWriter == null) {
            return null;
        }
        try {
            rdfWriter.startRDF();
            for (String nsName : namespaces.keySet()) {
                rdfWriter.handleNamespace(nsName, (String)namespaces.get(nsName));
            }
            for (Statement statement : graph) {
                rdfWriter.handleStatement(statement);
            }
            rdfWriter.endRDF();
        }
        catch (RDFHandlerException rdfe) {
            log.error(rdfe.getMessage());
        }
        return stringWriter.toString();
    }

    public static void serializeGraph(Model graph, RDFWriter rdfWriter) {
        if (graph == null || rdfWriter == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        try {
            rdfWriter.startRDF();
            HashMap namespaces = NS.getMap();
            for (String nsName : namespaces.keySet()) {
                rdfWriter.handleNamespace(nsName, (String)namespaces.get(nsName));
            }
            for (Statement statement : graph) {
                rdfWriter.handleStatement(statement);
            }
            rdfWriter.endRDF();
        }
        catch (RDFHandlerException rdfe) {
            log.error(rdfe.getMessage());
        }
    }

    public static Model deserializeGraph(String serializedGraph, RDFParser parser) {
        try {
            return GraphUtil.deserializeGraphUnsafe(serializedGraph, parser);
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Model deserializeGraphUnsafe(String serializedGraph, RDFParser parser) throws RDFParseException, RDFHandlerException, IOException {
        if (serializedGraph == null || parser == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        StringReader reader = new StringReader(serializedGraph);
        StatementCollector collector = new StatementCollector();
        parser.setRDFHandler((RDFHandler)collector);
        parser.parse((Reader)reader, "");
        return new LinkedHashModel(collector.getStatements());
    }

    public static Model deserializeGraph(String graphString, MediaType mediaType) {
        try {
            return GraphUtil.deserializeGraphUnsafe(graphString, mediaType);
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static Model deserializeGraphUnsafe(String graphString, MediaType mediaType) throws RDFHandlerException, IOException, RDFParseException {
        Model deserializedGraph = null;
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON) || mediaType.getName().equals("application/rdf+json")) {
            deserializedGraph = RDFJSON.rdfJsonToGraph(graphString);
        } else if (mediaType.equals((Object)MediaType.APPLICATION_RDF_XML)) {
            RDFXMLParser rdfXmlParser = new RDFXMLParser();
            rdfXmlParser.setParserConfig(GraphUtil.constructSafeXmlParserConfig());
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, (RDFParser)rdfXmlParser);
        } else if (mediaType.equals((Object)MediaType.TEXT_RDF_N3)) {
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, new N3ParserFactory().getParser());
        } else if (mediaType.getName().equals(RDFFormat.TURTLE.getDefaultMIMEType())) {
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, (RDFParser)new TurtleParser());
        } else if (mediaType.getName().equals(RDFFormat.TRIX.getDefaultMIMEType())) {
            TriXParser trixParser = new TriXParser();
            trixParser.setParserConfig(GraphUtil.constructSafeXmlParserConfig());
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, (RDFParser)trixParser);
        } else if (mediaType.getName().equals(RDFFormat.NTRIPLES.getDefaultMIMEType())) {
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, (RDFParser)new NTriplesParser());
        } else if (mediaType.getName().equals(RDFFormat.TRIG.getDefaultMIMEType())) {
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, (RDFParser)new TriGParser());
        } else if (mediaType.getName().equals(RDFFormat.JSONLD.getDefaultMIMEType())) {
            deserializedGraph = GraphUtil.deserializeGraphUnsafe(graphString, (RDFParser)new JSONLDParser());
        }
        return deserializedGraph;
    }

    public static String serializeGraph(Model graph, MediaType mediaType) {
        String serializedGraph = mediaType.equals((Object)MediaType.APPLICATION_JSON) || mediaType.getName().equals("application/rdf+json") ? RDFJSON.graphToRdfJson(graph) : (mediaType.equals((Object)MediaType.APPLICATION_RDF_XML) ? GraphUtil.serializeGraph(graph, RDFXMLPrettyWriter.class) : (mediaType.equals((Object)MediaType.TEXT_RDF_N3) ? GraphUtil.serializeGraph(graph, N3Writer.class) : (mediaType.getName().equals(RDFFormat.TURTLE.getDefaultMIMEType()) ? GraphUtil.serializeGraph(graph, TurtleWriter.class) : (mediaType.getName().equals(RDFFormat.TRIX.getDefaultMIMEType()) ? GraphUtil.serializeGraph(graph, TriXWriter.class) : (mediaType.getName().equals(RDFFormat.NTRIPLES.getDefaultMIMEType()) ? GraphUtil.serializeGraph(graph, NTriplesWriter.class) : (mediaType.getName().equals(RDFFormat.TRIG.getDefaultMIMEType()) ? GraphUtil.serializeGraph(graph, TriGWriter.class) : (mediaType.getName().equals(RDFFormat.JSONLD.getDefaultMIMEType()) ? GraphUtil.serializeGraph(graph, JSONLDWriter.class) : GraphUtil.serializeGraph(graph, TurtleWriter.class))))))));
        return serializedGraph;
    }

    public static JSONObject serializeGraphToJson(Model graph, MediaType rdfFormat) {
        if (rdfFormat == null || MediaType.APPLICATION_JSON.equals((Object)rdfFormat)) {
            return RDFJSON.graphToRdfJsonObject(graph);
        }
        if (RDFFormat.JSONLD.getDefaultMIMEType().equals(rdfFormat.getName())) {
            return new JSONObject(GraphUtil.serializeGraph(graph, rdfFormat));
        }
        log.warn("Model could not be serialized, returning empty JSON object");
        return new JSONObject();
    }

    public static boolean isSupported(MediaType mediaType) {
        for (MediaType mt : supportedMediaTypes) {
            if (!mt.equals((Object)mediaType, false)) continue;
            return true;
        }
        return false;
    }

    public static String validateRdf(String rdf, MediaType mediaType) {
        if (!GraphUtil.isSupported(mediaType)) {
            return "Unsupported media type: " + String.valueOf(mediaType);
        }
        StringReader reader = new StringReader(rdf);
        URIValidatingRDFHandler nullHandler = new URIValidatingRDFHandler();
        RDFXMLParser parser = new RDFXMLParser();
        parser.setParserConfig(GraphUtil.constructSafeXmlParserConfig());
        if (mediaType.equals((Object)MediaType.APPLICATION_JSON) || mediaType.getName().equals("application/rdf+json")) {
            Model g = RDFJSON.rdfJsonToGraph(rdf);
            if (g != null) {
                return "There was an error parsing the RDF/JSON payload";
            }
            return null;
        }
        if (mediaType.equals((Object)MediaType.TEXT_RDF_N3)) {
            parser = new N3ParserFactory().getParser();
        } else if (mediaType.getName().equals(RDFFormat.TURTLE.getDefaultMIMEType())) {
            parser = new TurtleParser();
        } else if (mediaType.getName().equals(RDFFormat.TRIX.getDefaultMIMEType())) {
            parser = new TriXParser();
            parser.setParserConfig(GraphUtil.constructSafeXmlParserConfig());
        } else if (mediaType.getName().equals(RDFFormat.NTRIPLES.getDefaultMIMEType())) {
            parser = new NTriplesParser();
        } else if (mediaType.getName().equals(RDFFormat.TRIG.getDefaultMIMEType())) {
            parser = new TriGParser();
        } else if (mediaType.getName().equals(RDFFormat.JSONLD.getDefaultMIMEType())) {
            parser = new JSONLDParser();
        }
        String error = null;
        try {
            parser.setRDFHandler((RDFHandler)nullHandler);
            parser.parse((Reader)reader, "");
        }
        catch (IOException | RDFHandlerException | RDFParseException rdfe) {
            error = rdfe.getMessage();
        }
        return error;
    }

    private static ParserConfig constructSafeXmlParserConfig() {
        ParserConfig pc = new ParserConfig();
        pc.set((RioSetting)XMLParserSettings.LOAD_EXTERNAL_DTD, (Object)false);
        pc.set((RioSetting)XMLParserSettings.SECURE_PROCESSING, (Object)true);
        XMLReader customXmlReader = null;
        try {
            customXmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            log.error(e.getMessage());
        }
        if (customXmlReader != null) {
            pc.set(XMLParserSettings.CUSTOM_XML_READER, (Object)customXmlReader);
            try {
                customXmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (SAXException se) {
                log.warn(se.getMessage());
            }
            try {
                customXmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (SAXException se) {
                log.warn(se.getMessage());
            }
            try {
                customXmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXException se) {
                log.warn(se.getMessage());
            }
            try {
                customXmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException se) {
                log.warn(se.getMessage());
            }
        }
        return pc;
    }

    private static Map<String, String> findNS(Value value) {
        String dataTypeIri;
        HashMap<String, String> result = new HashMap<String, String>();
        if (value.isLiteral()) {
            dataTypeIri = ((Literal)value).getDatatype().stringValue();
        } else if (value.isIRI()) {
            dataTypeIri = value.stringValue();
        } else {
            return result;
        }
        NS.getMap().forEach((prefix, ns) -> {
            if (dataTypeIri.startsWith((String)ns)) {
                result.put((String)prefix, (String)ns);
            }
        });
        return result;
    }

    static {
        supportedMediaTypes.add(MediaType.APPLICATION_RDF_XML);
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        supportedMediaTypes.add(MediaType.TEXT_RDF_N3);
        supportedMediaTypes.add(new MediaType(RDFFormat.TURTLE.getDefaultMIMEType()));
        supportedMediaTypes.add(new MediaType(RDFFormat.TRIX.getDefaultMIMEType()));
        supportedMediaTypes.add(new MediaType(RDFFormat.NTRIPLES.getDefaultMIMEType()));
        supportedMediaTypes.add(new MediaType(RDFFormat.TRIG.getDefaultMIMEType()));
        supportedMediaTypes.add(new MediaType(RDFFormat.JSONLD.getDefaultMIMEType()));
        supportedMediaTypes.add(new MediaType("application/rdf+json"));
    }
}

