/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import org.entrystore.rest.util.HttpUtil;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecaptchaVerifier {
    private static final Logger log = LoggerFactory.getLogger(RecaptchaVerifier.class);
    private final String secret;

    public RecaptchaVerifier(String secret) {
        if (secret == null) {
            throw new IllegalArgumentException("reCaptcha secret must not be null");
        }
        this.secret = secret;
    }

    public boolean verify(String userResponse, String userIP) {
        if (userResponse == null) {
            throw new IllegalArgumentException("User response token must not be null");
        }
        StringBuilder reCaptchaUrl = new StringBuilder().append("https://www.google.com/recaptcha/api/siteverify?secret=").append(this.secret).append("&response=").append(userResponse);
        if (userIP != null) {
            reCaptchaUrl.append("&remoteip=").append(userIP);
        }
        log.debug("reCaptcha URL: {}", (Object)reCaptchaUrl);
        Response response = HttpUtil.getResourceFromURL(reCaptchaUrl.toString());
        if (!response.getStatus().isSuccess()) {
            return false;
        }
        try {
            JSONObject result = new JSONObject(response.getEntityAsText());
            if (result.has("success")) {
                return result.getBoolean("success");
            }
        }
        catch (JSONException e) {
            log.debug(e.getMessage());
            return false;
        }
        return false;
    }
}

