/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class URIValidatingRDFHandler
extends AbstractRDFHandler {
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RDFHandlerException(e.getMessage());
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        try {
            if (st.getSubject() instanceof IRI) {
                new URI(st.getSubject().stringValue());
            }
            new URI(st.getPredicate().stringValue());
            if (st.getObject() instanceof IRI) {
                new URI(st.getObject().stringValue());
            }
        }
        catch (URISyntaxException e) {
            throw new RDFHandlerException(e.getMessage());
        }
    }
}

