/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.rest.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.entrystore.Entry;
import org.entrystore.rest.EntryStoreApplication;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.Tag;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    static Logger log = LoggerFactory.getLogger(Util.class);
    public static Set<String> dangerousFileExtensions = new HashSet<String>();

    public static HashMap<String, String> parseRequest(String request) {
        HashMap<String, String> argsAndVal = new HashMap<String, String>();
        int r = request.lastIndexOf("?");
        String req = request.substring(r + 1);
        String[] arguments = StringUtils.split((String)req, (char)'&');
        try {
            for (String argument : arguments) {
                String[] elements = StringUtils.split((String)argument, (char)'=');
                argsAndVal.put(elements[0], elements.length == 1 ? "" : Util.decodeHttpParameterIfNeeded(elements[0], elements[1]));
            }
        }
        catch (IndexOutOfBoundsException e) {
            argsAndVal.put(req, "");
        }
        return argsAndVal;
    }

    private static String decodeHttpParameterIfNeeded(String name, String value) {
        switch (name) {
            case "format": 
            case "rdfFormat": {
                value = value.replace("+", "%2B");
            }
        }
        return URLDecoder.decode(value.trim(), StandardCharsets.UTF_8);
    }

    public static void handleIfUnmodifiedSince(Entry entry, Request request) {
        if (entry != null && request != null) {
            Date modDate = entry.getModifiedDate();
            Date unmodSince = request.getConditions().getUnmodifiedSince();
            if (modDate != null && unmodSince != null) {
                long dT = modDate.getTime() - unmodSince.getTime();
                if (dT < 0L) {
                    dT *= -1L;
                }
                if (dT < 1000L) {
                    request.getConditions().setUnmodifiedSince(null);
                }
            } else {
                request.getConditions().setUnmodifiedSince(null);
            }
        }
    }

    public static JSONObject createResponseObject(int statusCode, String message) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("status", statusCode);
            obj.put("message", (Object)message);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
        return obj;
    }

    public static RestletFileUpload createRestletFileUpload(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null");
        }
        DiskFileItemFactory dfif = new DiskFileItemFactory(102400, null);
        RestletFileUpload upload = new RestletFileUpload((FileItemFactory)dfif);
        ServletContext sc = EntryStoreApplication.getServletContext(context);
        if (sc != null) {
            log.debug("Setting FileCleaningTracker on DiskFileItemFactory");
            dfif.setFileCleaningTracker(FileCleanerCleanup.getFileCleaningTracker((ServletContext)sc));
        } else {
            log.debug("Unable to get ServletContext instance, no FileCleaningTracker assigned to DiskFileItemFactory");
        }
        return upload;
    }

    public static Tag createTag(Date date) {
        return new Tag(Long.toString(date.getTime()), false);
    }

    public static String sanitizeFilename(String filename) {
        String fileExt = FilenameUtils.getExtension((String)filename);
        if (fileExt != null && dangerousFileExtensions.contains(fileExt.toLowerCase())) {
            return filename + "_dangerous";
        }
        return filename;
    }

    static {
        dangerousFileExtensions.add("apk");
        dangerousFileExtensions.add("app");
        dangerousFileExtensions.add("asp");
        dangerousFileExtensions.add("aspx");
        dangerousFileExtensions.add("bat");
        dangerousFileExtensions.add("bin");
        dangerousFileExtensions.add("cab");
        dangerousFileExtensions.add("cmd");
        dangerousFileExtensions.add("com");
        dangerousFileExtensions.add("command");
        dangerousFileExtensions.add("cpl");
        dangerousFileExtensions.add("csh");
        dangerousFileExtensions.add("ex");
        dangerousFileExtensions.add("exe");
        dangerousFileExtensions.add("gadget");
        dangerousFileExtensions.add("inf");
        dangerousFileExtensions.add("ins");
        dangerousFileExtensions.add("inx");
        dangerousFileExtensions.add("ipa");
        dangerousFileExtensions.add("isu");
        dangerousFileExtensions.add("js");
        dangerousFileExtensions.add("jse");
        dangerousFileExtensions.add("jsp");
        dangerousFileExtensions.add("jsx");
        dangerousFileExtensions.add("ksh");
        dangerousFileExtensions.add("lnk");
        dangerousFileExtensions.add("msc");
        dangerousFileExtensions.add("msi");
        dangerousFileExtensions.add("msp");
        dangerousFileExtensions.add("mst");
        dangerousFileExtensions.add("osx");
        dangerousFileExtensions.add("out");
        dangerousFileExtensions.add("paf");
        dangerousFileExtensions.add("pif");
        dangerousFileExtensions.add("php");
        dangerousFileExtensions.add("pl");
        dangerousFileExtensions.add("plx");
        dangerousFileExtensions.add("prg");
        dangerousFileExtensions.add("ps1");
        dangerousFileExtensions.add("rb");
        dangerousFileExtensions.add("reg");
        dangerousFileExtensions.add("rgs");
        dangerousFileExtensions.add("run");
        dangerousFileExtensions.add("scr");
        dangerousFileExtensions.add("sct");
        dangerousFileExtensions.add("shb");
        dangerousFileExtensions.add("shs");
        dangerousFileExtensions.add("u3p");
        dangerousFileExtensions.add("vb");
        dangerousFileExtensions.add("vbe");
        dangerousFileExtensions.add("vbs");
        dangerousFileExtensions.add("vbscript");
        dangerousFileExtensions.add("workflow");
        dangerousFileExtensions.add("ws");
        dangerousFileExtensions.add("wsf");
        dangerousFileExtensions.add("wsh");
    }
}

