/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.harvesting.oaipmh.harvester;

import java.net.URI;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.entrystore.harvester.Harvester;
import org.entrystore.harvesting.oaipmh.jobs.ListRecordsJob;
import org.entrystore.impl.RepositoryManagerImpl;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class OAIHarvester
extends Harvester {
    Log log = LogFactory.getLog(OAIHarvester.class);
    Scheduler scheduler;
    JobDetail job;
    Trigger trigger;
    String groupName = "oaiGroup";
    String jobName;

    public OAIHarvester(String target, String metadataType, String set, String timeRegExp, RepositoryManagerImpl rm, URI ownerContextURI) {
        super("OAI-PMH", target, metadataType, set, timeRegExp, rm, ownerContextURI);
        this.jobName = ownerContextURI.toString();
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.job = new JobDetail(this.jobName, this.groupName, ListRecordsJob.class);
            this.job.getJobDataMap().put("metadataType", this.getMetadataType());
            this.job.getJobDataMap().put("target", this.getTarget());
            this.job.getJobDataMap().put((Object)"rm", (Object)this.getRM());
            this.job.getJobDataMap().put((Object)"contextURI", (Object)this.getOwnerContextURI());
            this.job.getJobDataMap().put("from", this.getFrom());
            this.job.getJobDataMap().put("until", this.getUntil());
            this.job.getJobDataMap().put("set", this.getSet());
            this.trigger = new CronTrigger("trigger_" + this.jobName, this.groupName, this.jobName, this.groupName, this.getTimeRegExp());
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (ParseException e) {
            this.log.error((Object)e.getMessage());
        }
        this.log.info((Object)("Created an OAIHarvester for " + String.valueOf(ownerContextURI)));
    }

    public void run(String identifier) {
        this.log.warn((Object)"OAIHarvester.run(String identifier) is not implemented");
    }

    public void run() {
        try {
            this.scheduler.addJob(this.job, true);
            this.scheduler.scheduleJob(this.trigger);
            if (this.scheduler.isInStandbyMode()) {
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void setTimeRegExp(String timeRegExp) {
        try {
            JobDetail job = this.scheduler.getJobDetail(this.jobName, this.groupName);
            if (job != null) {
                CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger("trigger_" + this.jobName, this.groupName);
                this.log.info((Object)("Set new time: " + timeRegExp));
                trigger.setCronExpression(timeRegExp);
                this.scheduler.rescheduleJob("trigger_" + this.jobName, this.groupName, (Trigger)trigger);
                this.log.info((Object)("trigger.getNextFireTime(): " + String.valueOf(trigger.getNextFireTime())));
            }
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (ParseException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void setSet(String set) {
        super.setSet(set);
        JobDetail job = this.getJob();
        if (job != null) {
            job.getJobDataMap().put("set", set);
        }
    }

    public void setFrom(String from) {
        super.setFrom(from);
        JobDetail job = this.getJob();
        if (job != null) {
            job.getJobDataMap().put("from", from);
        }
    }

    public void setUntil(String until) {
        super.setUntil(until);
        JobDetail job = this.getJob();
        if (job != null) {
            job.getJobDataMap().put("until", until);
        }
    }

    public void setMetadataType(String metadataType) {
        super.setMetadataType(metadataType);
        JobDetail job = this.getJob();
        if (job != null) {
            job.getJobDataMap().put("metadataType", metadataType);
        }
    }

    public void setTarget(String target) {
        super.setTarget(target);
        JobDetail job = this.getJob();
        if (job != null) {
            job.getJobDataMap().put("target", target);
        }
    }

    public boolean delete() {
        try {
            if (this.job != null) {
                this.log.info((Object)"Deleting OAI harvester job");
                this.scheduler.deleteJob(this.job.getName(), this.job.getGroup());
                this.job = null;
            }
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    private JobDetail getJob() {
        return this.job;
    }
}

