/*
 * Decompiled with CFR 0.152.
 */
package org.entrystore.harvesting.oaipmh.jobs;

import ORG.oclc.oai.harvester2.verb.ListRecords;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ValueFactory;
import org.entrystore.Context;
import org.entrystore.ContextManager;
import org.entrystore.Entry;
import org.entrystore.EntryType;
import org.entrystore.Metadata;
import org.entrystore.PrincipalManager;
import org.entrystore.impl.RepositoryManagerImpl;
import org.entrystore.impl.converters.ConverterManagerImpl;
import org.entrystore.repository.config.Settings;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListRecordsJob
implements Job,
InterruptableJob {
    private final Log log = LogFactory.getLog(ListRecordsJob.class);
    private static XPathExpression expr;
    private static XPath xpath;
    private static boolean interrupted;
    private boolean replaceMetadata = false;
    private ValueFactory vf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (!interrupted) {
            this.log.info((Object)("ListRecordsJob starts: " + ((URI)context.getJobDetail().getJobDataMap().get((Object)"contextURI")).toString() + " metadataType: " + context.getJobDetail().getJobDataMap().getString("metadataType")));
            try {
                PrintStream out = System.out;
                JobDataMap dataMap = context.getJobDetail().getJobDataMap();
                RepositoryManagerImpl rm = (RepositoryManagerImpl)dataMap.get((Object)"rm");
                PrincipalManager pm = rm.getPrincipalManager();
                this.vf = rm.getValueFactory();
                URI realURI = pm.getAuthenticatedUserURI();
                try {
                    pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                    this.run(out, context);
                }
                finally {
                    pm.setAuthenticatedUserURI(realURI);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public synchronized void run(OutputStream out, JobExecutionContext jobContext) throws Exception {
        JobDataMap dataMap = jobContext.getJobDetail().getJobDataMap();
        RepositoryManagerImpl rm = (RepositoryManagerImpl)dataMap.get((Object)"rm");
        ContextManager cm = rm.getContextManager();
        final PrincipalManager pm = rm.getPrincipalManager();
        ListRecordsJob.initXpath();
        URI contextURI = (URI)dataMap.get((Object)"contextURI");
        String contextId = contextURI.toString().substring(contextURI.toString().lastIndexOf("/") + 1);
        final Context context = cm.getContext(contextId);
        final String metadataType = dataMap.getString("metadataType");
        final String target = dataMap.getString("target");
        String from = dataMap.getString("from");
        String until = dataMap.getString("until");
        String set = dataMap.getString("set");
        this.replaceMetadata = "replace".equalsIgnoreCase(rm.getConfiguration().getString(Settings.HARVESTER_OAI_METADATA_POLICY, "skip"));
        boolean fromAutoDetect = "on".equalsIgnoreCase(rm.getConfiguration().getString(Settings.HARVESTER_OAI_FROM_AUTO_DETECT, "on"));
        if (from == null && fromAutoDetect) {
            Date latestEntry = null;
            Set allEntries = context.getEntries();
            for (URI uri : allEntries) {
                Date cachedDate;
                Entry entry = context.getByEntryURI(uri);
                if (entry == null || !EntryType.Reference.equals((Object)entry.getEntryType()) && !EntryType.LinkReference.equals((Object)entry.getEntryType()) || (cachedDate = entry.getExternalMetadataCacheDate()) == null || latestEntry != null && !cachedDate.after(latestEntry)) continue;
                latestEntry = cachedDate;
            }
            if (latestEntry != null) {
                from = new SimpleDateFormat("yyyy-MM-dd").format(latestEntry);
            }
        }
        this.log.info((Object)("OAI-PMH metadataType: " + metadataType));
        this.log.info((Object)("OAI-PMH target: " + target));
        this.log.info((Object)("OAI-PMH from: " + from));
        this.log.info((Object)("OAI-PMH until: " + until));
        this.log.info((Object)("OAI-PMH set: " + set));
        ListRecords listRecords = null;
        try {
            listRecords = new ListRecords(target, from, until, set, metadataType);
        }
        catch (UnknownHostException e) {
            this.log.info((Object)"UnknownHostException since the target is unknown, the havester will be deleted");
            jobContext.getScheduler().interrupt(jobContext.getJobDetail().getName(), jobContext.getJobDetail().getGroup());
            return;
        }
        ThreadPoolExecutor exService = null;
        if ("on".equalsIgnoreCase(rm.getConfiguration().getString(Settings.HARVESTER_OAI_MULTITHREADED, "off"))) {
            int cpuCount = Runtime.getRuntime().availableProcessors();
            if (cpuCount == 1) {
                this.log.info((Object)"Multi-threaded harvesting activated, but only one CPU found; continuing single-threaded");
            } else {
                int threadCount = cpuCount + 1;
                this.log.info((Object)("Creating executor for multi-threaded harvesting, using thread pool of " + threadCount + " (available CPUs + 1) threads"));
                exService = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount);
            }
        } else {
            this.log.info((Object)"Performing single-threaded harvesting");
        }
        Date before = new Date();
        int j = 0;
        while (listRecords != null) {
            NodeList errors = listRecords.getErrors();
            if (errors != null && errors.getLength() > 0) {
                this.log.error((Object)"Found errors");
                int length = errors.getLength();
                for (int i = 0; i < length; ++i) {
                    Node item = errors.item(i);
                    System.out.println(item);
                }
                this.log.error((Object)("Error record: " + listRecords.toString()));
                break;
            }
            Element el = listRecords.getDocument().getDocumentElement();
            if (el.getElementsByTagName("ListRecords").getLength() == 0) {
                this.log.error((Object)"No ListRecords");
                throw new Exception("No ListRecords");
            }
            Element listRecordsElement = (Element)el.getElementsByTagName("ListRecords").item(0);
            NodeList recordList = listRecordsElement.getElementsByTagName("record");
            for (int i = 0; i < recordList.getLength(); ++i) {
                final Element recordElement = (Element)recordList.item(i).cloneNode(true);
                if (exService == null) {
                    try {
                        this.createEntry(context, recordElement, target, metadataType);
                    }
                    catch (XPathExpressionException e) {
                        this.log.error((Object)e.getMessage());
                    }
                } else {
                    exService.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                URI currentUser = pm.getAuthenticatedUserURI();
                                try {
                                    pm.setAuthenticatedUserURI(pm.getAdminUser().getURI());
                                    ListRecordsJob.this.createEntry(context, recordElement, target, metadataType);
                                }
                                finally {
                                    pm.setAuthenticatedUserURI(currentUser);
                                }
                            }
                            catch (XPathExpressionException e) {
                                ListRecordsJob.this.log.error((Object)e.getMessage());
                            }
                        }
                    });
                    while (exService.getQueue().size() > 250) {
                        this.log.info((Object)("Waiting before submitting additional Runnables, current queue size is " + exService.getQueue().size()));
                        Thread.sleep(50L);
                        this.log.info((Object)("Continuing, the current queue size is " + exService.getQueue().size()));
                    }
                }
                this.log.debug((Object)("total index: " + j++));
            }
            String resumptionToken = listRecords.getResumptionToken();
            if (resumptionToken == null || resumptionToken.length() == 0) {
                listRecords = null;
                continue;
            }
            this.log.info((Object)"Got resumption token");
            listRecords = new ListRecords(target, resumptionToken);
        }
        if (exService != null) {
            while (exService.getQueue().size() > 0) {
                this.log.info((Object)("Runnables left in queue: " + exService.getQueue().size() + ", waiting"));
                Thread.sleep(2000L);
            }
            exService.shutdown();
        }
        this.log.info((Object)"OAI-PMH harvester done with execution");
        long diff = new Date().getTime() - before.getTime();
        if (j > 0) {
            this.log.info((Object)("Harvesting of " + j + " records took " + diff + " ms (average of " + diff / (long)j + " ms per record)"));
        }
    }

    private static void initXpath() {
        XPathFactory factory = XPathFactory.newInstance();
        xpath = factory.newXPath();
        xpath.setNamespaceContext(ListRecordsJob.createNamespace());
    }

    public void createEntry(Context context, Element recordElement, String target, String metadataType) throws XPathExpressionException {
        String identifier = ListRecordsJob.getIdentifier(recordElement);
        String datestamp = ListRecordsJob.getDatestamp(recordElement);
        if (identifier == null) {
            return;
        }
        IRI openrdfEntryResourceURI = null;
        try {
            String resourceIdentifier = ListRecordsJob.getResourceIdentifier(recordElement, metadataType);
            if (resourceIdentifier == null) {
                this.log.warn((Object)"Resource identifier is null, skipping resource");
                return;
            }
            openrdfEntryResourceURI = this.vf.createIRI(resourceIdentifier);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)("Skipping this record, no proper resource URI found: " + e.getMessage()));
            return;
        }
        IRI openrdfEntryMetadataURI = null;
        try {
            openrdfEntryMetadataURI = this.vf.createIRI(target + "?verb=GetRecord&identifier=" + identifier + "&metadataPrefix=" + metadataType);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)("Illegal external metadata URI, not creating entry: " + e.getMessage()));
            return;
        }
        URI entryResourceURI = null;
        if (openrdfEntryResourceURI != null) {
            try {
                entryResourceURI = new URI(openrdfEntryResourceURI.toString());
            }
            catch (URISyntaxException e) {
                this.log.error((Object)e.getMessage());
            }
        }
        URI entryMetadataURI = null;
        if (openrdfEntryMetadataURI != null) {
            try {
                entryMetadataURI = new URI(openrdfEntryMetadataURI.toString());
            }
            catch (URISyntaxException e) {
                this.log.error((Object)("Illegal external metadata URI, not creating entry: " + e.getMessage()));
                return;
            }
        } else {
            this.log.error((Object)"Illegal external metadata URI, not creating entry");
            return;
        }
        Set entries = context.getByExternalMdURI(entryMetadataURI);
        if (entries.isEmpty()) {
            Model g = this.getExternalMetadataGraphFromXML(recordElement, metadataType, entryResourceURI);
            if (g != null) {
                Entry entry = context.createReference(null, entryResourceURI, entryMetadataURI, null);
                this.setCachedMetadataGraph(entry, g);
                this.log.info((Object)("Added entry " + String.valueOf(entry.getEntryURI()) + " with resource " + String.valueOf(entryResourceURI) + " and metadata " + String.valueOf(entryMetadataURI)));
            } else {
                this.log.error((Object)("Unable to extract metadata from XML for " + String.valueOf(entryMetadataURI)));
            }
        } else if (!this.replaceMetadata) {
            this.log.info((Object)"Cached metadata exists, but harvester is configured to not replace it");
        } else {
            Iterator eIt = entries.iterator();
            if (eIt.hasNext()) {
                URI extMdURI;
                Entry entry = (Entry)eIt.next();
                if (!entry.getResourceURI().equals(entryResourceURI)) {
                    this.log.info((Object)(String.valueOf(entry.getEntryURI()) + ": setting new resource URI: " + String.valueOf(entryResourceURI)));
                    if (entryResourceURI != null) {
                        entry.setResourceURI(entryResourceURI);
                    } else {
                        this.log.warn((Object)"New resource URI is null, no changes applied");
                    }
                }
                if (!(extMdURI = entry.getExternalMetadataURI()).equals(entryMetadataURI)) {
                    this.log.warn((Object)("New external metadata URI for " + String.valueOf(entry.getEntryURI()) + " is " + String.valueOf(entryMetadataURI)));
                    if (entryMetadataURI != null) {
                        entry.setExternalMetadataURI(entryMetadataURI);
                    }
                }
                this.log.info((Object)("Setting new cached external metadata on " + String.valueOf(entry.getEntryURI())));
                this.setCachedMetadataGraph(entry, this.getExternalMetadataGraphFromXML(recordElement, metadataType, entry.getResourceURI()));
            }
        }
    }

    private static String getDatestamp(Element el) throws XPathExpressionException {
        ListRecordsJob.initXpath();
        expr = xpath.compile("oai:header/oai:datestamp");
        return (String)expr.evaluate(el, XPathConstants.STRING);
    }

    private Model getExternalMetadataGraphFromXML(Element el, String metadataType, URI resourceURI) throws XPathExpressionException {
        return ConverterManagerImpl.convert((String)metadataType, (Node)ListRecordsJob.getMetadataNode(el, metadataType), (URI)resourceURI);
    }

    private void setCachedMetadataGraph(Entry entry, Model graph) {
        Metadata cachedMD;
        if (graph != null && (cachedMD = entry.getCachedExternalMetadata()) != null) {
            cachedMD.setGraph(graph);
        }
    }

    private static Node getMetadataNode(Element el, String metadataType) throws XPathExpressionException {
        ListRecordsJob.initXpath();
        if (metadataType.equals("oai_dc")) {
            expr = xpath.compile("oai:metadata/oai_dc:dc");
        } else if (metadataType.equals("rdn_dc")) {
            expr = xpath.compile("oai:metadata/rdn_dc:rdndc");
        }
        return (Node)expr.evaluate(el, XPathConstants.NODE);
    }

    private static NodeList getAboutNodes(Element el, String metadataType) throws XPathExpressionException {
        ListRecordsJob.initXpath();
        if (metadataType.equals("oai_dc") || metadataType.equals("rdn_dc")) {
            expr = xpath.compile("oai:about/oai_dc:dc");
            return (NodeList)expr.evaluate(el, XPathConstants.NODESET);
        }
        return null;
    }

    private static String getIdentifier(Element el) throws XPathExpressionException {
        ListRecordsJob.initXpath();
        expr = xpath.compile("oai:header/oai:identifier");
        return (String)expr.evaluate(el, XPathConstants.STRING);
    }

    public static NodeList getRecords(Element el) throws XPathExpressionException {
        expr = xpath.compile("oai:record");
        return (NodeList)expr.evaluate(el, XPathConstants.NODESET);
    }

    private static String getResourceIdentifier(Element el, String metadataType) throws XPathExpressionException {
        ListRecordsJob.initXpath();
        if (metadataType.equals("oai_dc")) {
            expr = xpath.compile("oai:metadata/oai_dc:dc/dc:identifier");
        } else if (metadataType.equals("rdn_dc")) {
            expr = xpath.compile("oai:metadata/rdn_dc:rdndc/dc:identifier");
        }
        NodeList ids = (NodeList)expr.evaluate(el, XPathConstants.NODESET);
        for (int i = 0; i < ids.getLength(); ++i) {
            String id = ids.item(i).getTextContent();
            if (id == null || !(id = id.trim()).startsWith("http://") && !id.startsWith("https://") && !id.startsWith("ftp://")) continue;
            return id;
        }
        return null;
    }

    private static NamespaceContext createNamespace() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return switch (prefix) {
                    case "oai" -> "http://www.openarchives.org/OAI/2.0/";
                    case "dc" -> "http://purl.org/dc/elements/1.1/";
                    case "dcterms" -> "http://purl.org/dc/terms/";
                    case "oai_dc" -> "http://www.openarchives.org/OAI/2.0/oai_dc/";
                    case "rdn_dc" -> "http://www.rdn.ac.uk/oai/rdn_dc/";
                    default -> null;
                };
            }

            @Override
            public Iterator<String> getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        };
    }

    public void interrupt() throws UnableToInterruptJobException {
        interrupted = true;
    }

    static {
        interrupted = false;
    }
}

